<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_ITEMSSTATVIEW';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");

$js = "";
if ($SysPrefs->use_popup_windows && $SysPrefs->use_popup_search)
	$js .= get_js_open_window(900, 500);

if (isset($_GET['stock_id']))
	$_POST['stock_id'] = $_GET['stock_id'];

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 600);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Avarage Price Inquiry"), isset($_GET['stock_id']), false, "", $js);
// page($_SESSION['page_title'], false, false, "", $js);
//----------------------------------------------------

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");

include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root . "/includes/db/manufacturing_db.inc");

if (list_updated('stock_id')) 
	$Ajax->activate('status_tbl');
//----------------------------------------------------------------------------------------------------

check_db_has_stock_items(_("There are no items defined in the system."));

start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();

	stock_categories_list_cells(_("Category:"), 'category_id', null, false, $new_item, $fixed_asset);
	date_cells(_("from:"), 'fromdate', '', null, -user_transaction_days());
	// locations_list_cells(_("Location:"), 'loc_code', null, true, true);
  	date_cells(_("to:"), 'todate', '', null, 1);


  	submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');

end_row();
end_table(1);



div_start('status_tbl');

start_table(TABLESTYLE);

	$th = array(_("Item Code"), _("Description"), _("Sales Avg Price"),
		_("Purchase Avg price"));


$item_res = get_items_catagory(0,$_POST['category_id']);
table_header($th);
$dec = get_qty_dec($_POST['stock_id']);
$j = 1;
$k = 0; //row colour counter

while ($myrow = db_fetch($item_res))
{

	alt_table_row_color($k);
        start_row();

		label_cell($myrow["stock_id"]);
			label_cell($myrow["description"]);
		// qty_cell($qoh, false, $dec);
        // qty_cell($myrow["reorder_level"], false, $dec);
        // qty_cell($demand_qty, false, $dec);
		// $pur_cost_price=getPurchseAverageCost($myrow["stock_id"], $_POST['loc_code'], $_POST['todate']);
		// display_error($pur_cost_price." == ".$myrow["stock_id"]);
         $pkr_sales_price = get_del_sales_cost($myrow["stock_id"],$_POST['fromdate'],$_POST['todate'],1,1);
         $other_sales_price = get_del_sales_cost($myrow["stock_id"],$_POST['fromdate'],$_POST['todate'],1,0);
        // qty_cell($qoh - $demand_qty, false, $dec);
         	label_cell("PKR : ".   price_format($pkr_sales_price['avg_price']) ."\n   , USD : ".price_format($other_sales_price['avg_price']) );
		$pruch_avg_price=get_grn_purchse_cost($myrow["stock_id"],$_POST['fromdate'],$_POST['todate'],1);
        amount_decimal_cell($pruch_avg_price['avg_price']);
        //  label_cell('-');
        // unit_amount_cell(0);
        end_row();
}

end_table();
div_end();
global $Ajax;
$Ajax->activate('_page_body');
end_form();
end_page();

