<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_PACKING_LIST';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/inventory/includes/db/logistic_db.inc");
include_once($path_to_root . "/sales/includes/db/packing_list_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Logistic Inquiry"), false, false, "", $js);

//---------------------------------------------------------------------------------------------

function logistic_view($row)
{	
	return get_trans_view_str(ST_LOGISTIC, $row['id']); 
}
	
function get_agent_name($row)
{
	return get_supplier_name($row['agent_name']);
}

function delete_link($row)
{
	return button("Delete".$row['id'], _("Delete"), _('Remove packing list'), ICON_DELETE);
}

function edit_link($row)
{
	return pager_link(_("Edit"),"/sales/packing_list.php?NewPacking=1&order_no=" .$row["order_no"]."&packing_list_id=".$row['id'], ICON_EDIT);
}
//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders')) 
{
	$Ajax->activate('orders_tbl');
}
//---------------------------------------------------------------------------------------------
start_form();
$id = find_submit('Delete');
if ($id!=-1){

	delete_packing_list($id);
	display_notification(_('Selected packing list has been deleted'));
	$Ajax->activate('orders_tbl');
}

start_table(TABLESTYLE_NOBORDER);
start_row();
text_cells(_("B/L Number"), 'bl_number', null,"","",false, "");

submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_row();
end_table();
//---------------------------------------------------------------------------------------------

$sql = get_logistic_inquiry(get_post('bl_number'));

$cols = array(
		_("Logistic #") => array('fun'=>'logistic_view', 'ord'=>'', 'align'=>'center'), 
		_("B/L Number") => array('align'=>'center'), 
		_("Invoice No.") => array('align'=>'center'), 
		_("Invoice Date") => array('name'=>'ord_date', 'type'=>'date', 'ord'=>'desc'),
		_("Agent Name") => array('fun'=>'get_agent_name', 'ord'=>'', 'align'=>'center'), 
		// _("Edit") => array('insert'=>true, 'fun'=>'edit_link', 'align'=>'center'),
		// _("Delete") => array('insert'=>true, 'fun'=>'delete_link', 'align'=>'center'),
		// array('insert'=>true, 'fun'=>'packing_slip_print'),
);

if (get_post('StockLocation') != ALL_TEXT) {
	$cols[_("Location")] = 'skip';
}

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);

$table->width = "80%";

display_db_pager($table);

end_form();
end_page();
