<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_LOGISTIC';
$path_to_root = "..";
include_once($path_to_root . "/includes/ui/items_cart.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/fixed_assets/includes/fixed_assets_db.inc");
include_once($path_to_root . "/inventory/includes/logistic_ui.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root . "/sales/includes/db/packing_list_db.inc");
include_once($path_to_root . "/inventory/includes/db/logistic_db.inc");
$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
if (isset($_GET['NewLogistic'])) {
	if (isset($_GET['FixedAsset'])) {
		$page_security = 'SA_ASSETDISPOSAL';
		$_SESSION['page_title'] = _($help_context = "Fixed Assets Disposal");
	} else {
		$_SESSION['page_title'] = _($help_context = "logistic");
	}
}
page($_SESSION['page_title'], false, false, "", $js);

//-----------------------------------------------------------------------------------------------

if (isset($_GET['AddedID'])) 
{
	$trans_no = $_GET['AddedID'];
	$trans_type = ST_LOGISTIC;

 
    display_notification_centered(_("Logistic has been processed"));
    display_note(get_trans_view_str($trans_type, $trans_no, _("&View this Logistic")));
	  hyperlink_params($_SERVER['PHP_SELF'], _("Enter &Another Logistic"), "NewLogistic=1");

	display_footer_exit();
}
//--------------------------------------------------------------------------------------------------

function line_start_focus() {
  global 	$Ajax;

  $Ajax->activate('items_table');
  set_focus('_stock_id_edit');
}
//-----------------------------------------------------------------------------------------------

function handle_new_order()
{
	if (isset($_SESSION['logistic_items']))
	{
		$_SESSION['logistic_items']->clear_items();
		unset ($_SESSION['logistic_items']);
	}

    $_SESSION['logistic_items'] = new items_cart(ST_LOGISTIC);
    $_SESSION['logistic_items']->fixed_asset = isset($_GET['FixedAsset']);
	$_POST['inv_date'] = new_doc_date();
	if (!is_date_in_fiscalyear($_POST['inv_date']))
		$_POST['inv_date'] = end_fiscalyear();
	$_SESSION['logistic_items']->tran_date = $_POST['inv_date'];	
}

//-----------------------------------------------------------------------------------------------

function can_process()
{
	global $SysPrefs;

	$adj = &$_SESSION['logistic_items'];

	if (count($adj->logistic_line_items) == 0)	{
		display_error(_("You must enter at least one non empty item line."));
		set_focus('stock_id');
		return false;
	}

	return true;
}

//-------------------------------------------------------------------------------

if (isset($_POST['Process']) && can_process()){

  $fixed_asset = $_SESSION['logistic_items']->fixed_asset; 

	$trans_no = add_logistic($_SESSION['logistic_items']->logistic_line_items, $_POST['bl_no'], $_POST['inv_no'],	
		$_POST['inv_date'], $_POST['shipment_line'], $_POST['agent_name'], 0, $_POST['memo_']);

	new_doc_date($_POST['inv_date']);

	$_SESSION['logistic_items']->clear_items();
	unset($_SESSION['logistic_items']);

  if ($fixed_asset)
   	meta_forward($_SERVER['PHP_SELF'], "AddedID=$trans_no&FixedAsset=1");
  else
   	meta_forward($_SERVER['PHP_SELF'], "AddedID=$trans_no");

} /*end of process credit note */

//-----------------------------------------------------------------------------------------------

function check_item_data()
{
	if (input_num('qty') == 0)
	{
		display_error(_("The quantity entered is invalid."));
		set_focus('qty');
		return false;
	}

   	return true;
}

//-----------------------------------------------------------------------------------------------

function handle_update_item()
{
	$id = $_POST['LineNo'];
   	$_SESSION['logistic_items']->update_logistic_cart_item($id, $_POST['gl_account'], input_num('qty'), 
   		$_POST['currency'], input_num('rate'), input_num('foreign'), $_POST['ex_rate']);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_delete_item($id)
{
	$_SESSION['logistic_items']->remove_logistic_from_cart($id);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_new_item(){
	add_to_order($_SESSION['logistic_items'], $_POST['gl_account'], input_num('qty'), $_POST['currency'], 
		input_num('rate'), input_num('foreign'), $_POST['ex_rate']);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------
$id = find_submit('Delete');
if ($id != -1)
	handle_delete_item($id);

if (isset($_POST['AddItem']) && check_item_data())
	handle_new_item();

if (isset($_POST['UpdateItem']) && check_item_data())
	handle_update_item();

if (isset($_POST['CancelItemChanges'])) {
	line_start_focus();
}
//-----------------------------------------------------------------------------------------------

if (isset($_GET['NewLogistic']) || !isset($_SESSION['logistic_items']))
{

	if (isset($_GET['FixedAsset']))
		check_db_has_disposable_fixed_assets(_("There are no fixed assets defined in the system."));
	else
		check_db_has_costable_items(_("There are no inventory items defined in the system which can be adjusted (Purchased or Manufactured)."));

	handle_new_order();
}

//-----------------------------------------------------------------------------------------------
start_form();

if ($_SESSION['logistic_items']->fixed_asset) {
	$items_title = _("Disposal Items");
	$button_title = _("Process Disposal");
} else {
	$items_title = _("Logistic Details");
	$button_title = _("Process Logistic");
}

display_order_header($_SESSION['logistic_items']);

start_outer_table(TABLESTYLE, "width='70%'", 10);

display_adjustment_items($items_title, $_SESSION['logistic_items']);
adjustment_options_controls();

end_outer_table(1, false);

submit_center_first('Update', _("Update"), '', null);
submit_center_last('Process', $button_title, '', 'default');

end_form();
end_page();

