<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_ITEMSTRANSVIEW';
$path_to_root = "../..";

include($path_to_root . "/includes/session.inc");

page(_($help_context = "View Inventory Adjustment"), true);

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");

if (isset($_GET["trans_no"]))
{
	$trans_no = $_GET["trans_no"];
}

display_heading($systypes_array[ST_INVADJUST] . " #$trans_no");

br(1);
$adjustment_items = get_stock_adjustment_items($trans_no);
$k = 0;
$header_shown = false;
$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');

$adjustment_bag = get_adjustment_bag($trans_no);
while ($adjustment = db_fetch($adjustment_items)){
	if (!$header_shown)	{

		start_table(TABLESTYLE2, "width='90%'");
		start_row();
		label_cells(_("At Location"), $adjustment['location_name'], "class='tableheader2'");
    	label_cells(_("Reference"), $adjustment['reference'], "class='tableheader2'", "colspan=6");
		label_cells(_("Date"), sql2date($adjustment['tran_date']), "class='tableheader2'");
		label_cells(_("File System"), get_file_system_name($adjustment['file_system']), "class='tableheader2'");
		end_row();
		comments_display_row(ST_INVADJUST, $trans_no);

		end_table();
		$header_shown = true;

		echo "<br>";
		start_table(TABLESTYLE, "width='90%'");

    	$th = array(_("Item Code"), _("Description"), _("Quantity"),		_("Units"), _("Unit Cost"));
		if($kv_exp_date){
			array_splice( $th, 2, 0, _("Batch No") );
			array_splice( $th, 3, 0, _("Exp Date") );
		}elseif($kv_batch){
			array_splice( $th, 2, 0, _("Batch No") );			
		}	

		array_splice( $th, 6, 0, _("Pack Size") );
		array_splice( $th, 7, 0, _("Pack Unit") );
		array_splice( $th, 8, 0, _("No of Pack") );
    	table_header($th);
	}

    alt_table_row_color($k);

    $data_adjust_bag =  db_fetch($adjustment_bag);
    label_cell($adjustment['stock_id']);
    label_cell($adjustment['description']);
	if($kv_exp_date){
		label_cell($adjustment['batch_no']);
		label_cell(sql2date($adjustment['exp_date']));
	} elseif($kv_batch)
		label_cell($adjustment['batch_no']);
    qty_cell($adjustment['qty'], false, get_qty_dec($adjustment['stock_id']));
    label_cell($adjustment['units']);
    if($_SESSION["wa_current_user"]->can_access('SA_WORKORDERCOST')){
    amount_decimal_cell($adjustment['standard_cost']);
	amount_cell($data_adjust_bag['pack_size'], null, "align='center'");
	label_cell($data_adjust_bag['pack_unit'], "align='center'");
	qty_cell($data_adjust_bag['no_of_pack'], false, get_qty_dec($adjustment['stock_id']));

    }else{
     label_cell('-');
     label_cell('-');
     label_cell('-');
     label_cell('-');
     }


    end_row();
}

end_table(1);

is_voided_display(ST_INVADJUST, $trans_no, _("This adjustment has been voided."));

end_page(true, false, false, ST_INVADJUST, $trans_no);
