<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_LOGISTIC';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root . "/inventory/includes/db/logistic_db.inc");
include_once($path_to_root . "/sales/includes/db/packing_list_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 600);
page(_($help_context = "View Logistic"), true, false, "", $js);


if (isset($_GET["trans_no"]))
{
	$trans_no = $_GET["trans_no"];
}

$myrow = get_logistic_header($trans_no);
$packing_list = get_packing_list_bl_no($myrow['bl_no']);
if($packing_list['order_no'])
	$sales_order = get_sales_order_header($packing_list['order_no'], ST_SALESORDER);

display_heading(_("Logistic"));
start_table(TABLESTYLE, "width='100%'");
start_row();
label_cells(_("BL No."), $myrow["bl_no"], "class='tableheader2'");
label_cells(_("Invoice No."), $myrow["inv_no"], "class='tableheader2'");
label_cells(_("Invoice Date"), sql2date($myrow["inv_date"]), "class='tableheader2'");
end_row();
start_row();
label_cells(_("Shipment Line"), $myrow["shipment_line"], "class='tableheader2'");
label_cells(_("Agent Name"), $myrow["agent_name"], "class='tableheader2'");
label_cells(_("Vessel Voyage"), $packing_list["vessel_name"], "class='tableheader2'");
end_row();
start_row();
label_cells(_("Form 'E' No"), $packing_list['form_e_no'], "class='tableheader2'");
label_cells(_("Date"), sql2date($packing_list['lc_contract_date']), "class='tableheader2'");
label_cells(_("P.O.L"), $sales_order['port_of_loading'], "class='tableheader2'");
end_row();
start_row();
label_cells(_("P.O.D"), $sales_order['port_of_discharge'], "class='tableheader2'");
label_cells(_("Bank Account"), get_bank_account_name($myrow["bank_account"]), "class='tableheader2'");
// print_r($myrow);	
label_cells(_("GL View"), get_trans_view_str(0, $myrow["gl_no"]), "class='tableheader2'");
end_row();
start_row();
label_cells(_("Memo"), $myrow["memo_"], "class='tableheader2'");
end_row();

end_table();

$result = get_logistic_details($trans_no);
br();
display_heading(_("Logistic Details"));
start_table(TABLESTYLE, "width='95%'");

if (db_num_rows($result) > 0)
{
	$th = array(_("Account Code"), _("Account Description"), _("Unit"), _("Currency"), _("Rate"), _("Foreign"), _("Ex.Rate"), _("Amount"));
	
	table_header($th);
	$k = 0;	//row colour counter
	$sub_total = 0;
	while ($myrow2 = db_fetch($result))
	{
		alt_table_row_color($k);

		label_cell($myrow2["gl_account"], "align='center'");
		$gl_account_name = get_gl_account_name($myrow2["gl_account"]);
		label_cell($gl_account_name, "align='center'");
		label_cell($myrow2["qty"], "align='center'");
		label_cell($myrow2["currency"], "align='center'");
		label_cell($myrow2["rate"], "align='center'");
		label_cell($myrow2["forign"], "align='center'");
		label_cell($myrow2["ex_rate"], "align='center'");
		label_cell($myrow2["forign"]*$myrow2["ex_rate"], "align='center'");

		end_row();
		$total += $myrow2["forign"]*$myrow2["ex_rate"];

	} //end while there are line items to print out

	start_row();
	label_cells(_("<b>Total</b>"), "<b>$total</b>", "colspan='7' align=left",
		"nowrap align=center");
	end_row();

}

end_table(1);

// $voided = is_voided_display(ST_SALESINVOICE, $trans_id, _("This invoice has been voided."));

// if (!$voided)
// {
// 	display_allocations_to(PT_CUSTOMER, $myrow['debtor_no'], ST_SALESINVOICE, $trans_id, $myrow['Total']);
// }

end_page(true, false, false, ST_SALESINVOICE, $trans_id);

