<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_ITEMSTRANSVIEW';
$path_to_root = "../..";

include($path_to_root . "/includes/session.inc");

page(_($help_context = "View Inventory Transfer"), true);

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

if (isset($_GET["trans_no"]))
{
	$trans_no = $_GET["trans_no"];
}

$trans = get_stock_transfer($trans_no);

display_heading($systypes_array[ST_LOCTRANSFER] . " #$trans_no");

if(!exists_approval_trans(ST_LOCTRANSFER, $trans_no))
echo "<center><b style='color : red;'>Un-Received</b></center>";
echo "<br>";
start_table(TABLESTYLE2, "width='90%'");

start_row();
label_cells(_("Reference"), $trans['reference'], "class='tableheader2'");
label_cells(_("Date"), sql2date($trans['tran_date']), "class='tableheader2'");
end_row();

   $data_trans = get_tranfer_data(ST_LOCTRANSFER, $trans_no);
if(!exists_approval_trans(ST_LOCTRANSFER, $trans_no))
{
start_row();
label_cells(_("From Location"), get_item_location($data_trans['from_loc'])['location_name'], "class='tableheader2'");
label_cells(_("To Location"), get_item_location($data_trans['to_loc'])['location_name'], "class='tableheader2'");
end_row();

}
else{

start_row();
label_cells(_("From Location"), $trans['from_name'], "class='tableheader2'");
label_cells(_("To Location"), $trans['to_name'], "class='tableheader2'");
end_row();
}

start_row();
label_cells(_("File System"), get_file_system_name($trans['file_system']), "class='tableheader2'");
end_row();

if($data_trans['po_inv'])
{
    start_row();
label_cells(_("Purchase Invoice"), get_trans_view_str(ST_SUPPINVOICE, $data_trans['po_inv']), "class='tableheader2'");

end_row();

}

if($data_trans['req_no'])
{
    start_row();
label_cells(_("View Requisition"), get_trans_view_str(ST_REQUISITION, $data_trans['req_no']), "class='tableheader2'");

end_row();

}


comments_display_row(ST_LOCTRANSFER, $trans_no);

end_table(2);

start_table(TABLESTYLE, "width='90%'");

$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');

$th = array(_("Item Code"), _("Description"),  _("Quantity"), _("Units"));
if($kv_exp_date){
			array_splice( $th, 2, 0, _("Batch No") );
			array_splice( $th, 3, 0, _("Exp Date") );
		}elseif($kv_batch){
			array_splice( $th, 2, 0, _("Batch No") );			
		}	
table_header($th);
$transfer_items = get_stock_moves(ST_LOCTRANSFER, $trans_no);
$k = 0;
while ($item = db_fetch($transfer_items))
{
	if ($item['loc_code'] == $trans['to_loc'])
	{
        alt_table_row_color($k);

        label_cell($item['stock_id']);
        label_cell($item['description']);
		if($kv_exp_date){
			label_cell($item['batch_no']);
			label_cell(sql2date($item['exp_date']));
		} elseif($kv_batch)
			label_cell($item['batch_no']);
        qty_cell($item['qty'], false, get_qty_dec($item['stock_id']));
        label_cell($item['units']);
        end_row();
	}
}

end_table(1);
// get_approved_trans($type,$trans_no)
$app_res = get_approved_trans(ST_LOCTRANSFER,$_GET['trans_no']);

if (db_num_rows($app_res) > 0)
{

    echo "</td><td valign=top>"; // outer table

    display_heading2(_("Received Approval Details"));
    start_table(TABLESTYLE);
    $th = array(_("#"), _("Approval Date"), _("Approved"),_("Remarks"));
    table_header($th);
    while ($myrow = db_fetch($app_res))
    {
        alt_table_row_color($k);

        // label_cell(get_trans_view_str(ST_SUPPRECEIVE,$myrow["id"]));
        label_cell($myrow["id"],'align="center"');
        label_cell(sql2date($myrow["date"]),'align="center"');
          label_cell(get_user($myrow["user_id"])['real_name'],'align="center"');
            label_cell($myrow["remarks"],'align="center"');
        end_row();
    }
    end_table();
}
is_voided_display(ST_LOCTRANSFER, $trans_no, _("This transfer has been voided."));

end_page(true, false, false, ST_LOCTRANSFER, $trans_no);
