<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_WORKORDERENTRY';
$path_to_root = "..";

include_once($path_to_root . "/includes/ui/items_cart.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/manufacturing/includes/direct_work_order_ui.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_ui.inc");
include_once($path_to_root . "/manufacturing/includes/work_order_issue_ui.inc");
include_once($path_to_root . "/manufacturing/includes/db/wo_item_westage_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Work Order Entry"), false, false, "", $js);

check_db_has_manufacturable_items(_("There are no manufacturable items defined in the system."));

check_db_has_locations(("There are no inventory locations defined in the system."));

//---------------------------------------------------------------------------------------

if (isset($_GET['trans_no']))
{
	$selected_id = $_GET['trans_no'];
}
elseif(isset($_POST['selected_id']))
{
	$selected_id = $_POST['selected_id'];
}


function line_start_focus() {
  global $Ajax;

  $Ajax->activate('items_table');
  set_focus('_stock_id_edit');
}

function line_start_focus_finish() {
  global $Ajax;

  $Ajax->activate('finish_items_table');
  set_focus('_stock_id_edit');
}


function handle_new_order()
{
     $_SESSION['wo'] = new items_cart(ST_WORKORDER);
}
//---------------------------------------------------------------------------------------

if (isset($_GET['AddedID']))
{
	$id = $_GET['AddedID'];
	$stype = ST_WORKORDER;

	display_notification_centered(_("The work order been added."));

    display_note(get_trans_view_str($stype, $id, _("View this Work Order")), 0, 1);

	if ($_GET['type'] != WO_ADVANCED || WO_PIPES)
	{
		include_once($path_to_root . "/reporting/includes/reporting.inc");

		submenu_print(_("&Print This Work Order"), ST_WORKORDER, $id, 'prtopt');
		submenu_print(_("&Email This Work Order"), ST_WORKORDER, $id, null, 1);
    	display_note(get_gl_view_str($stype, $id, _("View the GL Journal Entries for this Work Order")), 1);
    	$ar = array('PARAM_0' => $_GET['date'], 'PARAM_1' => $_GET['date'], 'PARAM_2' => $stype, 'PARAM_3' => '',
    		'PARAM_4' => (user_def_print_orientation() == 1 ? 1 : 0)); 
    	display_note(print_link(_("Print the GL Journal Entries for this Work Order"), 702, $ar), 1);
		hyperlink_params("$path_to_root/admin/attachments.php", _("Add an Attachment"), "filterType=$stype&trans_no=$id");
	}
	
	safe_exit();
}

//---------------------------------------------------------------------------------------

if (isset($_GET['UpdatedID']))
{
	$id = $_GET['UpdatedID'];

	display_notification_centered(_("The work order been updated."));
	safe_exit();
}

//---------------------------------------------------------------------------------------

if (isset($_GET['DeletedID']))
{
	$id = $_GET['DeletedID'];

	display_notification_centered(_("Work order has been deleted."));
	safe_exit();
}

//---------------------------------------------------------------------------------------

if (isset($_GET['ClosedID']))
{
	$id = $_GET['ClosedID'];

	display_notification_centered(_("This work order has been closed. There can be no more issues against it.") . " #$id");
	safe_exit();
}

//---------------------------------------------------------------------------------------

function safe_exit()
{
	global $path_to_root;

	hyperlink_no_params("", _("Enter a new work order"));
	hyperlink_no_params("search_work_orders.php", _("Select an existing work order"));
	
	display_footer_exit();
}

//-------------------------------------------------------------------------------------
if (!isset($_POST['date_']))
{
	$_POST['date_'] = new_doc_date();
	if (!is_date_in_fiscalyear($_POST['date_']))
		$_POST['date_'] = end_fiscalyear();
}

function can_process()
{
	global $selected_id, $SysPrefs;

	if (!isset($selected_id))
	{
    	if (!check_reference($_POST['wo_ref'], ST_WORKORDER))
    	{
			set_focus('wo_ref');
    		return false;
    	}
	}

	if (!check_num('quantity', 1))
	{
		display_error( _("The quantity entered is invalid or less than zero."));
		set_focus('quantity');
		return false;
	}
	// if(!isset($_POST['kv_batch'])) {
	// 	if (strlen($_POST['batch_no']) == 0 )	{
	// 		display_error( _("The Batch Number entered is invalid or less than zero."));
	// 		set_focus('batch_no');
	// 		return false;
	// 	}elseif(db_has_batch_no($_POST['batch_no'])) {
	// 		display_error( _("The Batch Number entered is already exists."));
	// 		set_focus('batch_no');
	// 		return false;
	// 	}
	// }
	if (!is_date($_POST['date_']))
	{
		display_error( _("The date entered is in an invalid format."));
		set_focus('date_');
		return false;
	}
	elseif (!is_date_in_fiscalyear($_POST['date_']))
	{
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('date_');
		return false;
	}
	// only check bom and quantites if quick assembly
	if (!($_POST['type'] == WO_ADVANCED  || WO_PIPES))
	{
        // if (!has_bom($_POST['stock_id']))
        // {
        // 	display_error(_("The selected item to manufacture does not have a bom."));
		// 	set_focus('stock_id');
        // 	return false;
        // }

		if ($_POST['Labour'] == "")
			$_POST['Labour'] = price_format(0);
    	if (!check_num('Labour', 0))
    	{
    		display_error( _("The labour cost entered is invalid or less than zero."));
			set_focus('Labour');
    		return false;
    	}
		if ($_POST['Costs'] == "")
			$_POST['Costs'] = price_format(0);
    	if (!check_num('Costs', 0))
    	{
    		display_error( _("The cost entered is invalid or less than zero."));
			set_focus('Costs');
    		return false;
    	}

        if (!$SysPrefs->allow_negative_stock())
        {
        	if ($_POST['type'] == WO_ASSEMBLY)
        	{
        		// check bom if assembling
                $result = get_bom($_POST['stock_id']);

            	while ($bom_item = db_fetch($result))
            	{

            		if (has_stock_holding($bom_item["ResourceType"]))
            		{

                		$quantity = $bom_item["quantity"] * input_num('quantity');

                        if (check_negative_stock($bom_item["component"], -$quantity, $bom_item["loc_code"], $_POST['date_']))
                		{
                			display_error(_("The work order cannot be processed because there is an insufficient quantity for component:") .
                				" " . $bom_item["component"] . " - " .  $bom_item["description"] . ".  " . _("Location:") . " " . $bom_item["location_name"]);
							set_focus('quantity');
        					return false;
                		}
            		}
            	}
        	}
        	elseif ($_POST['type'] == WO_UNASSEMBLY)
        	{
        		// if unassembling, check item to unassemble
                if (check_negative_stock($_POST['stock_id'], -input_num('quantity'), $_POST['StockLocation'], $_POST['date_']))
        		{
        			display_error(_("The selected item cannot be unassembled because there is insufficient stock."));
					return false;
        		}
        	}
    	}
     }
     else
     {
    	if (!is_date($_POST['RequDate']))
    	{
			set_focus('RequDate');
    		display_error( _("The date entered is in an invalid format."));
    		return false;
		}
    	if (isset($selected_id))
    	{
    		if ($_POST['units_issued'] > input_num('quantity'))
    		{
				set_focus('quantity');
    			display_error(_("The quantity cannot be changed to be less than the quantity already manufactured for this order."));
        		return false;
    		}
    	}
	}

	// $receive_row_weight = $_SESSION['wo']->get_row_all_weight();
	// $receive_finish_weight = $_SESSION['wo']->get_finish_all_weight($_POST['type']);
	// if ($receive_finish_weight['receive_finish_weight'] > $receive_row_weight['receive_row_weight']) {
	// 	set_focus('finish_qty');
	// 	display_error(_("Semi / Finish Items Quantity Cannot Be Greater Then Row Material Quantity."));
	// 	return false;
	// }

	// display_error($receive_finish_weight['receive_finish_weight'] .'=='. $receive_row_weight['receive_row_weight']);

	// $sum_row_qty = $_SESSION['wo']->sum_wo_row_qty();
	// $sum_finish_qty = $_SESSION['wo']->sum_wo_finish_qty();
	// $result = item_wise_westage($_POST['type']);
	// $i = 1;
	// while ($myrow = db_fetch($result)) {
	// 	$sum_westage['qty_westage']+=$_POST['qty_westage'.$i];
	// 	$i++;
	// }	

	// if ($sum_row_qty['qty'] != $sum_finish_qty['qty']) { //+$sum_westage['qty_westage']
	// 	if ($_POST['type'] == 2) 
	// 		display_error( _("Sami Finish Quantity ". $sum_finish_qty['qty'] . " Cannot Be Less Than Row Quantity ". $sum_row_qty['qty']));
	// 	if ($_POST['type'] == 4)
	// 		display_error( _("Finish Quantity ". $sum_finish_qty['qty'] . " Cannot Less Than Sami Finish Quantity ". $sum_row_qty['qty']));
	// 	return false;
	// }

	return true;
}

//-------------------------------------------------------------------------------------

if (isset($_POST['ADD_ITEM']) && can_process())
{
	global $Refs;


	$pr_data=$_SESSION['wo']->gl_total_item_and_price();
	$result = item_wise_westage($_POST['type']);
	$i = 1;
	// while ($myrow = db_fetch($result)) {
	// 		if ($_POST['qty_westage'.$i] > 0) 
	// 			$pr_data['qty']+=$_POST['qty_westage'.$i];
	// }	
	// // $act_price=$pr_data['price'];//*$pr_data['qty'];
	// 	$act_price=$pr_data['total']/$pr_data['qty'];//*$pr_data['qty'];

	// $receive_finish_weight = $_SESSION['wo']->get_finish_all_weight($_POST['type']);
	// $received = $receive_finish_weight['receive_finish_weight'] + $pr_data['qty'];

	// foreach ($_SESSION['wo']->line_items as $line_no => $line_item){
	// 	if ($received > 0 ) {
	// 		if($received >= $_SESSION['wo']->line_items[$line_no]->quantity)
	// 			$received_temp = $_SESSION['wo']->line_items[$line_no]->quantity;
	// 		elseif($received < $_SESSION['wo']->line_items[$line_no]->quantity){
	// 			$received_temp = $received;
	// 			$_SESSION['wo']->line_items[$line_no]->quantity = $received;
	// 		}
	// 		$received -= $received_temp; 
	// 	}else{
	// 		unset($_SESSION['wo']->line_items[$line_no]);
	// 	}
	// // display_error($line_item->quantity.'=='.$receive_finish_weight['receive_finish_weight']);
    // }

    // exit();

	if (!isset($_POST['cr_acc']))
		$_POST['cr_acc'] = "";
	if (!isset($_POST['cr_lab_acc']))
		$_POST['cr_lab_acc'] = "";
	$_POST['batch_no'] = (isset($_POST['batch_no']) ? $_POST['wo_ref'] : "");
	$_POST['exp_date'] = (isset($_POST['exp_date']) ? $_POST['date_'] : "");
	if($_POST['type'] == 2){

	$id = add_work_order($_POST['wo_ref'], $_POST['StockLocation'], input_num('finish_qty'), $_POST['finish_stock_id'],  
		$_POST['type'], $_POST['date_'], $_POST['RequDate'], $_POST['memo_'], input_num('Costs'), $_POST['cr_acc'], 
		input_num('Labour'), $_POST['cr_lab_acc'], $_POST['batch_no'], $_POST['exp_date'],0, $_POST['f_no_of_pack'],$_POST['f_pack_size'], $_POST['f_pack_unit'], $_POST['f_no_of_pack']);

	}else{

		$j=0;
	    $id = add_work_order($_POST['wo_ref'], $_POST['StockLocation'], input_num('finish_qty'.$j), $_POST['finish_stock_id'.$j],  
		$_POST['type'], $_POST['date_'], $_POST['RequDate'], $_POST['memo_'], input_num('Costs'), $_POST['cr_acc'], 
		input_num('Labour'), $_POST['cr_lab_acc'], $_POST['batch_no'], $_POST['exp_date'],0, $_POST['f_no_of_pack'.$j],$_POST['f_pack_size'.$j], $_POST['f_pack_unit'.$j], $_POST['f_no_of_pack'.$j],1);

	}



	$stockitem = get_item(input_num('finish_qty'));

for ($i=0; $i < $_POST['no_of_charges'] ; $i++) {
      $memo_labr= "Per Labour cost : ".$_POST['per_cost'.$i]." , No of Bags : ".$_POST['labour_of_bags'.$i];
	   if (input_num('Labour'.$i) != 0)
			add_wo_costs_journal($id, input_num('Labour'.$i), WO_LABOUR, $_POST['cr_lab_acc'.$i], $_POST['date_'], $stockitem["dimension_id"], $stockitem["dimension2_id"],$memo_labr);

   }

		if (input_num('Costs') != 0)
			add_wo_costs_journal($id, input_num('Costs'), WO_OVERHEAD, $_POST['cr_acc'],  $_POST['date_'], $stockitem["dimension_id"], $stockitem["dimension2_id"]);


    # issue enter for raw material

	$issue_ref = $Refs->get_next(ST_MANUISSUE, null, array('date'=> get_post('date_'), 'location' => get_post('StockLocation')));

	$failed_data = add_work_order_issue($id, $issue_ref, 0, $_SESSION['wo']->line_items, 
	$_POST['StockLocation'], 1, $_POST['date_'], $_POST['memo_']);

	if ($failed_data != null) 
	{
	display_error(_("The process cannot be completed because there is an insufficient total quantity for a component.") . "<br>"
	. _("Component is :"). $failed_data[0] . "<br>"
	. _("From location :"). $failed_data[1] . "<br>");
	} 

    // issue enter for finish item
	// $issue_ref = $Refs->get_next(ST_MANUISSUE, null, array('date'=> get_post('date_'), 'location' => get_post('StockLocation')));
 	// $failed_data = add_work_order_issue($id, $issue_ref, 1, $_SESSION['wo']->line_items_finish, 
	//  	$_POST['StockLocation'], 2, $_POST['date_'], $_POST['memo_']);
 	// if ($failed_data != null) 
	// {
	// 	display_error(_("The process cannot be completed because there is an insufficient total quantity for a component.") . "<br>"
	// 	. _("Component is :"). $failed_data[0] . "<br>"
	// 	. _("From location :"). $failed_data[1] . "<br>");
	// } 
 	//  unset($_SESSION['wo']->line_items_finish);

	$result = item_wise_westage($_POST['type']);
	$i = 1;
	$is_item_wo=1;
	while ($myrow = db_fetch($result)) {
			if ($_POST['by_pord_qty'.$i] > 0) {

				 $_SESSION['wo']->add_to_cart_finish (count($_SESSION['wo']->line_items_finish), 
					$_POST['by_pord_item'.$i], $_POST['by_pord_qty'.$i], $_POST['by_pord_cost'.$i], null,  $_POST['by_pord_batch_no'.$i], Today(),$_POST['by_pord_pack_size'.$i],$_POST['by_pord_pack_unit'.$i],$_POST['by_pord_no_of_pack'.$i]);
            	$is_item_wo=1;
			}
	     $i++;
	}

       if($_POST['type'] != 2){
       	      $array_pack=$_SESSION['wo']->get_packing_material_count();
       	      for ($i=0; $i < count($array_pack) ; $i++) { 
       	      	// code...
		 $_SESSION['wo']->add_to_cart_finish(count($_SESSION['wo']->line_items_finish), 
					$_POST['finish_stock_id'.$i], $_POST['finish_qty'.$i], $_POST['f_std_cost'.$i], null,  $_POST['finish_batch_no'.$i], Today(), $_POST['f_pack_size'.$i], $_POST['f_pack_unit'.$i], $_POST['f_no_of_pack'.$i]);
       	      }
		        $is_item_wo=1;
            }
	if($is_item_wo)
	{
		$issue_ref = $Refs->get_next(ST_MANUISSUE, null, array('date'=> get_post('date_'), 'location' => get_post('StockLocation')));
	 	$failed_data = add_work_order_issue($id, $issue_ref, 1, $_SESSION['wo']->line_items_finish, 
		 	$_POST['StockLocation'], 2, $_POST['date_'], $_POST['memo_']);
	 	if ($failed_data != null) 
		{
			display_error(_("The process cannot be completed because there is an insufficient total quantity for a component.") . "<br>"
			. _("Component is :"). $failed_data[0] . "<br>"
			. _("From location :"). $failed_data[1] . "<br>");
		}
	}


   if($_POST['type'] == 2){
    $prod_ref = $Refs->get_next(ST_MANURECEIVE, null, array('date'=> get_post('date_'), 'location' => get_post('StockLocation')));
     $close_wo = 0;
	 $id2 = work_order_produce($id, $prod_ref, input_num('finish_qty'),	$_POST['date_'], $_POST['memo_'], $close_wo,  $_POST['finish_batch_no'], $_POST['exp_date'], false,$_POST['f_pack_size'],$_POST['f_pack_unit'],input_num('f_no_of_pack'), 0, input_num('f_no_of_pack'));	
          }
	new_doc_date($_POST['date_']);
	meta_forward($_SERVER['PHP_SELF'], "AddedID=$id&type=".$_POST['type']."&date=".$_POST['date_']);
}

//-------------------------------------------------------------------------------------

if (isset($_POST['UPDATE_ITEM']) && can_process())
{

	update_work_order($selected_id, $_POST['StockLocation'], input_num('quantity'),
		$_POST['stock_id'],  $_POST['date_'], $_POST['RequDate'], $_POST['memo_']);
	new_doc_date($_POST['date_']);
	meta_forward($_SERVER['PHP_SELF'], "UpdatedID=$selected_id");
}

//--------------------------------------------------------------------------------------

if (isset($_POST['delete']))
{
	//the link to delete a selected record was clicked instead of the submit button

	$cancel_delete = false;

	// can't delete it there are productions or issues
	if (work_order_has_productions($selected_id) ||
		work_order_has_issues($selected_id)	||
		work_order_has_payments($selected_id))
	{
		display_error(_("This work order cannot be deleted because it has already been processed."));
		$cancel_delete = true;
	}

	if ($cancel_delete == false)
	{ //ie not cancelled the delete as a result of above tests

		// delete the actual work order
		delete_work_order($selected_id, $_POST['stock_id'], $_POST['quantity'], $_POST['date_']);
		meta_forward($_SERVER['PHP_SELF'], "DeletedID=$selected_id");
	}
}

//-------------------------------------------------------------------------------------

if (isset($_POST['close']))
{

	// update the closed flag in the work order
	close_work_order($selected_id);
	meta_forward($_SERVER['PHP_SELF'], "ClosedID=$selected_id");
}


//-----------------------------------------------------------------------------------------------

function check_item_data()
{
	if (input_num('qty') == 0 || !check_num('qty', 0))
	{
		display_error(_("The quantity entered is negative or invalid."));
		set_focus('qty');
		return false;
	}

	if (!check_num('std_cost', 0))
	{
		display_error(_("The entered standard cost is negative or invalid."));
		set_focus('std_cost');
		return false;
	}

	if (!get_post('row_batch_no'))
	{
		display_error(_("Batch No. Must Be Select."));
		set_focus('row_batch_no');
		return false;
	}

	// foreach ($_SESSION['wo']->line_items as $stock_item)
	// {
	// 	if (get_post('row_batch_no') == $stock_item->batch_no)
	// 	{
	// 		display_error(_("Same Batch No. Could Not Be Add."));
	// 		set_focus('row_batch_no');
	// 		return false;
	// 	}
	// }

   	return true;
}

// WO Finsish Items 
//-----------------------------------------------------------------------------------------------

function check_item_finish_data()
{
	if (input_num('finish_qty') == 0 || !check_num('finish_qty', 0))
	{
		display_error(_("The quantity entered is negative or invalid."));
		set_focus('finish_qty');
		return false;
	}

	if (!check_num('finish_std_cost', 0))
	{
		display_error(_("The entered standard cost is negative or invalid."));
		set_focus('finish_std_cost');
		return false;
	}

	if (!get_post('finish_batch_no'))
	{
		display_error(_("Batch No. Must Be Select."));
		set_focus('finish_batch_no');
		return false;
	}

   	return true;
}

//-----------------------------------------------------------------------------------------------

function handle_update_item()
{
    if($_POST['UpdateItem'] != "" && check_item_data())
    {
		$id = $_POST['LineNo'];
    	$_SESSION['wo']->update_cart_item($id, input_num('qty'), input_num('std_cost'), 
    		$_POST['thickness'], $_POST['width'], $_POST['row_batch_no']);
    }
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_delete_item($id)
{
	$_SESSION['wo']->remove_from_cart($id);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_new_item()
{
	if (!check_item_data())
		return;
	add_to_wo($_SESSION['wo'], $_POST['row_stock_id'], input_num('qty'),
		 input_num('std_cost'), get_post('row_batch_no'), get_post('exp_date'), $_POST['pack_size'], $_POST['pack_unit'], $_POST['no_of_pack']);
	line_start_focus();
}
//-----------------------------------------------------------------------------------------------
$id = find_submit('Delete');
if ($id != -1)
	handle_delete_item($id);

if (isset($_POST['AddItem']))
	handle_new_item();

if (isset($_POST['UpdateItem']))
	handle_update_item();

if (isset($_POST['CancelItemChanges'])) {
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------
// Semi / Finish Items
//-----------------------------------------------------------------------------------------------
function handle_update_item_finish()
{
    if($_POST['UpdateItem2'] != "" && check_item_finish_data())
    {
		$id = $_POST['LineNo2'];
    	$_SESSION['wo']->update_cart_item_finish($id, input_num('finish_qty'), input_num('finish_std_cost'),
    	'', input_num('weight'), input_num('semi_finish_thickness'), input_num('semi_finish_width')
    		, $_POST['bundle'], $_POST['length']);
    }
	line_start_focus_finish();
}

//-----------------------------------------------------------------------------------------------

function handle_delete_item_finish($id)
{
	$_SESSION['wo']->remove_from_cart_finish($id);
	line_start_focus_finish();
}

//-----------------------------------------------------------------------------------------------
function handle_new_item_finish()
{
	if (!check_item_finish_data())
		return;
  
		add_to_wo_finish($_SESSION['wo'], $_POST['finish_stock_id'], input_num('finish_qty'),
			 input_num('finish_std_cost'), get_post('finish_batch_no'), get_post('exp_date'), $_POST['f_pack_size'], $_POST['f_pack_unit'], $_POST['f_no_of_pack']);
	
	line_start_focus_finish();
}
//-----------------------------------------------------------------------------------------------
$id = find_submit('Delete2');
if ($id != -1)
	handle_delete_item_finish($id);

if (isset($_POST['AddItemFinish']))
	handle_new_item_finish();
if (isset($_POST['UpdateItem2']))
	handle_update_item_finish();
if (isset($_POST['CancelItemChanges2'])) {
	line_start_focus();
}
//-------------------------------------------------------------------------------------
if (get_post('_type_update')) 
{
  $Ajax->activate('_page_body');
}
//-------------------------------------------------------------------------------------

start_form();
if (isset($_GET['WorkOrder']))
{
	handle_new_order();
}
$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');
start_outer_table(TABLESTYLE2, "width='100%'");
table_section(1,"20%");
 table_section_title(_("Work Order Detail"));
$existing_comments = "";

$dec = 0;
if (isset($selected_id))
{
	$myrow = get_work_order($selected_id, true);

	if ($myrow === false)
	{
		echo _("The order number sent is not valid.");
		safe_exit();
	}

	// if it's a closed work order can't edit it
	if ($myrow["closed"] == 1)
	{
		echo "<center>";
		display_error(_("This work order is closed and cannot be edited."));
		safe_exit();
	}

	$_POST['wo_ref'] = $myrow["wo_ref"];
	$_POST['stock_id'] = $myrow["stock_id"];
	//$_POST['quantity'] = qty_format($myrow["units_reqd"], $_POST['stock_id'], $dec);
	$_POST['quantity'] = $myrow["units_reqd"];
	$_POST['StockLocation'] = $myrow["loc_code"];
	$_POST['released'] = $myrow["released"];
	$_POST['closed'] = $myrow["closed"];
	$_POST['type'] = $myrow["type"];
	$_POST['date_'] = sql2date($myrow["date_"]);
	$_POST['RequDate'] = sql2date($myrow["required_by"]);
	$_POST['released_date'] = sql2date($myrow["released_date"]);
	$_POST['units_issued'] = $myrow["units_issued"];
	$_POST['Costs'] = price_format($myrow["additional_costs"]);

	$_POST['memo_'] = get_comments_string(ST_WORKORDER, $selected_id);

	hidden('wo_ref', $_POST['wo_ref']);
	hidden('units_issued', $_POST['units_issued']);
	hidden('released', $_POST['released']);
	hidden('released_date', $_POST['released_date']);
	hidden('selected_id',  $selected_id);

	label_row(_("Reference:"), $_POST['wo_ref']);
	label_row(_("Type:"), $wo_types_array[$_POST['type']]);
	hidden('type', $myrow["type"]);
}
else
{
	$_POST['units_issued'] = $_POST['released'] = 0;

	ref_row(_("Reference:"), 'wo_ref', '', $Refs->get_next(ST_WORKORDER, null, get_post('date_')), false, ST_WORKORDER);

	// if(!$_POST['type'])
	// 	$_POST['type'] = 2;
	wo_types_list_row(_("Type:"), 'type', null);
}

if (get_post('released'))
{
	hidden('stock_id', $_POST['stock_id']);
	hidden('StockLocation', $_POST['StockLocation']);
	hidden('type', $_POST['type']);

	label_row(_("Item:"), $myrow["StockItemName"]);
	label_row(_("Destination Location:"), $myrow["location_name"]);
}
else
{
	// stock_manufactured_items_list_row(_("Item:"), 'stock_id', null, false, true);
	hidden('stock_id', '50196340');
	if (list_updated('stock_id'))
		$Ajax->activate('quantity');

	locations_list_row(_("Destination Location:"), 'StockLocation', null,false,true);
}

if (!isset($_POST['quantity']))
	$_POST['quantity'] = qty_format(1, $_POST['stock_id'], $dec);
else
	$_POST['quantity'] = qty_format($_POST['quantity'], $_POST['stock_id'], $dec);
	

if (get_post('type') == WO_ADVANCED  || WO_PIPES)
{
    // qty_row(_("Quantity Required:"), 'quantity', null, null, null, $dec);
    hidden('quantity', 1);
    if ($_POST['released'])
    	label_row(_("Quantity Manufactured:"), number_format($_POST['units_issued'], get_qty_dec($_POST['stock_id'])));
    date_row(_("Date") . ":", 'date_', '', true);
	date_row(_("Date Required By") . ":", 'RequDate', '', null, $SysPrefs->default_wo_required_by());

	if (!isset($_POST['Labour']) || list_updated('stock_id') || list_updated('type'))
	{
		$bank_act = get_default_bank_account();
		$item = get_item(get_post('stock_id'));
		$_POST['Labour'] = price_format(get_post('type') == WO_ASSEMBLY ? $item['labour_cost'] : 0);
		$_POST['cr_lab_acc'] = $bank_act['account_code'];
		$_POST['Costs'] = price_format(get_post('type') == WO_ASSEMBLY ? $item['overhead_cost'] : 0);
		$_POST['cr_acc'] = $bank_act['account_code'];
		$Ajax->activate('_page_body');
	}

	// amount_row($wo_cost_types[WO_LABOUR], 'Labour');
	// gl_all_accounts_list_row(_("Credit Labour Account"), 'cr_lab_acc', get_company_prefs()["credit_labour_acc"]);
	// amount_row($wo_cost_types[WO_OVERHEAD], 'Costs');
	// gl_all_accounts_list_row(_("Credit Overhead Account"), 'cr_acc', get_company_prefs()["credit_overhead_acc"]);

}
else
{
    qty_row(_("Quantity:"), 'quzantity', null, null, null, $dec);
    date_row(_("Date") . ":", 'date_', '', true);
	hidden('RequDate', '');

	// if (!isset($_POST['Labour']) || list_updated('stock_id') || list_updated('type'))
	// {
	// 	$bank_act = get_default_bank_account();
	// 	$item = get_item(get_post('stock_id'));
	// 	$_POST['Labour'] = price_format(get_post('type') == WO_ASSEMBLY ? $item['labour_cost'] : 0);
	// 	$_POST['cr_lab_acc'] = $bank_act['account_code'];
	// 	$_POST['Costs'] = price_format(get_post('type') == WO_ASSEMBLY ? $item['overhead_cost'] : 0);
	// 	$_POST['cr_acc'] = $bank_act['account_code'];
	// 	$Ajax->activate('_page_body');
	// }

}
     	// $bank_act = get_default_bank_account();
     	if(!  $_POST['cr_lab_acc'] )
     $_POST['cr_lab_acc'] = get_company_prefs()["credit_labour_acc"];
 if(!$_POST['no_of_charges'])
 	$_POST['no_of_charges']=1;

    amount_row("No Of Labour Charge", 'no_of_charges',null,null,null,null,true);

	// $pr_data=$_SESSION['wo']->gl_total_item_and_price();
   // if($_POST['type'] == 2){
   // 	$_POST['Labour']=$_POST['per_cost'] * $pr_data['tot_bags'];
   // }else{
   // 	$_POST['Labour']=$_POST['per_cost'] * $pr_data['pack_qty'];
   // }


	for ($i=0; $i < $_POST['no_of_charges'] ; $i++) { 
    table_section_title(_("Labour Cost ".($i+1) ));
	// code...
			// start_table(TABLESTYLE, "width='100%'");
// display_heading('By-Product');
	amount_row("Per Labour cost", 'per_cost'.$i,null,null,null,null,true);
	amount_row("No of Bags", 'labour_of_bags'.$i,null,null,null,null,true);

      $_POST['Labour'.$i]=$_POST['per_cost'.$i]*$_POST['labour_of_bags'.$i];
	amount_row($wo_cost_types[WO_LABOUR], 'Labour'.$i);
	gl_all_accounts_list_row(_("Credit Labour Account"), 'cr_lab_acc'.$i, null);
	// end_table();
	}
    table_section_title(_("Over Head"));

	amount_row($wo_cost_types[WO_OVERHEAD], 'Costs');
	gl_all_accounts_list_row(_("Credit Overhead  Account"), 'cr_acc', null);
if (get_post('released')){
	label_row(_("Released On:"),$_POST['released_date']);
}

// if (($kv_batch || $kv_exp_date) && (get_post('released') || get_post('type') != WO_ADVANCED)) {	
// 	text_row(_("Batch No:"), 'batch_no', null, 20, 20);	
// 	if($kv_exp_date)
// 		date_row(_("Exp Date:"), 'exp_date', null, null, null, $dec);
// } else {
// 	hidden('batch_no' , 0);
// 	hidden('exp_date' , '');
// 	hidden('kv_batch' , 1);	
// }

textarea_row(_("Memo:"), 'memo_', null, 20, 5);
table_section(2,"80%");
echo "<tr><td>";
if($_POST['type'] == 2)
display_wo_items(_("Row Material"), $_SESSION['wo'], $kv_batch, $kv_exp_date);
else
display_wo_items(_("Semi / Finish Items"), $_SESSION['wo'], $kv_batch, $kv_exp_date);
echo "</td></tr>";

echo "<tr><td>";

	start_table(TABLESTYLE, "width='100%'");
display_heading('By-Product');
$result = item_wise_westage($_POST['type']);
$i = 1;

$th = array(_("Item Description"),_("Batch # "),_("Qty"),_("Price"), _("Pack Size")
        , _("Pack Unit") , _("No of Pack"),_("Line Totl"));
table_header($th);
$by_p_qty=$by_p_tot=0;
while ($myrow = db_fetch($result)) {

	start_row();
	global $Ajax;
	// if(!$_POST['westage_item'.$i] && !list_updated('type'))
		$_POST['by_pord_item'.$i] = $myrow['stock_id_'];
		// display_error($_POST['by_pord_item'.$i] .'=='. $myrow['stock_id_']);
	$item_name_ = get_item($_POST['by_pord_item'.$i]);
	label_cell($_POST['by_pord_item'.$i] .' '. $item_name_['description']);
	hidden('by_pord_item'.$i, $_POST['by_pord_item'.$i]);
	// stock_component_items_list_rows(_("Westage"), 'westage_item'.$i, null, $_POST['westage_item'.$i], false, true);
	text_cells(null,'by_pord_batch_no'.$i, $_POST['by_pord_batch_no'.$i], 50, 40);

	text_cells(null,'by_pord_qty'.$i, $_POST['by_pord_qty'.$i], 40, 100, null, "", "", "",true);
		amount_cells(null, 'by_pord_cost'.$i, $_POST['by_pord_cost'.$i],null,null,null,true);

	amount_cells_ex(null, 'by_pord_pack_size'.$i, 25, 25, $_POST['by_pord_pack_size'.$i], null, null, 1,true);
	stock_packing_unit_list_cells(null, 'by_pord_pack_unit'.$i, $_POST['by_pord_pack_unit'.$i]);
			$_POST['by_pord_no_of_pack'.$i]=(input_num('by_pord_qty'.$i))/input_num('by_pord_pack_size'.$i);

        amount_cells_ex(null, 'by_pord_no_of_pack'.$i, 30, 30, $_POST['by_pord_no_of_pack'.$i], null, null, 1,true);
		global $Ajax;
		   $Ajax->activate('f_no_of_pack');


		label_cell(input_num('by_pord_qty'.$i)*input_num('by_pord_cost'.$i));
		if(!$myrow['is_not_cal'])
		$by_p_qty+=input_num('by_pord_qty'.$i);
		$by_p_tot+=input_num('by_pord_cost'.$i)*input_num('by_pord_qty'.$i);
	$Ajax->activate('_page_body');
	$i++;
	end_row();
} 

 end_table();

echo "</td></tr>";


end_outer_table();

start_outer_table(TABLESTYLE2, "width='100%'");
// table_section(1,"20%");

// display_heading('By-Product');
// $result = item_wise_westage($_POST['type']);
// $i = 1;

// $th = array(_("Item Description"),_("Qty"),_("Price"),_("Line Totl"));
// table_header($th);
// $by_p_qty=$by_p_tot=0;
// while ($myrow = db_fetch($result)) {

// 	start_row();
// 	global $Ajax;
// 	// if(!$_POST['westage_item'.$i] && !list_updated('type'))
// 		$_POST['by_pord_item'.$i] = $myrow['stock_id_'];
// 		// display_error($_POST['by_pord_item'.$i] .'=='. $myrow['stock_id_']);
// 	$item_name_ = get_item($_POST['by_pord_item'.$i]);
// 	label_cell($_POST['by_pord_item'.$i] .' '. $item_name_['description']);
// 	hidden('by_pord_item'.$i, $_POST['by_pord_item'.$i]);
// 	// stock_component_items_list_rows(_("Westage"), 'westage_item'.$i, null, $_POST['westage_item'.$i], false, true);

// 	text_cells(null,'by_pord_qty'.$i, $_POST['by_pord_qty'.$i], 25, 100, null, "", "", "",true);
// 		amount_cells(null, 'by_pord_cost'.$i, $_POST['by_pord_cost'.$i],null,null,null,true);
// 		label_cell(input_num('by_pord_qty'.$i)*input_num('by_pord_cost'.$i));
// 		$by_p_qty+=input_num('by_pord_qty'.$i);
// 		$by_p_tot+=input_num('by_pord_cost'.$i)*input_num('by_pord_qty'.$i);
// 	$Ajax->activate('_page_body');
// 	$i++;
// 	end_row();
// }


	$pr_data=$_SESSION['wo']->gl_total_item_and_price();
  // print_r($pr_data);

  // display_error($pr_data['total']." =----- ".$_SESSION['wo']->get_packing_material_count());
	

  $_POST['remain_qty']=$pr_data['qty']-$by_p_qty;
  $_POST['total_price']=($pr_data['total']+input_num('Labour')+ input_num('Costs'))-$by_p_tot;
table_section(1,"100%");
echo "<tr><td>";
// display_error($_POST['type']." <-- ");
if($_POST['type'] == 2)
display_wo_items_finish(_("Semi / Finish Items"), $_SESSION['wo'], $kv_batch, $kv_exp_date);
else{
	
display_wo_items_finish_packing($_SESSION['wo'],-1, $kv_batch, $kv_exp_date);
}
echo "</td></tr>";
end_outer_table();

if (isset($selected_id))
{
	echo "<table align=center><tr>";

	submit_cells('UPDATE_ITEM', _("Update"), '', _('Save changes to work order'), 'default');
	if (get_post('released'))
	{
		submit_cells('close', _("Close This Work Order"),'','',true);
	}
	submit_cells('delete', _("Delete This Work Order"),'','',true);

	echo "</tr></table>";
}
else
{
	submit_center('ADD_ITEM', _("Add Workorder"), true, '', 'default');
}

end_form();
end_page();

