<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/ui/items_cart.inc");

//--------------------------------------------------------------------------------

function add_to_wo(&$order, $new_item, $new_item_qty, $standard_cost, $batch_no=null, $exp_date =null,
	$pack_size =0 ,$pack_unit =null ,$no_of_pack =0)
{
// print_r($order->line_items);
   // if ($order->find_cart_item($new_item))
       //  display_error(_("For Part :") . $new_item . " " . "This item is already on this issue.  You can change the quantity issued of the existing line if necessary.");
	//else
     $order->add_to_cart (count($order->line_items), $new_item, $new_item_qty, $standard_cost, null,  $batch_no, $exp_date,0, $pack_size, $pack_unit, $no_of_pack);
}

// Workorder Finish Semi Items
//--------------------------------------------------------------------------------

function add_to_wo_finish(&$order, $new_item, $new_item_qty, $standard_cost, $batch_no=null, $exp_date =null ,$pack_size =0 ,$pack_unit =null ,$no_of_pack =0)
{
// print_r($order->line_items);
   // if ($order->find_cart_item($new_item))
       //  display_error(_("For Part :") . $new_item . " " . "This item is already on this issue.  You can change the quantity issued of the existing line if necessary.");
	//else
     $order->add_to_cart_finish(count($order->line_items_finish), $new_item, $new_item_qty, $standard_cost, null,  $batch_no, $exp_date, $pack_size, $pack_unit, $no_of_pack);
}
//---------------------------------------------------------------------------------

function display_wo_items($title, &$order, $kv_batch=0, $kv_exp_date = 0) {
	global $path_to_root;

	display_heading($title);
    div_start('items_table');
	start_table(TABLESTYLE, "width='100%'");
	$th = array(_("Item Code"), _("Item Description"),  _("Qty"),_("Price"), _("Line Total	"), '');
	if ( count($order->line_items)) $th[] = ''; //, _("Unit Cost")
	if($kv_exp_date){
			array_splice( $th, 2, 0, _("Batch No") );
			array_splice( $th, 3, 0, _("Exp Date") );
		}elseif($kv_batch){
			array_splice( $th, 2, 0, _("Batch No") );
		}

			array_splice( $th, 4, 0, _("Pack Size") );
		array_splice( $th, 5, 0, _("Pack Unit") );
		array_splice( $th, 6, 0, _("No of Pack") );	
	// if ($_POST['type'] == 4) {
	// 	array_splice( $th, 3, 0, _("Westage") );
	// }
	
	table_header($th);
//	$total = 0;
	// print_r($order->line_items);
	$k = 0;  //row colour counter

	if (count($order->line_items))
		$low_stock = $order->check_qoh($_POST['StockLocation'], $_POST['date_'],true);
	// display_error($_POST['StockLocation']." == ".$_POST['date_']);
	// print_r($low_stock);
	$id = find_submit('Edit');
    // $raw_qty_sum=0;
	foreach ($order->line_items as $line_no=>$stock_item)
	{
		if ($id != $line_no)
		{
			if (in_array($stock_item->stock_id, $low_stock))
				start_row("class='stockmankobg'");	// notice low stock status
			else 
				alt_table_row_color($k);

			view_stock_status_cell($stock_item->stock_id);
			label_cell($stock_item->item_description);
			if($kv_exp_date){
				label_cell($stock_item->batch_no);
				label_cell($stock_item->exp_date);
			}elseif($kv_batch)
				label_cell($stock_item->batch_no);
			// if($_POST['type'] == 4)
			// 		label_cell($stock_item->westage);
    		qty_cell($stock_item->quantity, false, get_qty_dec($stock_item->stock_id));
				label_cell($stock_item->pack_size);
			label_cell($stock_item->pack_unit);
			label_cell($stock_item->no_of_pack);
			amount_cell($stock_item->standard_cost);


			// $line_total = round(($stock_item->standard_cost) ? $stock_item->standard_cost : 1 * $stock_item->quantity, user_price_dec());
			$line_total = round($stock_item->standard_cost * $stock_item->quantity, user_price_dec());
			amount_cell($line_total);

			// edit_button_cell("Edit$line_no", _("Edit"),
			// 	_('Edit document line'));
			label_cell('-');
			delete_button_cell("Delete$line_no", _("Delete"),
				_('Remove line from document'));
			end_row();
		}	else {
			wo_edit_item_controls($order, $line_no, $kv_batch,$kv_exp_date);
		}
	
		$total_unit_cost += $stock_item->standard_cost *  $stock_item->quantity;
	}



	if ($id == -1)
		wo_edit_item_controls($order, -1, $kv_batch,$kv_exp_date);
	label_cells(_("Sub Total"),price_format($total_unit_cost),"colspan='8' align=right","align=right");
	label_cell("",'colspan="2"');
    end_table();
	if (@$low_stock)
		display_note(_("Marked items have insufficient quantities in stock as on day of issue."), 0, 1, "class='stockmankofg'");
	div_end();
}

//---------------------------------------------------------------------------------

function wo_edit_item_controls(&$order, $line_no=-1, $kv_batch=0, $kv_exp_date=0)
{
	global $Ajax;
	start_row();

	$id = find_submit('Edit');
	if ($line_no != -1 && $line_no == $id)
	{
		$_POST['row_stock_id'] = $order->line_items[$id]->stock_id;
		$_POST['qty'] = qty_format($order->line_items[$id]->quantity, 
			$order->line_items[$id]->stock_id, $dec);
		// $std_cost = $order->line_items[$id]->standard_cost;
		// $_POST['units'] = $order->line_items[$id]->units;
		$_POST['row_batch_no'] = $order->line_items[$id]->batch_no;
		$_POST['exp_date'] = $order->line_items[$id]->exp_date;
		$_POST['thickness'] = $order->line_items[$id]->thickness;
		$_POST['width'] = $order->line_items[$id]->width;

		hidden('stock_id', $_POST['row_stock_id']);
		label_cell($_POST['row_stock_id']);
		label_cell($order->line_items[$id]->item_description);
		// if($kv_batch || $kv_exp_date){
		// 	label_cell($_POST['row_batch_no']);
		// 	// label_cell($_POST['exp_date']);		
		// }
	    $Ajax->activate('items_table');
	}
	else
	{
  		stock_component_items_list_cells(null, 'row_stock_id',  null, null, false, true, false, 'stock_purchased');
		if (list_updated('row_stock_id')) {
			    $Ajax->activate('units');
			    $Ajax->activate('qty');
			    $Ajax->activate('std_cost');
				$Ajax->activate('items_table');
		}
		
		// if($kv_batch || $kv_exp_date) {
		// 	kv_batch_list_cells(null, 'row_batch_no', null, true);
		// 	if(list_updated('stock_id') || list_updated('row_batch_no') || get_post('row_batch_no')){				
		// 		if(get_post('row_batch_no') != '' || get_post('row_batch_no') != null ){
		// 			$sql0 =" SELECT SUM(qty) AS Stock, exp_date FROM ".TB_PREF."stock_moves WHERE row_batch_no=".db_escape(get_post('row_batch_no'))." AND stock_id=".db_escape(get_post('stock_id'));  
		// 			$res = db_query($sql0, "can't execute the query");
		// 			$row_res = db_fetch_row($res);		
		// 			$_POST['qty'] = $row_res[0];	
		// 			$exp_date = sql2date($row_res[1]);	
		// 			hidden('exp_date', $exp_date);
		// 			if($kv_exp_date)
		// 				label_cell($exp_date);						
		// 		} else {					
		// 			$_POST['qty'] = 0;
		// 			if($kv_exp_date)
		// 				date_cells(null, 'exp_date', null);
		// 		}
		// 		$Ajax->activate('items_table');
		// 	}	else {
		// 		$_POST['qty'] = 0;
		// 		if($kv_exp_date)
		// 			date_cells(null, 'exp_date', null);
		// 	}
		// }	else{
		// 	hidden('row_batch_no', 0);
		// 	$_POST['qty'] = 0;
		// }
    	$item_info = get_item_edit_info($_POST['row_stock_id']);

   		$dec = $item_info["decimals"];
   		// if(!$_POST['qty'] && list_updated('row_batch_no')){
   		// }
   		$std_cost = get_betch_price($_POST['row_batch_no'], $_POST['row_stock_id']);
   		// $_POST['qty'] =	number_format2(0, $dec);
		// $std_cost = $item_info["material_cost"];
		$_POST['units'] = $item_info["units"];
	}
	// if($_POST['row_batch_no'] || $id != -1){
	// 	$row_res = get_betch_price($_POST['row_batch_no'], $_POST['row_stock_id']);
	// 	$_POST['qty'] = $row_res['Stock'];	
	// }

	// if($_POST['westage'])
	// 	$_POST['qty'] =  $_POST['qty']-$_POST['westage'];;

	kv_batch_list_cells(null, 'row_batch_no', $_POST['row_batch_no'], true, true, get_post('row_stock_id'), get_post('StockLocation'));
	// if($_POST['type'] == 4)
	// 	text_cells(null, 'westage', $_POST['westage'], 6, 200, false, "", "", "", true);
	   amount_cells_ex(null, 'qty',30,30, $_POST['qty'], null, null, $dec,true);
	
		$p_row=get_batch_packing($_POST["row_batch_no"],$_POST['row_stock_id']);
		label_cell($p_row['pack_size']);
		label_cell($p_row['pack_unit']);
		label_cell(input_num('qty')/$p_row['pack_size']); // no of pack calculate ..
		hidden('pack_size',$p_row['pack_size']);
		hidden('pack_unit',$p_row['pack_unit']);
		hidden('no_of_pack',input_num('qty')/$p_row['pack_size']);

		// amount_cells(null, 'pack_size', $_POST['pack_size'], null, null, $dec, true);
		// stock_packing_unit_list_cells(null, 'pack_unit', $_POST['pack_unit']);

		// // if(input_num('pack_size'))
		// $_POST['no_of_pack']=(input_num('qty'))/input_num('pack_size');
		// qty_cells(null, 'no_of_pack',$_POST[ 'no_of_pack'] , "align=right ", null, $dec,'readonly');

		global $Ajax;
		$Ajax->activate('no_of_pack');
	// text_cells(null, 'thickness', $_POST['thickness'], 6, 200, false, "", "", "", false);
	// text_cells(null, 'width', $_POST['width'], 6, 200, false, "", "", "", false);
	// label_cell($_POST['units'], '', 'units');

	// amount_cells(null, 'std_cost', $_POST['std_cost']);
	label_cell($std_cost);
	hidden('std_cost', $std_cost);
	label_cell($std_cost*$_POST['qty']);
	// amount_cell($std_cost);

	if ($id != -1)
	{
		button_cell('UpdateItem', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('LineNo', $line_no);
 		set_focus('qty');
	}
	else
	{
		submit_cells('AddItem', _("Add Item"), "colspan=2",
		    _('Add new item to document'), true);
	}

	end_row();
}

//---------------------------------------------------------------------------------------------------
// For Service Semi / Finish
//---------------------------------------------------------------------------------

function display_wo_items_finish($title, &$order, $kv_batch=0, $kv_exp_date = 0) {
	global $path_to_root;

	display_heading($title);
    div_start('finish_items_table');
	start_table(TABLESTYLE, "width='80%'");
	$th = array(_("Item Code"), _("Item Description"),_("Qty"),_("Waste Qty"),_("Price"), _("Line Total"), '');
	if ( count($order->line_items_finish)) $th[] = ''; //, _("Unit Cost")
	if($kv_exp_date){
			array_splice( $th, 2, 0, _("Batch No") );
			array_splice( $th, 3, 0, _("Exp Date") );
		}elseif($kv_batch){
			array_splice( $th, 2, 0, _("Batch No") );
		}
		array_splice( $th, 5, 0, _("Pack Size") );
		array_splice( $th, 6, 0, _("Pack Unit") );
		array_splice( $th, 7, 0, _("No of Pack") );

	table_header($th);
//	$total = 0;
	// print_r($order->line_items_finish);
	$k = 0;  //row colour counter

	if (count($order->line_items_finish))
		$low_stock = $order->check_qoh($_POST['Location'], $_POST['date_']);
	$id = find_submit('edit2');

	foreach ($order->line_items_finish as $line_no=>$stock_item)
	{
		if ($id != $line_no)
		{
			if (in_array($stock_item->stock_id, $low_stock))
				start_row("class='stockmankobg'");	// notice low stock status
			else 
				alt_table_row_color($k);

			view_stock_status_cell($stock_item->stock_id);
			label_cell($stock_item->item_description);
			if($kv_exp_date){
				label_cell($stock_item->batch_no);
				label_cell($stock_item->exp_date);
			}elseif($kv_batch)
				label_cell($stock_item->batch_no);
    		qty_cell($stock_item->quantity, false, get_qty_dec($stock_item->stock_id));
    				label_cell($stock_item->pack_unit);
			label_cell($stock_item->no_of_pack);
			amount_cell($stock_item->standard_cost);
			// amount_cell($stock_item->standard_cost);
			$line_total = round(($stock_item->standard_cost) ? $stock_item->standard_cost : 1 * $stock_item->quantity, user_price_dec());
			amount_cell($line_total);
//			amount_cell($stock_item->standard_cost * $stock_item->quantity);

			edit_button_cell("edit2$line_no", _("Edit"),
				_('Edit document line'));
			delete_button_cell("Delete2$line_no", _("Delete"),
				_('Remove line from document'));
			end_row();
		}	else {
			finish_wo_edit_item_controls($order, $line_no, $kv_batch,$kv_exp_date);
		}

		$total_unit_cost_ += $line_total;
	}

	if ($id == -1)
		finish_wo_edit_item_controls($order, -1, $kv_batch,$kv_exp_date);

	label_cells(_("Sub Total"),price_format($total_unit_cost_),"colspan='5' align=right","align=right");
    end_table();
	if (@$low_stock)
		display_note(_("Marked items have insufficient quantities in stock as on day of issue."), 0, 1, "class='stockmankofg'");
	div_end();
}

//---------------------------------------------------------------------------------

function finish_wo_edit_item_controls(&$order, $line_no=-1, $kv_batch=0, $kv_exp_date=0)
{
	global $Ajax;
	start_row();

	$id = find_submit('edit2');
	if ($line_no != -1 && $line_no == $id)
	{
		$_POST['finish_stock_id'] = $order->line_items_finish[$id]->finish_stock_id;
		$_POST['finish_qty'] = qty_format($order->line_items_finish[$id]->quantity, 
			$order->line_items_finish[$id]->finish_stock_id, $dec);
		// $std_cost = $order->line_items_finish[$id]->standard_cost;
		// // $_POST['units'] = $order->line_items_finish[$id]->units;
		$_POST['weight'] = $order->line_items_finish[$id]->weight;
		if ($_POST['type'] == 2) {
			$_POST['semi_finish_thickness'] = $order->line_items_finish[$id]->thickness;
			$_POST['semi_finish_width'] = $order->line_items_finish[$id]->width;
		}

		if ($_POST['type'] == 4) {
			$_POST['bundle'] = $order->line_items_finish[$id]->bundle;
			$_POST['weight'] = $order->line_items_finish[$id]->weight;
			$_POST['length'] = $order->line_items_finish[$id]->length;
		}

		// $_POST['exp_date'] = $order->line_items_finish[$id]->exp_date;
		hidden('finish_stock_id', $_POST['finish_stock_id']);
		label_cell($_POST['finish_stock_id']);
		label_cell($order->line_items_finish[$id]->item_description);

	    $Ajax->activate('finish_items_table');
	}
	else
	{
		
		if (list_updated('finish_stock_id')) {
			    $Ajax->activate('finish_qty');
			    $Ajax->activate('finish_std_cost');
				$Ajax->activate('finish_items_table');
		}
		
		// if($kv_batch || $kv_exp_date) {
		// 	kv_batch_list_cells(null, 'batch_no', null, true);
		// 	if(list_updated('stock_id') || list_updated('batch_no') || get_post('batch_no')){				
		// 		if(get_post('batch_no') != '' || get_post('batch_no') != null ){
		// 			$sql0 =" SELECT SUM(qty) AS Stock, exp_date FROM ".TB_PREF."stock_moves WHERE batch_no=".db_escape(get_post('batch_no'))." AND stock_id=".db_escape(get_post('stock_id'));  
		// 			$res = db_query($sql0, "can't execute the query");
		// 			$row_res = db_fetch_row($res);		
		// 			$_POST['qty'] = $row_res[0];	
		// 			$exp_date = sql2date($row_res[1]);	
		// 			hidden('exp_date', $exp_date);
		// 			if($kv_exp_date)
		// 				label_cell($exp_date);						
		// 		} else {					
		// 			$_POST['qty'] = 0;
		// 			if($kv_exp_date)
		// 				date_cells(null, 'exp_date', null);
		// 		}
		// 		$Ajax->activate('items_table');
		// 	}	else {
		// 		$_POST['qty'] = 0;
		// 		if($kv_exp_date)
		// 			date_cells(null, 'exp_date', null);
		// 	}
		// }	else{
		// 	hidden('batch_no', 0);
		// 	$_POST['qty'] = 0;
		// }
    	$item_info = get_item_edit_info($_POST['finish_stock_id']);

   		$dec = $item_info["decimals"];
   		if(!$_POST['finish_qty'])
   		$_POST['finish_qty'] =	number_format2(0, $dec);
		// $std_cost = $item_info["material_cost"];
		$std_cost=get_betch_price($_POST['finish_batch_no'],$_POST['finish_stock_id'],true);
		// $_POST['units'] = $item_info["units"];
	}

    // 	$_POST['finish_batch_no'] = 'B: ' . $_POST['bundle'] . ': W: ' . $_POST['weight'];
	// else
	// if ($_POST['type'] == 4) 
	$_POST['finish_batch_no'] = $_POST['wo_ref'];
	if($_POST['finish_batch_no'])
		$Ajax->activate('_page_body');

	// $s_no = 1;
	// if ($_POST['type'] == 2) {
	// 	$_POST['finish_batch_no'] = $_POST['wo_ref'].'-'.$s_no++;
	// 	foreach ($_SESSION['wo']->line_items_finish as $line_no=>$stock_item)
	//    	{
	   		// $_POST['finish_batch_no'] = $_POST['wo_ref'].'-'.$s_no++;
	// 	}
	// }

	if(input_changed('finish_qty')){

		if(input_num('finish_qty')>$_POST['remain_qty']){
			display_error(_(" Finsh item qty can not increase Raw material qty"));
		  $_POST['finish_qty']=$_POST['remain_qty'];
		}else{
			$_POST['waste_finish_qty']=$_POST['remain_qty']-input_num('finish_qty');
		}

	}

	

	if(!$_POST['finish_stock_id'])
	$_POST['finish_stock_id']='FG-002';
  stock_component_items_list_cells(null, 'finish_stock_id',  null, null, false, true);
$_POST['finish_qty']=$_POST['remain_qty']-$_POST['waste_finish_qty'];
$_POST['f_std_cost']=$_POST['total_price']/$_POST['finish_qty'];

	text_cells(null,'finish_batch_no', $_POST['finish_batch_no'], 200, 100);
	amount_cells_ex(null, 'finish_qty',100,100, $_POST['finish_qty'], null, null, $dec,true);
	amount_cells_ex(null, 'waste_finish_qty',50,50, $_POST['waste_finish_qty'], null, null, $dec);
	amount_cells_ex(null, 'f_pack_size', 50, 50, $_POST['f_pack_size'], null, null, 1,true);
		stock_packing_unit_list_cells(null, 'f_pack_unit', $_POST['f_pack_unit']);

		// if(input_num('pack_size'))
		$_POST['f_no_of_pack']=(input_num('finish_qty'))/input_num('f_pack_size');
		// qty_cells(null, 'f_no_of_pack',$_POST[ 'f_no_of_pack'] , "align=right ", null, $dec,'readonly');

        amount_cells_ex(null, 'f_no_of_pack', 80, 80, $_POST['f_no_of_pack'], null, null, 1,true);
		global $Ajax;
		   $Ajax->activate('f_no_of_pack');
	// label_cell($_POST['units'], '', 'units');

	// amount_cells(null, 'f_std_cost', $_POST['f_std_cost']);
		amount_cells_ex(null, 'f_std_cost', 80, 80, $_POST['f_std_cost'], null, null, 1,true);
	// hidden('finish_std_cost', $std_cost);
	amount_cell($_POST['f_std_cost']*$_POST['finish_qty']);

	if ($id != -1)
	{
		button_cell('UpdateItem2', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges2', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('LineNo2', $line_no);
 		set_focus('finish_qty');
	}
	else
	{
			submit_cells('Calculte', _("Update"), "colspan=2",
		    _('Add new item to document'), true);
		// submit_cells('AddItemFinish', _("Add Finish Item"), "colspan=2",
		//     _('Add new item to document'), true);
	}

	end_row();
}


function display_wo_items_finish_packing(&$order, $line_no=-1, $kv_batch=0, $kv_exp_date=0,$count=0)
{
	global $Ajax;

	
	$th = array(_("Item Code"), _("Item Description"),_("Qty"),_("Waste Qty"),_("Price"), _("Line Total"), '');
	if ( count($order->line_items_finish)) $th[] = ''; //, _("Unit Cost")
	if($kv_exp_date){
			array_splice( $th, 2, 0, _("Batch No") );
			array_splice( $th, 3, 0, _("Exp Date") );
		}elseif($kv_batch){
			array_splice( $th, 2, 0, _("Batch No") );
		}
		array_splice( $th, 5, 0, _("Pack Size") );
		array_splice( $th, 6, 0, _("Pack Unit") );
		array_splice( $th, 7, 0, _("No of Pack") );

	table_header($th);



	



	  // print_r($order);

	$pr_data=$_SESSION['wo']->gl_total_item_and_price();
  print_r($pr_data);
  $row_cost=$pr_data['total']/$pr_data['qty'];
      $array_pack=$order->get_packing_material_count();
   // display_error($no_of_count." sami ");
// display_error($_POST['remain_qty']." == ".$_POST['total_price']);
	for ($i=0; $i < count($array_pack) ; $i++) { 
	start_row();

		if(input_changed('finish_qty'.$i)){

		if(input_num('finish_qty'.$i)>$array_pack[$i]->quantity){
			display_error(_(" Finsh item qty can not increase Raw material qty"));
		  $_POST['finish_qty'.$i]=$array_pack[$i]->quantity;
		}else{
			$_POST['waste_finish_qty'.$i]=$array_pack[$i]->quantity-input_num('finish_qty'.$i);
		}

	}
	
		// code...
	if(!$_POST['finish_stock_id'.$i])
	$_POST['finish_stock_id'.$i]='FG-002';
  stock_component_items_list_cells(null, 'finish_stock_id'.$i,  null, null, false, true);
  // display_error($array_pack[$i]->quantity."  counts");
$_POST['finish_qty'.$i]=$array_pack[$i]->quantity-$_POST['waste_finish_qty'.$i];
$_POST['f_std_cost'.$i]=(($row_cost+$array_pack[$i]->standard_cost)*($_POST['finish_qty'.$i]+$_POST['waste_finish_qty'.$i] ))/$_POST['finish_qty'.$i] ;
// display_error($_POST['f_std_cost']);
	$_POST['finish_batch_no'.$i] = $_POST['wo_ref'];
	// display_error($_POST['finish_batch_no'.$i]);
	text_cells(null,'finish_batch_no'.$i, $_POST['finish_batch_no'.$i], 200, 100);
	amount_cells_ex(null, 'finish_qty'.$i,100,100, $_POST['finish_qty'.$i], null, null, $dec,true);
	amount_cells_ex(null, 'waste_finish_qty'.$i,50,50, $_POST['waste_finish_qty'.$i], null, null, $dec);
	amount_cells_ex(null, 'f_pack_size'.$i, 50, 50, $_POST['f_pack_size'.$i], null, null, 1,true);
		stock_packing_unit_list_cells(null, 'f_pack_unit'.$i, $_POST['f_pack_unit'.$i]);

		// if(input_num('pack_size'))
		$_POST['f_no_of_pack'.$i]=(input_num('finish_qty'.$i))/input_num('f_pack_size'.$i);
		// qty_cells(null, 'f_no_of_pack',$_POST[ 'f_no_of_pack'] , "align=right ", null, $dec,'readonly');

        amount_cells_ex(null, 'f_no_of_pack'.$i, 80, 80, $_POST['f_no_of_pack'.$i], null, null, 1,true);
		global $Ajax;
		   $Ajax->activate('f_no_of_pack');
	// label_cell($_POST['units'], '', 'units');

	// amount_cells(null, 'f_std_cost', $_POST['f_std_cost']);
		amount_cells_ex(null, 'f_std_cost'.$i, 80, 80, $_POST['f_std_cost'.$i], null, null, 1,true);
	// hidden('finish_std_cost', $std_cost);
	amount_cell($_POST['f_std_cost'.$i]*$_POST['finish_qty'.$i]);

	// if ($id != -1)
	// {
	// 	button_cell('UpdateItem2', _("Update"),
	// 			_('Confirm changes'), ICON_UPDATE);
	// 	button_cell('CancelItemChanges2', _("Cancel"),
	// 			_('Cancel changes'), ICON_CANCEL);
	// 	hidden('LineNo2', $line_no);
 	// 	set_focus('finish_qty');
	// }
	// else
	// {
			submit_cells('Calculte', _("Update".$i), "colspan=2",
		    _('Add new item to document'), true);
		// submit_cells('AddItemFinish', _("Add Finish Item"), "colspan=2",
		//     _('Add new item to document'), true);
	// }

	end_row();
	}

		// if($_POST['finish_batch_no'])
	  global 	$Ajax;
		$Ajax->activate('_page_body');
}

