<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_WORKCENTRES';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/manufacturing/includes/db/wo_item_westage_db.inc");

page(_($help_context = "WorkOrder Item Westage"));
include($path_to_root . "/includes/ui.inc");

simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{
	$input_error = 0;

	if (strlen($_POST['stock_id']) == 0) 
	{
		$input_error = 1;
		display_error(_("The stock_id cannot be empty."));
		set_focus('stock_id');
	}

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_item_westage($selected_id, $_POST['stock_id'],input_num('is_not_cal'));
			$note = _('Selected item has been updated');
    	} 
    	else 
    	{
    		// display_error($_POST['name']);
    		add_item_westage($_POST['wo_type'], $_POST['stock_id'],input_num('is_not_cal'));
			$note = _('New item has been added');
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
}

//----------------------------------------------------------------------------------

if ($Mode == 'Delete')
{

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'stock_master'

	// if (item_unit_used($selected_id))
	// {
	// 	display_error(_("Cannot delete this unit of measure because items have been created using this unit."));

	// }
	// else
	// {
		delete_item_westage($selected_id);
		display_notification(_('Selected item has been deleted'));
	// }
	$Mode = 'RESET';
}


//----------------------------------------------------------------------------------
start_form();
echo "<center> ". "&nbsp;";
wo_types_list_row(_("Type:"), 'wo_type', null);
echo "<hr></center>";

if(list_updated('wo_type'))
	$Ajax->activate('_page_body');

$result = get_item_westages(check_value('show_inactive'), $_POST['wo_type']);

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

start_table(TABLESTYLE, "width='40%'");
$th = array(_('Item Code'), _('Item Description'), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; //row colour counter

while ($myrow = db_fetch($result))
{



	alt_table_row_color($k);
	$item_name = get_item($myrow['stock_id_']);
	label_cell($myrow["stock_id_"], "align='center'");
	label_cell($item_name['description'], "align='center'");
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'wo_item_wesatge', 'id');
 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}

inactive_control_row($th);
end_table(1);

//----------------------------------------------------------------------------------

start_table(TABLESTYLE2, "width=80%");

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing item category

		$myrow = get_item_westage($selected_id);

		$_POST['stock_id'] = $myrow["stock_id_"];
		$_POST['is_not_cal'] = $myrow["is_not_cal"];
		
	}
	hidden('selected_id', $myrow["id"]);
}

stock_component_items_list_rows(_("Items"), 'stock_id', null, $_POST['stock_id'], false, true);
check_row(_("Not Calculate In qty:"), 'is_not_cal', $_POST['is_not_cal'],
	false, _('Set this option to on if not calculate in semi finish qty'));

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();

