<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_MANUFTRANSVIEW';
$path_to_root = "../..";

include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");

include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_ui.inc");
include_once($path_to_root . "/purchasing/includes/ui/po_ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
page(_($help_context = "View Work Order"), true, false, "", $js);

//-------------------------------------------------------------------------------------------------
$woid = 0;
if ($_GET['trans_no'] != "")
{
	$woid = $_GET['trans_no'];
}

display_heading($systypes_array[ST_WORKORDER] . " # " . $woid);

br(1);
$myrow = get_work_order($woid);

if ($myrow["type"]  == WO_ADVANCED)
	display_wo_details($woid, true);
else
	display_wo_details_quick($woid, true);

echo "<center>";

// display the WO requirements
br(1);
// if ($myrow["released"] == false)
// {
//     display_heading2(_("BOM for item:") . " " . $myrow["StockItemName"]);
//     display_bom($myrow["stock_id"],$myrow);
// }
// else
// {
	display_heading2(_("Work Order Requirements"));
     $req_tot_cost =	display_wo_requirements($woid, $myrow["units_reqd"],true,null);
	// if ($myrow["type"] == WO_ADVANCED)
	// {
    	echo "<br><table cellspacing=7 class='tablestyle'><tr valign=top><td>";
    	display_heading2(_("Issues"),0,0,'style="background: #cccccc;"');
    	$tot_issue = display_wo_issues($woid);
    	echo "</td><td>";
    	display_heading2(_("Productions"),0,0,'style="background: #cccccc;"');
        $total_qty = display_wo_productions($woid);
    	echo "</td><td>";
    	display_heading2(_("Additional Costs"),0,0,'style="background: #cccccc;"');
    	if($_SESSION["wa_current_user"]->can_access('SA_WORKORDERCOST')){
    	  $ov_cost =  display_wo_payments($woid);
                echo "</td><td>";
                display_heading2(_("Total Production Costs"),0,0,'style="background: #cccccc;"');
                start_table(TABLESTYLE);
                $th = array(_("Total Costs"), _("Per Unit Costs"));
                  table_header($th);
                $sum_all_cost =$total_qty['amount']+$tot_issue +$ov_cost;
                    amount_cell(  $sum_all_cost);
                        amount_cell($sum_all_cost/ $total_qty['total_qty']);

                        // display_error( $total_qty['total_qty']." == ". $total_qty['amount']);
              end_table();
    	  }
    	echo "</td></tr></table>";
	// }
	// else
	// {
    // 	echo "<br><table cellspacing=7><tr valign=top><td>";
    // 	display_heading2(_("Additional Costs"));
    // 	display_wo_payments($woid);
    // 	echo "</td></tr></table>";
	// }
// }



 $qc_res = get_qc_trans_group_by($_GET['trans_no'], ST_WORKORDER);
if (db_num_rows($qc_res) > 0)
{

    echo "</td><td valign=top>"; // outer table

    display_heading2(_("QC Trans"));
    start_table(TABLESTYLE);
    $th = array(_("#"), _("Date"), _("Qc By"), _("Qc Status"));
    table_header($th);
    while ($myrow = db_fetch($qc_res))
    {
        alt_table_row_color($k);

        label_cell( viewer_link($myrow["trans_no"],'purchasing/view/view_supp_qc.php?trans_no='.$myrow["trans_no"]."&type=".ST_WORKORDER));//get_trans_view_str(ST_QC_TRANS,$myrow["trans_no"])); //get_trans_view_str(ST_SUPPRECEIVE,$myrow["id"])
        label_cell(sql2date($myrow["date_time"]));
        $aud_row=get_audit_trail_last(ST_QC_TRANS, $myrow['trans_no']);
        label_cell(get_user($aud_row['user'])['user_id']);
         label_cell(($myrow["qc_status"]) ? "<span class='label label-success' > Pass <span>": "<span class='label label-danger' > Fail <span>" ,"align='center'");
        end_row();
    }
    end_table();
}





echo "<br></center>";

is_voided_display(ST_WORKORDER, $woid, _("This work order has been voided."));

end_page(true, false, false, ST_WORKORDER, $woid);

