<?php
/*-------------------------------------------------------+
| Invooce Printing for FrontAccounting
| http://www.kvcodes.com/
+--------------------------------------------------------+
| Author: Kvvaradha  
| Email: admin@kvcodes.com
+--------------------------------------------------------+*/
if(!defined('SS_KVIMPORT')){
  define ('SS_KVIMPORT', 234<<8);
}
    
class hooks_Kvcodes_importexport extends hooks {

    function __construct() {
        $this->module_name = 'Kvcodes_importexport';
    }
    
   function install_options($app) {
    global $path_to_root;

     switch($app->id) {
        case 'system':       
          $app->add_rapp_function(1, _("Import/Export"), "modules/Kvcodes_importexport/index.php?", 'SA_IMPORT');
          break;
        case 'GL':       
          $app->add_lapp_function(2, _("Bank statement import Setting"), "modules/Kvcodes_importexport/manage/bank_trans_settings.php?", 'SA_IMPORT',MENU_MAINTENANCE);
          $app->add_lapp_function(1, _("Imported Bank Account"), "modules/Kvcodes_importexport/inquiry/imported_bank_inquiry.php?", 'SA_IMPORT',MENU_INQUIRY);
          break;
     }
   }
    function install_access()   {
        global $installed_extensions,$path_to_root;
         $security_sections[SS_KVIMPORT]    = _("Imports");
         $security_areas['SA_IMPORT'] = array(SS_KVIMPORT|2, _("Import Access")); 
         $security_areas['SA_IMINQ'] = array(SS_KVIMPORT|2, _("Imported Bank Inquiry Access")); 
          return array($security_areas, $security_sections);
    }     
    function activate_extension($company, $check_only=true) {
        global $db_connections, $path_to_root, $systypes_array, $installed_extensions;

        $updates = array( 'update.sql' => array('kv_bank_trans_settings'));

        if(defined('ST_MANURECEIVE')){
        if(!defined('ST_UNDEFINED')){
            $types_ = file_get_contents($path_to_root.'/includes/types.inc');
            if (strpos($types_, "define('ST_UNDEFINED',101);") == false) {

// dont try to align to this line
                $change_content = "define('ST_MANURECEIVE', 29);
define('ST_UNDEFINED',101);"; 

                $types_inc = str_replace("define('ST_MANURECEIVE', 29);", $change_content, $types_); 
                file_put_contents($path_to_root.'/includes/types.inc', $types_inc);
            }
        }


        
        $transactions_db = file_get_contents($path_to_root.'/admin/db/transactions_db.inc');
        if (strpos($transactions_db, 'case     ST_UNDEFINED  :') == false) {

    // dont try to align to this line
            $transactions_db_change = 'case     ST_BANKDEPOSIT  : return array(TB_PREF."bank_trans", "type", "trans_no", "ref", "trans_date");
        case     ST_UNDEFINED  : return array(TB_PREF."bank_trans", "type", "trans_no", "ref", "trans_date");';

            $transactions_db__inc = str_replace('case     ST_BANKDEPOSIT  : return array(TB_PREF."bank_trans", "type", "trans_no", "ref", "trans_date");', $transactions_db_change, $transactions_db);     
            file_put_contents($path_to_root.'/admin/db/transactions_db.inc', $transactions_db__inc);
        }

        if(!isset($systypes_array['ST_UNDEFINED'])){

            $sysnames = file_get_contents($path_to_root.'/includes/sysnames.inc');
            if (strpos($sysnames, 'ST_UNDEFINED => _("Undefined"),') == false) {

    // dont try to align to this line
                $change = 'ST_DIMENSION => _("Dimension"),
    ST_UNDEFINED => _("Undefined"),';

                $sysnames_inc = str_replace('ST_DIMENSION => _("Dimension"),', $change, $sysnames);   
                file_put_contents($path_to_root.'/includes/sysnames.inc', $sysnames_inc); 
            }
        }

      } 
      $this->kvcodes_update_databases($company, ["ALTER TABLE `".TB_PREF."bank_trans` ADD `account_no` VARCHAR(50) NOT NULL DEFAULT '' AFTER `person_id`,
 ADD `account_name` VARCHAR(250) NOT NULL DEFAULT '' AFTER `account_no`,
  ADD `entry_date` DATE NOT NULL DEFAULT '0000-00-00' AFTER `account_name`,
  ADD `imported` TINYINT NOT NULL DEFAULT '0' AFTER `entry_date` ;
" => ['bank_trans', 'account_no']]);
      return $this->update_databases($company, $updates, $check_only);
    }
    function deactivate_extension($company, $check_only=true) {
        global $db_connections;
        $updates = array('drop.sql' => array('kv_bank_trans_settings'));
        $this->kvcodes_update_databases($company, ["ALTER TABLE `".TB_PREF."bank_trans`  DROP `account_no`, DROP `account_name`, DROP `entry_date`, DROP `imported`;" => ['bank_trans', 'account_no']]);
        return $this->update_databases($company, $updates, $check_only);
    }

    function kvcodes_update_databases($comp, $updates, $check_only=false)  {
    global $db_connections, $path_to_root;
  
    if ($comp == -1) 
      $conn = $db_connections;
    else
      $conn = array( $comp => $db_connections[$comp]);
    $result = true;

    foreach($conn as $comp => $con) {
      set_global_connection($comp);
      foreach($updates as $query => $update) {
        $table = @$update[0];
        $field = @$update[1];
        $properties = @$update[2];
        $ok = check_table($con['tbpref'], $table, $field, $properties) == 0;

        if (!$check_only && !$ok) {
          db_query($query, "can't install with database changes",true);
        }
        $result &= $ok;
        if (!$result)
          break;
      }
      db_close();
      if (!$result)
        break;
    }
    set_global_connection(0); // return to siteadmin account

    return $result;
  }


}
