<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
//---------------------------------------------------------------------------------------------------

function display_grn_summary(&$po)
{
   global $SysPrefs, $pass_field,$replacement;

   start_table(TABLESTYLE2, "width='90%'");

    start_row();
	label_cells(_("Supplier"), $po->supplier_name, "class='tableheader2'");

    if (!is_company_currency($po->curr_code))
    	label_cells(_("Order Currency"), $po->curr_code, "class='tableheader2'");

    label_cells(_("For Purchase Order"), get_trans_view_str(ST_PURCHORDER, $po->order_no),
    	"class='tableheader2'");

	label_cells(_("Delivery Date"), $po->orig_order_date, "class='tableheader2'"); // FIXME: delivery date
	end_row();

   	start_row();
   	label_cells(_("Reference"), $po->reference, "class='tableheader2'");
   	label_cells(_("Deliver Into Location"), get_location_name($po->Location), "class='tableheader2'");
	label_cells(_("Supplier's Reference"), $po->supp_ref, "class='tableheader2'");

    end_row();

      if($po->dimension)
        label_cells(_($SysPrefs->prefs['dim1_name']), get_dimension_name($po->dimension), "class='tableheader2'");
          if($po->dimension2)
        label_cells(_($SysPrefs->prefs['dim2_name']), get_dimension_name($po->dimension2), "class='tableheader2'");
      start_row();
   	label_cells(_("Delivery Address"), $po->delivery_address, "class='tableheader2'");
			
// 			print_r($po);
		$truck_details = get_truck_details($po->order_no,$po->dc_no);
		// if($truck_details['dc_no'])
		// label_cells(_("Dc No #"), $truck_details['dc_no'], "class='tableheader2'");
		// if($truck_details['truck_of_no'])
		// label_cells(_("Truck No #"), $truck_details['truck_of_no'], "class='tableheader2'");
		if($po->dc_no)
		label_cells(_("Dc No #"), $po->dc_no, "class='tableheader2'");
		if($po->vehicle_no)
		label_cells(_("Truck No #"), $po->vehicle_no, "class='tableheader2'");
   	 end_row();
   	 start_row();
	  if($truck_details['station'])
			label_cells(_("Station"), $truck_details['station'], "class='tableheader2'");
		if($truck_details['analytics_by'])
			label_cells(_("Analytics By"), $truck_details['analytics_by'], "class='tableheader2'");
		// if($po->broken)
		// 	label_cells(_("Broken"), $po->broken, "class='tableheader2'");
   	  end_row();
		
		start_row();
		if($truck_details['no_of_bags'])
			label_cells(_("No. Bags"), $truck_details['no_of_bags'], "class='tableheader2'");
		if($truck_details['builty_number'])
			label_cells(_("Builty No #"), $truck_details['builty_number'], "class='tableheader2'");

		// if($po->supplier_id)
		// 	label_cells(_("Broker"), $po->supplier_id, "class='tableheader2'");

		$status_class = ($truck_details['is_status'] == 0) ? 'label label-success' : 'label label-danger';
		label_cell($pass_field[$truck_details['is_status']], "class='tableheader2 $status_class'");

		if($po->file_system)
 		label_row(_("File System"), get_file_system_name($po->file_system), "class='tableheader2'", "colspan=9");
    if ($po->Comments != "")
    	label_row(_("Order Comments"), $po->Comments, "class='tableheader2'", "colspan=9");
    end_table(1);
}

function edit_grn_summary(&$po)
{
	global $Refs,$SysPrefs;
	
	start_outer_table(TABLESTYLE2, "width='80%'");

	table_section(1);
		label_row(_("Supplier"), $po->supplier_name);

    	if (!is_company_currency($po->curr_code))
    		label_row(_("Order Currency"), $po->curr_code);

	    label_row(_("For Purchase Order"), get_trans_view_str(ST_PURCHORDER, $po->order_no));

            	$po_row = get_po($po->order_no);
            	// print_r(	$po_row );
            		global $replacement;
	    label_row(_("Replacement Status"), $replacement[$po_row['is_replacement']], "class='tableheader2'");

		label_row(_("Ordered On"), $po->orig_order_date);

    text_row_ex(_("Station").':', 'station', 20);
    // text_row_ex(_("Broken").':', 'broken', 20);
    text_row_ex(_("Analytics By").':', 'analytics_by', 20);
    
    hidden('broken', 0);

	table_section(2);
    	if (!isset($_POST['ref']))
    	    $_POST['ref'] = $Refs->get_next(ST_SUPPRECEIVE, null, array('supplier' => $po->supplier_id, 'date' => Today()));
    	ref_row(_("Reference"), 'ref', '', null);

        if (!isset($_POST['Location']))
        	$_POST['Location'] = $po->Location;

        locations_list_row(_("Deliver Into Location"), "Location", $_POST['Location']);

    	if (!isset($_POST['DefaultReceivedDate']))
     	  	$_POST['DefaultReceivedDate'] = new_doc_date();

    	date_row(_("Date Items Received"), 'DefaultReceivedDate', '', true, 0, 0, 0, '', true);
 // text_row($label, $name, $value, $size, $max=null, $title=null, $params="", 
// 	$post_label="", $submit_on_change=false)
    text_row(_("No. Bags").':', 'no_bags', $_POST['no_bags'],10,10,null,'','',true);
      text_row_ex(_("Builty No #").':', 'builty_no', 20,"","",false, "class='tableheader2'");

    if($po->broker_id)
			{   global $brokery_type;
				label_row(_("Broker"), get_supplier_name($po->broker_id), null);
     	// if($_POST['broker_id'])
				if($_POST['no_bags']){
					// $po->brokery_type=1;
					if($po->brokery_type)
					$_POST['brokery_amt']=$po->brokery_amt*$_POST['mill_weigh'];
						else
					$_POST['brokery_amt']=$po->brokery_amt*$_POST['no_bags'];

				}
	         text_row(_("Brokery Amount (".$brokery_type[$po->brokery_type] .")"), "brokery_amt", null, 20, 30);
     }
	table_section(3);
		// label_row(_("Supplier's Reference"), $po->supp_ref);

	   	label_row(_("Delivery Address"), $po->delivery_address);
	   	label_row(_("File System"), get_file_system_name($po->file_system));
 	 	 	hidden('file_system', $po->file_system);
        if($po->dimension)
      label_row(_($SysPrefs->prefs['dim1_name']), get_dimension_name($po->dimension));
          if($po->dimension2)
      label_row(_($SysPrefs->prefs['dim2_name']), get_dimension_name($po->dimension2));


    	if ($po->Comments != "")
    		label_row(_("Order Comments"), $po->Comments, "class='tableheader2'", "colspan=9");

    	text_row_ex(_("DC #").':', 'dc_no', 20);
      text_row_ex(_("Truck No #").':', 'vehicle_no', 20,"","",false, "class='tableheader2'");


      truck_details_row(_("Status"), "is_status", null, false, true);	
			qty_row(_("X-Weight"), "x_weight", $_POST['x_weight'],  "class='tableheader2'", null, $dec);
			qty_row(_("Mill Weight"), "mill_weigh", $_POST['mill_weigh'],  "class='tableheader2'", null, $dec,true);
			 $_POST[0]= $_POST['mill_weigh'];


		
			// if($po->brokery_amt)
			// label_row(_("Brokery Amount"), price_format($po->brokery_amt), null);

	    if (!is_company_currency($po->curr_code))
			exchange_rate_display(get_company_currency(), $po->curr_code, get_post('DefaultReceivedDate'));
	end_outer_table(1);
}

