<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_FILE_SYSTEM';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/purchasing/includes/db/file_system_db.inc");


$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "File System Inquiry"), false, false, "", $js);

//---------------------------------------------------------------------------------------------

function view_link($row)
{
	return viewer_link($row['id'] ,'/gl/inquiry/journal_inquiry.php?file_system='.$row['id']);
}

function edit_link($row) 
{
	$edit = trans_editor_link(ST_FILE_SYSTEM, $row["id"]);
	return $edit;
}
//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders')) 
{
	$Ajax->activate('orders_tbl');
}
start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();

text_cells(null, "name", null, 20, "", false, "", "", "", true);
// file_system_list_cells(_("File System:"), 'file_system', null, true, true);
date_cells(_("From:"), 'OrdersAfterDate', '', null, -user_transaction_days());
date_cells(_("To:"), 'OrdersToDate');

submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_row();
end_table(1);
//---------------------------------------------------------------------------------------------

$sql = get_file_system_inquiry(get_post('name'), get_post('OrdersAfterDate'), get_post('OrdersToDate'));
		//,get_post('file_system')

$cols = array(
	_("#") => array('fun'=>'view_link'), 
	_("Reference") => array('reference', 'align'=>'center'),
	_("Date") => array('name'=>'date_', 'type'=>'date'),
	_("Name") => array('name', 'align'=>'center'),
	_("Description") => array('description', 'align'=>'center'),
	_("") => array('fun'=>'edit_link', 'ord'=>'', 'align'=>'center'),
		
);

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);

$table->width = "80%";
display_db_pager($table);

end_form();
end_page();
