<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SUPPTRANSVIEW';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Search Purchase Orders"), false, false, "", $js);

//---------------------------------------------------------------------------------------------
function trans_view($trans)
{
	return get_trans_view_str(ST_PURCHORDER, $trans["order_no"]);
}

function ref_trans_view($trans)
{
	return get_trans_view_str(ST_PURCHORDER, $trans["order_no"], $trans['reference']);
}


function edit_link($row) 
{
	global $page_nested;

	return $page_nested || !$row['isopen'] ? '' :
		trans_editor_link(ST_PURCHORDER, $row["order_no"]);
}

function receive_link($row) 
{
	global $page_nested;

	if($row['is_close'])
		return '-';
	
	return $page_nested || !$row['OverDue'] ? '' :
		pager_link( _("Receive"),
			"/purchasing/po_receive_items.php?PONumber=" . $row["order_no"], ICON_RECEIVE);
}

function po_close_link($row){

$name = "chgtpl" .$row['order_no'];
		$value = $row['is_close'] ? 1:0;
		// save also in hidden field for testing during 'Update'
     // if(!$_SESSION["wa_current_user"]->can_access('SA_GT_APPROVAL'))
     // 	return (!$row['approved']) ?  "<span style='color:red;' > Un-Approved <span>" : "<span style='color:Green' > Approved <span>" ;

		if ($row['quantity_ordered']==$row['quantity_received']) {
		// display_error($row['quantity_ordered']." == ".$row['quantity_received']." == ".$row['order_no']);
				return "<span style='color:Green;' > All Received <span>";
			}


		if(!$row['is_close'])
		return checkbox(null, $name, $value, true,
		_("Set the PO Closed ")) 
		. hidden('last['.$row['order_no'].']', $value, false)."<span style='color:red;' > Open <span>";
        else
          return checkbox(null, $name, $value, true,
		_("Set the PO Closed ")) 
		. hidden('last['.$row['order_no'].']', $value, false)."<span style='color:Green' > Closed <span>";	

}

$id = find_submit('_chgtpl');
if ($id != -1)
{
	purchase_order_close($id, check_value('chgtpl'.$id));
	$Ajax->activate('orders_tbl');
}

function prt_link($row)
{
	return print_document_link($row['order_no'], _("Print"), true, ST_PURCHORDER, ICON_PRINT);
}

function display_supplier_summary($supplier_record)
{
	start_table(TABLESTYLE, "width='20%'");
	global $Ajax;
	start_row();
	// display_error($supplier_record);
	label_cell(_("Total Order"), "style='font-weight:bold'");
	label_cell(number_format2($supplier_record, 2),  "align='right'");
	$Ajax->activate('_page_body');
	end_row();
	end_table();
}

function po_status_link($row) 
{
	global $page_nested;

	 if ($row['is_close'] == 0 && !$row['quantity_received'])
	    return "<span class='label label-success'>Pending</span>";
	 elseif ($row['is_close'] == 1 && $row['quantity_received']) 
	    return "<span class='label label-warning'>Closed</span>";
	 elseif ($row['is_close'] == 1) 
	    return "<span class='label label-danger'>Cancel</span>";
	 elseif ($row['quantity_received'] == $row['quantity_ordered']) 
	    return "<span class='label label-info'>Complete Arrival</span>";
	 else 
	    return '-';
}

if (isset($_GET['order_number']))
{
	$_POST['order_number'] = $_GET['order_number'];
}

//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders')) 
{
	$Ajax->activate('orders_tbl');
	$Ajax->activate('totals_tbl');

} elseif (get_post('_order_number_changed')) 
{
	$disable = get_post('order_number') !== '';

	$Ajax->addDisable(true, 'OrdersAfterDate', $disable);
	$Ajax->addDisable(true, 'OrdersToDate', $disable);
	$Ajax->addDisable(true, 'StockLocation', $disable);
	$Ajax->addDisable(true, '_SelectStockFromList_edit', $disable);
	$Ajax->addDisable(true, 'SelectStockFromList', $disable);

	if ($disable) {
		$Ajax->addFocus(true, 'order_number');
	} else
		$Ajax->addFocus(true, 'OrdersAfterDate');

	$Ajax->activate('orders_tbl');
}
//---------------------------------------------------------------------------------------------

start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();
ref_cells(_("#:"), 'order_number', '',null, '', true);
ref_cells(_("Ref #:"), 'order_ref_number', '',null, '', true);

date_cells(_("from:"), 'OrdersAfterDate', '', null, -user_transaction_days());
date_cells(_("to:"), 'OrdersToDate');

locations_list_cells(_("into location:"), 'StockLocation', null, true);
end_row();
end_table();

start_table(TABLESTYLE_NOBORDER);
start_row();

stock_items_list_cells(_("for item:"), 'SelectStockFromList', null, true);

if (!$page_nested)
	supplier_list_cells(_("Select a supplier: "), 'supplier_id', null, true, true);

check_cells(_('Also closed:'), 'also_closed', check_value('also_closed'));

submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_row();
end_table(1);

//---------------------------------------------------------------------------------------------

$sql = get_sql_for_po_search_completed(get_post('OrdersAfterDate'), get_post('OrdersToDate'),get_post('supplier_id'), get_post('StockLocation'), get_post('order_number'),
	get_post('SelectStockFromList'), get_post('also_closed'),get_post('order_ref_number'));

$cols = array(
		_("#") => array('fun'=>'trans_view', 'ord'=>'', 'align'=>'right'), 
		_("Reference") => array('fun'=>'ref_trans_view', 'ord'=>'', 'align'=>'right'), 
		_("Supplier") => array('ord'=>''),
		_("Location"),
		_("Supplier's Reference"), 
		_("Order Date") => array('name'=>'ord_date', 'type'=>'date', 'ord'=>'desc'),
		_("Currency") => array('align'=>'center'), 
		_("Order Total") => 'amount',
		array('insert'=>true, 'fun'=>'edit_link'),
		// array('insert'=>true, 'fun'=>'receive_link'),
		array('insert'=>true, 'fun'=>'prt_link'),
		array('insert'=>true, 'fun'=>'po_close_link'),
		array('insert'=>true, 'fun'=>'po_status_link'),

);


if (get_post('StockLocation') != ALL_TEXT) {
	$cols[_("Location")] = 'skip';
}

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);

$table->width = "80%";

display_db_pager($table);

div_start('totals_tbl');
// if ($_POST['supplier_id'] != "" && $_POST['supplier_id'] != ALL_TEXT)
// {
$supplier_record = order_total_po(get_post('OrdersAfterDate'), get_post('OrdersToDate'),
get_post('supplier_id'), get_post('StockLocation'), get_post('order_number'),
get_post('SelectStockFromList'), get_post('also_closed'));
display_supplier_summary($supplier_record);
  echo "<br>";
// }
div_end();

end_form();
end_page();
