<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_STORE_REQUEST';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Store Request Pending"), false, false, "", $js);

//---------------------------------------------------------------------------------------------
function trans_view($trans)
{
	return get_trans_view_str(ST_REQUISITION, $trans["order_no"]);
}

function edit_link($row) 
{
	global $page_nested;

	return $page_nested || !$row['isopen'] ? '' :
		trans_editor_link(ST_REQUISITION, $row["order_no"]);
}

function issue_link($row) 
{
	global $page_nested;
	
	//return //$page_nested || !$row['OverDue'] ? '' :
	// if(!$row['is_purchase_request'])
     return  !$row['isopen'] ||  $row['is_purchase_request']  ? '' :	pager_link( _("Issue Store"),
			"/inventory/store_transfers.php?NewTransfer=1&&req_no=" . $row["order_no"], ICON_RECEIVE);
    //  else
    // return "<span style='color:green'> issue <span>"; 	
}

function prt_link($row)
{
	return print_document_link($row['order_no'], _("Print"), true, ST_REQUISITION, ICON_PRINT);
}
function delete_link($row){
	return 	$row['issue'] ? '' : delete_button_cell("Delete".$row['order_no'], _("Delete"),	_('Remove line from document'));
}

function get_loc_name($row){
	$loc_row = get_item_location($row['request_location']);

	return $loc_row['location_name'];
}

function get_status($row){


	if($row['isopen'])
	{
		
		if($row['is_purchase_request'])
		 return '<span style="color:red;"> Request For Purchase <span>'	;
		else
		 return '<span style="color:orange;"> Pending Store Request <span>'	;

	}
	else{
		if($row['is_purchase_request'])
          return "<span style='color:green'> Po complete <span>"; 	
     	else
     	 return "<span style='color:green'> issue complete <span>"; 		

	}	

	// if($row['is_complete'])
	//  return '<span style="color:blue;"> issue complete <span>'	;  


}

function tmpl_checkbox($row)
{
	$name = "chgtpl" .$row['order_no'];
	$value =   ($row["is_closed"]) ? 1:0;
// save also in hidden field for testing during 'Update'
	if($row["is_complete"])
	return '-';	
  
	if($row["is_closed"])
	return "-";	
	else
	return checkbox(null, $name, $value, true,
	_('Set this order as a template for direct deliveries/invoices'))
	. hidden('last['.$row['order_no'].']', $value, false);


}
if (isset($_GET['order_number']))
{
	$_POST['order_number'] = $_GET['order_number'];
}

$id = find_submit('Delete');
if ($id!=-1){

	 delete_req_order($id, ST_REQUISITION);
				display_notification(_("requisition has been deleted."), 1);
}
//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders')) 
{
	$Ajax->activate('orders_tbl');
} elseif (get_post('_order_number_changed')) 
{
	$disable = get_post('order_number') !== '';

	$Ajax->addDisable(true, 'OrdersAfterDate', $disable);
	$Ajax->addDisable(true, 'OrdersToDate', $disable);
	$Ajax->addDisable(true, 'StockLocation', $disable);
	$Ajax->addDisable(true, '_SelectStockFromList_edit', $disable);
	$Ajax->addDisable(true, 'SelectStockFromList', $disable);

	if ($disable) {
		$Ajax->addFocus(true, 'order_number');
	} else
		$Ajax->addFocus(true, 'OrdersAfterDate');

	$Ajax->activate('orders_tbl');
}

$id = find_submit('_chgtpl');
if($id!=-1)
{
	$sql = "UPDATE ".TB_PREF."req_orders SET 
	is_closed=1 WHERE order_no=".db_escape($id);
	db_query($sql, "could not update request for Purchase");
  
    add_audit_trail(ST_REQUISITION, $id,  Today(),_(" Requisition Closed"));
}
//---------------------------------------------------------------------------------------------

start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();
ref_cells(_("#:"), 'order_number', '',null, '', true);

date_cells(_("from:"), 'OrdersAfterDate', '', null, -user_transaction_days());
date_cells(_("to:"), 'OrdersToDate');

locations_list_cells(_("into location:"), 'StockLocation', null, true);
end_row();
end_table();

start_table(TABLESTYLE_NOBORDER);
start_row();

stock_items_list_cells(_("for item:"), 'SelectStockFromList', null, true);

if (!$page_nested)
	supplier_list_cells(_("Select a supplier: "), 'supplier_id', null, true, true);

check_cells(_('Also closed:'), 'also_closed', check_value('also_closed'));

submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_row();
end_table(1);

//-----------------------------------------------------------------------------

$sql = get_sql_for_store_search_completed(get_post('OrdersAfterDate'), get_post('OrdersToDate'),
	get_post('supplier_id'), get_post('StockLocation'), get_post('order_number'),
	get_post('SelectStockFromList'), get_post('also_closed'));

$cols = array(
		_("#") => array('fun'=>'trans_view', 'ord'=>'', 'align'=>'right'), 
		_("Reference"), 
		_("Supplier")  => 'skip',//=> array('ord'=>''),
		_("Date") => array('name'=>'ord_date', 'type'=>'date', 'ord'=>'desc'),
		_("Request Location"),
		_("Receive Location") => array( 'fun'=>'get_loc_name'),
		// _("Supplier's Reference"), 
		// _("Currency") => array('align'=>'center'), 
		// _("Order Total") => 'amount',
		// array('insert'=>true, 'fun'=>'edit_link'),
		_("Issue") => array('insert'=>true, 'fun'=>'issue_link'),
				_("Status") => array( 'fun'=>'get_status'),

		array('insert'=>true, 'fun'=>'prt_link'),
		_("Closed") => array('insert'=>false, 'fun'=>'tmpl_checkbox' ,'align'=>'left' ),
		_(" Delete") => array('insert'=>true, 'fun'=>'delete_link') );


if (get_post('StockLocation') != ALL_TEXT) {
	$cols[_("Location")] = 'skip';
}

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);

$table->width = "80%";

display_db_pager($table);

end_form();
end_page();
