<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CHARGES_RATE_PER';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/purchasing/includes/db/charges_rate_per_db.inc");

page(_($help_context = "Charges Rate Percentage"));
include($path_to_root . "/includes/ui.inc");

simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	$input_error = 0;

	// if (strlen($_POST['name']) == 0) 
	// {
	// 	$input_error = 1;
	// 	display_error(_("The name cannot be empty."));
	// 	set_focus('name');
	// }

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_charge_rate_per($selected_id, input_num('percentage'), input_num('amount'));
			$note = _('Selected chrages rate percentage has been updated');
    	} 
    	else 
    	{
    		add_charge_rate_per($_POST['charges_id'], input_num('percentage'), input_num('amount'));
			$note = _('New chrages rate percentage has been added');
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
}

//----------------------------------------------------------------------------------

if ($Mode == 'Delete')
{

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'stock_master'

	// if (item_unit_used($selected_id))
	// {
	// 	display_error(_("Cannot delete this unit of measure because items have been created using this unit."));

	// }
	// if (key_in_foreign_table($selected_id, 'charges_trans', 'charge_id'))
	// {
	// 	$cancel_delete = 1;
	// 	display_error(_("Cannot delete this chrages rate percentage because customer branches have been created using this chrages rate percentage ."));
	// } 
	if ($cancel_delete == 0) 
	{
		delete_charge_rate_per($selected_id);
		display_notification(_('Selected chrages rate percentage has been deleted'));
	} 
	$Mode = 'RESET';
	
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	$charges_id=$_POST['charges_id'];
	unset($_POST);
	$_POST['charges_id']=$charges_id;
	$_POST['show_inactive'] = $sav;
	set_focus('percentage');
}

//----------------------------------------------------------------------------------
start_form();

echo "<center>" .  _("Charges Rate Percentage"). "&nbsp;";
charges_rate_percentage_row(null, 'charges_id', $_POST['charges_id'], false, true);
echo "<hr></center>";

$result = get_charge_rate_pers(check_value('show_inactive'), $_POST['charges_id']);
start_table(TABLESTYLE, "width='40%'");
$th = array(_('Percentage'), _('Amount'), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; //row colour counter

while ($myrow = db_fetch($result))
{

	alt_table_row_color($k);
	label_cell(price_format($myrow["percentage"])." %");	
	label_cell(price_format($myrow["amount"]));

	inactive_control_cell($myrow["id"], $myrow["inactive"], 'charges_rate_percentage', 'id');
 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}

inactive_control_row($th);
end_table(1);

//----------------------------------------------------------------------------------

start_table(TABLESTYLE2);
global $Ajax;
if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing item category

	$myrow = get_charge_rate_per($selected_id);
		$_POST['percentage']	 = $myrow["percentage"];
		$_POST['amount']	 = $myrow["amount"];
	}
	hidden("selected_id", $selected_id);
}

// ($label, $name, $value, $size, $max, $title=null, $params="", $post_label="")
text_row(_("Percentage"), 'percentage', null, 30, null,null,"","%");
text_row(_("Amount"), 'amount', null, 30, null);

$Ajax->activate('_page_body');

end_table(1);
submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();

