<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SUPPTRANSVIEW';
$path_to_root = "../..";
include($path_to_root . "/purchasing/includes/po_class.inc");

include($path_to_root . "/includes/session.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
page(_($help_context = "Last Purchase Price"), true, false, "", $js);

include($path_to_root . "/purchasing/includes/purchasing_ui.inc");

display_heading(_("Last Purchase Price For ") . " " . $_GET['item_code']);
echo "<BR>";
// display_grn_summary($purchase_order);

display_heading2(_("Price Details"));

start_table(TABLESTYLE, "width='90%'");
$th = array(_("Po # "),_("Date"), _("Vendor"), _("Qty"), _("Rate"));
table_header($th);
$total = 0;
$k = 0;  //row colour counter

$sql=" SELECT * FROM  ".TB_PREF."purch_orders po LEFT JOIN ".TB_PREF."purch_order_details pod ON po.order_no=pod.order_no  WHERE pod.item_code=".db_escape($_GET['item_code'])."  ORDER BY pod.po_detail_item DESC " ;

// diskfreespace()
// display_error($sql);
$res = db_query($sql);
$sno=0;
while ($row = db_fetch($res))
{

	
$sno++;
	alt_table_row_color($k);
    // get_trans_view_str(ST_PURCHORDER
	label_cell(get_trans_view_str(ST_PURCHORDER,$row['order_no']), "align='center'");

	label_cell(sql2date($row['ord_date']), "align='center'");
	label_cell(get_supplier_name($row['supplier_id']) , "align='center'");
	label_cell($row['quantity_ordered'], "align='center'");
	label_cell($row['unit_price'], "align='center'");
	if($sno==10)
		break;
	// $total += $line_total;
}

// 	$colspan= 2; 
// $display_sub_tot = number_format2($total,user_price_dec());
// label_row(_("Sub Total"), $display_sub_tot, "align=right colspan=".$colspan, "nowrap align=right", 1);

// $taxes = $purchase_order->get_taxes();
// $tax_total = display_edit_tax_items($taxes, $colspan, $purchase_order->tax_included, 1);

// $display_total = price_format(($total + $tax_total));

// start_row();
// label_cells(_("Amount Total"), $display_total, "colspan=".$colspan." align='right'","align='right'");
// label_cell('');
end_row();


end_table(1);

is_voided_display(ST_SUPPRECEIVE, $_GET['trans_no'], _("This delivery has been voided."));

end_page(true, false, false, ST_SUPPRECEIVE, $_GET['trans_no']);

