<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_REP_PRINT_SALES_ORDER' : 'SA_REP_PRINT_SALES_ORDER';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Sales Orders
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/admin/db/shipping_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");

//----------------------------------------------------------------------------------------------------

print_sales_orders();

function print_sales_orders()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report_inv_tax.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$print_as_quote = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$orientation = $_POST['PARAM_6'];

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$cols = array(4, 300,  385, 450, 515);

	// $headers in doctext.inc
	$aligns = array('center', 'center', 'center', 'center', 'center');

	$params = array('comments' => $comments, 'print_quote' => $print_as_quote);

	$cur = get_company_Pref('curr_default');

    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		$myrow = get_sales_order_header($i, ST_SALESORDER);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];
		$branch = get_branch($myrow["branch_code"]);

        if ($i == $from || $email == 1)
            $rep = new FrontReport(_("Proforma Invoice"), "PARFOMAINVOICE", user_pagesize(), 9, $orientation);
        if ($print_as_quote == 1)
        {
            $rep->title = _('QUOTE');
            $rep->filename = "Quote" . $i . ".pdf";
        }
        else
        {
            $rep->title = _("Proforma Invoice");
            $rep->filename = "Proforma Invoice" . $i . ".pdf";
        }		
		$rep->SetHeaderType('Header2');
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_branch_contacts($branch['branch_code'], 'order', $branch['debtor_no'], true);
		$rep->SetCommonData($myrow, $branch, $myrow, $baccount, ST_SALESORDER, $contacts);
		$rep->NewPage();

		$result = get_sales_order_details($i, ST_SALESORDER);
		$SubTotal = 0;
		$items = $prices = array();
		$rep->aligns[0]='left';
		$ctn_sum=0;
		$data = db_fetch($result);

		// $rep->row = 82;
		$rep->row = $rep->pageHeight - $rep->topMargin;
        $rep->NewLine(2);
		$rep->SetLineStyle(array('width' => 1.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(90, 90, 90)));
		$rep->RoundedRect(40, $rep->get_reverse_current_row(), 540, 730, 0, '1111', 'D',null, array(224, 224, 224));
		$company_id = get_latter_hand_setting($rep->formData['company_id']);
		if($rep->company['coy_logo'] || $rep->company['file_name']){
			if($company_id['file_name'])
			$coy_logo  = $company_id['file_name'];
			else
			$coy_logo = $rep->company['coy_logo'];
		}
		$logo = company_path() . "/images/" . $coy_logo;
		if ($rep->company['coy_logo'] != '' && file_exists($logo))
		{
			$rep->NewLine(3);
			$rep->AddImage($logo, 165, $rep->row, 0, 60);
		}
		$rep->Font('','helvetica');
	
		// display_error($save_line);
		// $this->NewLine(-6);
		// $this->row = $save_line;
		
		$rep->fontSize +=8;
		// $rep->Font('bold','times');
			$rep->Font('bold');
		// $rep->Text($ccol+60, $rep->company['coy_name'], $icol+300, 0, -50);
		if (@$rep->company['coy_name']  || $company_id['latter_head_id']) {
			if($company_id['latter_head_id'])
			$coy_name  = get_latter_hand_name($company_id['latter_head_id']);
			else
			$coy_name = $rep->company['coy_name'];
		     $rep->NewLine(-3.5);
			// $rep->Text($ccol, $coy_name, $icol, 0,100 ,'center');
		      $rep->TextWrap(220, $rep->row, 220, strtoupper($coy_name),  'center');

		}
		$rep->fontSize -= 8;
		// $rep->row = $save_line;
		// display_error(br() . '=='.  $save_line .' =='. $rep->row);
		// exit();
   		// $rep->TextWrapLines($mcol+120, $icol, $rep->company['postal_address']);
   		$rep->NewLine();
   		if (@$rep->company['postal_address']  || $company_id['address'])
		{	
			if($company_id['address'])
			$address  = $company_id['address'];
			else
			$address = $rep->company['postal_address'];
   			// $rep->TextWrapLines($mcol+120, $icol, $address);
	      $rep->TextWrap(220, $rep->row, 220, $address,  'center');

		}

		if (@$rep->company['postal_address']  || $company_id['contact_no'])
		{	
			if($company_id['address'])
			$address  = $company_id['address'];
			else
			$address = $rep->company['postal_address'];
   			// $rep->TextWrapLines($mcol+120, $icol, $address);
	      $rep->TextWrap(220, $rep->row, 220, $address,  'center');

		}

        $rep->NewLine();
		if (@$rep->company['phone']  || $company_id['contact_no'])
		{	
			if($company_id['contact_no'])
			$phone  = $company_id['contact_no'];
			else
			$phone = $rep->company['phone'];
			// $this->Text($ccol, _("Phone"), $c2col);
			// $this->Text($c2col, $phone, $mcol);

		$rep->TextWrap(220, $rep->row, 220, "TEL : ".$phone,  'center');
			
		}

		 $rep->NewLine();
		if (@$rep->company['email']  || $company_id['email'])
		{	
			if($company_id['email'])
			$email  = $company_id['email'];
			else
			$email = $rep->company['email'];
			// $this->Text($ccol, _("Phone"), $c2col);
			// $this->Text($c2col, $phone, $mcol);

		$rep->TextWrap(220, $rep->row, 220, "EMAIL : ".$email,  'center');
			
		}

		$rep->NewLine(3.5);
		$rep->RoundedRect(40, $rep->get_reverse_current_row(), 540, 30, 0, '1111', 'D',null, array(224, 224, 224));

		$rep->fontSize += 8;
			$rep->Font('bold');
			$rep->NewLine(-0.5);
		$rep->TextWrap(200, $rep->row, 220, "PROFORMA INVOICE",  'center');
		$rep->fontSize -= 8;
		$rep->Font();
		$rep->NewLine(3);
		$rep->RoundedRect(40, $rep->get_reverse_current_row(), 120, 20, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->RoundedRect(160, $rep->get_reverse_current_row(), 130, 20, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->RoundedRect(290, $rep->get_reverse_current_row(), 60, 20, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->RoundedRect(350, $rep->get_reverse_current_row(), 70, 20, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->RoundedRect(420, $rep->get_reverse_current_row(), 70, 20, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->RoundedRect(490, $rep->get_reverse_current_row(), 90, 20, 0, '1111', 'D',null, array(224, 224, 224));

		$rep->NewLine(-1.2);
		$rep->Font('bold');
		$rep->TextWrap(40,  $rep->row, 100, "ORDER NO :",  'center');
		$rep->Font();
		$rep->TextWrap(160,  $rep->row, 100, $myrow['export_inv_ref'],  'center');

		$rep->Font('bold');
		$rep->TextWrap(270,  $rep->row, 100, " DATE :",  'center');
		$rep->Font();
		$rep->TextWrap(340,  $rep->row, 100,  sql2date($myrow['ord_date']),  'center');



		$rep->Font('bold');
		$rep->TextWrap(410,  $rep->row, 100, "PO NO :",  'center');
		$rep->Font();
		$rep->TextWrap(490,  $rep->row, 100, $myrow['buyer_order_no'],  'center');
		$rep->NewLine(2.9);
		// $rep->RoundedRect(40, $rep->get_reverse_current_row(), 280, 80, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->RoundedRect(320, $rep->get_reverse_current_row(), 260, 75, 0, '1111', 'D',null, array(224, 224, 224));
	    $rep->fontSize = 7;
		$rep->NewLine(-1.8);
		$rep->Font('bold');
		$rep->TextWrap(20,  $rep->row, 100, "Consignee:",  'center');
		
			$old_row=$rep->row;
		$rep->TextWrap(290,  $rep->row, 100, "1st Notify:",  'center');
		$rep->NewLine(3);
        	$rep->TextWrap(290,  $rep->row, 100, "2nd Notify",  'center');
		$rep->row=$old_row;
		$rep->Font();
        $rep->NewLine();
			$old_lineHeight=$rep->lineHeight;
			$rep->lineHeight=9;
			$old_row=$rep->row;
			$rep->TextWrapLines(45,250, $myrow['applicant']);
			$rep->row=$old_row+5;
			$rep->TextWrapLines(330,250, $myrow['notify_consignee']);
            $rep->NewLine();
					// $rep->row=$old_row+5;
			$rep->TextWrapLines(330,250, $myrow['notify_consignee']);
			$rep->lineHeight=$old_lineHeight;

        $rep->row=$old_row;
		$rep->NewLine(7);
		$rep->RoundedRect(40, $rep->get_reverse_current_row(), 280, 40, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->RoundedRect(320, $rep->get_reverse_current_row(), 130, 40, 0, '1111', 'D',null, array(224, 224, 224));

		$rep->RoundedRect(450, $rep->get_reverse_current_row(), 130, 40, 0, '1111', 'D',null, array(224, 224, 224));


		$rep->NewLine(-1.8);
		$rep->Font('bold');
		$old_row=$rep->row;
		$rep->TextWrap(20,  $rep->row, 100, "OUR BANK IS :",  'center');
		$rep->TextWrapLines(330,100, " COUNTRY OF ORIGIN OF GOODS",  'center');
		$rep->row=$old_row;
		$rep->TextWrap(455,  $rep->row, 120, "COUNTRY OF FINAL DESTINATION",  'center');
		$rep->Font();
		$rep->row=$old_row;



		$rep->NewLine();
		$bank_acc = get_bank_account($myrow['bank_account']);
		$old_row=$rep->row;
		$rep->TextWrapLines(45,400, " BANK NAME : ".$bank_acc['bank_name']." \nBANK A/C :". $bank_acc['bank_account_number']." , SWIFT :".$bank_acc['swift_code']);
		$rep->row=$old_row;
		$rep->NewLine();
		$rep->TextWrap(330,  $rep->row, 100,$myrow['origin'] ,  'center');

		$rep->TextWrap(460,  $rep->row, 100,$myrow['finel_destination'] ,  'center');
          

        $old_row=$rep->row;
		$rep->NewLine(3.2);
		$rep->RoundedRect(40, $rep->get_reverse_current_row(), 300, 50, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->RoundedRect(340, $rep->get_reverse_current_row(), 240, 35, 0, '1111', 'D',null, array(224, 224, 224));
		// $rep->NewLine();
		$rep->RoundedRect(40, $rep->get_reverse_current_row(), 300, 25, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->NewLine(2.1);
		$rep->RoundedRect(40, $rep->get_reverse_current_row(), 150, 25, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->NewLine(0.8);
		$rep->RoundedRect(340, $rep->get_reverse_current_row(), 110, 15, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->RoundedRect(450, $rep->get_reverse_current_row(), 130, 15, 0, '1111', 'D',null, array(224, 224, 224));


        $rep->row=$old_row;
        $rep->NewLine(1.5);
        $rep->Font('bold');
		$rep->TextWrap(40,  $rep->row, 300, "PORT OF LOADING",  'center');
		$rep->TextWrap(260,  $rep->row, 300, "TERMS OF DELIVERY OF PAYMENT : -",  'center');
        $rep->Font();


		$rep->NewLine();
		$rep->TextWrap(40,  $rep->row, 300,$myrow['port_of_loading'] ,  'center');
		$rep->TextWrap(240,  $rep->row, 300,$myrow['delivery_terms'] ,  'center');

        $rep->NewLine();
        $rep->Font('bold');
		$rep->TextWrap(40,  $rep->row, 150, "PORT OF DISCHARGE",  'center');
		$rep->TextWrap(190,  $rep->row, 150, "FINAL DESTINATION",  'center');
        $rep->Font();
		// print_r( $company_id);exit();

		$rep->NewLine();
		$rep->TextWrap(40,  $rep->row, 150,$myrow['port_of_discharge'] ,  'center');
		$rep->TextWrap(190,  $rep->row, 150,$myrow['finel_destination'] ,  'center');

        // $rep->NewLine();
		$rep->Font('bold');
		$rep->TextWrap(320,  $rep->row, 150, "DELIVERED AT : ",  'center');
		$rep->Font();
		$rep->TextWrap(420,  $rep->row, 150, $myrow['delivery_terms'] ,  'center');
		$rep->NewLine(2.9);
		$rep->RoundedRect(40, $rep->get_reverse_current_row(), 540, 20, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->RoundedRect(375, $rep->get_reverse_current_row(), 75, 328, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->RoundedRect(450, $rep->get_reverse_current_row(), 65, 328, 0, '1111', 'D',null, array(224, 224, 224));





		$rep->NewLine(-1.5);
		$rep->Font('bold');
		$rep->TextWrap(40,  $rep->row, 330, "Description of Goods",  'center');
		// $rep->TextWrap(380,  $rep->row, 45, "Quantity  MTS",  'center');
		$rep->NewLine(-0.3);
		$rep->lineHeight=9;
		$old_row=$rep->row;
		$rep->TextWrapLines(390,45, "Quantity  MTS",  'center');
		$rep->row=$old_row;

		$rep->TextWrapLines(460,45, "Rate US$  PER M/TON",  'center');
		$rep->row=$old_row;
		$rep->TextWrapLines(520,45, "Amount  US$",  'center');
		$rep->Font();



		$result = get_sales_order_details($i, ST_SALESORDER);
		$SubTotal = 0;
		$qty_sum=0;
			$rep->NewLine();
		while ($myrow2=db_fetch($result))
		{
			$old_row=$rep->row;
			$rep->TextWrapLines(40,330, $myrow2['description'],  'center');
			$rep->row=$old_row;
			$DisplayQty = number_format2($myrow2["quantity"]/1000,get_qty_dec($myrow2['stk_code']));
 
			$rep->TextWrap(375,  $rep->row, 70, $DisplayQty,  'center');

			$rep->TextWrap(450,  $rep->row, 70, $myrow2['rate'],  'center');
			$DisplayPrice = price_format($myrow2["rate"]*($myrow2["quantity"]/1000));
			$rep->TextWrap(510,  $rep->row, 70, $DisplayPrice,  'center');
            $qty_sum+=($myrow2["quantity"]/1000);
            $SubTotal+=$myrow2["rate"]*($myrow2["quantity"]/1000);

		} 




		$rep->NewLine(3);
		$rep->Font('bold');
		$rep->TextWrap(40,  $rep->row, 100, "Packing Detail :",  'center');
		$rep->Font();
		$rep->NewLine(1.2);

		$rep->Font('U');
		$rep->TextWrap(35,  $rep->row, 100, "Brand Name",  'center');
		$rep->TextWrap(80,  $rep->row, 100, "Bags ",  'center');
		$rep->TextWrap(140,  $rep->row, 100, "Packing Detail ",  'center');
		$rep->Font();
        

        // $res2=get_so_packing($i);
        if(db_num_rows($res2))
         $rep->NewLine();
     $sum_bags=0;
        while($pack_row=db_fetch($res2)){
         	// $rep->NewLine(1.2);
        $rep->TextWrap(35,  $rep->row, 100,$pack_row['brand_name'],  'center');
		$rep->TextWrap(80,  $rep->row, 100, $pack_row['bags'],  'center');
		// $rep->TextWrap(140,  $rep->row, 100, $pack_row['pack_desc'],  'center');
		$rep->TextWrapLines(60,330, $pack_row['pack_desc'],  'center');
        $sum_bags+=$pack_row['bags'];
        }

       	$rep->NewLine(1.2);
		$rep->TextWrap(60,  $rep->row, 100, "Total Bags      : ".$sum_bags,  'left');
		$rep->NewLine();
		$rep->TextWrap(60,  $rep->row, 100, "Net Weight      : ".($qty_sum *1000)." KG",  'left');
		$rep->NewLine();		
		$rep->TextWrap(60,  $rep->row, 100, "Tare Weight    : ".$myrow['tare_Weight']." KG",  'left');
		$rep->NewLine();
		$rep->TextWrap(60,  $rep->row, 100, "Gross Weight  : ".$myrow['gross_weight']." KG",  'left');
		// $rep->TextWrapLines(80,330, $myrow['packing'],  'left');


			// $rep->NewLine(3);
		$rep->row=242;
		$rep->RoundedRect(40, $rep->get_reverse_current_row(), 335, 90, 0, '1111', 'D',null, array(224, 224, 224));
		$rep->Font('bold');
		$rep->TextWrap(50,  $rep->row, 150, "Term & Condition And Shipment Schedule :",  'center');
		$rep->Font();
		$rep->NewLine(1.2);
		$rep->TextWrapLines(80,330, $myrow['other_shipment_term'],  'left');
		$rep->row=152;
		$rep->RoundedRect(40, $rep->get_reverse_current_row(), 540, 30, 0, '1111', 'D',null, array(224, 224, 224));
 
       $rep->NewLine(-2);

	    $rep->Font('bold');
		$rep->TextWrap(20,  $rep->row, 150, "Total Amount in Words :",  'center');
			    $rep->Font();
			$rep->NewLine(1.2);
			$words = price_in_words($SubTotal, ST_SALESORDER);
            $rep->TextWrap(60,  $rep->row, 400,  $words ,  'left');
             $rep->NewLine(-1);
			$rep->Font('bold');
			$old_row=$rep->row;
			$rep->TextWrapLines(380,70, $qty_sum." \nP/MTS",  'center');
			$rep->row=$old_row;
    		$rep->TextWrapLines(450,70, "TOTAL AMOUNT  \nUS$",  'center');
			// $rep->row=$old_row;
			$rep->NewLine(-1.5);
			$rep->TextWrapLines(510,70, price_format($SubTotal),  'center');
		$rep->Font();



   $rep->NewLine(2);
	    $rep->Font('bold');
		$rep->TextWrap(15,  $rep->row, 100, "BUYER'S",  'center');
			$rep->TextWrap(410,  $rep->row, 150, "FOR JKG OVERSEAS PVT LTD",  'center');


 $rep->NewLine(10);
		$rep->TextWrap(20,  $rep->row, 100, "SIGNATURE",  'center');
			$rep->TextWrap(420,  $rep->row, 150, "AUTH. SIGN",  'center');
		// display_error($rep->row." = ".$rep->get_reverse_current_row());exit();
		
		// $rep->TextWrap(13,692,180, _("CONTRACT / PROFORMA INVOICE NO."), -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(228, $rep->row, 150, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(270,692,180, $myrow['export_inv_ref'], -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(378, $rep->row, 80, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(383,692,180, _("DATED"), -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(458, $rep->row, 145, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(500,692,180, sql2date($myrow['ord_date']), -2);
		// $rep->row = 107;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 200, 110, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(80,670,180, _("SHIPPER"), -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(208, $rep->row, 200, 110, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(280,670,180, _("APPLICATION"), -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(408, $rep->row, 195, 110, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(455,670,180, _("NOTIFY / CONSIGNEE"), -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 20, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->row = 217;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 90, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,558,180, _("QUANTITY +/- 5%"), -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(98, $rep->row, 120, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(140,558,180, $data['quantity'], -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(218, $rep->row, 120, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(260,558,180, $data['no_of_qty'] . " " . $data['unit_id'], -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(338, $rep->row, 100, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// $curr_row = get_currency($myrow['curr_code']);
		// $rep->TextWrap(345,558,180, _("PRICE ". "( " . $curr_row['curr_abrev'] . " )"), -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(438, $rep->row, 165, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(500,558,180, price_format($data['unit_price']), -2);
		// $rep->row = 242;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 90, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,533,180, _("AMOUNT +/- 5%"), -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(98, $rep->row, 120, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(140,533,180, price_format($data['unit_price']), -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(218, $rep->row, 80, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// // $rep->TextWrap(225,533,180, _("IN WORDS"), -2);
		// // $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(298, $rep->row, 305, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// // $words = price_in_words($data['unit_price'], ST_SALESORDER);
		// // $rep->TextWrap(305,533,180, $words, -2);
		// // $rep->row = 267;
		// // $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(8, $rep->row, 90, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// // $rep->TextWrap(13,508,180, _("SHIPMENT FROM"), -2);
		// // $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(98, $rep->row, 220, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// // $rep->TextWrap(105,508,180, $myrow['shipment_to_date'], -2);
		// // $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(318, $rep->row, 90, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// // $rep->TextWrap(325,508,180, _("SHIPMENT TO"), -2);
		// // $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(408, $rep->row, 195, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// // $rep->TextWrap(415,508,180, $myrow['shipment_from_date'], -2);
		// // $rep->row = 292;
		// // $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(8, $rep->row, 90, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// // $rep->TextWrap(13,483,180, _("PACKING"), -2);
		// // $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(98, $rep->row, 505, 25, 0, '1111', 'D',null, array(0, 0, 0));
		// // $rep->TextWrap(105,483,500, $myrow['packing'], -2);
		// // $rep->row = 317;
		// // $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(8, $rep->row, 595, 175, 0, '1111', 'D',null, array(0, 0, 0));
		// // $rep->TextWrap(13,460,180, _("COMMODITY"), -2);
		// // $rep->TextWrap(195,460,180, $data['description'], -2);
		// // $rep->TextWrap(195,440,180, _("SPECIFICATION"), -2);
		// // $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(8, $rep->row, 180, 453, 0, '1111', 'D',null, array(0, 0, 0));
		// // $rep->row = 360;
		// // $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(188, $rep->row, 380, 110, 0, '1111', 'D',null, array(0, 0, 0));
		// // $rep->TextWrap(188,415,600, _("____________________________________________________________________________"), -2);
		// // $rep->TextWrap(188,400,600, _("____________________________________________________________________________"), -2);
		// // $rep->TextWrap(188,385,600, _("____________________________________________________________________________"), -2);
		// // $rep->TextWrap(188,370,600, _("____________________________________________________________________________"), -2);
		// // $rep->TextWrap(188,355,600, _("____________________________________________________________________________"), -2);
		// // $rep->TextWrap(188,340,600, _("____________________________________________________________________________"), -2);
		// // $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// // $rep->RoundedRect(450, $rep->row, 118, 110, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(195,310,600, _("FREE FROM LIVE WEEVILS, MOLDS AND FRESHLY FUMIGATED BY METHYL BROMIDE"), -2);
		// $rep->row = 492;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 30, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,280,180, _("SHIPMENT"), -2);
		// $date_from = date_create_from_format('Y-m-d', $myrow['shipment_to_date']);
		// $date_to = date_create_from_format('Y-m-d', $myrow['shipment_from_date']);
		// $formatted_date_from = date_format($date_from, 'jS F Y');
		// $formatted_date_to = date_format($date_to, 'jS F Y');
		// $new_format = $formatted_date_from . " TO " . $formatted_date_to;
		// $rep->TextWrap(195, 280, 500, $new_format, -2);
		// $rep->row = 522;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 30, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,250,180, _("INSURANCE"), -2);
		// $rep->TextWrap(195,250,500, $myrow['insurance'], -2);
		// $rep->row = 552;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 30, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,220,180, _("PAYMENT TERM"), -2);
		// $pay_term = get_payment_terms($myrow['payment_terms']);
		// $rep->TextWrap(195,220,500, $pay_term['terms'], -2);
		// $rep->row = 582;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 50, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,190,180, _("OTHER SHIPPING TERMS"), -2);
		// if($myrow['other_shipment_term']){
		// // $rep->NewLine(32);
		// $rep->row = 195;
		// $rep->TextWrapLines(195,450, $myrow['other_shipment_term']);
		// }
		// $rep->row = 632;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 138, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,140,180, _("SPECIAL SPECIFICATION"), -2);
		// if($myrow['comments']){
		// $rep->row = 145;
		// $rep->TextWrapLines(195,400, $myrow['comments']);
		// }

		// $item_ = get_item($data['stk_code']);
		// $result = get_qc_details($item_['category_id']);
		// $line_height = 15; 
		// $current_height = 418;
		// while ($row = db_fetch($result)) {
		//     $rep->TextWrap(195, $current_height , 600, _($row['name']), -2);
		//     $current_height -= $line_height;
		// }

		// if(get_company_prefs()['postal_address']){
		// 	$rep->row = 650;
		// 	$rep->TextWrapLines(30,180, get_company_prefs()['coy_name']);
		// 	$rep->NewLine(0.2);
		// 	$rep->TextWrapLines(30,180, get_company_prefs()['postal_address']);
		// }
		// if($myrow['applicant']){
		// 	$rep->row = 650;
		// 	$rep->TextWrapLines(220,180, $myrow['applicant']);
		// }
		// if($myrow['notify_consignee']){
		// 	$rep->row = 650;
		// 	$rep->TextWrapLines(420,180, $myrow['notify_consignee']);
		// }

		// $rep->NewPage();
		// $rep->row = 82;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 30, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,665,180, _("SELLER'S BANK DETAILS"), -2);
		// $rep->row = 112;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 100, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,565,180, _("BUYER'S BANK DETAILS"), -2);
		// // IF($myrow['buyer_bank_details'])
		// // $rep->TextWrapLines(195,400, $myrow['buyer_bank_details']);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 180, 550, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->row = 212;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 100, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,465,180, _("DOCUMENTS"), -2);
		// $rep->row = 312;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 150, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,315,180, _("FOR FORCE MAJEURE"), -2);
		// $rep->row = 462;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 100, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(13,215,180, _("ARBITRATION"), -2);
		// $rep->row = 562;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 100, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->row = 662;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 300, 108, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->row = 740;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 30, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(40,35,300, _("SING AND STAMP OF OF SUPPLIER (EXPORTER)"), -2);
		// $rep->TextWrap(340,35,300, _("SING AND STAMP OF OF CONSIGNEE (IMPORTER)"), -2);


		// $bank_acc = get_bank_account($myrow['bank_account']);
		// if($myrow['bank_account']){
		// 	$rep->TextWrap(200,665,300, _("A/C No"), -2);
		// 	$rep->TextWrap(200,655,300, _("A/C Title"), -2);
		// 	$rep->TextWrap(200,645,300, _("Bank Name"), -2);
		// 	$rep->TextWrap(200,635,300, _("Iban No"), -2);
		// 	$rep->TextWrap(200,625,300, _("Swift Code"), -2);
		// 	$rep->TextWrap(200,615,300, _("Branch Code"), -2);
		// 	// $rep->row = 665;
		// 	$rep->TextWrap(260,665,300, $bank_acc['bank_account_number']);
		// 	$rep->TextWrap(260,655,300, $bank_acc['bank_account_name']);
		// 	$rep->TextWrap(260,645,300, $bank_acc['bank_name']);
		// 	$rep->TextWrap(260,635,300, $bank_acc['iban_no']);
		// 	$rep->TextWrap(260,625,300, $bank_acc['swift_code']);
		// 	$rep->TextWrap(260,615,300, $bank_acc['branch_code']);

		// }

		// if($myrow['buyer_bank_details']){
		// 	$rep->row = 560;
		// 	$rep->TextWrapLines(195,400, $myrow['buyer_bank_details']);
		// }
		// if($myrow['documents']){
		// 	$rep->row = 460;
		// 	$rep->TextWrapLines(195,400, $myrow['documents']);
		// }
		// if($myrow['for_force_majeure']){
		// 	$rep->row = 310;
		// 	$rep->TextWrapLines(195,400, $myrow['for_force_majeure']);
		// }

		// if($myrow['for_force_majeure']){
		// 	$rep->row = 210;
		// 	$rep->TextWrapLines(195,400, $myrow['for_force_majeure']);
		// }
		// $rep->row = 732;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 38, 0, '1111', 'D',null, array(0, 0, 0));

        if ($i == $to || $email == 1)
            $rep->End($email);
	}
}

