<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_REP_PRINT_SALES_ORDER' : 'SA_REP_PRINT_SALES_ORDER';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Sales Orders
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/admin/db/shipping_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");
include_once($path_to_root . "/sales/includes/db/packing_list_db.inc");

//----------------------------------------------------------------------------------------------------

print_sales_orders();

function print_sales_orders()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report_inv_tax_2.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$email = $_POST['PARAM_2'];
	$comments = $_POST['PARAM_3'];
	$orientation = $_POST['PARAM_4'];

	$data = explode('-', $from);
	$order_no = $data[0];
	$packing_list_id = $data[1];

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$cols = array(8, 33, 143, 183, 243, 303, 308, 333, 443, 483, 543);

	// $headers in doctext.inc
	$aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left');

	$params = array('comments' => $comments, 'print_quote' => $print_as_quote);

	$cur = get_company_Pref('curr_default');

    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $order_no; $i <= $order_no; $i++)
	{
		$myrow = get_sales_order_header($i, ST_SALESORDER);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];
		$branch = get_branch($myrow["branch_code"]);

        if ($i == $order_no || $email == 1)
            $rep = new FrontReport(_("Packing List"), "PackingListBulk", user_pagesize(), 7, $orientation);
        if ($print_as_quote == 1)
        {
            $rep->title = _('QUOTE');
            $rep->filename = "Quote" . $i . ".pdf";
        }
        else
        {
            $rep->title = _("Packing List");
            $rep->filename = "PackingList" . $i . ".pdf";
        }		
		$rep->SetHeaderType('Header2');
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_branch_contacts($branch['branch_code'], 'order', $branch['debtor_no'], true);
		$rep->SetCommonData($myrow, $branch, $myrow, $baccount, ST_SALESORDER, $contacts);
		$rep->NewPage();

		$result = get_sales_order_details($i, ST_SALESORDER);
		$SubTotal = 0;
		$items = $prices = array();
		$rep->aligns[0]='left';
		$ctn_sum=0;
		$data = db_fetch($result);
		$packing_slip = get_packing_list_header($packing_list_id);

		$rep->row = 90;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 300, 90, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(125, 691,180, _("BENEFICIARY"), -2);

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(308, $rep->row, 295, 90, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(420, 691,180, _("APPLICATION"), -2);

		$rep->row = 180;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 120, 130, 0, '1111', 'D',null, array(0, 0, 0));


		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15, 601,180, _("DESCRIPTION"), -2);
		$rep->TextWrap(300, 602,180, $data['description'], -2);

		$rep->row = 195;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15, 586,180, _("INVOICE NO"), -2);
		$rep->TextWrap(200,586,180, $myrow['export_inv_ref'], -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(330, $rep->row, 120, 90, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(340, 586,180, _("PORT OF LOADING"), -2);
		$rep->TextWrap(470,586,180, $myrow['port_of_loading'], -2);

		$rep->row = 210;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15, 571,180, _("INVOICE DATE"), -2);
		$rep->TextWrap(200,571,180, sql2date($myrow['ord_date']), -2);
		$rep->TextWrap(340, 571,180, _("PORT OF DISCHARGE"), -2);
		$rep->TextWrap(470,571,180, $myrow['port_of_discharge'], -2);

		$rep->row = 225;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15, 556,180, _("FORM 'E' NO"), -2);
		$rep->TextWrap(200,556,180, $packing_slip['form_e_no'], -2);
		$rep->TextWrap(340, 556,180, _("VESSEL NAME"), -2);
		$rep->TextWrap(470,556,180, $packing_slip['vessel_name'], -2);

		$rep->row = 240;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15, 541,180, _("FORM 'E' DATE"), -2);
		$rep->TextWrap(200,541,180, sql2date($packing_slip['form_e_date']), -2);
		$rep->TextWrap(340, 541,180, _("B/L Number"), -2);
		$rep->TextWrap(470,541,180, $packing_slip['bl_no'], -2);

		$rep->row = 255;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15, 526,180, _("PAYMENT TERM"), -2);
		$pay_term = get_payment_terms($myrow['payment_terms']);
		$rep->TextWrap(200,526,500, $pay_term['terms'], -2);

		$rep->TextWrap(340, 526,180, _("B/L DATE"), -2);
		$rep->TextWrap(470,526,180, sql2date($packing_slip['bl_date']), -2);

		$rep->row = 270;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15, 511,180, _("L/C CONTRACT #"), -2);
		$rep->TextWrap(200,511,180, $packing_slip['lc_contract_no'], -2);
		$rep->TextWrap(340, 511,180, _("L/C / CONTRACT DATE"), -2);
		$rep->TextWrap(470,511,180, sql2date($packing_slip['lc_contract_date']), -2);

		$rep->row = 285;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 25, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15, 495,180, _("PACKING"), -2);
		// $rep->TextWrap(200,495,400, $myrow['packing'], -2);
        $rep->row = 498;
        $rep->fontSize -=2;
        $rep->lineHeight=6;
        $rep->TextWrapLines(140,430, preg_replace("/\r|\n/", "",$myrow['packing']) );
        $rep->fontSize +=2;
        $rep->lineHeight=12;

		$rep->row = 310;
		$rectangles = [8 => 25, 33 => 110, 143 => 40, 183 => 60, 243 => 60, 303 => 5, 308 => 25,
		333 => 110, 443 => 40, 483 => 60, 543 => 60];
		$values = [13 => 'S.#', 80 => 'NO', 150 => 'BAGS', 200 => 'NET WT', 250 => 'GROSS WT',
				  313 => 'S.#', 380 => 'NO', 450 => 'BAGS', 500 => 'NET WT', 550 => 'GROSS WT'];
		foreach ($rectangles as $x => $width) {
			$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
			$rep->RoundedRect($x, $rep->row, $width, 15, 0, '1111', 'D', null, array(0, 0, 0));
			  foreach ($values as $x2 => $text)
       				 $rep->TextWrap($x2, 471, 200, $text, -2);
		}


		$rep->row = 325;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 25, 268, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(33, $rep->row, 110, 268, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(143, $rep->row, 40, 268, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(183, $rep->row, 60, 268, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(183, $rep->row, 60, 268, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(243, $rep->row, 60, 268, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(303, $rep->row, 5, 268, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(308, $rep->row, 25, 268, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(333, $rep->row, 110, 268, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(443, $rep->row, 40, 268, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(483, $rep->row, 60, 268, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(543, $rep->row, 60, 268, 0, '1111', 'D',null, array(0, 0, 0));

		// $height = 15;
		// $sno = 1;
		// $rectangles2 = [[8, 25], [33, 110], [143, 40], [183, 60], [243, 60],
		// [303, 5], [308, 25], [333, 110], [443, 40], [483, 60], [543, 60]];
		// $row_line=395;
		$rep->row = 458;
		$packing_slip_details = get_packing_list_details($packing_list_id);
		$item_count = db_num_rows($packing_slip_details); 
		$serial_number = 1;
		$data_rows_break = 0;
		$dividing_rows = $item_count/2;
		$start_row = $rep->row;
		$start_status = 0;
		while ($row = db_fetch($packing_slip_details)) {
		    if ($data_rows_break < $dividing_rows) {
		        $rep->TextWrap(15, $rep->row, 900, $serial_number++, -2);
		        $rep->TextWrap(65, $rep->row, 900, $row['no'], -2);
		        $rep->TextWrap(150, $rep->row, 900, $row['bags'], -2);
		        $rep->TextWrap(200, $rep->row, 900, $row['net_wt'], -2);
		        $rep->TextWrap(260, $rep->row, 900, $row['gross_wt'], -2);
		        $total_bags_sec_1 += $row['bags'];
				$total_net_wt_sec_1 += $row['net_wt'];
				$total_gross_wt_sec_1 += $row['gross_wt'];
		    } else {
		        $rep->TextWrap(315, $rep->row, 900, $serial_number++, -2);
		        $rep->TextWrap(370, $rep->row, 900, $row['no'], -2);
		        $rep->TextWrap(450, $rep->row, 900, $row['bags'], -2);
		        $rep->TextWrap(505, $rep->row, 900, $row['net_wt'], -2);
		        $rep->TextWrap(560, $rep->row, 900, $row['gross_wt'], -2);
		        $total_bags_sec_2 += $row['bags'];
				$total_net_wt_sec_2 += $row['net_wt'];
				$total_gross_wt_sec_2 += $row['gross_wt'];
		    }
			$rep->TextWrap(9,455,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,440,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,425,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,410,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,395,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,380,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,365,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,350,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,335,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,320,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,305,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,290,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,275,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,260,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,245,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,230,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,215,900, str_repeat("_",153), -2);
			$rep->TextWrap(9,200,900, str_repeat("_",153), -2);

		    $rep->row -= 15;
		    $data_rows_break++;

		    if ($data_rows_break >= $dividing_rows && $start_status == 0) {
		       $rep->row = $start_row;
		       $start_status = 1; 
		    }
			
			$total_bags += $row['bags'];
			$total_net_wt += $row['net_wt'];
			$total_gross_wt += $row['gross_wt'];
		}

		$rep->row = 592;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 25, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(33, $rep->row, 110, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(143, $rep->row, 40, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(183, $rep->row, 60, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(243, $rep->row, 60, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(13,188,400, _("TTl"), -2);
		$rep->TextWrap(145,188,400, price_format($total_bags_sec_1), -2);
		$rep->TextWrap(195,188,400, price_format($total_net_wt_sec_1), -2);
		$rep->TextWrap(250,188,400, price_format($total_gross_wt_sec_1), -2);

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(303, $rep->row, 5, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(308, $rep->row, 25, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(333, $rep->row, 110, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(443, $rep->row, 40, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(483, $rep->row, 60, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(543, $rep->row, 60, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->TextWrap(445,188,400, price_format($total_bags_sec_2), -2);
		$rep->TextWrap(495,188,400, price_format($total_net_wt_sec_2), -2);
		$rep->TextWrap(550,188,400, price_format($total_gross_wt_sec_2), -2);

		$rep->row = 607;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 295, 60, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(143, $rep->row, 160, 60, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->Font('bold');
		$rep->TextWrap(13, 160, 900, _("TOTAL BAG"), -2);
		$rep->TextWrap(13, 145, 900, _("TOTAL NET WEIGHT"), -2);
		$rep->TextWrap(13, 130, 900, _("TOTAL GROSS WEIGHT"), -2);
		$rep->TextWrap(170,160,400, price_format($total_bags) ." BAGS ", -2);
		$rep->TextWrap(170,145,400, price_format($total_net_wt) . " " . $data['unit_id'], -2);
		$rep->TextWrap(170,130,400, price_format($total_gross_wt) . " ". $data['unit_id'], -2);
		$rep->Font();

		$rep->row = 885;
		$rep->fontSize += 3;
		$rep->Font('BU');
		$rep->TextWrap(13, 105, 900, _("SHIPPMENT MARKS"), -2);
		$rep->Font();
		$rep->fontSize -= 3;
		$rep->TextWrapLines(13, 180, $packing_slip['shipping_marks']);
		// $rep->TextWrapLines(13, 90, 900, $packing_slip['shipping_marks'], -2);
		// $rep->TextWrap(9, 170, 900, "TOTAL NET WEIGHT: $total_net_wt", -2);
		// $rep->TextWrap(9, 155, 900, "TOTAL GROSS WEIGHT: $total_gross_wt", -2);
		// $c=0;
		// foreach ($rectangles2 as $line_x_w) {
		//     list($x, $width) = $line_x_w;
		//     $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		//     $rep->RoundedRect($x, $rep->row, $width, $height, 0, '1111', 'D', null, array(0, 0, 0));
		// }
		// $rep->TextWrap(13, $rep->row+$row_line , 200, $s_no++, -2);
		// $rep->TextCol($c++, $c,	$myrow2['stock_id'], -2);
	 	// $rep->TextWrap(80, $rep->row-110, 200, $row['no'], -2);
	 	// $rep->TextWrap(150, $rep->row-110, 200, $row['bags'], -2);
	 	// $rep->TextWrap(200, $rep->row-110, 200, $row['net_wt'], -2);
	 	// $rep->TextWrap(250, $rep->row-110, 200, $row['gross_wt'], -2);
	 	// $rep->TextWrap(313, $rep->row-110, 200, '1', -2);
	 	// $rep->TextWrap(380, $rep->row-110, 200, $row['no'], -2);
	 	// $rep->TextWrap(450, $rep->row-110, 200, $row['bags'], -2);
	 	// $rep->TextWrap(500, $rep->row-110, 200, $row['net_wt'], -2);
	 	// $rep->TextWrap(550, $rep->row-110, 200, $row['gross_wt'], -2);

		// $rep->row += $height;
		// $row_line += $height;

		if($myrow['applicant']){
			$rep->row = 675;
			$rep->TextWrapLines(60,180, $myrow['applicant']);
		}
		if($myrow['notify_consignee']){
			$rep->row = 675;
			$rep->TextWrapLines(370,180, $myrow['notify_consignee']);
		}

		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(408, $rep->row, 195, 110, 0, '1111', 'D',null, array(0, 0, 0));
		// $rep->TextWrap(407,670,180, _("NOTIFY / CONSIGNEE"), -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 20, 0, '1111', 'D',null, array(0, 0, 0));

		// $rep->row = 732;
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 595, 38, 0, '1111', 'D',null, array(0, 0, 0));

        if ($i == $order_no || $email == 1)
            $rep->End($email);
	}
}

