<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_REP_PRINT_SALES_ORDER' : 'SA_REP_PRINT_SALES_ORDER';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Sales Orders
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/admin/db/shipping_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");
include_once($path_to_root . "/sales/includes/db/packing_list_db.inc");

//----------------------------------------------------------------------------------------------------

print_sales_orders();

function print_sales_orders()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report_inv_tax_3.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$email = $_POST['PARAM_2'];
	$comments = $_POST['PARAM_3'];
	$orientation = $_POST['PARAM_4'];

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$cols = array(8, 33, 143, 183, 243, 303, 308, 333, 443, 483, 543);

	// $headers in doctext.inc
	$aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left');

	$params = array('comments' => $comments, 'print_quote' => $print_as_quote);

	$cur = get_company_Pref('curr_default');

    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		$myrow = get_sales_order_header($i, ST_SALESORDER);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];
		$branch = get_branch($myrow["branch_code"]);

        if ($i == $from || $email == 1)
            $rep = new FrontReport(_("SALES ORDER"), "BLINSTRUCTIONBulk", user_pagesize(), 7, $orientation);
        if ($print_as_quote == 1)
        {
            $rep->title = _('QUOTE');
            $rep->filename = "Quote" . $i . ".pdf";
        }
        else
        {
            $rep->title = _("BL INSTRUCTION");
            $rep->filename = "BLINSTRUCTION" . $i . ".pdf";
        }		
		$rep->SetHeaderType('Header2');
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_branch_contacts($branch['branch_code'], 'order', $branch['debtor_no'], true);
		$rep->SetCommonData($myrow, $branch, $myrow, $baccount, ST_SALESORDER, $contacts);
		$rep->NewPage();

		$result = get_sales_order_details($i, ST_SALESORDER);
		$SubTotal = 0;
		$items = $prices = array();
		$rep->aligns[0]='left';
		$ctn_sum=0;
		$data = db_fetch($result);
		$packing_slip = get_packing_list_header($myrow['order_no']);

		$rep->row = 35;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 410, 735, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(13,746,180, _("SHIPPER : "), -2);
		$rep->TextWrap(460,746,180, _("SHIP-CO AGENT AT DEST : "), -2);

		$rep->row = 50;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 80, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(13,652,400, _('CONSIGNEE : This B/L is not negotiable unless marked "To Order" or "To Order of"... here'), -2);
		$rep->TextWrap(480,652,180, _("ALSO NOTIFY "), -2);
		if($packing_slip['booking']){
			$rep->TextWrap(430,560,180, _("BOOKING: "), -2);
			$rep->TextWrap(470,560,180, $packing_slip['booking'], -2);
		}


		$rep->row = 130;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->row = 145;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 410, 80, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->row = 225;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 410, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->row = 240;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 410, 100, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(13,556,400, _("NOTIFY PARTIES : (No responsibility shall attach to carrier or) "), -2);

		$rep->row = 340;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 175, 430, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->row = 340;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(50,442,180, _("VESSEL & VOYAGE NO. "), -2);
		$rep->TextWrap(250,442,180, _("PORT OF LOADING "), -2);
		$rep->TextWrap(470,442,180, _("PLACE OF RECEIPT "), -2);

		$rep->row = 355;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->row = 385;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(60,396,180, _("BOOKING NO. "), -2);
		$rep->TextWrap(247,396,180, _("PORT OF DISCHARGE "), -2);
		$rep->TextWrap(470,396,180, _("PLACE OF DELIVERY "), -2);

		$rep->row = 400;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->row = 415;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(50,366,180, _("MARKS / CONTAINER NO "), -2);
		$rep->TextWrap(230,366,400, _("DESCRIPTION of Packages and Goods "), -2);

		$rep->row = 415;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(418, $rep->row, 95, 100, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(428,366,180, _("GROSS VARGO WT "), -2);
		$rep->TextWrap(530,366,180, _("MEASUREMENT "), -2);

		$rep->row = 515;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 175, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->row = 515;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 67, 255, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(75, $rep->row, 50, 255, 0, '1111', 'D',null, array(0, 0, 0));

		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(125, $rep->row, 58, 200, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->TextWrap(12,266,180, _("CONTAINER # "), -2);
		$rep->TextWrap(88,266,180, _("BAGS "), -2);
		$rep->TextWrap(130,266,180, _("NET WEIGHT "), -2);

		$rep->row = 253;
		$packing_slip_details = get_packing_list_details($myrow['order_no']);
		$item_count = db_num_rows($packing_slip_details); 
		$serial_number = 1;
		$data_rows_break = 0;
		$dividing_rows = $item_count/2;
		$start_row = $rep->row;
		$start_status = 0;
		while ($row = db_fetch($packing_slip_details)) {

			 if ($data_rows_break < $dividing_rows) {
		        // $rep->TextWrap(15, $rep->row, 900, $serial_number++, -2);
		        $rep->TextWrap(30, $rep->row, 900, $row['no'], -2);
		        $rep->TextWrap(90, $rep->row, 900, $row['bags'], -2);
		        $rep->TextWrap(140, $rep->row, 900, $row['net_wt'], -2);
		        // $rep->TextWrap(260, $rep->row, 900, $row['gross_wt'], -2);
		        $total_bags_sec_1 += $row['bags'];
				$total_net_wt_sec_1 += $row['net_wt'];
				$total_gross_wt_sec_1 += $row['gross_wt'];
		    } else {
		        $rep->TextWrap(440, $rep->row, 900, $row['no'], -2);
		        $rep->TextWrap(500, $rep->row, 900, $row['bags'], -2);
		        $rep->TextWrap(550, $rep->row, 900, $row['net_wt'], -2);
		        // $rep->TextWrap(560, $rep->row, 900, $row['gross_wt'], -2);
		        $total_bags_sec_2 += $row['bags'];
				$total_net_wt_sec_2 += $row['net_wt'];
				$total_gross_wt_sec_2 += $row['gross_wt'];
		    }

			$rep->TextWrap(8,250,900, str_repeat("_",45), -2);
			$rep->TextWrap(8,235,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,220,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,205,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,190,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,175,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,160,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,145,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,130,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,115,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,100,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,85,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,70,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,55,180, str_repeat("_",45), -2);
			$rep->TextWrap(8,40,180, str_repeat("_",45), -2);

		    $rep->row -= 15;
		    $data_rows_break++;

		    if ($data_rows_break >= $dividing_rows && $start_status == 0) {
		       $rep->row = $start_row;
		       $start_status = 1; 
		    }
			
			$total_bags += $row['bags'];
			$total_net_wt += $row['net_wt'];
			$total_gross_wt += $row['gross_wt'];
	  	}

	  	$rep->TextWrap(85,30,400, price_format($total_bags_sec_1), -2);
		$rep->TextWrap(135,30,400, price_format($total_net_wt_sec_1), -2);

		$rep->TextWrap(490,30,400, price_format($total_bags_sec_2), -2);
		$rep->TextWrap(545,30,400, price_format($total_net_wt_sec_2), -2);

		$rep->row = 515;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(418, $rep->row, 67, 255, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(485, $rep->row, 50, 255, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(535, $rep->row, 68, 255, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->TextWrap(419,265,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,250,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,235,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,220,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,205,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,190,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,175,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,160,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,145,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,130,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,115,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,100,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,85,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,70,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,55,400, str_repeat("_",47), -2);
		$rep->TextWrap(419,40,400, str_repeat("_",47), -2);
		$rep->TextWrap(422,266,180, _("CONTAINER # "), -2);
		$rep->TextWrap(497,266,180, _("BAGS "), -2);
		$rep->TextWrap(540,266,180, _("NET WEIGHT "), -2);

		if(get_company_prefs()['postal_address']){
			$rep->row = 720;
			$rep->TextWrapLines(13,180, get_company_prefs()['coy_name']);
			$rep->NewLine(0.2);
			$rep->TextWrapLines(13,180, get_company_prefs()['postal_address']);
		}
		$rep->row = 720;
		$rep->TextWrapLines(450, 150, _("AGENT AT DESTINATION") . "\n" . _("PHONE, FAX NO AND EMAIL ADD"), 210);

		$bank_acc = get_bank_account($myrow['bank_account']);
		if($bank_acc['bank_name']){
			$rep->TextWrap(13,630,180, _("TO THE ORDER OF "), -2);
			$rep->row = 620;
			$rep->TextWrapLines(13,80, $bank_acc['bank_name']);
		}
		if($myrow['notify_consignee']){
			$rep->row = 530;
			$rep->TextWrapLines(13,180, $myrow['notify_consignee']);
		}
		if($packing_slip['vessel_name']){
			$rep->TextWrap(45,426,180, $packing_slip['vessel_name'], -2);
		}
		if($myrow['port_of_loading']){
			$rep->TextWrap(245,426,180, $myrow['port_of_loading'], -2);
		}
		if($myrow['port_of_discharge']){
			$rep->TextWrap(240,381,180, $myrow['port_of_discharge'], -2);
		}
		if($packing_slip['shipping_marks']){
			$rep->row = 345;
			$rep->TextWrapLines(25,150, $packing_slip['shipping_marks']);
		}
		if($data['description']){
			$rep->row = 345;
			$rep->TextWrapLines(190,150, $data['description']);
		}

		if($packing_slip['form_e_no']){
			$rep->row = 320;
			$rep->TextWrapLines(190,150, _("FORM 'E' NO: "));
			$rep->TextWrap(240,320,180, $packing_slip['form_e_no'], -2);
		}

		if($packing_slip['form_e_date']){
			$rep->row = 320;
			$rep->TextWrapLines(350,150, _("Date: "));
			$rep->TextWrap(370,320,180, sql2date($packing_slip['form_e_date']), -2);
		}

		$rep->TextWrap(190,280 , 900, _("FREIGHT PREPAID"), -2);
		$rep->row = 265;
		$rep->TextWrapLines(190,150, $packing_slip['freight_prepaid']);

		$rep->TextWrap(190,120 , 900, _("TOTAL GROSS WEIGHT"), -2);
		$rep->TextWrap(190, 105, 900, _("TOTAL NET WEIGHT"), -2);
		$rep->TextWrap(190, 90, 900, _("TOTAL BAG"), -2);
		$rep->TextWrap(275,120,400, price_format($total_gross_wt) . " ". $data['unit_id'], -2);
		$rep->TextWrap(275,105,400, price_format($total_net_wt) . " " . $data['unit_id'], -2);
		$rep->TextWrap(275,90,400, price_format($total_bags) ." BAGS ", -2);

		$rep->Font('bold');
		$rep->TextWrap(430,345 , 900, _("GROSS WT KGS"), -2);
		$rep->TextWrap(440,330,600, price_format($total_gross_wt) . " ". $data['unit_id'], -2);
		$rep->TextWrap(430,305 , 900, _("NET WT KGS"), -2);
		$rep->TextWrap(440,290,600, price_format($total_net_wt) . " ". $data['unit_id'], -2);
		$rep->TextWrap(550,345 , 900, _("M3"), -2);
		$rep->Font();

		// $rep->TextWrap(230, 602,180, $data['description'], -2);
		// $rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		// $rep->RoundedRect(8, $rep->row, 50, 200, 0, '1111', 'D',null, array(0, 0, 0));

        if ($i == $to || $email == 1)
            $rep->End($email);
	}
}

