<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_REP_PRINT_SALES_ORDER' : 'SA_REP_PRINT_SALES_ORDER';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Sales Orders
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/admin/db/shipping_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");
include_once($path_to_root . "/sales/includes/db/packing_list_db.inc");

//----------------------------------------------------------------------------------------------------

print_sales_orders();

function print_sales_orders()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report_inv_tax_4.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$email = $_POST['PARAM_2'];
	$comments = $_POST['PARAM_3'];
	$orientation = $_POST['PARAM_4'];

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$cols = array(8, 33, 143, 183, 243, 303, 308, 333, 443, 483, 543);

	// $headers in doctext.inc
	$aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left');

	$params = array('comments' => $comments, 'print_quote' => $print_as_quote);

	$cur = get_company_Pref('curr_default');

    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		$myrow = get_customer_trans($i, ST_SALESINVOICE);
		$so_data = get_sales_order_header($myrow['order_'], ST_SALESORDER);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];
		$branch = get_branch($myrow["branch_code"]);

        if ($i == $from || $email == 1)
            $rep = new FrontReport(_("Commercial Invoice"), "CommercialInvoiceBulk", user_pagesize(), 7, $orientation);
        if ($print_as_quote == 1)
        {
            $rep->title = _('QUOTE');
            $rep->filename = "Quote" . $i . ".pdf";
        }
        else
        {
            $rep->title = _("Commercial Invoice");
            $rep->filename = "CommercialInvoice" . $i . ".pdf";
        }		
		$rep->SetHeaderType('Header2');
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_branch_contacts($branch['branch_code'], 'order', $branch['debtor_no'], true);
		$rep->SetCommonData($myrow, $branch, $myrow, $baccount, ST_SALESORDER, $contacts);
		$rep->NewPage();

		$result = get_sales_order_details($i, ST_SALESORDER);
		$SubTotal = 0;
		$items = $prices = array();
		$rep->aligns[0]='left';
		$ctn_sum=0;
		$data = db_fetch($result);
		$packing_slip = get_packing_list_header($myrow['order_']);

		$rep->row = 80;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 100, 40, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(25, 700,180, _("INVOICE NUMBER."), -2);
		$rep->TextWrap(35, 683,180, $myrow['reference'], -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(108, $rep->row, 100, 40, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(125, 700,180, _("INVOICE DATE"), -2);
		$rep->TextWrap(130, 683,180, sql2date($myrow["tran_date"]), -2);
	
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(208, $rep->row, 100, 40, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(225, 700,180, _("FORM 'E' NUMBER"), -2);
		$rep->TextWrap(235, 683,180, $packing_slip['form_e_no'], -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(308, $rep->row, 100, 40, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(325, 700,180, _("FORM 'E' DATE"), -2);
		$rep->TextWrap(335, 683,180, sql2date($packing_slip['form_e_date']), -2);
		$rep->TextWrap(470, 700,180, _("SHIPPING MARKS"), -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->row = 120;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 200, 100, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(80,661,180, _("BENEFICIARY"), -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(208, $rep->row, 200, 100, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(280,661,180, _("APPLICATION"), -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(408, $rep->row, 195, 100, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(480,661,180, _("NOTIFY"), -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));
		if(get_company_prefs()['postal_address']){
			$rep->row = 640;
			$rep->TextWrapLines(20,180, get_company_prefs()['coy_name']);
			$rep->NewLine(0.2);
			$rep->TextWrapLines(20,180, get_company_prefs()['postal_address']);
		}
		if($so_data['applicant']){
			$rep->row = 640;
			$rep->TextWrapLines(220,180, $so_data['applicant']);
		}
		if($so_data['notify_consignee']){
			$rep->row = 640;
			$rep->TextWrapLines(420,180, $so_data['notify_consignee']);
		}
		$rep->row = 220;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 200, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(70,561,180, _("SHIPMENT FROM"), -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(208, $rep->row, 200, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(280,561,180, _("SHIPMENT TO"), -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(408, $rep->row, 195, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(470,561,180, _("SHIPPING MARKS"), -2);
		$rep->row = 530;
		$rep->TextWrapLines(415, 190, $packing_slip['shipping_marks']);

		$rep->row = 235;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 200, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(80,546,180, $so_data['port_of_loading'], -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(208, $rep->row, 200, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(260,546,180, $so_data['port_of_discharge'], -2);

		$rep->row = 250;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 400, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15,531,180, _("EXP REGISTRATION NO"), -2);
		$rep->row = 250;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 110, 95, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->row = 265;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 400, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15,516,180, _("NAME OF VESSEL"), -2);
		$rep->TextWrap(230,516,180, $packing_slip['vessel_name'], -2);
		$rep->row = 280;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 400, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15,501,180, _("B/L NUMBER"), -2);
		$rep->TextWrap(150,501,180, $packing_slip['bl_no'], -2);

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(275, $rep->row, 55, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(290,501,180, _("DATED"), -2);
		$rep->TextWrap(350,501,180, _("0000-00-00"), -2);
		$rep->row = 295;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 400, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15,486,180, _("DRAFT DRAWN AT"), -2);
		$rep->row = 310;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 400, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15,471,180, _("L/C CONTRACT NO."), -2);
		$rep->TextWrap(150,471,180, $packing_slip['lc_contract_no'], -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(275, $rep->row, 55, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(290,471,180, _("DATED"), -2);
		$rep->TextWrap(350,471,180, sql2date($packing_slip['lc_contract_date']), -2);

		$rep->row = 325;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 400, 20, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(15,455,180, _("BANK NAME"), -2);

		$rep->row = 345;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 595, 15, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 110, 340, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(20,436,180, _("BAGS"), -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(60, $rep->row, 58, 340, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(70,436,180, _("QTY-MTS"), -2);
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(118, $rep->row, 290, 340, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(190,436,180, _("DESCRIPTION OF THE COMMODITY"), -2);

		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(408, $rep->row, 95, 425, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(435,436,180, _("UNIT PRICE"), -2);
		$rep->TextWrap(525,436,180, _("TOTAL VALUE"), -2);

		$rep->row = 635;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 400, 25, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(200, $rep->row, 100, 25, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(300, $rep->row, 108, 25, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->TextWrap(20,140,180, _("PACKING"), -2);
		$rep->TextWrap(65,140,180, _("NO OF BAGS"), -2);
		$rep->TextWrap(135,140,180, _("NET WEIGHT"), -2);
		$rep->TextWrap(225,140,180, _("TARE WEIGHT"), -2);
		$rep->TextWrap(320,140,180, _("GROSS WEIGHT"), -2);

		$rep->row = 660;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(8, $rep->row, 400, 25, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(200, $rep->row, 100, 25, 0, '1111', 'D',null, array(0, 0, 0));
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(300, $rep->row, 108, 25, 0, '1111', 'D',null, array(0, 0, 0));

		$rep->row = 610;
		$rep->SetLineStyle(array('width' => 0, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(0, 0, 0)));
		$rep->RoundedRect(408, $rep->row, 195, 15, 0, '1111', 'D',null, array(0, 0, 0));
		$curr_row = get_currency($so_data['curr_code']);

		$rep->TextWrap(432,171,180, _("TOTAL VALUE") . " ". $curr_row['curr_abrev'], -2);

		$bank_acc = get_bank_account($so_data['bank_account']);
		$rep->row = 885;
		$rep->Font('BU');
		$rep->TextWrap(13, 95, 900, _("ACCOUNT DETAILS HMB"), -2);
		$rep->Font();
		if($so_data['bank_account']){
			$rep->TextWrap(13,80,300, _("IBAN No.: "), -2);
			$rep->TextWrap(85,80,300, $bank_acc['iban_no']);
			$rep->TextWrap(13,70,300, _("Bank Name: "), -2);
			$rep->TextWrap(85,70,300, $bank_acc['bank_name']);
			$rep->TextWrap(13,60,300, _("Address: "), -2);
			$rep->TextWrap(85,60,300, $bank_acc['bank_address']);
			$rep->TextWrap(13,50,300, _("Swift Code"), -2);
			$rep->TextWrap(85,50,300, $bank_acc['swift_code']);
			$rep->TextWrap(13,40,300, _("Pakistan Account No.: "), -2);
			$rep->TextWrap(85,40,300, $bank_acc['bank_account_number']);
			$rep->TextWrap(13,30,300, _("Branch Code"), -2);
			$rep->TextWrap(85,30,300, $bank_acc['branch_code']);
		}

		$packing_slip_details = get_packing_list_details($so_data['order_no']);
		while ($row = db_fetch($packing_slip_details)) {
			$total_bags += $row['bags'];
			$total_net_wt += $row['net_wt'];
			$total_gross_wt += $row['gross_wt'];
		}
		$rep->TextWrap(20,420,180, number_format2($total_bags), -2);
		$rep->TextWrap(70,115,180, number_format2($total_bags), -2);

		$result2 = get_customer_trans_details(ST_SALESINVOICE, $i);
		while ($myrow2 = db_fetch($result2))
		{
			$rep->TextWrap(120,420,180, $myrow2['description'], -2);
			$total_qty += $myrow2["quantity"];
			$total_price += $myrow2["unit_price"];
		}
			$rep->TextWrap(70,420,180, number_format2($total_qty), -2);
			$rep->TextWrap(440,420,180, $curr_row['curr_symbol'] ." ". price_format($total_price), -2);
			$rep->TextWrap(530,420,180,  $curr_row['curr_symbol'] ." ". price_format($total_qty*$total_price), -2);
			$rep->TextWrap(530,171,180,  $curr_row['curr_symbol'] ." ". price_format($total_qty*$total_price), -2);

		$rep->TextWrap(120,360,300, _("CONTRACT NO. "), -2);
		$rep->TextWrap(175,360,180, $packing_slip['lc_contract_no'], -2);
		$rep->TextWrap(320,360,300, _("DATE"), -2);
		$rep->TextWrap(350,360,180, sql2date($packing_slip['lc_contract_date']), -2);

        if ($i == $to || $email == 1)
            $rep->End($email);
	}
}

