<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_BILL_OF_EXCHANGE' : 'SA_BILL_OF_EXCHANGE';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19BILL_OF_EXCHANGE
// Title:	Print Sales Orders
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/admin/db/shipping_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");
include_once($path_to_root . "/sales/includes/db/bill_of_exchange_db.inc");
//----------------------------------------------------------------------------------------------------

print_sales_orders();

function print_sales_orders()
{
	global $path_to_root, $SysPrefs;

	include_once($path_to_root . "/reporting/includes/pdf_report_inv_tax.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$print_as_quote = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$orientation = $_POST['PARAM_6'];

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

	$cols = array(4, 300,  385, 450, 515);

	// $headers in doctext.inc
	$aligns = array('center', 'center', 'center', 'center', 'center');

	$params = array('comments' => $comments, 'print_quote' => $print_as_quote);

	$cur = get_company_Pref('curr_default');

    if ($orientation == 'L')
    	recalculate_cols($cols);

	for ($i = $from; $i <= $to; $i++)
	{
		$myrow = get_sales_order_header($i, ST_SALESORDER);
		if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
			continue;
		}
		$baccount = get_default_bank_account($myrow['curr_code']);
		$params['bankaccount'] = $baccount['id'];
		$branch = get_branch($myrow["branch_code"]);

        if ($i == $from || $email == 1)
            $rep = new FrontReport(_("Bill of Exchange"), "BILLOFEXCHANGE", user_pagesize(), 9, $orientation);
        if ($print_as_quote == 1)
        {
            $rep->title = _('QUOTE');
            $rep->filename = "Quote" . $i . ".pdf";
        }
        else
        {
            $rep->title = _("Bill of Exchange");
            $rep->filename = "Bill of Exchange" . $i . ".pdf";
        }		
		$rep->SetHeaderType('Header5');
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$contacts = get_branch_contacts($branch['branch_code'], 'order', $branch['debtor_no'], true);
		$rep->SetCommonData($myrow, $branch, $myrow, $baccount, ST_SALESORDER, $contacts);
		$rep->NewPage();

		$result = get_bill_of_exchange_by_order_no($i);
		
		$rep->fontSize += 5;
		$rep->Font('bold');
		$rep->TextWrap(20,730,180, _("DRAWN UNDER"), -2);
		$rep->Font();
		$rep->fontSize -= 5;
		$rep->row = 710;
		$rep->TextWrapLines(20,450, $result['drawn_under']);

		$rep->fontSize += 1;
		$rep->Font('bold');
		$rep->TextWrap(20,670,180, _("For USD"), -2);
		$rep->Font();
		$rep->fontSize -= 1;
		$rep->fontSize += 1;
		$rep->TextWrap(150,670,600, number_format($result['for_usd']), -2);
		$rep->fontSize -= 1;
		$rep->TextWrap(70,670,600, _("_______________________________________________"), -2);

		$rep->fontSize += 1;
		$rep->Font('bold');
		$rep->TextWrap(320,670,180, _("Date"), -2);
		$rep->Font();
		$rep->fontSize -= 1;
		$rep->fontSize += 1;
		$rep->TextWrap(400,670,600, sql2date($result['date_']), -2);
		$rep->fontSize -= 1;
		$rep->TextWrap(350,670,600, _("________________________________________________"), -2);

		$rep->fontSize += 1;
		$payment_term = get_payment_terms($result['payment_term']);
		$rep->TextWrap(20,640,600, $payment_term['terms'], -2);
		$rep->TextWrap(100,640,600, _(" pay against this FIRST BILL OF EXCHANGE (Second of the same tenor and date being unpaid)"), -2);
		$rep->fontSize -= 1;
		$rep->TextWrap(20,640,600, _("________________"), -2);


		$rep->fontSize += 1;
		$payment_term = get_payment_terms($result['payment_term']);
		$rep->TextWrap(20,610,600, _("to the order of". $result['bank_name']. "THE SUM OF"), -2);
		$rep->fontSize -= 1;

		$rep->fontSize += 1;
		$rep->Font('bold');
		$rep->TextWrap(20,580,600, _("US DOLLARS"), -2);
		$rep->Font();
		$rep->fontSize -= 1;
		$rep->TextWrap(20,580,600, _("__________________________________________________________________________________________________________________"), -2);
		$rep->fontSize += 1;
		$words = price_in_words($result['for_usd'], BILL_OF_EXCHANGE);
		$rep->row = 580;
		$rep->TextWrapLines(90,450, $words);
		$rep->fontSize -= 1;
		
		$rep->fontSize += 4;
		$rep->Font('bold');
		$rep->TextWrap(20,550,180, _("DRAWEE"), -2);
		$rep->Font();
		$rep->fontSize -= 4;
		$rep->row = 550;
		$rep->TextWrapLines(120,450, $result['drawee']);

        if ($i == $to || $email == 1)
            $rep->End($email);
	}
}

