<?php
/**********************************************************************
    Copyright (C) FrontAccounting Team.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_SUPPLIER_BALANCES';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2018-12-21
// Title:	Supplier Trial Balances
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//----------------------------------------------------------------------------------------------------

print_supplier_balances();


function get_bank_trans_date($type,$trans_no){

	$sql = "SELECT *
		FROM ".TB_PREF."bank_trans
		WHERE type=".db_escape($type)
		." AND trans_no=".db_escape($trans_no);
		// display_error($sql);
	$result = db_query($sql, "Cannot retreive a bank transaction");
    $row = db_fetch($result);
   return $row;

}

function get_open_balance($supplier_id, $to)
{
    if ($to)
        $to = date2sql($to);

    $sql = "SELECT SUM(IF(t.type = ".ST_SUPPINVOICE." OR (t.type IN (".ST_JOURNAL." , ".ST_BANKDEPOSIT.") AND t.ov_amount>0),
        -abs(t.ov_amount + t.ov_gst + t.ov_discount), 0)) AS credits,";

    $sql .= "SUM(IF(t.type != ".ST_SUPPINVOICE." AND NOT(t.type IN (".ST_JOURNAL." , ".ST_BANKDEPOSIT.") AND t.ov_amount>0),
        abs(t.ov_amount + t.ov_gst + t.ov_discount) * -1, 0)) AS charges,";

    $sql .= "SUM(IF(t.type != ".ST_SUPPINVOICE." AND NOT(t.type IN (".ST_JOURNAL." , ".ST_BANKDEPOSIT.")), t.alloc * -1, t.alloc)) 
        AS Allocated,";

    $sql .= "SUM(IF(t.type = ".ST_SUPPINVOICE.", 1, -1) *
        (abs(t.ov_amount + t.ov_gst + t.ov_discount) - abs(t.alloc))) AS OutStanding
        FROM ".TB_PREF."supp_trans t
        WHERE t.supplier_id = ".db_escape($supplier_id);
    if ($to)
        $sql .= " AND t.tran_date < '$to'";
    $sql .= " GROUP BY supplier_id";

    $result = db_query($sql,"No transactions were returned");
           



    return db_fetch($result);
}

function getTransactions($supplier_id, $from, $to)
{
	$from = date2sql($from);
	$to = date2sql($to);

    $sql = "SELECT *,
				(ov_amount + ov_gst + ov_discount) AS TotalAmount,
				alloc AS Allocated,
				((type = ".ST_SUPPINVOICE.") AND due_date < '$to') AS OverDue
   			FROM ".TB_PREF."supp_trans
   			WHERE tran_date >= '$from' AND tran_date <= '$to' 
    			AND supplier_id = '$supplier_id' AND ov_amount!=0
    				ORDER BY tran_date";

    $TransResult = db_query($sql,"No transactions were returned");

    return $TransResult;
}

function get_grn_items_data($id){
	$sql = " SELECT * FROM ".TB_PREF."grn_items WHERE id = '$id' ";
	$result =  db_query($sql, " ");
	return db_fetch($result);
}

function get_grn_batch_data($id){
	$sql = " SELECT * FROM ".TB_PREF."grn_batch WHERE id = '$id' ";
	$result =  db_query($sql, " ");
	return db_fetch($result);
}


function get_line_wise_journal_entry($trans_no, $type, $person_type_id, $person_id)
{
	$sql = "SELECT * FROM " . TB_PREF . "gl_trans WHERE type_no = " . db_escape($trans_no) . " AND type = " . db_escape($type) . " AND person_type_id = " . db_escape($person_type_id) . " AND CONVERT(person_id USING utf8) = " . db_escape($person_id);
	// display_error($sql);
	return db_query($sql,"could not get group");
}
//----------------------------------------------------------------------------------------------------

function print_supplier_balances()
{
	global $path_to_root, $systypes_array;

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$fromsupp = $_POST['PARAM_2'];
	$show_balance = $_POST['PARAM_3'];
	$currency = $_POST['PARAM_4'];
	$no_zeros = $_POST['PARAM_5'];
	$account_group = $_POST['PARAM_6'];
	$comments = $_POST['PARAM_7'];
	$orientation = $_POST['PARAM_8'];
	$destination = $_POST['PARAM_9'];
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	if ($fromsupp == ALL_TEXT)
		$supp = _('All');
	else
		$supp = get_supplier_name($fromsupp);
    	$dec = user_price_dec();

	if ($currency == ALL_TEXT)
	{
		$convert = true;
		$currency = _('Balances in Home currency');
	}
	else
		$convert = false;

	if ($no_zeros) $nozeros = _('Yes');
	else $nozeros = _('No');


		if ($account_group == ALL_TEXT)
		$acc_name = _('All');
	else
		$acc_name = get_account_type_name($account_group);

	// $cols = array(0, 95, 140, 200,	260, 320, 385, 450,	515);

	$cols = array(0, 40, 90, 180, 220,	250, 290, 320,360, 400,470,	570,640);


	// $headers = array(_('Trans Type'), _('#'),_("Cheque No"), _('Date'), _('Due Date'), _('Debits'), //Charges
	// 	_('Credits'), _('Allocated'), _('Outstanding'), _('Memo'));


	$headers = array(_('Date'), _('Ref No.'),_("DESCRIPTION"), _('VEHICLE'), _('BAG'), _('Gross Wt '), _('Less '), _('Net Wt '),  _('Batch No '),//Charges
		_('Rate'), _('DEBIT'), _('Credit'), _('Balance'));


	// if ($show_balance)
	// 	$headers[8] = _('Balance');
	$aligns = array('left',	'left', 'left',	'left',	'left',	'left',	'left',	'left',	'right', 'right', 'right', 'right', 'right');

    $params =   array( 	0 => $comments,
    			1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
    			2 => array('text' => _('Supplier'), 'from' => $supp, 'to' => ''),
               	3 => array( 'text' => _('Group Name'),'from' => $acc_name,'to' => ''),
    			// 3 => array(  'text' => _('Currency'),'from' => $currency, 'to' => ''),
				// 4 => array('text' => _('Suppress Zeros'), 'from' => $nozeros, 'to' => '')
    		);

    $rep = new FrontReport(_('Supplier Detail Report'), "SupplierDetailedBalances", 'LEGAL', 7, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

	$total = array();
	$grandtotal = array(0,0,0,0);

 $sql = "SELECT sp.supplier_id, sp.supp_name AS name, sp.curr_code, sp.supp_ref ,cm.account_type FROM ".TB_PREF."suppliers as sp 
           LEFT JOIN ".TB_PREF."chart_master  as cm ON  sp.payable_account=cm.account_code WHERE 1=1 ";
	if ($fromsupp != ALL_TEXT)
		$sql .= " AND supplier_id=".db_escape($fromsupp);

	   	if ($account_group != ALL_TEXT)
		$sql .= " AND cm.account_type=".db_escape($account_group);


	$sql .= " ORDER BY  cm.account_type";




	$result = db_query($sql, "The customers could not be retrieved");
	$acc_id=0;
	$bag_sum=$net_sum=$gross_sum=0;
	while ($myrow=db_fetch($result))
	{

         		if(	$acc_id!=$myrow['account_type'])
		{
			    $rep->Font('bold');
			    $rep->fontSize += 2;
		        	$rep->TextCol(0, 3, get_account_type_name($myrow['account_type'])) ;
				$rep->NewLine();
				$rep->fontSize -= 2;
				    $rep->Font();
		}
		$acc_id=$myrow['account_type'];


		if (!$convert && $currency != $myrow['curr_code'])
			continue;
		$accumulate = 0;
		$rate = $convert ? get_exchange_rate_from_home_currency($myrow['curr_code'], Today()) : 1;
		$bal = get_open_balance($myrow['supplier_id'], $from);
		$init = array();
		$bal['charges'] = isset($bal['charges']) ? $bal['charges'] : 0;
		$bal['credits'] = isset($bal['credits']) ? $bal['credits'] : 0;
		$bal['Allocated'] = isset($bal['Allocated']) ? $bal['Allocated'] : 0;
		$bal['OutStanding'] = isset($bal['OutStanding']) ? $bal['OutStanding'] : 0;
		$init[0] = round2(abs($bal['charges']*$rate), $dec);
		$init[1] = round2(Abs($bal['credits']*$rate), $dec);
		// $init[2] = round2($bal['Allocated']*$rate, $dec);
		if ($show_balance)
		{
			$init[3] = $init[0] - $init[1];
			$accumulate += $init[3];
		}	
		else	
			$init[3] = round2($bal['OutStanding']*$rate, $dec);
		$res = getTransactions($myrow['supplier_id'], $from, $to);
		if ($no_zeros && db_num_rows($res) == 0) continue;

		$rep->fontSize += 2;
				$rep->TextCol(0, 3, $myrow['supp_ref'] ." - ". $myrow['name']);
		// if ($convert) $rep->TextCol(3, 4,	$myrow['curr_code']);
		$rep->fontSize -= 2;
		$rep->TextCol(4, 6,	_("Open Balance"));
		$rep->AmountCol(9, 10, $init[0], $dec);
		$rep->AmountCol(10, 11, $init[1], $dec);
		// $rep->AmountCol(7, 8, $init[2], $dec);
		$rep->AmountCol(11, 12, $init[3], $dec);
		$total = array(0,0,0,0);
		for ($i = 0; $i < 4; $i++)
		{
			$total[$i] += $init[$i];
			$grandtotal[$i] += $init[$i];
		}
		$rep->NewLine(1, 2);
		$rep->Line($rep->row + 4);
		if (db_num_rows($res)==0) {
			$rep->NewLine(1, 2);
			continue;
		}	
			$rep->NewLine(1, 2);
		while ($trans=db_fetch($res))
		{
			if ($no_zeros && floatcmp(abs($trans['TotalAmount']), $trans['Allocated']) == 0) continue;
			$rep->DateCol(0, 1,	$trans['tran_date'], true);
			// $rep->TextCol(0, 1, $systypes_array[$trans['type']]);
			$rep->TextCol(1, 2,	$trans['reference']);
			 
              

                   if($trans['type'] == ST_SUPPINVOICE)
                   {
							$sup_res = get_supp_invoice_items(ST_SUPPINVOICE, $trans['trans_no']);
						    while($supp_row=db_fetch($sup_res)){

								if($supp_row['grn_item_id'] != -1){
								$grn_item_id = $supp_row['grn_item_id'];
								$supp_data=$supp_row;
								// break;
						    // print_r(  $supp_row);exit();
								}
								if($supp_row['gl_code']==5685)
									$kam_amt=abs($supp_row['unit_price']);
								// echo "<pre>";
						    } 
						  //   display_error($kam_amt);
                          // exit();
								
							// $grn_item_id = $supp_row['grn_item_id'];
								

							$grn_item_row=get_grn_items_data($grn_item_id);
							$grn_batch_row =  get_grn_batch_data($grn_item_row['grn_batch_id']);

							if ($destination)
                       		$rep->TextCol(2, 3,	$supp_data['description']);
							else{

							$oldrow = $rep->row;
							$rep->TextColLines(2, 3,	$supp_data['description']);
							$newrow = $rep->row;
							$rep->row = $oldrow;
							}	

                       		$rep->TextCol(3, 4,	$grn_batch_row['vehicle_no']);
                       	    $rep->TextCol(4, 5,	$grn_batch_row['no_bags']);

                       	     $rep->AmountCol(5, 6,	$supp_data['quantity'], $dec);
                       	     $kat_wt=$kam_amt/$supp_data['unit_price'];
                       	      $rep->AmountCol(6, 7,	$kat_wt, $dec);
                       	      $rep->AmountCol(7, 8,	$supp_data['quantity']-$kat_wt, $dec);
                               
                       	         $rep->TextCol(8, 9,	$grn_item_row['batch_no'], $dec);
                       	         $rep->AmountCol(9, 10,	$supp_data['unit_price'], $dec);

                       	         $bag_sum+=	$grn_batch_row['no_bags'];
                       	         $gross_sum+=$supp_data['quantity'];
                       	         $net_sum+=$supp_data['quantity']-$kat_wt;



                   }else{


                     // if($trans['type'] == ST_JOURNAL)
                   	 $cheque_no='';
                        if ($trans['type'] == ST_SUPPAYMENT || $trans['type'] == ST_BANKDEPOSIT || $trans['type'] == ST_BANKPAYMENT) {
             	// $trans['type'] == ST_BANKPAYMENT;

		             $bank_row = get_bank_trans_date($trans['type'],$trans['trans_no']) ;
		             // $rep->TextCol(2, 3, ($bank_row['cheque_no']) ?  "   ".$bank_row['cheque_no'] : '  -' , true);
                   		   $cheque_no=($bank_row['cheque_no']) ?  "   ".$bank_row['cheque_no'] : '  -';
		             }
                   $gl_res = get_line_wise_journal_entry($trans['trans_no'], $trans['type'], 3, $myrow['supplier_id']);
                   $gl_row = db_fetch($gl_res);

                           if ($destination)
                       		$rep->TextCol(2, 3, $gl_row['memo_']." ".   $cheque_no);
							else{
                   			$oldrow = $rep->row;
                   			$rep->TextColLines(2, 3,	$gl_row['memo_']." ".   $cheque_no);
							$newrow = $rep->row;
							$rep->row = $oldrow;
                        }
                 }









			// if ($trans['type'] == ST_SUPPINVOICE)
			// 	$rep->DateCol(4, 5,	$trans['due_date'], true);
			$item[0] = $item[1] = 0.0;
			if($trans['rate'])
			$rate=$trans['rate'];	
			if ($trans['TotalAmount'] < 0.0)
			{
				$item[0] = round2(abs($trans['TotalAmount']) * $rate, $dec);
				$rep->AmountCol(10, 11, $item[0], $dec);
				$accumulate += $item[0];
				// $item[2] = round2($trans['Allocated'] * $rate, $dec);
			}
			else
			{
				$item[1] = round2(abs($trans['TotalAmount']) * $rate, $dec);
				$rep->AmountCol(11, 12, $item[1], $dec);
				$accumulate -= $item[1];
				// $item[2] = round2($trans['Allocated'] * $rate, $dec) * -1;
			}

	
			// $rep->AmountCol(7, 8, $item[2], $dec);
			// if ($trans['TotalAmount'] > 0.0)
			// 	$item[3] = $item[0] - $item[2];
			// else	
			// 	$item[3] = -$item[1] - $item[2];


			if ($show_balance)	
				$rep->AmountCol(12, 13, $accumulate, $dec);
			else	
				$rep->AmountCol(12, 13, $item[3], $dec);
			for ($i = 0; $i < 3; $i++)
			{
				$total[$i] += $item[$i];
				$grandtotal[$i] += $item[$i];
			}

			// if ($show_balance)
				$total[2] = $total[0] - $total[1];
		
           
            // $memo = get_comments_string($trans['type'], $trans['trans_no']);
		   

			// 	$oldrow = $rep->row;
			// 	$rep->TextColLines(9, 10,($memo) ?"  ".$memo :'-', -2);
			// 	$newrow = $rep->row;
			// 	$rep->row = $oldrow;
				// if($newrow)
				if ($destination)
                 $rep->NewLine();
				else
				$rep->row = $newrow;

				if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
				{
					$rep->Line($rep->row - 2);
					$rep->NewPage();
				}
			    // else
				// $rep->NewLine();



		}
		$rep->Line($rep->row -14);
		$rep->NewLine(2);
		$rep->TextCol(0, 3,	_('Total'));
				 $rep->AmountCol(4, 5, $bag_sum, 2);
			  $rep->AmountCol(5, 6, $gross_sum, 2);
			   $rep->AmountCol(7, 8, $net_sum, 2);

		for ($i = 0; $i < 3; $i++)
		{
			$rep->AmountCol($i + 10, $i + 11, $total[$i], $dec);
			$total[$i] = 0.0;
		}
    	$rep->Line($rep->row  - 4);
    	$rep->NewLine(2);
	}
	$rep->fontSize += 2;
	$rep->TextCol(0, 3,	_('Grand Total'));
	$rep->fontSize -= 2;
	if ($show_balance)
		$grandtotal[2] = $grandtotal[0] - $grandtotal[1];
	for ($i = 0; $i < 3; $i++)
		$rep->AmountCol($i + 10, $i + 11,$grandtotal[$i], $dec);
	$rep->Line($rep->row  - 4);
	$rep->NewLine();
    $rep->End();
}

