<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_PRINT_PURCH_ORDER';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Outstanding Delivery Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//----------------------------------------------------------------------------------------------------

print_outstanding_delivery();

function getTransactions($from, $to, $fromsupp)
{
	// display_error($from);

	$fromdate = date2sql($from);
	$todate = date2sql($to);

	$sql = "SELECT * FROM ".TB_PREF."purch_orders as po, ".TB_PREF."purch_order_details as pod WHERE po.order_no=pod.order_no ";  //AND pod.quantity_received-pod.qty_invoiced!=0

	// $sql .= " AND grn.delivery_date >=".db_escape($fromdate)." AND grn.delivery_date<=".db_escape($todate);
	if ($fromsupp != ALL_TEXT)
		$sql .= " AND po.supplier_id =".db_escape($fromsupp);

	$sql .= " ORDER BY po.order_no";
	// display_error($sql);
    return db_query($sql, "No transactions were returned");
}

//----------------------------------------------------------------------------------------------------

function print_outstanding_delivery()
{
    global $path_to_root;

    $from = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
    $fromsupp = $_POST['PARAM_2'];
    $comments = $_POST['PARAM_3'];
	$orientation = $_POST['PARAM_4'];
	$destination = $_POST['PARAM_5'];
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	if ($fromsupp == ALL_TEXT)
		$from_ = _('All');
	else
		$from_ = get_customer_name($fromsupp);
    $dec = user_price_dec();

	$cols = array(0, 40,90, 160,200 , 250,290, 320,350, 390, 445, 505, 560);

	$headers = array(_('Order No.'),_('Reference'), _('Item') . '/' . _('Description'), _('PO Qty') , _('Qty Recd'), _('Ord Truck'), _('Recd Truck'), _('Bal Qty'), _('PO Cost'),
		_('PO Value'), _('GRN Value'), _('Status'));

	$aligns = array('left',	'left',	'left',	'left',	'left',	'left',	'left',	'right', 'right', 'right', 'right', 'right', 'right');

    $params =   array( 	0 => $comments,
    				    1 => array('text' => _('Supplier'), 'from_' => $from_, 'to' => ''));

    $rep = new FrontReport(_('Pending Souda Report'), "PO", user_pagesize(), 7, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

	$po_sum=$rec_sum=$bal_sum=$price_sum=$Tot_Val=0;
 	$res = getTransactions($from, $to, $fromsupp);
    $supplier_id = '';
	while ($Dev = db_fetch($res))
	{

	  if($supplier_id!=$Dev['supplier_id'])
      {
        
			$rep->Font('bold');
			$rep->TextCol(0, 2, get_supplier_name($Dev['supplier_id']) ) ;
			$supplier_id = $Dev['supplier_id'];
			$rep->Font();
			$rep->NewLine();
      }	

		$dec2 = get_qty_dec($Dev['item_code']);
		$rep->NewLine();
		$rep->TextCol(0, 1, $Dev['order_no']);
		$rep->TextCol(1, 2, $Dev['reference']);

		$oldrow = $rep->row;
		$rep->TextColLines(2, 3, $Dev['stock_id'] . '-' . $Dev['description']);
		$newrow = $rep->row;
		$rep->row = $oldrow;
		
		$rep->AmountCol(3, 4, $Dev['quantity_ordered'], $dec2);
		$rep->AmountCol(4, 5, $Dev['quantity_received'], $dec2);
		   $po_gen_res=get_po_grns( $Dev['order_no']);
		$rep->TextCol(5, 6, ($Dev['no_of_truck'])?$Dev['no_of_truck']:'-', $dec2);
		$rep->AmountCol(6, 7, db_num_rows($po_gen_res), $dec2);
			$rep->AmountCol(7, 8, $Dev['quantity_ordered']-$Dev['quantity_received'], $dec2);
		$rep->AmountCol(8, 9, $Dev['unit_price'] ,$dec2);
		$Value = $Dev['quantity_ordered'] *$Dev['unit_price']; //($Dev['quantity_received'] - $Dev['qty_invoiced']) * $Dev['unit_price'];
		$Value2 =  $Dev['quantity_received'] *$Dev['unit_price'];  //($Dev['quantity_received'] - $Dev['qty_invoiced']) * $Dev['act_price'];
		$rep->AmountCol(9, 10, $Value, $dec);
		$rep->AmountCol(10, 11, $Value2, $dec);

		if($Dev['is_close'] == 0 && ($Dev['quantity_ordered']>$Dev['quantity_received']) )
			$rep->TextCol(11, 12, _("Pending"));
		elseif($Dev['is_close'] == 1)
			$rep->TextCol(11, 12, _("Closed"));
		// elseif($Dev['is_close'])
		// 	$rep->TextCol(10, 11, _("Cancel"), $dec);
		elseif($Dev['quantity_received'] == $Dev['quantity_ordered'])
			$rep->TextCol(11, 12, _("Complete Arrival"));
		

		


		$po_sum += $Dev['quantity_ordered'];
		$rec_sum += $Dev['quantity_received'];
		$bal_sum += $Dev['quantity_ordered']-$Dev['quantity_received'];
		$price_sum += $Dev['unit_price'];

		$Tot_Val += $Value;
		$Tot_Val2 += $Value2;
		$rep->row = $newrow;

		$rep->NewLine(0, 1);
	}

	$rep->NewLine(2);
	$rep->TextCol(0, 5, _('Total'));

	$rep->AmountCol(3, 4, $po_sum, $dec);
	$rep->AmountCol(4, 5, $rec_sum, $dec);
	$rep->AmountCol(7, 8, $bal_sum, $dec);

	$rep->AmountCol(8, 9, $Tot_Val, $dec);
	$rep->AmountCol(9, 10, $Tot_Val2, $dec);

	$rep->NewLine();
	$rep->Font('bold');
	$rep->TextCol(0, 5, _('Avarage Cost'));
	$rep->AmountCol(2, 6, $Tot_Val/$po_sum,$dec);
	$rep->Font();
	$rep->Line($rep->row - 2);
    $rep->End();
}

