<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_CLOSING_STOCK_SUMMARY';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Sales Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//------------------------------------------------------------------


print_sales_summary_report();

function getAllItem($stock_id, $itm_group=0, $category_id=-1){

	$sql = " SELECT * FROM ".TB_PREF."stock_master WHERE stock_id!='' ";
	if ($stock_id != '')
	$sql .= " AND  stock_id =".db_escape($stock_id);
    if($itm_group!=0)
	$sql .= " AND item_group_id =".db_escape($itm_group);
    if($category_id!=-1)
	$sql .= " AND category_id =".db_escape($category_id);

	// display_error($sql);
	$result = db_query($sql);
	return $result;
}

function get_location_header($multi_location='')
{
    $multi_location_arr=array();
	foreach ($multi_location as $key => $value) 
	$multi_location_arr[] = db_escape($value);
	$multi_location = implode(', ', $multi_location_arr);  //

	$sql = " SELECT * FROM ".TB_PREF."locations WHERE loc_code IN (".$multi_location.") ";

	// display_error($sql);
	$result = db_query($sql);
	return $result;
	// $row = db_fetch_row($result);
	// return is_array($row) ? $row[0] : false;
}

function get_items_name($stock_id)
{
	$sql = "SELECT description FROM ".TB_PREF."stock_master WHERE stock_id=".db_escape($stock_id);
	// display_error($sql);
	$result = db_query($sql);
	$row = db_fetch_row($result);
	return is_array($row) ? $row[0] : false;
}

//----------------------------------------------------------------------------------------------------

function print_sales_summary_report()
{
	global $path_to_root;
	
	// $orientation = $_POST['PARAM_0'];
	// $destination = $_POST['PARAM_1'];
	// $stock_id = $_POST['PARAM_2'];
	// $itm_group = $_POST['PARAM_3'];


	$end_date = $_POST['PARAM_0'];
	$stock_id = $_POST['PARAM_1'];
	$category_id = $_POST['PARAM_2'];
	$itm_group = $_POST['PARAM_3'];
	$multi_location = $_POST['PARAM_4'];
   	$no_zeros = $_POST['PARAM_5'];
	$orientation = $_POST['PARAM_6'];
	$destination = $_POST['PARAM_7'];
	
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');

	if ($itm_group == 0)
		$itm_group_new = _('All');
	else
		$itm_group_new = get_item_group_name($itm_group);

	if ($stock_id == '') 
	 	$stock_id_new = _('All');
    else
	 	$stock_id_new = get_items_name($stock_id);

	$multi_location_arr=array();
 	if (!is_array($multi_location)) 
	  	$multi_location_name = _('All');
 	else{
		foreach ($multi_location as $key => $value) 
		$multi_location_arr[] = get_item_location($value)['location_name'];
		$multi_location_name = implode(', ', $multi_location_arr); 
 	}

	$category_name = get_item_category($category_id);
	if ($category_id == -1) 
	    $category_id_new = _('All');
	else
	 	$category_id_new = $category_name['description'];


	if ($no_zeros) $nozeros = _('Yes');
	else $nozeros = _('No');
 	// display_error($multi_location_name.'=='.$multi_location);
	
	// if ($sales_type == 0) 
	// 	$type = _('All');
	// else
	// 	$type = get_sales_type_name($sales_type);

	 $dec = user_price_dec();

	

	$rep = new FrontReport(_('Closing Stock Summary Report'), "SalesReport", user_pagesize(), 9, $orientation);

	$params =   array( 	0 => $comments,
						1 => array( 'text' => _('Date'),'from' => $end_date,'to' => ''),
						2 => array( 'text' => _('Item Stock'),'from' => $stock_id_new,'to' => ''),
						3 => array( 'text' => _('Item group'),'from' => $itm_group_new,'to' => ''),
						4 => array( 'text' => _('Category'),'from' => $category_id_new,'to' => ''),
						5 => array( 'text' => _('Location'),'from' => $multi_location_name,'to' => ''),
			 			6 => array('text' => _('Suppress Zeros'), 'from' => $nozeros, 'to' => '')
						// 2 => array( 'text' => _('Customer Id'),'from' => $cust,'to' => ''),
						// 4 => array( 'text' => _('Sales Person'),'from' => $sale_Prsn,'to' => ''),
						// 6 => array( 'text' => _('Items Group'),'from' => $item_group,'to' => ''),
						// 7 => array( 'text' => _('Sales Type'),'from' => $type,'to' => '')
					);
						// 2 => array( 'text' => _('Tax Id Only'),'from' => $tid,'to' => ''),
						// 4 => array( 'text' => _('Branch Id'),'branch_id' => $branch_id,'to' => ''),

		$cols = array(0, 100, 350, 400, 500, 560); //, 680

	// $headers = array(_('Item Name'), _('Packing Flor'), _('FGS Karachi'), _('FGS Factory'), _('FGS Lahore'), _('FGS HYD'), _('Total'));
	// $loc_array = array("'PFLR2'", "'FGKAR'", "'FGHUB'", "'FGLHR'", "'FGHYD'" ); 

	
	$headers = array(_('Item Name.'), _(''), _(''), _('QOH'), _(''));
	// $data = get_location_header($loc_array);
	// $headers= array();
	//  $headers[] = _('Item Name');
	//  while($row=db_fetch($data))
	//  {
    //  $headers[]=$row['location_name'];
	//  }
	 	 // $headers[] = _('Total');
	$aligns = array('left', 'left', 'left' , 'left', 'left');
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();
	
	$result = getAllItem($stock_id, $itm_group, $category_id);
	$total_line_qoh=array();
	while ($trans=db_fetch($result))
	{

				$c=0;
                
                	// $rep->NewLine();
				$qoh=0;
				$line_qoh = 0;
				$none=0;
				$all_locations = get_location_header($multi_location);
				$loc_data=array();
				while ($loc_row = db_fetch($all_locations)) {
					$qoh = get_qoh_on_date($trans['stock_id'], $loc_row['loc_code'], $end_date);
					if($qoh)
				     $none=1;
                $loc_data[$loc_row['loc_code']]=round($qoh,get_qty_dec($trans['stock_id']));
				$line_qoh += $qoh;
              // display_error($trans['stock_id']."  ".$loc_row['loc_code']."  ".$loc_data[$loc_row['loc_code']]."  == ".$qoh."  ".$end_date);
				$total_line_qoh[$loc_row['loc_code']]+= $qoh;
				}
				if ($none==0 && $no_zeros ==  1) continue;

				$oldrow = $rep->row;
				$rep->Font('bold');
				$rep->TextCol(0, 4, $trans['stock_id']." - ".$trans['description']);
				// $rep->TextColLines($c++, $c, $trans['stock_id']." - ".$trans['description'], -2);
				$rep->Font();
				$newrow = $rep->row;
				$rep->row = $oldrow;

				foreach ($loc_data as $key_loc_name => $qoh) {
					if($qoh)
					{
						$rep->NewLine();
						$rep->TextCol(0, 1, "  ".$key_loc_name);
						$rep->AmountCol(3, 4, $qoh, get_qty_dec($trans['stock_id']));

					    // $none=1;
					}
				}
				unset($loc_data);

				if($none==0)
				{
					$rep->SetTextColor(255, 0, 0);
					$rep->NewLine();
					$rep->TextCol(0, 1,"  Not Available All location" );
					$rep->NewLine();
					$rep->SetTextColor(0, 0, 0);

				}else
				{
				$rep->Font('bold');
				$rep->NewLine();
				$rep->TextCol(0, 1,	_("Total"));
				$rep->AmountCol(3, 4, $line_qoh, $dec);
				$rep->NewLine();
				$rep->Font();
					
				}


//-------------------------------------------------------------------------------------------------------------------------------------------
				
	if ($rep->row < $rep->bottomMargin + $rep->lineHeight+50)
	{
		$rep->Line($rep->row - 2);
		$rep->NewPage();
	}
		
	// $total_line_qoh += $line_qoh;
	// $fohcost += $data['amount'];
	// display_error($amt_total);
	// $new_total1 += $total;
	}

	$rep->Font('bold');
	$rep->NewLine();
	$rep->Line($rep->row+5);
	// $rep->TextCol(0, 1,	_("Total"));
	$data = get_location_header($multi_location);
	$c=1;
	$rep->NewLine();
	while ($loc_row = db_fetch($data)) {
		$rep->NewLine();
		$rep->TextCol(0, 1, $loc_row['location_name']);
	    $rep->AmountCol(3, 4, $total_line_qoh[$loc_row['loc_code']], $dec);
	}
   	// $rep->AmountCol($c++, $c, $loc_sum['total'], $dec);
	$rep->Line($rep->row - 5);
	$rep->Font();
	$rep->End();
}

