<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_WASTAGE_REPORT';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Sales Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//------------------------------------------------------------------


print_sales_summary_report();

function getTaxTransactions($from, $to, $stock_id, $order_num, $batch_no , $item_group){
	$fromdate = date2sql($from);
	$todate = date2sql($to);

	$sql = " SELECT wo.*, sm.*, stm.* FROM ".TB_PREF."workorders as wo, ".TB_PREF."stock_moves as sm, ".TB_PREF."stock_master as stm, ".TB_PREF."wo_manufacture as wom WHERE wom.workorder_id=wo.id AND wom.id=sm.trans_no AND sm.type=29  AND stm.stock_id=sm.stock_id";
			 $sql .= " AND wo.date_ >=".db_escape($fromdate)." AND wo.date_<=".db_escape($todate);
			 if ($stock_id != '')
			 $sql .= " AND sm.stock_id =".db_escape($stock_id);
			if ($order_num != '')
			 $sql .= " AND wo.id =".db_escape($order_num);
			if ($batch_no != '')
			 $sql .= " AND sm.batch_no =".db_escape($batch_no);
			if ($item_group != '')
			 $sql .= " AND stm.item_group_id =".db_escape($item_group);
			 // display_error($sql);
			 $result = db_query($sql);
			 return $result;

}

function wstg_qty_cost($order_num, $stock_id)
{
	$sql = " SELECT wii.qty_issued, wii.unit_cost FROM ".TB_PREF."wo_issue_items as wii, ".TB_PREF."wo_issues as wi WHERE wi.issue_no=wii.issue_id AND wi.workorder_id=".db_escape($order_num) . " AND wii.qty_issued!=0";
	$sql .= " ANd wii.stock_id=".db_escape($stock_id);
	// display_error($sql);
	$result = db_query($sql);
	return db_fetch($result);
	// return db_query($sql);
}


	
 function fohcost($order_num, $cost_type)
{
	$sql = " SELECT wo.*, woc.*, jo.* FROM ".TB_PREF."workorders as wo, ".TB_PREF."wo_costing as woc, ".TB_PREF."journal as jo WHERE wo.id=woc.workorder_id
	 AND woc.trans_no=jo.trans_no AND woc.cost_type =".db_escape($cost_type);
	 $result = db_query($sql);
	return db_fetch($result);
	
}
function get_items_name($stock_id)
{
	$sql = "SELECT description FROM ".TB_PREF."stock_master WHERE stock_id=".db_escape($stock_id);
	// display_error($sql);
	$result = db_query($sql);
	$row = db_fetch_row($result);
	return is_array($row) ? $row[0] : false;
}



//----------------------------------------------------------------------------------------------------

function print_sales_summary_report()
{
	global $path_to_root;
	
	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$stock_id = $_POST['PARAM_2'];
	$order_num = $_POST['PARAM_3'];
	$batch_no = $_POST['PARAM_4'];
	$item_group = $_POST['PARAM_5'];
	$orientation = $_POST['PARAM_6'];
	$destination = $_POST['PARAM_7'];

	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');

	// if ($customer_id == ALL_TEXT)
	// 	$cust = _('All');
	// else
	// 	$cust = get_customer_name($customer_id);
	// $dec = user_price_dec();

	// if ($broker == -1) 
	// 	$sale_Prsn = _('All');
	// else
	// 	$sale_Prsn = get_sales_group_name($broker);

	if ($item_group == 0)
		$itm_group = _('All');
	else
		$itm_group = get_item_group_name($item_group);

	// if ($item_group_id == 0) 
	//  	$item_group = _('All');
	//  else
	//  	$item_group = get_item_group_name($item_group_id);
	
	// if ($sales_type == 0) 
	// 	$type = _('All');
	// else
	// 	$type = get_sales_type_name($sales_type);

	

	$rep = new FrontReport(_('Wastage Report'), "SalesReport", user_pagesize(), 9, $orientation);

	$params =   array( 	0 => $comments,
						1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
						2 => array( 'text' => _('Item Stock'),'from' => $stock_id,'to' => ''),
						3 => array( 'text' => _('Item group'),'from' => $itm_group,'to' => ''),
						// 2 => array( 'text' => _('Customer Id'),'from' => $cust,'to' => ''),
						// 4 => array( 'text' => _('Sales Person'),'from' => $sale_Prsn,'to' => ''),
						// 6 => array( 'text' => _('Items Group'),'from' => $item_group,'to' => ''),
						// 7 => array( 'text' => _('Sales Type'),'from' => $type,'to' => '')
					);
						// 2 => array( 'text' => _('Tax Id Only'),'from' => $tid,'to' => ''),
						// 4 => array( 'text' => _('Branch Id'),'branch_id' => $branch_id,'to' => ''),

	$cols = array(0, 30, 120, 200, 240, 300, 390, 470, 520); // , 600, 650, 660

	$headers = array(_('W-O #'), _('Batch #'), _('item Name'), _('Item Group'), _('Qty Used'), _('Standard Wastage'), _('Actual Wastage'), _('Variance'), _('Remarks'));
	$aligns = array('left', 'left', 'left', 'left', 'center', 'left', 'left', 'left', 'left');
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();
	
	$totalnet = 0.0;
	$transactions = getTaxTransactions($from, $to, $stock_id, $order_num, $batch_no, $item_group);


	$rep->NewLine(2);

	$order_num = '';
	while ($trans=db_fetch($transactions))
	{
		// display_error($trans['stock_id']);
		if ($order_num != $trans['id'])
		{
				$rep->Line($rep->row - 2);
				$rep->NewLine(2, 3);
				$rep->TextCol(0, 1, $trans['id']);
				$rep->TextCol(1, 2, $trans['id']);
				$order_num = $trans['id'];
				$rep->NewLine();
		}
		global $SysPrefs;
				$rep->TextCol(0, 1, $trans['id']);
				$rep->TextCol(1, 2, $trans['batch_no']);
				$oldrow = $rep->row;
				$rep->TextColLines(2, 3, get_items_name($trans['stock_id']), -2);
				$newrow = $rep->row;
				$rep->row = $oldrow;
				$row  = wstg_qty_cost($trans['id'], $trans['stock_id']);
				$rep->TextCol(3, 4,	get_item_group_name($trans['item_group_id']));
				// $material_cost = $trans['price'] * $trans['qty'];
				// $rep->TextCol(4, 5,	$material_cost);
				// $wastage_cost = $row['qty_issued']*$row['unit_cost'];
				// $rep->TextCol(5, 6, $row['qty_issued']);
				// $rep->TextCol(6, 7, $wastage_cost);
				// $tot_mtr = $trans['qty'] + $row['qty_issued'];
				// $rep->TextCol(7, 8, $tot_mtr);
				// $rep->TextCol(8, 9, $trans['loc_code']);
				// $data1 = fohcost($trans['id'] , 0);
				// $rep->TextCol(9, 10, $trans['date_']);
				// $data = fohcost($trans['id'] , 1);
				// $rep->TextCol(10, 11, $data['amount']);
				// $total = $row['qty_issued'] * $row['unit_cost'];
				// $total = $material_cost * $wastage_cost;
				// $rep->AmountCol(10, 11, $total, $dec);
				$rep->TextCol(11, 12, '');
				$rep->row = $newrow;

				
//-------------------------------------------------------------------------------------------------------------------------------------------
				
				$rep->NewLine();

				if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
				{
					$rep->Line($rep->row - 2);
					$rep->NewPage();
				}
		
	$labourcost += $data1['amount'];
	$fohcost += $data['amount'];
	// display_error($amt_total);
	$new_total1 += $total;
	}

	$rep->Font('bold');
	$rep->NewLine();
	$rep->Line($rep->row + $rep->lineHeight);
	$rep->TextCol(0, 2,	_("Total"));
	// $rep->AmountCol(8, 9, $labourcost, $dec);
	// $rep->AmountCol(9, 10, $fohcost, $dec);
	$rep->AmountCol(10, 11, $new_total1, $dec);
	$rep->Line($rep->row - 5);
	$rep->Font();
	$rep->End();
}

