<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_JOURNALENTRY';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Sales Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");

//------------------------------------------------------------------
print_sales_summary_report();

function get_work_order_rep($from='', $to='')
{
	$fromdate = date2sql($from);
	$todate = date2sql($to);
	$sql = "SELECT * FROM ".TB_PREF."workorders ";
	$sql .= " WHERE date_ >=".db_escape($fromdate)." AND date_<=".db_escape($todate);
	return db_query($sql,"could not get group");
}
//----------------------------------------------------------------------------------------------------

function print_sales_summary_report()
{
	global $path_to_root;
	
	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$orientation = $_POST['PARAM_2'];
	$destination = $_POST['PARAM_3'];

	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');
		$orientation = 'L';

	$dec = user_price_dec();
	$rep = new FrontReport(_('Production Costing Report'), "ProductionReport", user_pagesize(), 9, $orientation);

	$params =   array( 	0 => $comments,
						1 => array('text' => _('Period'), 'from' => $from, 'to' => $to),
						2 => array( 'text' => _('Item Stock'),'from' => $stock_id,'to' => ''));

	// $cols = array(0, 30, 100, 200, 230, 280, 320, 360, 400, 450 , 500, 570, 600);
	$cols = array(4, 120, 230, 350, 420, 480, 515);

	$headers = array(_('W-O #'), _('Batch #'), _('item Name'), _("Qty"), _('Date'), 
		_('Unit Cost'));
	$aligns = array('left', 'left', 'left', 'left', 'left');
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();
	
	$transactions = get_work_order_rep($from, $to);
	while ($wo = db_fetch($transactions)) {
	// for ($i = $from; $i <= $to; $i++)
	// {
		$total_qty = 0;
	    $total_unit_cost = 0;
	    $total_cost = 0;

		$rep->NewLine(1.7);
		$rep->TextCol(0, 1,	$wo['id']);
		$rep->TextCol(1, 2,	$wo['batch_no']);
		$item_name = get_item($wo['stock_id']);
		$rep->TextCol(2, 3,	$item_name['description']);
		$rep->TextCol(3, 4,	$wo['units_reqd']);
		$rep->TextCol(4, 5,	sql2date($wo['date_']));
		$batch_price= get_betch_price($wo['batch_no'], $wo["stock_id"]);
		$old_cost = get_unit_cost($wo["stock_id"]);
		$rep->TextCol(5, 7,	round($old_cost, 4));

		$total_qty += $wo["units_reqd"];
		$total_unit_cost += $old_cost;
		$total_cost += $old_cost*$wo["units_reqd"];

	 	$result = get_work_order_issues($wo['id']);
	 	if(db_num_rows($result))
		{
			$rep->NewLine(2);
			$rep->Font('B');
		 	$rep->Line($rep->row-3);
			$rep->TextCol(0, 1,_("Matrial Cost"), -2);
			$rep->NewLine();
		 	$rep->Line($rep->row-3);
			$rep->TextCol(0, 1, "Component");
			$rep->TextCol(1, 2, "Quantity");
			$rep->TextCol(2, 3, "Units");
			$rep->TextCol(3, 4, "Unit Cost");
			$rep->TextCol(4, 5, "Total");
			$rep->TextCol(5, 6, "Status");
			$rep->Font();
			$rep->NewLine();                	
		}	

	 	while ($data = db_fetch($result)) {
         $res = get_work_order_issue_details($data['issue_no']);
	     while ($myrow2=db_fetch($res)) {

				$item_name = get_item($myrow2['stock_id']);
				$rep->TextCol(0, 1,	$myrow2['stock_id'] .' - '. $item_name['description'], -2);
				$rep->TextCol(1, 2, $myrow2["qty_issued"], -2);
				$rep->TextCol(2, 3, $myrow2["units"], -2);
				$rep->AmountCol(3, 4, $myrow2["unit_cost"], -2);
				$rep->TextCol(4, 5, $myrow2["unit_cost"]*$myrow2["qty_issued"], -2);
				if($myrow2["qty_issued"] < 0)
				$rep->TextCol(5, 7, _("BY-PRODUCT"), -2);
				if($myrow2["qty_issued"] > 0)
				$rep->TextCol(5, 7, _("RAW-PRODUCT"), -2);
				$rep->NewLine();                	

				$total_qty += $myrow2["qty_issued"];
				$total_unit_cost += $myrow2["unit_cost"];
				$total_cost += $myrow2["unit_cost"]*$myrow2["qty_issued"];

            }

				if ($rep->row < $rep->bottomMargin + 5)
				$rep->NewPage();

	 	}
		$result2 = get_wo_costing($wo['id']);
		if(db_num_rows($result2))
		{
			$rep->NewLine();
			$rep->Font('B');
		 	$rep->Line($rep->row-3);
			$rep->TextCol(0, 1,_("Additional Costs"), -2);
			$rep->NewLine();
		 	$rep->Line($rep->row-3);
			$rep->TextCol(0, 1, "Type");
			$rep->TextCol(1, 2, "Date");
			$rep->TextCol(2, 3, "Amount");
			$rep->Font();
			$rep->NewLine();                     	
		}	

		while ($row = db_fetch($result2))
        {
          global $wo_cost_types;
		  $rep->TextCol(0, 1, $wo_cost_types[$row['cost_type']], -2);
  		  $rep->TextCol(1, 2, sql2date($row["tran_date"]), -2);
		  $rep->AmountCol(4, 5, $row['amount'], -2);
		  $rep->NewLine();               
		  $total_qty += $myrow2["qty_issued"];
		  $total_unit_cost += $row["amount"];
		  $total_cost += $myrow2["unit_cost"]*$myrow2["qty_issued"];
        }

	$rep->NewLine(0.4);               
	$rep->Font('B');
	$rep->fontSize += 2;
	$rep->TextCol(0, 2,	_("Total"));
	$rep->fontSize -= 2;
	$rep->AmountCol(1, 2, $total_qty, $dec);
	$rep->AmountCol(3, 4, $total_unit_cost, $dec);
	$rep->AmountCol(4, 5, $total_cost, $dec);
	$rep->TextCol(5, 7, _("Unit Cost ( ") .  round($total_cost/$total_qty, $dec). " ) ", $dec);
	$rep->Font();
	$rep->Line($rep->row-4, 1);
	}
	$rep->End();

}