<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CUSTPAYMREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Sales Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/customers_db.inc");

//------------------------------------------------------------------


print_sales_summary_report();

function get_balance_item_wise($from='', $to='', $fromcust='')
{
	$from = date2sql($from);
	$to = date2sql($to);

	$sql = " SELECT *
	FROM ".TB_PREF."debtor_trans AS trans
	LEFT JOIN ".TB_PREF."debtor_trans_details AS dtd
	ON trans.trans_no = dtd.debtor_trans_no AND trans.type = dtd.debtor_trans_type
	WHERE (trans.type = 10 OR trans.type = 12 OR trans.type = 13)
	AND trans.ov_amount != 0
	AND (trans.tran_date >= '$from' AND trans.tran_date <= '$to')";

	if($fromcust != '')
		$sql .= " AND trans.debtor_no=".db_escape($fromcust);

	$sql.=" ORDER BY trans.tran_date";
	// display_error($sql);
	return db_query($sql, "could not get customer");
}

//----------------------------------------------------------------------------------------------------

function print_sales_summary_report()
{
	global $path_to_root, $systypes_array;
	
	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$fromcust = $_POST['PARAM_2'];
	$show_balance = $_POST['PARAM_3'];
	$currency = $_POST['PARAM_4'];
	$no_zeros = $_POST['PARAM_5'];
	$comments = $_POST['PARAM_6'];
	$orientation = 1;
	$destination = $_POST['PARAM_8'];

	if($fromcust == ''){
		display_error('Must Be Select Customer');
		exit();
	}

	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');

	if ($fromcust == ALL_TEXT)
		$cust = _('All');
	else
		$cust = get_customer_name($fromcust);
	
	$rep = new FrontReport(_('Total Balances Item Wise'), "CustomerBalances", user_pagesize(), 9, $orientation);

	$params =   array( 	0 => $comments,
						1 => array('text' => _('Customer'), 'from' => $cust,   	'to' => ''));
						// 2 => array( 'text' => _('Tax Id Only'),'from' => $tid,'to' => ''),
						// 4 => array( 'text' => _('Branch Id'),'branch_id' => $branch_id,'to' => ''),

	$cols = array(4, 30, 80, 130, 210, 260, 310, 350, 390, 435, 475, 520, 550);

	$headers = array(_("S.#"), _("Date"), _("Mode"), _('Particular'), _('B/V. #'), 
		_('Truck #'), _("Bags"), _("Rate"), _("Weight"), _("Debit"), _("Credit"), _("Balance"));
	$aligns = array('left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left', 'left'); //, _("Type") 
    if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();
	
	$transactions = get_balance_item_wise($from, $to, $fromcust);
	$sno = 1;
	$newrow=array();
	while ($trans=db_fetch($transactions))
	{	
			$rep->TextCol(0, 1, $sno++);
			$rep->TextCol(1, 2,	sql2date($trans['tran_date']), -2);	
			$rep->TextCol(2, 3,	$trans['mode'] ? $trans['mode'] : '-', -2);	
			$oldrow2 = $rep->row;
			$rep->TextColLines(3, 4, get_customer_name($trans['debtor_no']));
			$newrow[] = $rep->row;
			$rep->row = $oldrow2;
			$rep->TextCol(4, 5, $trans['reference']);
			$rep->TextCol(5, 6, $trans['vehicle_no'] ? $trans['vehicle_no'] : '-');
			$rep->TextCol(6, 7, $trans['bags'] ? $trans['bags'] : '-');
			$rep->TextCol(7, 8, number_format2($trans['unit_price']));
			$rep->TextCol(8, 9, number_format2($trans['quantity']));


			if($trans['type'] == 10){
				$credit =  $trans['quantity']*$trans['unit_price'];
				$debit = 0;	
				$balance = $credit; 
			}elseif ( $trans['type'] == 0) {
				if($trans['ov_amount'] > 0.0)
				{  
					$debit = $trans['ov_amount']+$trans['ov_gst'];
					$credit = 0;
					$balance = $debit; 					
				}
				else{
					$debit = 0;	
					$credit = $trans['ov_amount']+$trans['ov_gst'];
					$balance = $credit; 
				}	
			}
			elseif ($trans['type'] == 12 ) {
			 
					$debit = $trans['ov_amount']+$trans['ov_gst'];
					$credit = 0;
					$balance = -$debit; 					
			}	
			else{
				$debit = $trans['quantity']*$trans['unit_price'];
				$credit = 0;
				$balance = $debit; 
			}
			$show_balance += $balance;
			$rep->AmountCol(9, 10, abs($debit) );
			$rep->AmountCol(10, 11, abs($credit) );
			$rep->AmountCol(11, 12, $show_balance);
				
			$total_debit += $debit;
			$total_credit += $credit;

			$rep->row = min($newrow);
            unset($newrow);
		if ($rep->row < $rep->bottomMargin+10 )
		{
			$rep->Line($rep->row - 2);
			$rep->NewPage();
		}
	}
	$rep->Line($rep->row - 2);

	$rep->Font('bold');
	$rep->NewLine();
	$rep->fontSize += 2;
	$rep->TextCol(0, 3, _('Grand Total'));
	$rep->fontSize -= 2;
	$rep->AmountCol(9, 10, $total_debit, $dec);
	$rep->AmountCol(10, 11, $total_credit, $dec);
	$rep->AmountCol(11, 12, abs($show_balance), $dec);
	$rep->Line($rep->row - 5);
	$rep->Font();

	$rep->End();
}