<?php

$page_security = 'SA_DEPOSIT';
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/reporting/amount_words.php");

print_Deposit_report();

//pk
function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------

function print_Deposit_report()
{
	global $path_to_root, $SysPrefs, $bank_transfer_types;
	
	include_once($path_to_root . "/reporting/includes/pdf_report_payment.inc");

	$trans_id = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$paylink = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$orientation = $_POST['PARAM_6'];
	$REPORT_ID = 975;

	if (!$trans_id || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

 	
	$cols = array(4, 100, 220, 330, 430, 450);

	// $headers in doctext.inc
	$aligns = array('left',	'left',	'left', 'left', 'right');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_('Bank Deposit'), "Deposit", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);


    $result = get_bank_trans(ST_BANKDEPOSIT, $trans_id);
	if (db_num_rows($result) != 1){
		display_db_error("duplicate Deposit bank transaction found", "");
	}

	$voided = is_voided_display(ST_BANKDEPOSIT, $trans_id, _("This Deposit has been voided."));
	$myrow = db_fetch($result);
	
		// $myrow = get_customer_trans($trans_id, ST_CUSTCREDIT);
		
		$branch=null;
		$baccount=null;
		$sales_order = null;
		$contacts=null;
		if ($email == 1)
		{
			$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
			$rep->title = _('Bank Deposit');
			$rep->filename = "BankDeposit" . $myrow['ref'] . ".pdf";
		}
		$rep->currency = $cur;
		$rep->Font();
		$rep->Info($params, $cols, null, $aligns);

		$rep->SetCommonData($myrow, $branch, $sales_order, $baccount, ST_BANKDEPOSIT, $contacts);
		$rep->SetHeaderType('Header2');
		$rep->NewPage();

		
		$items = get_gl_trans(ST_BANKDEPOSIT, $trans_id);
		if (db_num_rows($items)==0){
			display_error(_("There are no items for this Deposit."));
			exit;
		}
		
		while ($item = db_fetch($items)){
			if ($item["account"] != $myrow["account_code"]){
				$rep->TextCol(0, 1, $item["account"]);
				
				$oldrow = $rep->row;
				$rep->TextColLines(1, 2, $item["account_name"]);
				$newrow[] = $rep->row;
				$rep->row = $oldrow;
				
				if($item['dimension_id'] > 0){
					$oldrow = $rep->row;
					$rep->TextColLines(2, 3, trim(get_dimension_string($item['dimension_id'], true)));
					$newrow[] = $rep->row;
					$rep->row = $oldrow;
				}
				if($item['dimension2_id'] > 0){
					$oldrow = $rep->row;
					$rep->TextColLines(3, 4, trim(get_dimension_string($item['dimension2_id'], true)));
					$newrow[] = $rep->row;
					$rep->row = $oldrow;
				}
				$rep->AmountCol(4, 5, abs($item['amount']), $dec);
				if($item['memo_'] != null){
					$rep->row = min($newrow);
					$rep->newLine(0.5);
					$rep->TextColLines(0, 6, "Memo : ". $item['memo_']);
					$rep->newLine(0.5);
					$newrow[] = $rep->row;
					$rep->row = $oldrow;

				}
				$rep->row = min($newrow);
				$rep->newLine(0.5);
				unset($newrow);
				$total_amount += abs($item["amount"]);
				if ($rep->row < $rep->bottomMargin + (15 * $rep->lineHeight-80))
					$rep->NewPage();
				else
					$rep->Line($rep->row+12);
			}
		}

		$rep->row = $rep->bottomMargin + (9 * $rep->lineHeight);
		$rep->cols[4]-= 200;
		$rep->TextCol(4, 5, _("Total Amount:")."  ".number_format2($total_amount,$dec), -2);
		$rep->newLine();
		$rep->TextColLines(4, 5, ucwords(numberTowords($total_amount)." only"));
		// $rep->AmountCol(4, 5,	$total_amount, $dec);
		$rep->cols[4]+= 200;
		
		

		$memo = get_comments_string(ST_BANKDEPOSIT, $trans_id);
		if ($memo != "")
		{
			$rep->row = $rep->bottomMargin + (13 * $rep->lineHeight);
			$rep->NewLine();
			$rep->TextColLines(1, 3, $memo, -2);
		}

		
		if ($email == 1)
		{
			$rep->End($email);
		}


	//pk
    // $res = checking_report($REPORT_ID);
    // if(db_num_rows($res) > 0){
        // $row = db_fetch($res);
        // if($row['signature2'] == '' && $row['signature3'] == ''){   
        //     $rep->TextWrap(96,47,150,"_______________"); 
        //     $rep->TextWrap(105,37,150,$row['signature1']); 
        // }
        // if($row['signature2'] != '' && $row['signature3'] == ''){
        //     $rep->TextWrap(96,47,150,"_______________"); 
        //     $rep->TextWrap(105,37,150,$row['signature1']); 

        //     $rep->TextWrap(441,47,150,"_________________"); 
        //     $rep->TextWrap(455,37,150,$row['signature2']);
        // }
        // if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
            $rep->TextWrap(96,47,150,"_______________"); 
            $rep->TextWrap(105,35,150,'Prepared By'); 

            $rep->TextWrap(260,47,150,"__________________"); 
            $rep->TextWrap(270,35,150,'Reviewed By'); 

            $rep->TextWrap(441,47,150,"_______________"); 
            $rep->TextWrap(445,35,150,'Approved By');
        // }
    // }
	if ($email == 0)
		$rep->End();
}

