<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_BILL_OF_EXCHANGE';
$path_to_root = "..";
include($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/db/bill_of_exchange_db.inc");
include_once($path_to_root . "/includes/ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
    $js .= get_js_open_window(900, 500);
if (user_use_date_picker())
    $js .= get_js_date_picker();
page(_($help_context = "Bill Of Exchange"), false, false, "", $js);
if(isset($_GET['order_no'])){
    $_POST['order_no']=$_GET['order_no'];
    hidden('order_no', $_POST['order_no']);
}
//---------------------------------------------------------------------------------------
if(isset($_POST['selected_id']))
{
    $selected_id = $_POST['selected_id'];
}
else
    $selected_id = -1;

//---------------------------------------------------------------------------------------
if (isset($_GET['AddedID']))
{
    $id = $_GET['AddedID'];

    display_notification_centered(_("The bill of exchange been added."));

    echo '<div style="margin-left: 44%;">' . viewer_link(_("View this bill of exchange"), '/sales/view/bill_of_exchange_view.php?bill_id=' . $id) . '</div>';
    hyperlink_params("$path_to_root/sales/inquiry/sales_orders_view.php", _("Search Outstanding Sales Orders"), "OutstandingOnly=1");
    display_footer_exit();
}

//---------------------------------------------------------------------------------------

// if (isset($_GET['UpdatedID']))
// {
//     $id = $_GET['UpdatedID'];
//     echo '<div style="margin-left: 45.5%;">' . viewer_link(_("View this dollar booking"), '/gl/view/dollar_booking_view.php?dollar_booking_id=' . $id) . '</div>';
//      hyperlink_no_params($path_to_root."/gl/inquiry/dollar_booking_inquiry.php", _("Dollar Booking Inquiry"));
//     display_notification_centered(_("The dollar booking been updated."));
//     display_footer_exit();
// }

//-------------------------------------------------------------------------------------

if (isset($_POST['ADD_ITEM']))
{
    $id = add_bill_of_exchange($_POST['order_no'], $_POST['date_'], input_num('for_usd'), $_POST['payment_term'], $_POST['drawn_under'],
    		$_POST['bank_name'], $_POST['drawee']);
    meta_forward($_SERVER['PHP_SELF'], "AddedID=$id");
}

//-------------------------------------------------------------------------------------

// if (isset($_POST['UPDATE_ITEM']))
// {

//     update_bill_of_exchange($selected_id, $_POST['booking_date'], input_num('customer'), 
//     			$_POST['receiving_date'], $_POST['due_date'], $_POST['amount'], 
//     			$_POST['currency'], $_POST['exchange_rate'], $_POST['total_amount'], 
//     			$_POST['gl_account'], $_POST['bank_account'], $_POST['deduction'], 
//     			$_POST['deduction_gl_account']);
//     meta_forward($_SERVER['PHP_SELF'], "UpdatedID=$selected_id");
// }

//-------------------------------------------------------------------------------------
if (get_post('_type_update')) 
{
  $Ajax->activate('_page_body');
}
//-------------------------------------------------------------------------------------

start_form();
start_table(TABLESTYLE);

br();

date_row(_("Date"), 'date_');
amount_row(_("For USD"), 'for_usd');
sale_payment_list_cells(_('Payment:'), 'payment_term', null, null, true, true);
textarea_row(_("Drawn Under"), "drawn_under", null, 35, 5);
textarea_row(_("Bank"), "bank_name", null, 35, 5);
textarea_row(_("Drawee"), "drawee", null, 35, 5);

end_table(1);

if ($selected_id != -1)
{
    echo "<table align=center><tr>";
    submit_cells('UPDATE_ITEM', _("Update Bill"), '', _('Save changes to job order'), 'default');
    echo "</tr></table>";
}
else
{
    submit_center('ADD_ITEM', _("Add Bill"), true, '', 'default');
}

end_form();
end_page();


?>

