<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_bill_of_exchange($order_no, $date_, $for_usd, $payment_term, $drawn_under, $bank_name, $drawee)
{
	$sql = "INSERT INTO ".TB_PREF."bill_of_exchange (order_no, date_, for_usd, payment_term, drawn_under, bank_name, drawee) VALUES (".db_escape($order_no) . ", '".date2sql($date_) . "', ".db_escape($for_usd) . ", ".db_escape($payment_term) . ", ".db_escape($drawn_under) . ",".db_escape($bank_name) . ",".db_escape($drawee) . ")";
   	db_query($sql,"The sales area could not be added");
    $bill_id = db_insert_id();
    return $bill_id;
}

function update_bill_of_exchange($selected_id, $name)
{
	$sql = "UPDATE ".TB_PREF."bill_of_exchange SET name=".db_escape($name)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The sales area could not be updated");
}

function delete_bill_of_exchange($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."bill_of_exchange WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete sales area");
}

function get_bill_of_exchanges($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."bill_of_exchange";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	return db_query($sql,"could not get areas");
}

function get_bill_of_exchange($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."bill_of_exchange WHERE id=".db_escape($selected_id);
	$result = db_query($sql,"could not get area");
	return db_fetch($result);
}

function get_bill_of_exchange_name($id)
{
	$sql = "SELECT name FROM ".TB_PREF."bill_of_exchange WHERE id=".db_escape($id);
	$result = db_query($sql, "could not get sales type");
	$row = db_fetch_row($result);
	return is_array($row) ? $row[0] : false;
}

function get_bill_of_exchange_by_order_no($order_no)
{
	$sql = "SELECT * FROM ".TB_PREF."bill_of_exchange WHERE order_no=".db_escape($order_no);
	$result = db_query($sql,"could not get area");
	return db_fetch($result);
}