<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/


function add_packing_list($items, $order_no, $form_e_no, $vessel_name, $form_e_date, $bl_no, $bl_date, 
		$lc_contract_no, $lc_contract_date, $whole_grain_length, $ratio_of_length, $shipping_marks, 
		$freight_prepaid, $booking)
{
	global $SysPrefs, $path_to_root, $Refs;

	begin_transaction();

	$sql = "INSERT INTO ".TB_PREF."packing_list (order_no, form_e_no, vessel_name, form_e_date, bl_no, bl_date, lc_contract_no, lc_contract_date, whole_grain_length, ratio_of_length, shipping_marks, freight_prepaid, booking) VALUES (".db_escape($order_no) . ", ".db_escape($form_e_no) . ", ".db_escape($vessel_name) . ", '".sql2date($form_e_date) . "', 
	".db_escape($bl_no) . ", '".sql2date($bl_date) . "', ".db_escape($lc_contract_no) . ", 
	'".sql2date($lc_contract_date) . "', ".db_escape($whole_grain_length) . ", 
	".db_escape($ratio_of_length) . ", ".db_escape($shipping_marks) . ", ".db_escape($freight_prepaid) . ",
	".db_escape($booking) . ")";
   	db_query($sql,"The packing list could not be added");
   	$packing_id = db_insert_id();

	foreach ($items as $line_item)
	{
		add_packing_list_details($packing_id, $order_no, $line_item->no, $line_item->bags, 
			$line_item->net_wt, $line_item->gross_wt);
	}

	add_audit_trail(PACKING_LIST, $packing_id, Today());
	commit_transaction();

	return $logistic_id;
}

function add_packing_list_details($packing_id, $order_no, $no, $bags, $net_wt, $gross_wt)
{
	$sql = "INSERT INTO ".TB_PREF."packing_list_details (packing_id, order_no, no, bags, net_wt, gross_wt) VALUES (".db_escape($packing_id).", ".db_escape($order_no).",".db_escape($no).",".db_escape($bags).",".db_escape($net_wt).",".db_escape($gross_wt).")";
	db_query($sql, "could not add packing list");		
}

function get_packing_list_inquiry($order_number='', $bl_number='')
{
	$sql = "SELECT 
			pt.id,
			pt.order_no,
			pt.bl_no,
			pt.bl_date,
			pt.lc_contract_no,
			pt.lc_contract_date,
			pt.booking
	 FROM ".TB_PREF."packing_list as pt , ".TB_PREF."packing_list_details as pld WHERE pt.id=pld.packing_id";
	if($order_number != '')
	 	$sql .= " AND pt.order_no=".db_escape($order_number);
	if($bl_number != '')
	 	$sql .= " AND pt.bl_no=".db_escape($bl_number);
	$sql .= " GROUP BY pt.id";
// 	display_error($sql);
	return $sql;
}

// function update_packing_list($id, $no, $bags, $net_wt, $gross_wt)
// {
// 	$sql = "UPDATE ".TB_PREF."packing_list_details SET no = ".db_escape($no).",
// 	bags =".db_escape($bags).", net_wt=".db_escape($net_wt).", gross_wt=".db_escape($gross_wt)." WHERE id = ".db_escape($id);
	
// 	db_query($sql, "could not update packing list");			
// }

// function get_all_packing_list($all=false)
// {
// 	$sql = "SELECT * FROM ".TB_PREF."packing_list_details";
// 	if (!$all)
// 		$sql .= " WHERE !inactive";
	
// 	return db_query($sql, "could not get all packing lists");
// } 

// function get_packing_list($id)
// {
// 	$sql = "SELECT * FROM ".TB_PREF."packing_list_details WHERE id=".db_escape($id);
	
// 	$result = db_query($sql, "could not get packing list");
	
// 	return db_fetch($result);
// }

function delete_packing_list($id)
{
	$sql = "DELETE pl, pld 
	        FROM ".TB_PREF."packing_list pl 
	        JOIN ".TB_PREF."packing_list_details pld 
	        ON pl.id = pld.packing_id 
	        WHERE pl.id = ".db_escape($id);
	db_query($sql, "The packing list record could not be deleted");

}

function get_packing_list_header($id)
{
	$sql = "SELECT * FROM ".TB_PREF."packing_list WHERE id=".db_escape($id);
	$result = db_query($sql, "could not get packing list");
	return db_fetch($result);
}

function get_packing_list_details($id)
{
	$sql = "SELECT * FROM ".TB_PREF."packing_list_details WHERE packing_id=".db_escape($id);
	return db_query($sql, "could not get packing list");
}

function get_packing_list_header_by_order_no($order_no)
{
	$sql = "SELECT * FROM ".TB_PREF."packing_list WHERE order_no=".db_escape($order_no);
	return db_query($sql, "could not get packing list");
}

function get_packing_list_header_by_order_no_rep($order_no)
{
	$sql = "SELECT * FROM ".TB_PREF."packing_list WHERE order_no=".db_escape($order_no);
	$result = db_query($sql, "could not get packing list");
	return db_fetch($result);
}

function get_packing_list_details_by_order_no($order_no)
{
	$sql = "SELECT * FROM ".TB_PREF."packing_list_details WHERE order_no=".db_escape($order_no);
	return db_query($sql, "could not get packing list");
}

function get_packing_list_bl_no($bl_no)
{
	$sql = "SELECT * FROM ".TB_PREF."packing_list WHERE bl_no=".db_escape($bl_no);
	$result = db_query($sql, "could not get packing list");
	return db_fetch($result);
}

function read_packing_list_header($id)
{
	$packing_list_header = get_packing_list_header($id);
	$_POST['form_e_no'] = $packing_list_header['form_e_no'];
	$_POST['vessel_name'] = $packing_list_header['vessel_name'];
	$_POST['form_e_date'] = sql2date($packing_list_header['form_e_date']);
	$_POST['bl_no'] = $packing_list_header['bl_no'];
	$_POST['bl_date'] = sql2date($packing_list_header['bl_date']);
	$_POST['lc_contract_no'] = $packing_list_header['lc_contract_no'];
	$_POST['lc_contract_date'] = sql2date($packing_list_header['lc_contract_date']);
	$_POST['whole_grain_length'] = $packing_list_header['whole_grain_length'];
	$_POST['ratio_of_length'] = $packing_list_header['ratio_of_length'];
	$_POST['shipping_marks'] = $packing_list_header['shipping_marks'];
	$_POST['freight_prepaid'] = $packing_list_header['freight_prepaid'];
	$_POST['booking'] = $packing_list_header['booking'];
}

function read_packing_list_details($order, $id)
{
	$result = get_packing_list_details($id);
	if (db_num_rows($result) > 0)
	{
		$line_no=0;
		while ($myrow = db_fetch($result))	{
			$order->add_to_packing_list_line_items($line_no, $myrow['no'], $myrow['bags'], $myrow['net_wt'],
			 $myrow['gross_wt']);
		$line_no++;
		}
	}
}