<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_pay_term($pay_term)
{
	$sql = "INSERT INTO ".TB_PREF."pay_term (pay_term) VALUES (".db_escape($pay_term) . ")";
   	db_query($sql,"The sales area could not be added");
}

function update_pay_term($selected_id, $pay_term)
{
	$sql = "UPDATE ".TB_PREF."pay_term SET pay_term=".db_escape($pay_term)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The sales area could not be updated");
}

function delete_pay_term($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."pay_term WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete sales area");
}

function get_pay_terms($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."pay_term";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	return db_query($sql,"could not get areas");
}

function get_pay_term($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."pay_term WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get area");
	return db_fetch($result);
}

function get_pay_term_name($id)
{
	$sql = "SELECT pay_term FROM ".TB_PREF."pay_term WHERE id=".db_escape($id);

	$result = db_query($sql, "could not get sales type");

	$row = db_fetch_row($result);
	return is_array($row) ? $row[0] : false;
}
