<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/sales/includes/cart_class.inc");

//--------------------------------------------------------------------------------

function add_to_order(&$order, $no, $bags, $net_wt, $gross_wt)
{
 	$order->add_to_packing_list_line_items(count($order->packing_list_line_items), $no, $bags, $net_wt, $gross_wt);
}

//--------------------------------------------------------------------------------

function display_order_header(&$order)
{
	global $Refs, $Ajax;

	if(isset($_GET['order_no']) && isset($_GET['packing_list_id']))
		read_packing_list_header($_POST['packing_list_id']);

	start_table(TABLESTYLE2, "width='100%'");
	display_heading("Packing List");
	br();
	echo "<tr><td>"; // outer table
	start_row();
	text_cells(_("Form 'E' No").':', 'form_e_no', $_POST['form_e_no'],"","",false, "class='tableheader2'");
	text_cells(_("Vessel Name").':', 'vessel_name', $_POST['vessel_name'],"","",false, "class='tableheader2'");
	date_cells(_("Form 'E' Date").':', 'form_e_date', '', null, 0, 0, 0, "class='tableheader2'");
	end_row();
	start_row();
	text_cells(_("B/L Number").':', 'bl_no', $_POST['bl_no'],"","",false, "class='tableheader2'");
	date_cells(_("B/L Date"), 'bl_date', '', null, 0, 0, 0, "class='tableheader2'");
	text_cells(_("L/C Contract #").':', 'lc_contract_no', $_POST['lc_contract_no'],"","",false, "class='tableheader2'");
	end_row();
	start_row();
	date_cells(_("L/C / Contract Date").':', 'lc_contract_date', '', null, 0, 0, 0, "class='tableheader2'");
	text_cells(_("Whole Grain Length Before Broken").':', 'whole_grain_length', $_POST['whole_grain_length'],"","",false, "class='tableheader2'");
	text_cells(_("Ratio Of Length And Width Before Broken").':', 'ratio_of_length', $_POST['ratio_of_length'],"","",false, "class='tableheader2'");
	end_row();
	start_row();
	text_cells(_("Booking").':', 'booking', $_POST['booking'],"","",false, "class='tableheader2'");
	textarea_cells(_("Shipping Marks: "), 'shipping_marks', $_POST['shipping_marks'], 30, 2, null, "class='tableheader2'");
	textarea_cells(_("Freight Prepaid: "), 'freight_prepaid', $_POST['freight_prepaid'], 30, 2, null, "class='tableheader2'");
	end_row();
	echo "</td><td>";
	end_table();
	br(2);
}

//---------------------------------------------------------------------------------

function display_packing_list_items($title, &$order)
{
	global $path_to_root;

	$kv_batch = get_company_pref('kv_batch');
	$kv_exp_date = get_company_pref('kv_exp_date');
	display_heading($title);
    div_start('items_table');
	start_table(TABLESTYLE, "width='80%'");

	if(isset($_GET['order_no']) && isset($_GET['packing_list_id']))
		read_packing_list_details($order, $_POST['packing_list_id']);

	$th = array(_("Number"), _("Bags"), _("Net WT"),
	_("Gross WT"), "");
	if ( count($order->packing_list_line_items)) $th[] = '';
	
	table_header($th);
	$total = 0;
	$k = 0;  //row colour counter
	$id = find_submit('Edit');
	foreach ($order->packing_list_line_items as $line_no=>$stock_item)
	{
		$total += ($stock_item->standard_cost * $stock_item->quantity);
		$dec = user_price_dec();

		if ($id != $line_no)
		{
			alt_table_row_color($k);

			label_cell($stock_item->no, "align='center'");
			label_cell($stock_item->bags, "align='center'");
			label_cell($stock_item->net_wt, "align='center'");
			label_cell($stock_item->gross_wt, "align='center'");

			$total_bags += $stock_item->bags;
			$total_net_wt += $stock_item->net_wt;
			$total_gross_wt += $stock_item->gross_wt;

    		edit_button_cell("Edit$line_no", _("Edit"),	_('Edit document line'));
			delete_button_cell("Delete$line_no", _("Delete"), _('Remove line from document'));
			end_row();
		}
		else
		{
			adjustment_edit_item_controls($order, $line_no, $kv_batch, $kv_exp_date);
		}
	}

	if ($id == -1)
		adjustment_edit_item_controls($order, -1, $kv_batch, $kv_exp_date);

	start_row();
	label_cells(_("<b>Total</b>"), "<b>$total_bags</b>", "colspan='1' align=left",
		"nowrap align=center");
	label_cells(_(""), "<b>$total_net_wt</b>", "colspan='2' align=left",
		"nowrap align=center");
	label_cells(_(""), "<b>$total_gross_wt</b>", "colspan='2' align=left",
		"nowrap align=center");
	end_row();

    end_table();
	hidden('order_no', $_POST['order_no']);
	hidden('packing_list_id', $_POST['packing_list_id']);
	div_end();
}

//---------------------------------------------------------------------------------

function adjustment_edit_item_controls(&$order, $line_no=-1, $kv_batch=0, $kv_exp_date=0)
{
	global $Ajax;
	start_row();

	$dec2 = user_price_dec();
	$id = find_submit('Edit');
	if ($line_no != -1 && $line_no == $id)
	{
		$_POST['no'] = $order->packing_list_line_items[$id]->no;
		$_POST['bags'] = $order->packing_list_line_items[$id]->bags;
		$_POST['net_wt'] = $order->packing_list_line_items[$id]->net_wt;
		$_POST['gross_wt'] = $order->packing_list_line_items[$id]->gross_wt;

	    $Ajax->activate('items_table');
	}
	else
	{
		if (list_updated('no')) {
			    $Ajax->activate('bags');
			    $Ajax->activate('net_wt');
			    $Ajax->activate('gross_wt');
			    $Ajax->activate('items_table');
		}
	}
	
	text_cells(null, 'no', null,"","",false, "");
	text_cells(null, 'bags', null,"","",false, "");
	text_cells(null, 'net_wt', null,"","",false, "");
	text_cells(null, 'gross_wt', null,"","",false, "");

	if ($id != -1)
	{
		button_cell('UpdateItem', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('LineNo', $line_no);
 		set_focus('qty');
	}
	else
	{
		submit_cells('AddItem', _("Add Item"), "colspan=2",
		    _('Add new item to document'), true);
	}

	end_row();
}


//---------------------------------------------------------------------------------

