<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_PACKING_LIST';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/sales/includes/db/packing_list_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Packing List Inquiry"), false, false, "", $js);

//---------------------------------------------------------------------------------------------
function sales_order_view($row)
{
	return get_trans_view_str(ST_SALESORDER, $row["order_no"]);
}
function packing_list_view($row)
{	
	return	 get_trans_view_str(PACKING_LIST, $row['id']); 
}
function packing_slip_print($row)
{
	$sales_order = get_sales_order_header($row['order_no'], ST_SALESORDER);
	if($sales_order['export_invoice'])
		return print_document_link($row['order_no'].'-'.$row['id'], _("Print"), true, ST_PACKING_SLIP, ICON_PRINT);
}
function delete_link($row)
{
	return button("Delete".$row['id'], _("Delete"), _('Remove packing list'), ICON_DELETE);
}

function edit_link($row)
{
	return pager_link(_("Edit"),"/sales/packing_list.php?NewPacking=1&order_no=" .$row["order_no"]."&packing_list_id=".$row['id'], ICON_EDIT);
}
//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders')) 
{
	$Ajax->activate('orders_tbl');
}
//---------------------------------------------------------------------------------------------
start_form();
$id = find_submit('Delete');
if ($id!=-1){

	delete_packing_list($id);
	display_notification(_('Selected packing list has been deleted'));
	$Ajax->activate('orders_tbl');
}

start_table(TABLESTYLE_NOBORDER);
start_row();
ref_cells(_("Order #:"), 'order_number', '',null, '', true);
text_cells(_("B/L Number"), 'bl_number', null,"","",false, "");

submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_row();
end_table();
//---------------------------------------------------------------------------------------------

$sql = get_packing_list_inquiry(get_post('order_number'), get_post('bl_number'));

$cols = array(
		_("SO #") => array('fun'=>'sales_order_view', 'ord'=>'', 'align'=>'center'), 
		_("Packing List #") => array('fun'=>'packing_list_view', 'ord'=>'', 'align'=>'center'), 
		_("B/L Number") => array('align'=>'center'), 
		_("B/L Date") => array('name'=>'ord_date', 'type'=>'date', 'ord'=>'desc'),
		_("L/C Contract #") => array('align'=>'center'), 
		_("L/C / Contract Date") => array('name'=>'ord_date', 'type'=>'date', 'ord'=>'desc'),
		_("Booking") => array('align'=>'center'), 
		_("Edit") => array('insert'=>true, 'fun'=>'edit_link', 'align'=>'center'),
		_("Delete") => array('insert'=>true, 'fun'=>'delete_link', 'align'=>'center'),
		array('insert'=>true, 'fun'=>'packing_slip_print'),
);

if (get_post('StockLocation') != ALL_TEXT) {
	$cols[_("Location")] = 'skip';
}

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);

$table->width = "80%";

display_db_pager($table);

end_form();
end_page();
