<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CHARGES';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/db/charges_db.inc");

page(_($help_context = "Charges"));
include($path_to_root . "/includes/ui.inc");

simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	$input_error = 0;

	// if (strlen($_POST['name']) == 0) 
	// {
	// 	$input_error = 1;
	// 	display_error(_("The name cannot be empty."));
	// 	set_focus('name');
	// }

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_charge($selected_id,$_POST['gl_code'], $_POST['name'], input_num('is_percentage'), input_num('is_weight'), input_num('predefined_rate'),
    		input_num('is_negative'));
			$note = _('Selected customer charges has been updated');
    	} 
    	else 
    	{
    		add_charge($_POST['gl_code'], $_POST['name'], input_num('is_percentage'), 
    			input_num('is_weight'), input_num('predefined_rate'), input_num('is_negative'));
			$note = _('New customer charges has been added');
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
}

//----------------------------------------------------------------------------------

if ($Mode == 'Delete')
{

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'stock_master'

	// if (item_unit_used($selected_id))
	// {
	// 	display_error(_("Cannot delete this unit of measure because items have been created using this unit."));

	// }
	if (key_in_foreign_table($selected_id, 'charges_trans', 'charge_id'))
	{
		$cancel_delete = 1;
		display_error(_("Cannot delete this customer charges because customer branches have been created using this customer charges."));
	} 
	if ($cancel_delete == 0) 
	{
		delete_charge($selected_id);
		display_notification(_('Selected customer charges has been deleted'));
	} 
	$Mode = 'RESET';
	
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

//----------------------------------------------------------------------------------

$result = get_charges(check_value('show_inactive'));

start_form();
start_table(TABLESTYLE, "width='40%'");
$th = array(_('Account Name'), _('Name'), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; //row colour counter

while ($myrow = db_fetch($result))
{

	alt_table_row_color($k);
	label_cell($myrow["gl_code"]." - ".get_gl_account_name($myrow["gl_code"]));	
	label_cell($myrow["name"]);

	inactive_control_cell($myrow["id"], $myrow["inactive"], 'name', 'id');
 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}

inactive_control_row($th);
end_table(1);

//----------------------------------------------------------------------------------

start_table(TABLESTYLE2);
global $Ajax;
if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing item category

	$myrow = get_charge($selected_id);
		$_POST['gl_code']	 = $myrow["gl_code"];
		$_POST['name']	 = $myrow["name"];
		$_POST['is_percentage']	 = $myrow["is_percentage"];
		$_POST['is_weight']	 = $myrow["is_weight"];
		$_POST['predefined_rate']	 = $myrow["predefined_rate"];
		$_POST['is_negative']	 = $myrow["is_negative"];
	}
	hidden("selected_id", $selected_id);
}

echo gl_all_accounts_list('gl_code', null, false, true, false, true);
text_row(_("Name:"), 'name', null, 30, 70);
check_row(_("Percentage %"), 'is_percentage', $_POST['is_percentage'], true);
if($_POST['is_percentage']){
check_row(_("Weight Per Price"), 'is_weight', $_POST['is_weight'], true);
// check_row(_("Predefined Rate"), 'predefined_rate', $_POST['predefined_rate'], true);
hidden('predefined_rate', 0);
}
check_row(_("Negative Charges"), 'is_negative', $_POST['is_negative'], true);
$Ajax->activate('_page_body');

end_table(1);
submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();

