<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_PAY_TERM';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");
include($path_to_root . "/sales/includes/db/pay_term_db.inc");

page(_($help_context = "Pay Term"));

include($path_to_root . "/includes/ui.inc");

simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	$input_error = 0;

	if (strlen($_POST['pay_term']) == 0) 
	{
		$input_error = 1;
		display_error(_("The pay term cannot be empty."));
		set_focus('pay_term');
	}

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_pay_term($selected_id, $_POST['pay_term']);
			$note = _('Selected pay term has been updated');
    	} 
    	else 
    	{
    		add_pay_term($_POST['pay_term']);
			$note = _('New pay term has been added');
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete')
{

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtors_master'

	// if (key_in_foreign_table($selected_id, 'cust_branch', 'area'))
	// {
	// 	$cancel_delete = 1;
	// 	display_error(_("Cannot delete this area because customer branches have been created using this area."));
	// } 
	if ($cancel_delete == 0) 
	{
		delete_pay_term($selected_id);

		display_notification(_('Selected pay term has been deleted'));
	} //end if Delete area
	$Mode = 'RESET';
} 

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

//-------------------------------------------------------------------------------------------------

$result = get_pay_terms(check_value('show_inactive'));

start_form();
start_table(TABLESTYLE, "width='30%'");

$th = array(_("ID"), _("Pay Term"), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; 

while ($myrow = db_fetch($result)) 
{
	
	alt_table_row_color($k);
	
	label_cell($myrow["id"]);
	label_cell($myrow["pay_term"]);
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'pay_term', 'id');

 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}
	
inactive_control_row($th);
end_table();
echo '<br>';

//-------------------------------------------------------------------------------------------------

start_table(TABLESTYLE2);

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing area
		$myrow = get_pay_term($selected_id);

		$_POST['pay_term']  = $myrow["pay_term"];
	}
	hidden("selected_id", $selected_id);
} 

text_row_ex(_("Pay Term:"), 'pay_term', 30); 

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();
