<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$path_to_root = "..";
$page_security = 'SA_PACKING_LIST';
include_once($path_to_root . "/sales/includes/cart_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/sales/includes/db/packing_list_db.inc");
include_once($path_to_root . "/sales/includes/ui/packing_slip_ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
if (isset($_GET['NewPacking'])) {
	if (isset($_GET['FixedAsset'])) {
		$page_security = 'SA_ASSETDISPOSAL';
		$_SESSION['page_title'] = _($help_context = "Fixed Assets Disposal");
	} else {
		$_SESSION['page_title'] = _($help_context = "Packing List");
	}
}
page($_SESSION['page_title'], false, false, "", $js);

if(isset($_GET['order_no'])){
	$_POST['order_no']=$_GET['order_no'];
}
if(isset($_GET['packing_list_id'])){
	$_POST['packing_list_id']=$_GET['packing_list_id'];
}

//-----------------------------------------------------------------------------------------------

if (isset($_GET['AddedID'])) 
{
  $trans_no = $_GET['AddedID'];
  $trans_type = ST_LOGISTIC;

  $result = get_stock_adjustment_items($trans_no);
  $row = db_fetch($result);

  
  display_notification_centered(_("Items adjustment has been processed"));
  display_note(get_trans_view_str($trans_type, $trans_no, _("&View this adjustment")));

  display_note(get_gl_view_str($trans_type, $trans_no, _("View the GL &Postings for this Adjustment")), 1, 0);

	hyperlink_params("$path_to_root/admin/attachments.php", _("Add an Attachment"), "filterType=$trans_type&trans_no=$trans_no");

	display_footer_exit();
}

//--------------------------------------------------------------------------------------------------

function line_start_focus() {
  global 	$Ajax;

  $Ajax->activate('items_table');
  unset($_POST['no']);
  unset($_POST['bags']);
  unset($_POST['net_wt']);
  unset($_POST['gross_wt']);
  set_focus('_stock_id_edit');
}
//-----------------------------------------------------------------------------------------------

function handle_new_order()
{
	if (isset($_SESSION['packing_items']))
	{
		$_SESSION['packing_items']->clear_items();
		unset ($_SESSION['packing_items']);
	}

  $_SESSION['packing_items'] = new Cart(PACKING_LIST);
	$_POST['inv_date'] = new_doc_date();
	if (!is_date_in_fiscalyear($_POST['inv_date']))
		$_POST['inv_date'] = end_fiscalyear();
	$_SESSION['packing_items']->tran_date = $_POST['inv_date'];	
}

//-----------------------------------------------------------------------------------------------

function can_process()
{
	global $SysPrefs;

	$adj = &$_SESSION['packing_items'];

	if (count($adj->packing_list_line_items) == 0)	{
		display_error(_("You must enter at least one non empty item line."));
		set_focus('stock_id');
		return false;
	}

	return true;
}

//-------------------------------------------------------------------------------

if (isset($_POST['Process']) && can_process()){

	if(isset($_POST['order_no']) && isset($_POST['packing_list_id'])){
		delete_packing_list($_POST['packing_list_id']);
		
		$trans_no = add_packing_list($_SESSION['packing_items']->packing_list_line_items, $_POST['order_no'], 
		$_POST['form_e_no'], $_POST['vessel_name'], $_POST['form_e_date'], $_POST['bl_no'], $_POST['bl_date'], 
		$_POST['lc_contract_no'], $_POST['lc_contract_date'], $_POST['whole_grain_length'], 
		$_POST['ratio_of_length'], $_POST['shipping_marks'], $_POST['freight_prepaid'], $_POST['booking']);
	  new_doc_date($_POST['inv_date']);

		$_SESSION['packing_items']->clear_items();
		unset($_SESSION['packing_items']);
	 	// meta_forward($_SERVER['PHP_SELF'], "AddedID=$trans_no");
		meta_forward($path_to_root.'/sales/inquiry/packing_list_inquiry.php?');
	}else{

		$trans_no = add_packing_list($_SESSION['packing_items']->packing_list_line_items, $_POST['order_no'], 
			$_POST['form_e_no'], $_POST['vessel_name'], $_POST['form_e_date'], $_POST['bl_no'], $_POST['bl_date'], 
			$_POST['lc_contract_no'], $_POST['lc_contract_date'], $_POST['whole_grain_length'], 
			$_POST['ratio_of_length'], $_POST['shipping_marks'], $_POST['freight_prepaid'], $_POST['booking']);
		new_doc_date($_POST['inv_date']);

		$_SESSION['packing_items']->clear_items();
		unset($_SESSION['packing_items']);
	 	// meta_forward($_SERVER['PHP_SELF'], "AddedID=$trans_no");
		meta_forward($path_to_root.'/sales/inquiry/packing_list_inquiry.php?');
	}


} /*end of process credit note */

//-----------------------------------------------------------------------------------------------

function check_item_data()
{
	$net_wt = $_POST['net_wt'];
	$gross_wt = $_POST['gross_wt'];
	$total_weight = $net_wt;//+$gross_wt
	$order_no = $_POST['order_no'];
	$so_details = get_sales_details($_POST['order_no']);
	print_r($so_details);
// 	display_error($total_weight." ".$so_details);
	if ($total_weight > $so_details) {
	    display_error(_("Net Weight & Gross Weight should not be greater than Sales Order Weight"));
	    set_focus('net_wt');
	    return false;
	}

   	return true;
}

//-----------------------------------------------------------------------------------------------

function handle_update_item()
{
	$id = $_POST['LineNo'];
   	$_SESSION['packing_items']->update_packing_cart_item($id, $_POST['no'], $_POST['bags'], $_POST['net_wt'], $_POST['gross_wt']);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_delete_item($id)
{
	$_SESSION['packing_items']->remove_packing_from_cart($id);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------
function handle_new_item(){
	add_to_order($_SESSION['packing_items'], $_POST['no'], $_POST['bags'], $_POST['net_wt'], $_POST['gross_wt']);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------
$id = find_submit('Delete');
if ($id != -1)
	handle_delete_item($id);

if (isset($_POST['AddItem']) && check_item_data())
	handle_new_item();

if (isset($_POST['UpdateItem'])) // && check_item_data()
	handle_update_item();

if (isset($_POST['CancelItemChanges'])) {
	line_start_focus();
}
//-----------------------------------------------------------------------------------------------

if (isset($_GET['NewPacking']) || !isset($_SESSION['packing_items']))
{

	if (isset($_GET['FixedAsset']))
		check_db_has_disposable_fixed_assets(_("There are no fixed assets defined in the system."));
	else
		check_db_has_costable_items(_("There are no inventory items defined in the system which can be adjusted (Purchased or Manufactured)."));

	handle_new_order();
}

//-----------------------------------------------------------------------------------------------
start_form();

$items_title = _("Packing List Details");
$button_title = _("Process Packing List");

display_order_header($_SESSION['packing_items']);
start_outer_table(TABLESTYLE, "width='70%'", 10);
display_packing_list_items($items_title, $_SESSION['packing_items']);
end_outer_table(1, false);

submit_center_first('Process', $button_title, '', 'default');

end_form();
end_page();

