<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_BILL_OF_EXCHANGE';
$path_to_root = "../..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/sales/includes/db/bill_of_exchange_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
    $js .= get_js_open_window(800, 500);
page(_($help_context = "View Bill Of Exchange"), true, false, "", $js);

//-------------------------------------------------------------------------------------------------
$bill_id = 0;
if ($_GET['bill_id'] != "")
{
    $bill_id = $_GET['bill_id'];
}

display_heading(_("Bill Of Exchange") . " # " . $bill_id);

$myrow = get_bill_of_exchange($bill_id);
br();
start_table(TABLESTYLE2, "width='50%'");
start_row();
label_row(_("Date"), sql2date($myrow['date_']), "class='tableheader2'");
label_row(_("For USD"), number_format($myrow['for_usd']), "class='tableheader2'");
$payment_term = get_payment_terms($myrow['payment_term']);
label_row(_("Payment"), $payment_term['terms'], "class='tableheader2'");
label_row(_("Drawn Under"), $myrow['drawn_under'], "class='tableheader2'");
label_row(_("Bank"), $myrow['bank_name'], "class='tableheader2'");
label_row(_("Drawee"), $myrow['drawee'], "class='tableheader2'");

end_row();
end_table();

br();

end_page(true, false, false, null, $bill_id);