<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_PACKING_LIST';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/sales/includes/db/packing_list_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 600);
page(_($help_context = "View Packing List"), true, false, "", $js);


if (isset($_GET["trans_no"]))
{
	$trans_no = $_GET["trans_no"];
}

$myrow = get_packing_list_header($trans_no);

display_heading(_("Packing List"));
start_table(TABLESTYLE, "width='100%'");
start_row();
label_cells(_("Form 'E' No"), $myrow["form_e_no"], "class='tableheader2'");
label_cells(_("Vessel Name"), $myrow["vessel_name"], "class='tableheader2'");
label_cells(_("Form 'E' Date"), sql2date($myrow["form_e_date"]), "class='tableheader2'");
end_row();
start_row();
label_cells(_("B/L Number"), $myrow["bl_no"], "class='tableheader2'");
label_cells(_("B/L Date"), sql2date($myrow["bl_date"]), "class='tableheader2'");
label_cells(_("L/C Contract #"), $myrow["lc_contract_no"], "class='tableheader2'");
end_row();
start_row();
label_cells(_("L/C / Contract Date"), sql2date($myrow["lc_contract_date"]), "class='tableheader2'");
label_cells(_("Whole Grain Length Before Broken"), $myrow["whole_grain_length"], "class='tableheader2'");
label_cells(_("Ratio Of Length And Width Before Broken"), $myrow["ratio_of_length"], "class='tableheader2'");
end_row();
start_row();
label_cells(_("Booking"), $myrow["shipping_marks"], "class='tableheader2'");
label_cells(_("Shipping Marks"), $myrow["shipping_marks"], "class='tableheader2'");
label_cells(_("Freight Prepaid"), $myrow["freight_prepaid"], "class='tableheader2'");
end_row();

end_table();

$result = get_packing_list_details($trans_no);
br();
display_heading(_("Packing List Details"));
start_table(TABLESTYLE, "width='95%'");

if (db_num_rows($result) > 0)
{
	$th = array(_("Number"), _("Bags"), _("Net WT"), _("Gross WT"));
	
	table_header($th);
	$k = 0;	//row colour counter
	$sub_total = 0;
	while ($myrow2 = db_fetch($result))
	{
		alt_table_row_color($k);

		label_cell($myrow2["no"], "align='center'");
		label_cell($myrow2["bags"], "align='center'");
		label_cell(price_format($myrow2["net_wt"]), "align='center'");
		label_cell(price_format($myrow2["gross_wt"]), "align='center'");
      
		end_row();

		$total_bags += $myrow2["bags"];
		$net_wt += $myrow2["net_wt"];
		$gross_wt += $myrow2["gross_wt"];

	} //end while there are line items to print out

	start_row();
	label_cells(_("<b>Total</b>"), "<b>$total_bags</b>", "colspan='1' align=left",
		"nowrap align=center");
	label_cells(_(""), "<b>$net_wt</b>", "colspan='2' align=left",
		"nowrap align=center");
	label_cells(_(""), "<b>$gross_wt</b>", "colspan='2' align=left",
		"nowrap align=center");
	end_row();

}

end_table(1);

// $voided = is_voided_display(ST_SALESINVOICE, $trans_id, _("This invoice has been voided."));

// if (!$voided)
// {
// 	display_allocations_to(PT_CUSTOMER, $myrow['debtor_no'], ST_SALESINVOICE, $trans_id, $myrow['Total']);
// }

end_page(true, false, false, ST_SALESINVOICE, $trans_id);

