<?php

function can_insert_inventory($row) {
    global $unknown,$Refs;
    $error='';
    $data=array();

    $data['tran_date'] =$row[0];
    $data['loc_code'] =$row[1];
    $data['stock_id'] =$row[2];   
    $data['batch'] =$row[3];
    $data['exp_date'] =$row[4];
    $data['qty'] =$row[5];
    $data['standard_cost'] =$row[6];
    $data['memo'] =$row[7]; 
    $data['type']='';
    $data['reference'] ='';
    $set_date=$row[0];
    $data['tran_date']=date('Y-m-d',strtotime($set_date));
    // $data['tran_date']=date('d-m-Y',$row['0']);

    $check_empty =array('Date Column'=>$row[0],'Location Column'=>$row[1],'Stock id  Column'=>$row[2],'Quantity Column'=>$row[5],'Standard cost Column'=>$row[6]);
    if(check_empty(array('Batch'=>$row[3]))){
        $data['batch']='-';
    }
    if(check_empty(array('exp_date'=>$row[4]))){
        $data['exp_date']='-';
    }
    if($error=check_empty($check_empty)){
        array_push($row, $error);
        array_push($unknown, $row);
        return false;
    }
    if(!GetSingleValue('stock_master','stock_id',array('stock_id'=>$data['stock_id']))){
        array_push($row, 'No item matched with this stock id');
        array_push($unknown, $row);
        return false;
    }
    if (!$data['loc_code']=get_location_code($row[1])) {
        array_push($row,'Invalid location code');
        array_push($unknown, $row);
        return false;
    }
    return $data;
}

function import_inventory($file_name){
    global $unknown ,$Refs ;
    $file =fopen($file_name, 'r');
    $counter =-1;
    $result='';
    $for_next =array();
    $prev_date='';
    $prev_type='';
    $prev_reference='';
    while ($row=fgetcsv($file)) {
        if($counter!=-1){
            $counter++;
            if($counter<=$_POST["max_rows"]){
                begin_transaction();
                $data=can_insert_inventory($row);   
                if(!$data){
                    cancel_transaction();
                }else{
                    if($prev_date ==$data['tran_date'] && $prev_loc ==$data['loc_code'] ){
                        $data['type'] = $prev_type;
                        $data['reference'] =$prev_reference;
                    }else{
                        $data['type']=get_next_trans_no(ST_INVADJUST);
                        $data['reference']= $Refs->get_next(ST_INVADJUST, null, array('location'=>$data['loc_code'], 'date'=>sql2date($data['tran_date'])));
                        $Refs->save(ST_INVADJUST, $data['type'],$data['reference']);
                        add_comments(ST_INVADJUST, $data['type'],sql2date($data['tran_date']),$data['memo']);
                        add_audit_trail(ST_INVADJUST, $data['type'],sql2date($data['tran_date']));
                    }
                    $result1 =add_stock_adjustment_item($data['type'],$data['stock_id'], $data['loc_code'], sql2date($data['tran_date']), $data['reference'], $data['qty'], $data['standard_cost'],$data['memo'],$data['batch'],sql2date($data['exp_date']));
                    if(true){
                        $prev_date =$data['tran_date'];
                        $prev_type =$data['type'];
                        $prev_loc =$data['loc_code'];
                        $prev_reference = $data['reference'];
                        commit_transaction();
                    }else{
                        cancel_transaction();
                    }
                }
            }else{
                array_push($for_next,$row);
            }
        }else {
            array_push($row,'Memo');
            $unknown=array();
            array_push($unknown,$row);
            $counter++;
        } 
    }
    $error_rows=sizeof($unknown)-1;
    $remaining_rows =sizeof($for_next);
    foreach ($for_next as $value) {
        array_push($unknown, $value);
    }   
    if($error_rows ==0 && $remaining_rows ==0){
        display_notification($counter-$error_rows-$remaining_rows.' rows are inserted');
    }else{  
        put_csv($unknown);
        display_error($counter-$error_rows-$remaining_rows.' rows are inserted <br> '.$error_rows.' row are having errors while uploading <br> '.$remaining_rows.' rows are yet to be added <br><a href="'.$_SERVER['PHP_SELF'].'?dl='.$_FILES['file']['name'].'" > Click Here </a> Download the CSV File and reupload it again after correcting the errors if any to import the rest of the items');
    }

}




?>