<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/ui/items_cart.inc");

//--------------------------------------------------------------------------------


//---------------------------------------------------------------------------------

function display_gl_items($title, &$order)
{
	global $path_to_root;

	display_heading($title);

	$dim = get_company_pref('use_dimension');

	$id = find_submit('Edit');
	$sub_type = is_subledger_account(get_post('code_id'));
	$has_subaccounts = $order->has_sub_accounts();

    div_start('items_table');
	start_table(TABLESTYLE, "width='95%'");
	if ($dim == 2)
		$th = array(_("Account Code"), _("Account Description"), _("Dimension")." 1",
			_("Dimension")." 2", _("Debit"), _("Credit"), _("Memo"), "");
	elseif ($dim == 1)
		$th = array(_("Account Code"), _("Account Description"), _("Dimension"),
			_("Debit"), _("Credit"), _("Memo"), "");
	else
		$th = array(_("Account Code"), _("Account Description"),
			_("Debit"), _("Credit"), _("Memo"), "");

	if (count($order->gl_items)) $th[] = '';
	if ($sub_type || $has_subaccounts)
		array_insert($th, 2, _("Counterparty"));

	table_header($th);

	$k = 0;

	if ($id == -1) 
		$id = get_post('Index', -1);

	foreach ($order->gl_items as $line => $item) 
	{
		if ($id != $line)
		{
    		alt_table_row_color($k);

			$acc = $item->code_id . ($item->person_id ? sprintf(' %05d', $item->person_id) : '');
			label_cells($acc, $item->description);

		if ($sub_type || $has_subaccounts)
			label_cell($item->person_name);

    		if ($dim >= 1)
   				label_cell(get_dimension_string($item->dimension_id, true));
    		if ($dim > 1)
   				label_cell(get_dimension_string($item->dimension2_id, true));
    		if ($item->amount > 0)
    		{
    			amount_cell(abs($item->amount));
    			label_cell("");
    		}
    		else
    		{
    			label_cell("");
    			amount_cell(abs($item->amount));
    		}	
			label_cell($item->reference);

			edit_button_cell("Edit$line", _("Edit"),
				_('Edit journal line'));
			delete_button_cell("journalDelete$line", _("Delete"),
				_('Remove line from journal'));
    		end_row();
		} 
		else 
		{
			gl_edit_item_controls($order, $dim, $item->person_id, $line);
		}
	}

	if ($id == -1)
		gl_edit_item_controls($order, $dim, $sub_type);

	
	if ($order->count_gl_items()) 
	{
		$colspan = ($dim == 2 ? "4" : ($dim == 1 ? "3" : "2")) + ($sub_type || $has_subaccounts ? 1 : 0);
		start_row();
		label_cell(_("Total"), "align=right colspan=" . $colspan);
		amount_cell($order->gl_items_total_debit());
		amount_cell(abs($order->gl_items_total_credit()));
		label_cell('', "colspan=3");
		end_row();
	}
	start_row();
	end_row();

	$colspan = ($dim == 2 ? "4" : ($dim == 1 ? "3" : "2")) + ($sub_type || $has_subaccounts ? 1 : 0);

	$left_to_allocate =abs($order->original_amount) -$order->gl_items_total_debit();
	hidden('left_to_allocate',$left_to_allocate);
	label_cell(_("Left to allocate"), "align=right colspan=" . $colspan);
		amount_cell($left_to_allocate);
    end_table();

	div_end();
}

//---------------------------------------------------------------------------------

function gl_edit_item_controls(&$order, $dim, $sub_accounts, $Index=null)
{
	global $Ajax;
	start_row();

	$id = find_submit('Edit');
	if ($id == -1) 
		$continue = $id = get_post('Index', -1);

	if ($Index != -1 && $Index == $id)
	{
	    // Modifying an existing row
		$item = $order->gl_items[$Index];
		if (!isset($continue))
		{
			$_POST['code_id'] = $item->code_id;
			$_POST['dimension_id'] = $item->dimension_id;
			$_POST['dimension2_id'] = $item->dimension2_id;
			$_POST['person_id'] = $item->person_id;
			if ($item->amount > 0)
			{
				$_POST['AmountDebit'] = price_format($item->amount);
				$_POST['AmountCredit'] = "";
			}
			else
			{
				$_POST['AmountDebit'] = "";
				$_POST['AmountCredit'] = price_format(abs($item->amount));
			}
			$_POST['description'] = $item->description;
			$_POST['LineMemo'] = $item->reference;
		}
		hidden('Index', $id);
		$skip_bank = !$_SESSION["wa_current_user"]->can_access('SA_BANKJOURNAL');
		echo gl_all_accounts_list('code_id', null, $skip_bank, true, _('[Select account]'), true, false, false);

		if (is_subledger_account(get_post('code_id')))
		{	// for home currency postings show all customers
			$sel_cur = get_post('currency', $order->currency);
			subledger_list_cells(null, 'person_id', get_post('code_id'), null, false, false,
				get_company_currency() == $sel_cur  ? null : $sel_cur);
		} elseif ($order->has_sub_accounts())
			label_cell('');
		if ($dim >= 1) 
			dimensions_list_cells(null, 'dimension_id', null, true, " ", false, 1);
		if ($dim > 1) 
			dimensions_list_cells(null, 'dimension2_id', null, true, " ", false, 2);
	    $Ajax->activate('items_table');
	}
	else
	{
		$skip_bank = !$_SESSION["wa_current_user"]->can_access('SA_BANKJOURNAL');
		echo gl_all_accounts_list('code_id', null, $skip_bank, true, _('[Select account]'), true, false, false);
		if ($sub_accounts)
		{
			// for home currency postings show all customers
			$sel_cur = get_post('currency', $order->currency);
			subledger_list_cells(null, 'person_id', get_post('code_id'), null, false, false,
				get_company_currency() == $sel_cur  ? null : $sel_cur);
		}
		elseif ($order->has_sub_accounts())
			label_cell('');

		if ($dim >= 1)
			dimensions_list_cells(null, 'dimension_id', null, true, " ", false, 1);
		if ($dim > 1)
			dimensions_list_cells(null, 'dimension2_id', null, true, " ", false, 2);
		$_POST['LineMemo'] = "";			
	}

	if (get_post('_code_id_update'))
	{
	    $Ajax->activate('code_id');
		set_focus($sub_accounts ? 'person_id' : 'AmountDebit');
	}
	if ($dim < 1)
		hidden('dimension_id', 0);
	if ($dim < 2)
		hidden('dimension2_id', 0);

	small_amount_cells(null, 'AmountDebit');
	small_amount_cells(null, 'AmountCredit');
	text_cells_ex(null, 'LineMemo', 35, 255);

	if ($id != -1)
	{
		button_cell('journalUpdateItem', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('journalCancelItemChanges', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
 		set_focus('amount');
	} 
	else 
		submit_cells('journalAddItem', _("Add Item"), "colspan=2",
		    _('Add new line to journal'), true);

	end_row();
}

//---------------------------------------------------------------------------------

function gl_options_controls()
{
	  echo "<br><table align='center'>";

	  textarea_row(_("Memo"), 'memo_', null, 50, 3);

	  echo "</table>";
}
