# MySQL dump of database 'digihzdv_demo_test' on host 'localhost'
# Backup Date and Time: 2022-12-20 13:42
# Built by digitleysystem 2.4.11
# http://digitleysystem
# Company: Digitley System
# User: Administrator

# Compatibility: 2.4.1

# Comment:
# Bkp 20-11-2020


SET NAMES latin1;


### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('1', 'Global', '0'),
('2', 'mirpurkhas', '0'),
('3', 'umarkot', '0'),
('4', 'hyderabad', '0'),
('5', 'nokot', '0'),
('6', 'abc', '0');

### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attachments` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `user` smallint(6) unsigned NOT NULL DEFAULT 0,
  `stamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `description` varchar(60) DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT 0,
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_audit_trail` ###

INSERT INTO `0_audit_trail` VALUES
('1', '0', '1', '1', '2022-12-20 00:52:02', NULL, '3', '2022-12-16', NULL),
('2', '18', '1', '1', '2022-12-16 09:33:34', NULL, '3', '2022-12-16', '0'),
('3', '25', '1', '1', '2022-12-20 01:39:44', NULL, '3', '2022-12-16', NULL),
('4', '20', '1', '1', '2022-12-16 09:40:21', NULL, '3', '2022-12-16', NULL),
('5', '20', '1', '1', '2022-12-16 09:40:21', 'Voided.\nDocument reentered.', '3', '2022-12-16', '0'),
('6', '20', '2', '1', '2022-12-16 09:41:34', NULL, '3', '2022-12-16', NULL),
('7', '20', '2', '1', '2022-12-16 09:41:34', 'Voided.\nDocument reentered.', '3', '2022-12-16', '0'),
('8', '20', '3', '1', '2022-12-20 01:23:58', NULL, '3', '2022-12-16', NULL),
('9', '0', '1', '1', '2022-12-20 00:52:02', 'Voided.\n', '3', '2022-12-20', '0'),
('10', '20', '3', '1', '2022-12-20 01:23:58', 'Voided.\n', '3', '2022-12-20', '0'),
('11', '18', '2', '1', '2022-12-20 01:33:17', NULL, '3', '2022-12-20', '0'),
('12', '25', '2', '1', '2022-12-20 01:39:38', NULL, '3', '2022-12-20', NULL),
('13', '20', '4', '1', '2022-12-20 01:35:20', NULL, '3', '2022-12-20', NULL),
('14', '20', '4', '1', '2022-12-20 01:35:20', 'Voided.\n', '3', '2022-12-20', '0'),
('15', '25', '2', '1', '2022-12-20 01:39:38', 'Voided.\n', '3', '2022-12-20', '0'),
('16', '25', '1', '1', '2022-12-20 01:39:44', 'Voided.\n', '3', '2022-12-20', '0'),
('17', '18', '3', '1', '2022-12-20 01:44:31', NULL, '3', '2022-12-20', '0'),
('18', '25', '3', '1', '2022-12-20 02:01:24', NULL, '3', '2022-12-20', NULL),
('19', '20', '5', '1', '2022-12-20 01:58:09', NULL, '3', '2022-12-20', NULL),
('20', '20', '5', '1', '2022-12-20 01:58:09', 'Voided.\n', '3', '2022-12-20', '0'),
('21', '25', '3', '1', '2022-12-20 02:01:24', 'Voided.\n', '3', '2022-12-20', '0'),
('22', '18', '4', '1', '2022-12-20 02:03:33', NULL, '3', '2022-12-20', '0'),
('23', '25', '4', '1', '2022-12-20 02:25:58', NULL, '3', '2022-12-20', NULL),
('24', '20', '6', '1', '2022-12-20 02:25:41', NULL, '3', '2022-12-20', NULL),
('25', '20', '6', '1', '2022-12-20 02:25:41', 'Voided.\n', '3', '2022-12-20', '0'),
('26', '25', '4', '1', '2022-12-20 02:25:58', 'Voided.\n', '3', '2022-12-20', '0'),
('27', '18', '5', '1', '2022-12-20 08:16:38', NULL, '3', '2022-12-20', '0'),
('28', '25', '5', '1', '2022-12-20 08:16:38', NULL, '3', '2022-12-20', '0'),
('29', '20', '7', '1', '2022-12-20 08:41:32', NULL, '3', '2022-12-20', NULL),
('30', '20', '7', '1', '2022-12-20 08:41:32', 'Voided.\nvoid', '3', '2022-12-20', '0');

### Structure of table `0_bank_accounts` ###

DROP TABLE IF EXISTS `0_bank_accounts`;

CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT 0,
  `bank_account_name` varchar(60) NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) NOT NULL DEFAULT '',
  `bank_name` varchar(60) NOT NULL DEFAULT '',
  `bank_address` tinytext DEFAULT NULL,
  `bank_curr_code` char(3) NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT 0,
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_accounts` ###

INSERT INTO `0_bank_accounts` VALUES
('1060', '0', 'Meezan Bank account', 'N/A', 'N/A', NULL, 'PKR', '1', '1', '5690', '2022-06-05 00:00:00', '0', '0'),
('1065', '3', 'Petty Cash account', 'N/A', 'N/A', NULL, 'PKR', '0', '2', '5690', '0000-00-00 00:00:00', '0', '0'),
('1061', '0', 'AHMED MBL', '', '', NULL, 'PKR', '0', '3', '5690', '0000-00-00 00:00:00', '0', '0'),
('1062', '0', 'CI BAHL', '', '', NULL, 'PKR', '0', '4', '5690', '0000-00-00 00:00:00', '0', '0'),
('1063', '0', 'CLR BAHL', '', '', NULL, 'PKR', '0', '5', '5690', '0000-00-00 00:00:00', '0', '0'),
('1064', '0', 'CM MEEZAN', '', '', NULL, 'PKR', '0', '6', '5690', '0000-00-00 00:00:00', '0', '0');

### Structure of table `0_bank_trans` ###

DROP TABLE IF EXISTS `0_bank_trans`;

CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) NOT NULL DEFAULT '',
  `ref` varchar(40) DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) NOT NULL DEFAULT 0,
  `person_id` tinyblob DEFAULT NULL,
  `reconciled` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_trans` ###

INSERT INTO `0_bank_trans` VALUES
('1', '0', '1', '2', '001/2022', '2022-12-16', '0', '0', '0', '0', NULL, NULL);

### Structure of table `0_bom` ###

DROP TABLE IF EXISTS `0_bom`;

CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) NOT NULL DEFAULT '',
  `component` char(20) NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bom` ###


### Structure of table `0_budget_trans` ###

DROP TABLE IF EXISTS `0_budget_trans`;

CREATE TABLE `0_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `memo_` tinytext NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_budget_trans` ###


### Structure of table `0_chart_class` ###

DROP TABLE IF EXISTS `0_chart_class`;

CREATE TABLE `0_chart_class` (
  `cid` varchar(3) NOT NULL,
  `class_name` varchar(60) NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_class` ###

INSERT INTO `0_chart_class` VALUES
('1', 'Assets', '1', '0'),
('2', 'Liabilities', '2', '0'),
('3', 'Income', '4', '0'),
('4', 'Costs', '6', '0');

### Structure of table `0_chart_master` ###

DROP TABLE IF EXISTS `0_chart_master`;

CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_code2` varchar(15) NOT NULL DEFAULT '',
  `account_name` varchar(60) NOT NULL DEFAULT '',
  `account_type` varchar(10) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_master` ###

INSERT INTO `0_chart_master` VALUES
('0001', '', 'OPENING BALANCE ACCOUNT', '1', '0'),
('1060', '', 'Checking Account', '1', '0'),
('1061', '', 'CURRENT ACCOUNT', '1', '0'),
('1062', '', 'CURRENT ACCOUNT', '1', '0'),
('1063', '', 'CURRENT ACCOUNT', '1', '0'),
('1064', '', 'CURRENT ACCOUNT', '1', '0'),
('1065', '', 'Petty Cash', '1', '0'),
('1200', '', 'Accounts Receivables', '1', '0'),
('1205', '', 'Allowance for doubtful accounts', '1', '0'),
('1510', '', 'Inventory', '2', '0'),
('1520', '', 'Stocks of Raw Materials', '2', '0'),
('1530', '', 'Stocks of Work In Progress', '2', '0'),
('1540', '', 'Stocks of Finished Goods', '2', '0'),
('1550', '', 'Goods Received Clearing account', '2', '0'),
('1820', '', 'Office Furniture &amp; Equipment', '3', '0'),
('1825', '', 'Accum. Amort. -Furn. &amp; Equip.', '3', '0'),
('1840', '', 'Vehicle', '3', '0'),
('1845', '', 'Accum. Amort. -Vehicle', '3', '0'),
('2093', '', 'ABDULLAH WASTE PAPER', '4', '0'),
('2094', '', 'ALI SOHAIL', '4', '0'),
('2095', '', 'CI', '4', '0'),
('2096', '', 'CONSTRUCTION', '4', '0'),
('2097', '', 'DASTI A/C', '4', '0'),
('2098', '', 'TARIQ MUNEER', '4', '0'),
('2099', '', 'TRITEX CLOTHING', '4', '0'),
('2100', '', 'Accounts Payable', '4', '0'),
('2105', '', 'Deferred Income', '4', '0'),
('2110', '', 'Accrued Income Tax - Federal', '4', '0'),
('2120', '', 'Accrued Income Tax - State', '4', '0'),
('2130', '', 'Accrued Franchise Tax', '4', '0'),
('2140', '', 'Accrued Real &amp; Personal Prop Tax', '4', '0'),
('2150', '', 'Sales Tax', '4', '0'),
('2160', '', 'Accrued Use Tax Payable', '4', '0'),
('2210', '', 'Accrued Wages', '4', '0'),
('2220', '', 'Accrued Comp Time', '4', '0'),
('2230', '', 'Accrued Holiday Pay', '4', '0'),
('2240', '', 'Accrued Vacation Pay', '4', '0'),
('2310', '', 'Accr. Benefits - 401K', '4', '0'),
('2320', '', 'Accr. Benefits - Stock Purchase', '4', '0'),
('2330', '', 'Accr. Benefits - Med, Den', '4', '0'),
('2340', '', 'Accr. Benefits - Payroll Taxes', '4', '0'),
('2350', '', 'Accr. Benefits - Credit Union', '4', '0'),
('2360', '', 'Accr. Benefits - Savings Bond', '4', '0'),
('2370', '', 'Accr. Benefits - Garnish', '4', '0'),
('2380', '', 'Accr. Benefits - Charity Cont.', '4', '0'),
('2620', '', 'Bank Loans', '5', '0'),
('2680', '', 'Loans from Shareholders', '5', '0'),
('3350', '', 'Common Shares', '6', '0'),
('3590', '', 'Retained Earnings - prior years', '7', '0'),
('4010', '', 'Sales', '8', '0'),
('4430', '', 'Shipping &amp; Handling', '9', '0'),
('4431', '', 'AHMED', '9', '0'),
('4432', '', 'HALIMA', '9', '0'),
('4440', '', 'Interest', '9', '0'),
('4450', '', 'Foreign Exchange Gain', '9', '0'),
('4500', '', 'Prompt Payment Discounts', '9', '0'),
('4510', '', 'Discounts Given', '9', '0'),
('5010', '', 'Cost of Goods Sold - Retail', '10', '0'),
('5020', '', 'Material Usage Varaiance', '10', '0'),
('5030', '', 'Consumable Materials', '10', '0'),
('5040', '', 'Purchase price Variance', '10', '0'),
('5050', '', 'Purchases of materials', '10', '0'),
('5060', '', 'Discounts Received', '10', '0'),
('5100', '', 'Freight', '10', '0'),
('5410', '', 'Wages &amp; Salaries', '11', '0'),
('5420', '', 'Wages - Overtime', '11', '0'),
('5430', '', 'Benefits - Comp Time', '11', '0'),
('5440', '', 'Benefits - Payroll Taxes', '11', '0'),
('5450', '', 'Benefits - Workers Comp', '11', '0'),
('5460', '', 'Benefits - Pension', '11', '0'),
('5470', '', 'Benefits - General Benefits', '11', '0'),
('5510', '', 'Inc Tax Exp - Federal', '11', '0'),
('5520', '', 'Inc Tax Exp - State', '11', '0'),
('5530', '', 'Taxes - Real Estate', '11', '0'),
('5540', '', 'Taxes - Personal Property', '11', '0'),
('5550', '', 'Taxes - Franchise', '11', '0'),
('5560', '', 'Taxes - Foreign Withholding', '11', '0'),
('5610', '', 'Accounting &amp; Legal', '12', '0'),
('5611', '', 'MISC', '12', '0'),
('5615', '', 'Advertising &amp; Promotions', '12', '0'),
('5620', '', 'Bad Debts', '12', '0'),
('5660', '', 'Amortization Expense', '12', '0'),
('5685', '', 'Insurance', '12', '0'),
('5690', '', 'Interest &amp; Bank Charges', '12', '0'),
('5700', '', 'Office Supplies', '12', '0'),
('5760', '', 'Rent', '12', '0'),
('5765', '', 'Repair &amp; Maintenance', '12', '0'),
('5780', '', 'Telephone', '12', '0'),
('5785', '', 'Travel &amp; Entertainment', '12', '0'),
('5790', '', 'Utilities', '12', '0'),
('5795', '', 'Registrations', '12', '0'),
('5800', '', 'Licenses', '12', '0'),
('5810', '', 'Foreign Exchange Loss', '12', '0'),
('9990', '', 'Year Profit/Loss', '12', '0');

### Structure of table `0_chart_types` ###

DROP TABLE IF EXISTS `0_chart_types`;

CREATE TABLE `0_chart_types` (
  `id` varchar(10) NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `class_id` varchar(3) NOT NULL DEFAULT '',
  `parent` varchar(10) NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_types` ###

INSERT INTO `0_chart_types` VALUES
('1', 'Current Assets', '1', '', '0'),
('10', 'Cost of Goods Sold', '4', '', '0'),
('11', 'Payroll Expenses', '4', '', '0'),
('12', 'General &amp; Administrative expenses', '4', '', '0'),
('2', 'Inventory Assets', '1', '', '0'),
('3', 'Capital Assets', '1', '', '0'),
('4', 'Current Liabilities', '2', '', '0'),
('5', 'Long Term Liabilities', '2', '', '0'),
('6', 'Share Capital', '2', '', '0'),
('7', 'Retained Earnings', '2', '', '0'),
('8', 'Sales Revenue', '3', '', '0'),
('9', 'Other Revenue', '3', '', '0');

### Structure of table `0_comments` ###

DROP TABLE IF EXISTS `0_comments`;

CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext DEFAULT NULL,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_comments` ###

INSERT INTO `0_comments` VALUES
('20', '7', '2022-12-20', 'opening invoice');

### Structure of table `0_credit_status` ###

DROP TABLE IF EXISTS `0_credit_status`;

CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_credit_status` ###

INSERT INTO `0_credit_status` VALUES
('1', 'Good History', '0', '0'),
('3', 'No more work until payment received', '1', '0'),
('4', 'In liquidation', '1', '0');

### Structure of table `0_crm_categories` ###

DROP TABLE IF EXISTS `0_crm_categories`;

CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) NOT NULL COMMENT 'contact type e.g. customer',
  `action` varchar(20) NOT NULL COMMENT 'detailed usage e.g. department',
  `name` varchar(30) NOT NULL COMMENT 'for category selector',
  `description` tinytext NOT NULL COMMENT 'usage description',
  `system` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_categories` ###

INSERT INTO `0_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `0_crm_contacts` ###

DROP TABLE IF EXISTS `0_crm_contacts`;

CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT 0 COMMENT 'foreign key to crm_persons',
  `type` varchar(20) NOT NULL COMMENT 'foreign key to crm_categories',
  `action` varchar(20) NOT NULL COMMENT 'foreign key to crm_categories',
  `entity_id` varchar(11) DEFAULT NULL COMMENT 'entity id in related class table',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=177 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_contacts` ###

INSERT INTO `0_crm_contacts` VALUES
('1', '1', 'cust_branch', 'general', '1'),
('2', '1', 'customer', 'general', '1'),
('3', '2', 'cust_branch', 'general', '2'),
('4', '2', 'customer', 'general', '2'),
('5', '3', 'cust_branch', 'general', '3'),
('6', '3', 'customer', 'general', '3'),
('7', '4', 'cust_branch', 'general', '4'),
('8', '4', 'customer', 'general', '4'),
('9', '5', 'cust_branch', 'general', '5'),
('10', '5', 'customer', 'general', '5'),
('11', '6', 'cust_branch', 'general', '6'),
('12', '6', 'customer', 'general', '6'),
('13', '7', 'cust_branch', 'general', '7'),
('14', '7', 'customer', 'general', '7'),
('15', '8', 'cust_branch', 'general', '8'),
('16', '8', 'customer', 'general', '8'),
('17', '9', 'cust_branch', 'general', '9'),
('18', '9', 'customer', 'general', '9'),
('19', '10', 'cust_branch', 'general', '10'),
('20', '10', 'customer', 'general', '10'),
('21', '11', 'cust_branch', 'general', '11'),
('22', '11', 'customer', 'general', '11'),
('23', '12', 'cust_branch', 'general', '12'),
('24', '12', 'customer', 'general', '12'),
('25', '13', 'cust_branch', 'general', '13'),
('26', '13', 'customer', 'general', '13'),
('27', '14', 'cust_branch', 'general', '14'),
('28', '14', 'customer', 'general', '14'),
('29', '15', 'cust_branch', 'general', '15'),
('30', '15', 'customer', 'general', '15'),
('31', '16', 'cust_branch', 'general', '16'),
('32', '16', 'customer', 'general', '16'),
('33', '17', 'cust_branch', 'general', '17'),
('34', '17', 'customer', 'general', '17'),
('35', '18', 'cust_branch', 'general', '18'),
('36', '18', 'customer', 'general', '18'),
('37', '19', 'cust_branch', 'general', '19'),
('38', '19', 'customer', 'general', '19'),
('39', '20', 'cust_branch', 'general', '20'),
('40', '20', 'customer', 'general', '20'),
('41', '21', 'cust_branch', 'general', '21'),
('42', '21', 'customer', 'general', '21'),
('43', '22', 'cust_branch', 'general', '22'),
('44', '22', 'customer', 'general', '22'),
('45', '23', 'cust_branch', 'general', '23'),
('46', '23', 'customer', 'general', '23'),
('47', '24', 'cust_branch', 'general', '24'),
('48', '24', 'customer', 'general', '24'),
('49', '25', 'cust_branch', 'general', '25'),
('50', '25', 'customer', 'general', '25'),
('51', '26', 'cust_branch', 'general', '26'),
('52', '26', 'customer', 'general', '26'),
('53', '27', 'cust_branch', 'general', '27'),
('54', '27', 'customer', 'general', '27'),
('55', '28', 'cust_branch', 'general', '28'),
('56', '28', 'customer', 'general', '28'),
('57', '29', 'cust_branch', 'general', '29'),
('58', '29', 'customer', 'general', '29'),
('59', '30', 'cust_branch', 'general', '30'),
('60', '30', 'customer', 'general', '30'),
('61', '31', 'cust_branch', 'general', '31'),
('62', '31', 'customer', 'general', '31'),
('63', '32', 'cust_branch', 'general', '32'),
('64', '32', 'customer', 'general', '32'),
('65', '33', 'cust_branch', 'general', '33'),
('66', '33', 'customer', 'general', '33'),
('67', '34', 'cust_branch', 'general', '34'),
('68', '34', 'customer', 'general', '34'),
('69', '35', 'cust_branch', 'general', '35'),
('70', '35', 'customer', 'general', '35'),
('71', '36', 'cust_branch', 'general', '36'),
('72', '36', 'customer', 'general', '36'),
('73', '37', 'cust_branch', 'general', '37'),
('74', '37', 'customer', 'general', '37'),
('75', '38', 'cust_branch', 'general', '38'),
('76', '38', 'customer', 'general', '38'),
('77', '39', 'cust_branch', 'general', '39'),
('78', '39', 'customer', 'general', '39'),
('79', '40', 'cust_branch', 'general', '40'),
('80', '40', 'customer', 'general', '40'),
('81', '41', 'cust_branch', 'general', '41'),
('82', '41', 'customer', 'general', '41'),
('83', '42', 'cust_branch', 'general', '42'),
('84', '42', 'customer', 'general', '42'),
('85', '43', 'cust_branch', 'general', '43'),
('86', '43', 'customer', 'general', '43'),
('87', '44', 'cust_branch', 'general', '44'),
('88', '44', 'customer', 'general', '44'),
('89', '45', 'cust_branch', 'general', '45'),
('90', '45', 'customer', 'general', '45'),
('91', '46', 'cust_branch', 'general', '46'),
('92', '46', 'customer', 'general', '46'),
('93', '47', 'cust_branch', 'general', '47'),
('94', '47', 'customer', 'general', '47'),
('95', '48', 'cust_branch', 'general', '48'),
('96', '48', 'customer', 'general', '49'),
('97', '49', 'cust_branch', 'general', '49'),
('98', '49', 'customer', 'general', '50'),
('99', '50', 'cust_branch', 'general', '50'),
('100', '50', 'customer', 'general', '51'),
('101', '51', 'cust_branch', 'general', '51'),
('102', '51', 'customer', 'general', '52'),
('103', '52', 'cust_branch', 'general', '52'),
('104', '52', 'customer', 'general', '53'),
('105', '53', 'cust_branch', 'general', '53'),
('106', '53', 'customer', 'general', '54'),
('107', '54', 'cust_branch', 'general', '54'),
('108', '54', 'customer', 'general', '55'),
('109', '55', 'cust_branch', 'general', '55'),
('110', '55', 'customer', 'general', '56'),
('111', '56', 'cust_branch', 'general', '56'),
('112', '56', 'customer', 'general', '57'),
('113', '57', 'cust_branch', 'general', '57'),
('114', '57', 'customer', 'general', '58'),
('115', '58', 'cust_branch', 'general', '58'),
('116', '58', 'customer', 'general', '59'),
('117', '59', 'cust_branch', 'general', '59'),
('118', '59', 'customer', 'general', '60'),
('119', '60', 'cust_branch', 'general', '60'),
('120', '60', 'customer', 'general', '61'),
('121', '61', 'cust_branch', 'general', '61'),
('122', '61', 'customer', 'general', '62'),
('123', '62', 'cust_branch', 'general', '62'),
('124', '62', 'customer', 'general', '63'),
('125', '63', 'cust_branch', 'general', '63'),
('126', '63', 'customer', 'general', '64'),
('127', '64', 'cust_branch', 'general', '64'),
('128', '64', 'customer', 'general', '65'),
('129', '65', 'cust_branch', 'general', '65'),
('130', '65', 'customer', 'general', '66'),
('131', '66', 'cust_branch', 'general', '66'),
('132', '66', 'customer', 'general', '67'),
('133', '67', 'cust_branch', 'general', '67'),
('134', '67', 'customer', 'general', '68'),
('135', '68', 'cust_branch', 'general', '68'),
('136', '68', 'customer', 'general', '69'),
('137', '69', 'cust_branch', 'general', '69'),
('138', '69', 'customer', 'general', '70'),
('139', '70', 'cust_branch', 'general', '70'),
('140', '70', 'customer', 'general', '71'),
('141', '71', 'cust_branch', 'general', '71'),
('142', '71', 'customer', 'general', '72'),
('143', '72', 'cust_branch', 'general', '72'),
('144', '72', 'customer', 'general', '73'),
('145', '73', 'cust_branch', 'general', '73'),
('146', '73', 'customer', 'general', '74'),
('147', '74', 'cust_branch', 'general', '74'),
('148', '74', 'customer', 'general', '75'),
('149', '75', 'cust_branch', 'general', '75'),
('150', '75', 'customer', 'general', '76'),
('151', '76', 'cust_branch', 'general', '76'),
('152', '76', 'customer', 'general', '77'),
('153', '77', 'cust_branch', 'general', '77'),
('154', '77', 'customer', 'general', '78'),
('155', '78', 'cust_branch', 'general', '78'),
('156', '78', 'customer', 'general', '79'),
('157', '79', 'cust_branch', 'general', '79'),
('158', '79', 'customer', 'general', '80'),
('159', '80', 'cust_branch', 'general', '80'),
('160', '80', 'customer', 'general', '81'),
('161', '81', 'cust_branch', 'general', '81'),
('162', '81', 'customer', 'general', '82'),
('163', '82', 'cust_branch', 'general', '82'),
('164', '82', 'customer', 'general', '83'),
('165', '83', 'supplier', 'general', '1'),
('166', '84', 'supplier', 'general', '2'),
('167', '85', 'supplier', 'general', '3'),
('168', '86', 'supplier', 'general', '4'),
('169', '87', 'supplier', 'general', '5'),
('170', '88', 'supplier', 'general', '6'),
('171', '89', 'supplier', 'general', '7'),
('172', '90', 'supplier', 'general', '8'),
('173', '91', 'supplier', 'general', '9'),
('174', '92', 'supplier', 'general', '10'),
('175', '93', 'supplier', 'general', '11'),
('176', '94', 'supplier', 'general', '12');

### Structure of table `0_crm_persons` ###

DROP TABLE IF EXISTS `0_crm_persons`;

CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) NOT NULL,
  `name` varchar(60) NOT NULL,
  `name2` varchar(60) DEFAULT NULL,
  `address` tinytext DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `phone2` varchar(30) DEFAULT NULL,
  `fax` varchar(30) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `lang` char(5) DEFAULT NULL,
  `notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_persons` ###

INSERT INTO `0_crm_persons` VALUES
('1', 'ABBAS BHAI', 'ABBAS BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('2', 'ABU BAKAR ARSHAD', 'ABU BAKAR ARSHAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('3', 'AFZAL SAHAB (LANYU)', 'AFZAL SAHAB (LANYU)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('4', 'AL NISA SAAD BHAI', 'AL NISA SAAD BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('5', 'ALEEM SARJANI TOWN', 'ALEEM SARJANI TOWN', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('6', 'ALI IQBAL CLOTH MARKET', 'ALI IQBAL CLOTH MARKET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('7', 'ALTAF HUSSAIN AFRIDI', 'ALTAF HUSSAIN AFRIDI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('8', 'AMAR BHAI', 'AMAR BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('9', 'AMIR KHATRI', 'AMIR KHATRI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('10', 'ANIS LAKHANI', 'ANIS LAKHANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('11', 'ARIF BHAI', 'ARIF BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('12', 'ARIF WASTE PAPER', 'ARIF WASTE PAPER', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('13', 'ASIF PAPER WASTE', 'ASIF PAPER WASTE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('14', 'ASLAM BHAI', 'ASLAM BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('15', 'AYESHA SOMAYA', 'AYESHA SOMAYA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('16', 'BABAR NAZIMABAD', 'BABAR NAZIMABAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('17', 'BABOO NEW KARACHI', 'BABOO NEW KARACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('18', 'BASHIR KHAN HIGHWAY', 'BASHIR KHAN HIGHWAY', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('19', 'BOMBAY FAISHION', 'BOMBAY FAISHION', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('20', 'CASH SALE', 'CASH SALE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('21', 'CENTRAL DYING', 'CENTRAL DYING', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('22', 'CLR', 'CLR', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('23', 'DANISH DAKHNI', 'DANISH DAKHNI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('24', 'DECOTEX (ASGHAR BHAI)', 'DECOTEX (ASGHAR BHAI)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('25', 'DHANAK', 'DHANAK', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('26', 'DINERS', 'DINERS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('27', 'EVOLUTION C/O ALI', 'EVOLUTION C/O ALI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('28', 'FARHAN MOTI WALA', 'FARHAN MOTI WALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('29', 'FARUKH BHAI', 'FARUKH BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('30', 'GHANI BHAI', 'GHANI BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('31', 'GULF FABRICS', 'GULF FABRICS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('32', 'HAJI ADAM &amp; SONS', 'HAJI ADAM &amp; SONS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('33', 'HASHMAT BHAI', 'HASHMAT BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('34', 'HUMAIRA INDUSTRIES', 'HUMAIRA INDUSTRIES', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('35', 'IFAN OPAI', 'IFAN OPAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('36', 'IMRAN NEW KARACHI', 'IMRAN NEW KARACHI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('37', 'J &amp; S', 'J &amp; S', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('38', 'JAHANZAIB BHAI', 'JAHANZAIB BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('39', 'KAMRAN FABRICS', 'KAMRAN FABRICS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('40', 'KASHIF MAMU', 'KASHIF MAMU', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('41', 'KHURAM BHAI GIZRI', 'KHURAM BHAI GIZRI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('42', 'M. SALEEM KHAN', 'M. SALEEM KHAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('43', 'M.E.M TRADERS', 'M.E.M TRADERS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('44', 'MANSOOR SB C/O KHAN INT', 'MANSOOR SB C/O KHAN INT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('45', 'MEHMOOD BROTHERS', 'MEHMOOD BROTHERS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('46', 'MMS GOLD', 'MMS GOLD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('47', 'MOIN CLOTH MARKET', 'MOIN CLOTH MARKET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('48', 'MTF TEXTILE', 'MTF TEXTILE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('49', 'MUBASHIR BHAI', 'MUBASHIR BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('50', 'MUMTAZ DUPATTA', 'MUMTAZ DUPATTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('51', 'NADEEM BHATTA', 'NADEEM BHATTA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('52', 'NASIR ENTERPRISES', 'NASIR ENTERPRISES', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('53', 'ORANGE TEXTILE', 'ORANGE TEXTILE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('54', 'QASMI INDUSTRIES', 'QASMI INDUSTRIES', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('55', 'RAFAY ONAWALA', 'RAFAY ONAWALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('56', 'RAHEEL SITE AREA', 'RAHEEL SITE AREA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('57', 'RAHEEL IQBAL SILK HOUSE', 'RAHEEL IQBAL SILK HOUSE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('58', 'SAAD FIMS', 'SAAD FIMS', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('59', 'SAJJID WASTAGE PAPER', 'SAJJID WASTAGE PAPER', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('60', 'SALEEM MOTI WALA', 'SALEEM MOTI WALA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('61', 'SALMAN ALISHAN', 'SALMAN ALISHAN', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('62', 'SALMAN BHAI (JENY)', 'SALMAN BHAI (JENY)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('63', 'SALMAN MANSOOR LHR', 'SALMAN MANSOOR LHR', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('64', 'SAMI BHAI T.M', 'SAMI BHAI T.M', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('65', 'SANA SAFINAZ', 'SANA SAFINAZ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('66', 'SAQIB BHAI', 'SAQIB BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('67', 'SAQIB BHAI WASTAGE', 'SAQIB BHAI WASTAGE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('68', 'SARA TEXTILE', 'SARA TEXTILE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('69', 'SENSE PRINTER', 'SENSE PRINTER', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('70', 'SHUJAT', 'SHUJAT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('71', 'SOHNI DHARTI', 'SOHNI DHARTI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('72', 'TALHA ARSHAD', 'TALHA ARSHAD', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('73', 'TALHA BHAI', 'TALHA BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('74', 'TEX LAB', 'TEX LAB', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('75', 'TREX ', 'TREX ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('76', 'UNIQUE CREATION', 'UNIQUE CREATION', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('77', 'VIP FLAG', 'VIP FLAG', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('78', 'WASEEM ENTERPRISE', 'WASEEM ENTERPRISE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('79', 'YASIR BHAI', 'YASIR BHAI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('80', 'ZAKARIA', 'ZAKARIA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('81', 'ZARINA TEX', 'ZARINA TEX', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('82', 'ZUBAIR DIGITAL ZONE', 'ZUBAIR DIGITAL ZONE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('83', 'ADIL BHAI', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('84', 'AKBAR ENTERPRISES', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('85', 'FAHAD MANA', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('86', 'FAZAL NOORANI', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('87', 'KARACHI PAPER', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('88', 'LANYU', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('89', 'MAN CHINA', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('90', 'RAYASAT KHAN', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('91', 'SOHAIL DESIGNER', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('92', 'WANG CHINA', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('93', 'XPO MARITIME', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('94', 'YARN PURCHASE', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0');

### Structure of table `0_currencies` ###

DROP TABLE IF EXISTS `0_currencies`;

CREATE TABLE `0_currencies` (
  `currency` varchar(60) NOT NULL DEFAULT '',
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) NOT NULL DEFAULT '',
  `country` varchar(100) NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_currencies` ###

INSERT INTO `0_currencies` VALUES
('CA Dollars', 'CAD', '$', 'Canada', 'Cents', '1', '0'),
('Euro', 'EUR', '€', 'Europe', 'Cents', '1', '0'),
('Pounds', 'GBP', '£', 'England', 'Pence', '1', '0'),
('Rupee', 'PKR', 'Rs', 'Pakistan', 'Rupees', '1', '0'),
('US Dollars', 'USD', '$', 'United States', 'Cents', '1', '0');

### Structure of table `0_cust_allocations` ###

DROP TABLE IF EXISTS `0_cust_allocations`;

CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trans_type_from` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_allocations` ###


### Structure of table `0_cust_branch` ###

DROP TABLE IF EXISTS `0_cust_branch`;

CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT 0,
  `br_name` varchar(60) NOT NULL DEFAULT '',
  `branch_ref` varchar(30) NOT NULL DEFAULT '',
  `br_address` tinytext NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT 0,
  `default_location` varchar(5) NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) NOT NULL DEFAULT '',
  `receivables_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT 1,
  `br_post_address` tinytext NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT 0,
  `notes` tinytext NOT NULL,
  `bank_account` varchar(60) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_branch` ###

INSERT INTO `0_cust_branch` VALUES
('1', '1', 'ABBAS BHAI', 'ABBAS BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('2', '2', 'ABU BAKAR ARSHAD', 'ABU BAKAR ARSHAD', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('3', '3', 'AFZAL SAHAB (LANYU)', 'AFZAL SAHAB (LANYU)', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('4', '4', 'AL NISA SAAD BHAI', 'AL NISA SAAD BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('5', '5', 'ALEEM SARJANI TOWN', 'ALEEM SARJANI TOWN', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('6', '6', 'ALI IQBAL CLOTH MARKET', 'ALI IQBAL CLOTH MARKET', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('7', '7', 'ALTAF HUSSAIN AFRIDI', 'ALTAF HUSSAIN AFRIDI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('8', '8', 'AMAR BHAI', 'AMAR BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('9', '9', 'AMIR KHATRI', 'AMIR KHATRI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('10', '10', 'ANIS LAKHANI', 'ANIS LAKHANI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('11', '11', 'ARIF BHAI', 'ARIF BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('12', '12', 'ARIF WASTE PAPER', 'ARIF WASTE PAPER', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('13', '13', 'ASIF PAPER WASTE', 'ASIF PAPER WASTE', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('14', '14', 'ASLAM BHAI', 'ASLAM BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('15', '15', 'AYESHA SOMAYA', 'AYESHA SOMAYA', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('16', '16', 'BABAR NAZIMABAD', 'BABAR NAZIMABAD', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('17', '17', 'BABOO NEW KARACHI', 'BABOO NEW KARACHI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('18', '18', 'BASHIR KHAN HIGHWAY', 'BASHIR KHAN HIGHWAY', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('19', '19', 'BOMBAY FAISHION', 'BOMBAY FAISHION', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('20', '20', 'CASH SALE', 'CASH SALE', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('21', '21', 'CENTRAL DYING', 'CENTRAL DYING', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('22', '22', 'CLR', 'CLR', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('23', '23', 'DANISH DAKHNI', 'DANISH DAKHNI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('24', '24', 'DECOTEX (ASGHAR BHAI)', 'DECOTEX (ASGHAR BHAI)', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('25', '25', 'DHANAK', 'DHANAK', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('26', '26', 'DINERS', 'DINERS', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('27', '27', 'EVOLUTION C/O ALI', 'EVOLUTION C/O ALI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('28', '28', 'FARHAN MOTI WALA', 'FARHAN MOTI WALA', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('29', '29', 'FARUKH BHAI', 'FARUKH BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('30', '30', 'GHANI BHAI', 'GHANI BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('31', '31', 'GULF FABRICS', 'GULF FABRICS', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('32', '32', 'HAJI ADAM &amp; SONS', 'HAJI ADAM &amp; SONS', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('33', '33', 'HASHMAT BHAI', 'HASHMAT BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('34', '34', 'HUMAIRA INDUSTRIES', 'HUMAIRA INDUSTRIES', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('35', '35', 'IFAN OPAI', 'IFAN OPAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('36', '36', 'IMRAN NEW KARACHI', 'IMRAN NEW KARACHI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('37', '37', 'J &amp; S', 'J &amp; S', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('38', '38', 'JAHANZAIB BHAI', 'JAHANZAIB BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('39', '39', 'KAMRAN FABRICS', 'KAMRAN FABRICS', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('40', '40', 'KASHIF MAMU', 'KASHIF MAMU', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('41', '41', 'KHURAM BHAI GIZRI', 'KHURAM BHAI GIZRI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('42', '42', 'M. SALEEM KHAN', 'M. SALEEM KHAN', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('43', '43', 'M.E.M TRADERS', 'M.E.M TRADERS', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('44', '44', 'MANSOOR SB C/O KHAN INT', 'MANSOOR SB C/O KHAN INT', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('45', '45', 'MEHMOOD BROTHERS', 'MEHMOOD BROTHERS', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('46', '46', 'MMS GOLD', 'MMS GOLD', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('47', '47', 'MOIN CLOTH MARKET', 'MOIN CLOTH MARKET', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('48', '49', 'MTF TEXTILE', 'MTF TEXTILE', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('49', '50', 'MUBASHIR BHAI', 'MUBASHIR BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('50', '51', 'MUMTAZ DUPATTA', 'MUMTAZ DUPATTA', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('51', '52', 'NADEEM BHATTA', 'NADEEM BHATTA', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('52', '53', 'NASIR ENTERPRISES', 'NASIR ENTERPRISES', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('53', '54', 'ORANGE TEXTILE', 'ORANGE TEXTILE', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('54', '55', 'QASMI INDUSTRIES', 'QASMI INDUSTRIES', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('55', '56', 'RAFAY ONAWALA', 'RAFAY ONAWALA', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('56', '57', 'RAHEEL SITE AREA', 'RAHEEL SITE AREA', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('57', '58', 'RAHEEL IQBAL SILK HOUSE', 'RAHEEL IQBAL SILK HOUSE', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('58', '59', 'SAAD FIMS', 'SAAD FIMS', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('59', '60', 'SAJJID WASTAGE PAPER', 'SAJJID WASTAGE PAPER', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('60', '61', 'SALEEM MOTI WALA', 'SALEEM MOTI WALA', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('61', '62', 'SALMAN ALISHAN', 'SALMAN ALISHAN', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('62', '63', 'SALMAN BHAI (JENY)', 'SALMAN BHAI (JENY)', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('63', '64', 'SALMAN MANSOOR LHR', 'SALMAN MANSOOR LHR', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('64', '65', 'SAMI BHAI T.M', 'SAMI BHAI T.M', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('65', '66', 'SANA SAFINAZ', 'SANA SAFINAZ', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('66', '67', 'SAQIB BHAI', 'SAQIB BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('67', '68', 'SAQIB BHAI WASTAGE', 'SAQIB BHAI WASTAGE', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('68', '69', 'SARA TEXTILE', 'SARA TEXTILE', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('69', '70', 'SENSE PRINTER', 'SENSE PRINTER', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('70', '71', 'SHUJAT', 'SHUJAT', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('71', '72', 'SOHNI DHARTI', 'SOHNI DHARTI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('72', '73', 'TALHA ARSHAD', 'TALHA ARSHAD', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('73', '74', 'TALHA BHAI', 'TALHA BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('74', '75', 'TEX LAB', 'TEX LAB', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('75', '76', 'TREX ', 'TREX ', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('76', '77', 'UNIQUE CREATION', 'UNIQUE CREATION', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('77', '78', 'VIP FLAG', 'VIP FLAG', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('78', '79', 'WASEEM ENTERPRISE', 'WASEEM ENTERPRISE', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('79', '80', 'YASIR BHAI', 'YASIR BHAI', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('80', '81', 'ZAKARIA', 'ZAKARIA', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('81', '82', 'ZARINA TEX', 'ZARINA TEX', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('82', '83', 'ZUBAIR DIGITAL ZONE', 'ZUBAIR DIGITAL ZONE', '', '6', '2', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0');

### Structure of table `0_debtor_trans` ###

DROP TABLE IF EXISTS `0_debtor_trans`;

CREATE TABLE `0_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `debtor_no` int(11) unsigned NOT NULL,
  `branch_code` int(11) NOT NULL DEFAULT -1,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT 0,
  `order_` int(11) NOT NULL DEFAULT 0,
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `ov_freight` double NOT NULL DEFAULT 0,
  `ov_freight_tax` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`),
  KEY `order_` (`order_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans` ###


### Structure of table `0_debtor_trans_details` ###

DROP TABLE IF EXISTS `0_debtor_trans_details`;

CREATE TABLE `0_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  `standard_cost` double NOT NULL DEFAULT 0,
  `qty_done` double NOT NULL DEFAULT 0,
  `src_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans_details` ###


### Structure of table `0_debtors_master` ###

DROP TABLE IF EXISTS `0_debtors_master`;

CREATE TABLE `0_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `debtor_ref` varchar(30) NOT NULL,
  `address` tinytext DEFAULT NULL,
  `tax_id` varchar(55) NOT NULL DEFAULT '',
  `curr_code` char(3) NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT 1,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `credit_status` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT 0,
  `pymt_discount` double NOT NULL DEFAULT 0,
  `credit_limit` float NOT NULL DEFAULT 1000,
  `notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtors_master` ###

INSERT INTO `0_debtors_master` VALUES
('1', 'ABBAS BHAI', 'ABBAS BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('2', 'ABU BAKAR ARSHAD', 'ABU BAKAR ARSHAD', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('3', 'AFZAL SAHAB (LANYU)', 'AFZAL SAHAB (LANYU)', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('4', 'AL NISA SAAD BHAI', 'AL NISA SAAD BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('5', 'ALEEM SARJANI TOWN', 'ALEEM SARJANI TOWN', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('6', 'ALI IQBAL CLOTH MARKET', 'ALI IQBAL CLOTH MARKET', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('7', 'ALTAF HUSSAIN AFRIDI', 'ALTAF HUSSAIN AFRIDI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('8', 'AMAR BHAI', 'AMAR BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('9', 'AMIR KHATRI', 'AMIR KHATRI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('10', 'ANIS LAKHANI', 'ANIS LAKHANI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('11', 'ARIF BHAI', 'ARIF BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('12', 'ARIF WASTE PAPER', 'ARIF WASTE PAPER', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('13', 'ASIF PAPER WASTE', 'ASIF PAPER WASTE', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('14', 'ASLAM BHAI', 'ASLAM BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('15', 'AYESHA SOMAYA', 'AYESHA SOMAYA', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('16', 'BABAR NAZIMABAD', 'BABAR NAZIMABAD', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('17', 'BABOO NEW KARACHI', 'BABOO NEW KARACHI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('18', 'BASHIR KHAN HIGHWAY', 'BASHIR KHAN HIGHWAY', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('19', 'BOMBAY FAISHION', 'BOMBAY FAISHION', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('20', 'CASH SALE', 'CASH SALE', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('21', 'CENTRAL DYING', 'CENTRAL DYING', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('22', 'CLR', 'CLR', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('23', 'DANISH DAKHNI', 'DANISH DAKHNI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('24', 'DECOTEX (ASGHAR BHAI)', 'DECOTEX (ASGHAR BHAI)', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('25', 'DHANAK', 'DHANAK', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('26', 'DINERS', 'DINERS', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('27', 'EVOLUTION C/O ALI', 'EVOLUTION C/O ALI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('28', 'FARHAN MOTI WALA', 'FARHAN MOTI WALA', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('29', 'FARUKH BHAI', 'FARUKH BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('30', 'GHANI BHAI', 'GHANI BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('31', 'GULF FABRICS', 'GULF FABRICS', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('32', 'HAJI ADAM &amp; SONS', 'HAJI ADAM &amp; SONS', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('33', 'HASHMAT BHAI', 'HASHMAT BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('34', 'HUMAIRA INDUSTRIES', 'HUMAIRA INDUSTRIES', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('35', 'IFAN OPAI', 'IFAN OPAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('36', 'IMRAN NEW KARACHI', 'IMRAN NEW KARACHI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('37', 'J &amp; S', 'J &amp; S', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('38', 'JAHANZAIB BHAI', 'JAHANZAIB BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('39', 'KAMRAN FABRICS', 'KAMRAN FABRICS', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('40', 'KASHIF MAMU', 'KASHIF MAMU', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('41', 'KHURAM BHAI GIZRI', 'KHURAM BHAI GIZRI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('42', 'M. SALEEM KHAN', 'M. SALEEM KHAN', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('43', 'M.E.M TRADERS', 'M.E.M TRADERS', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('44', 'MANSOOR SB C/O KHAN INT', 'MANSOOR SB C/O KHAN INT', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('45', 'MEHMOOD BROTHERS', 'MEHMOOD BROTHERS', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('46', 'MMS GOLD', 'MMS GOLD', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('47', 'MOIN CLOTH MARKET', 'MOIN CLOTH MARKET', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('49', 'MTF TEXTILE', 'MTF TEXTILE', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('50', 'MUBASHIR BHAI', 'MUBASHIR BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('51', 'MUMTAZ DUPATTA', 'MUMTAZ DUPATTA', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('52', 'NADEEM BHATTA', 'NADEEM BHATTA', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('53', 'NASIR ENTERPRISES', 'NASIR ENTERPRISES', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('54', 'ORANGE TEXTILE', 'ORANGE TEXTILE', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('55', 'QASMI INDUSTRIES', 'QASMI INDUSTRIES', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('56', 'RAFAY ONAWALA', 'RAFAY ONAWALA', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('57', 'RAHEEL SITE AREA', 'RAHEEL SITE AREA', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('58', 'RAHEEL IQBAL SILK HOUSE', 'RAHEEL IQBAL SILK HOUSE', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('59', 'SAAD FIMS', 'SAAD FIMS', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('60', 'SAJJID WASTAGE PAPER', 'SAJJID WASTAGE PAPER', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('61', 'SALEEM MOTI WALA', 'SALEEM MOTI WALA', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('62', 'SALMAN ALISHAN', 'SALMAN ALISHAN', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('63', 'SALMAN BHAI (JENY)', 'SALMAN BHAI (JENY)', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('64', 'SALMAN MANSOOR LHR', 'SALMAN MANSOOR LHR', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('65', 'SAMI BHAI T.M', 'SAMI BHAI T.M', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('66', 'SANA SAFINAZ', 'SANA SAFINAZ', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('67', 'SAQIB BHAI', 'SAQIB BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('68', 'SAQIB BHAI WASTAGE', 'SAQIB BHAI WASTAGE', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('69', 'SARA TEXTILE', 'SARA TEXTILE', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('70', 'SENSE PRINTER', 'SENSE PRINTER', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('71', 'SHUJAT', 'SHUJAT', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('72', 'SOHNI DHARTI', 'SOHNI DHARTI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('73', 'TALHA ARSHAD', 'TALHA ARSHAD', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('74', 'TALHA BHAI', 'TALHA BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('75', 'TEX LAB', 'TEX LAB', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('76', 'TREX ', 'TREX ', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('77', 'UNIQUE CREATION', 'UNIQUE CREATION', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('78', 'VIP FLAG', 'VIP FLAG', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('79', 'WASEEM ENTERPRISE', 'WASEEM ENTERPRISE', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('80', 'YASIR BHAI', 'YASIR BHAI', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('81', 'ZAKARIA', 'ZAKARIA', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('82', 'ZARINA TEX', 'ZARINA TEX', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('83', 'ZUBAIR DIGITAL ZONE', 'ZUBAIR DIGITAL ZONE', NULL, '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0');

### Structure of table `0_dimensions` ###

DROP TABLE IF EXISTS `0_dimensions`;

CREATE TABLE `0_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT 1,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_dimensions` ###

INSERT INTO `0_dimensions` VALUES
('1', '001/2022', 'F B Area DIM', '1', '0', '2022-03-30', '2022-04-19');

### Structure of table `0_exchange_rates` ###

DROP TABLE IF EXISTS `0_exchange_rates`;

CREATE TABLE `0_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT 0,
  `rate_sell` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_exchange_rates` ###

INSERT INTO `0_exchange_rates` VALUES
('1', 'USD', '189.28', '189.28', '2022-05-11'),
('2', 'USD', '189.28', '189.28', '2022-05-17'),
('3', 'USD', '189.28', '189.28', '2022-05-19'),
('4', 'USD', '189.28', '189.28', '2022-05-20'),
('5', 'USD', '189.28', '189.28', '2022-05-22'),
('6', 'USD', '189.28', '189.28', '2022-06-02'),
('7', 'USD', '189.28', '189.28', '2022-06-03'),
('8', 'USD', '189.28', '189.28', '2022-06-09'),
('9', 'USD', '189.28', '189.28', '2022-06-15');

### Structure of table `0_fiscal_year` ###

DROP TABLE IF EXISTS `0_fiscal_year`;

CREATE TABLE `0_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_fiscal_year` ###

INSERT INTO `0_fiscal_year` VALUES
('1', '2020-01-01', '2020-12-31', '1'),
('2', '2021-01-01', '2021-12-31', '0'),
('3', '2022-01-01', '2022-12-31', '0');

### Structure of table `0_gl_trans` ###

DROP TABLE IF EXISTS `0_gl_trans`;

CREATE TABLE `0_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT 0,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `memo_` tinytext NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob DEFAULT NULL,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_gl_trans` ###

INSERT INTO `0_gl_trans` VALUES
('1', '0', '1', '2022-12-16', '0001', '', '0', '0', '0', NULL, NULL),
('2', '0', '1', '2022-12-16', '1065', '', '0', '0', '0', NULL, NULL),
('3', '25', '1', '2022-12-16', '1510', 'SUB01', '0', '0', '0', NULL, NULL),
('4', '25', '1', '2022-12-16', '1550', '', '0', '0', '0', NULL, NULL),
('5', '20', '1', '2022-12-16', '2150', '', '0', '0', '0', NULL, NULL),
('6', '20', '1', '2022-12-16', '2100', '', '0', '0', '0', '3', '9'),
('7', '20', '1', '2022-12-16', '1550', '', '0', '0', '0', NULL, NULL),
('8', '20', '2', '2022-12-16', '2150', '', '0', '0', '0', NULL, NULL),
('9', '20', '2', '2022-12-16', '2100', '', '0', '0', '0', '3', '9'),
('10', '20', '2', '2022-12-16', '1550', '', '0', '0', '0', NULL, NULL),
('11', '20', '3', '2022-12-16', '2150', '', '0', '0', '0', NULL, NULL),
('12', '20', '3', '2022-12-16', '2100', '', '0', '0', '0', '3', '9'),
('13', '20', '3', '2022-12-16', '1550', '', '0', '0', '0', NULL, NULL),
('14', '25', '1', '2022-12-16', '1510', 'GRN Removal', '0', '0', '0', NULL, NULL),
('15', '25', '1', '2022-12-16', '1550', 'GRN Removal', '0', '0', '0', NULL, NULL),
('16', '25', '1', '2022-12-16', '1510', 'GRN Removal', '0', '0', '0', NULL, NULL),
('17', '25', '1', '2022-12-16', '1550', 'GRN Removal', '0', '0', '0', NULL, NULL),
('18', '25', '1', '2022-12-16', '1510', 'GRN Removal', '0', '0', '0', NULL, NULL),
('19', '25', '1', '2022-12-16', '1550', 'GRN Removal', '0', '0', '0', NULL, NULL),
('20', '25', '1', '2022-12-16', '1510', 'GRN Removal', '0', '0', '0', NULL, NULL),
('21', '25', '1', '2022-12-16', '1550', 'GRN Removal', '0', '0', '0', NULL, NULL),
('22', '25', '2', '2022-12-20', '1510', 'OPENING01', '0', '0', '0', NULL, NULL),
('23', '25', '2', '2022-12-20', '1550', '', '0', '0', '0', NULL, NULL),
('24', '20', '4', '2022-12-20', '2150', '', '0', '0', '0', NULL, NULL),
('25', '20', '4', '2022-12-20', '2100', '', '0', '0', '0', '3', '1'),
('26', '20', '4', '2022-12-20', '1550', '', '0', '0', '0', NULL, NULL),
('27', '25', '3', '2022-12-20', '1510', 'OPENING01', '0', '0', '0', NULL, NULL),
('28', '25', '3', '2022-12-20', '1550', '', '0', '0', '0', NULL, NULL),
('29', '20', '5', '2022-12-20', '2150', '', '0', '0', '0', NULL, NULL),
('30', '20', '5', '2022-12-20', '2100', '', '0', '0', '0', '3', '1'),
('31', '20', '5', '2022-12-20', '1550', '', '0', '0', '0', NULL, NULL),
('32', '25', '3', '2022-12-20', '1510', 'GRN Removal', '0', '0', '0', NULL, NULL),
('33', '25', '3', '2022-12-20', '1550', 'GRN Removal', '0', '0', '0', NULL, NULL),
('34', '25', '4', '2022-12-20', '1510', 'OPENING01', '0', '0', '0', NULL, NULL),
('35', '25', '4', '2022-12-20', '1550', '', '0', '0', '0', NULL, NULL),
('36', '20', '6', '2022-12-20', '2150', '', '0', '0', '0', NULL, NULL),
('37', '20', '6', '2022-12-20', '2100', '', '0', '0', '0', '3', '1'),
('38', '20', '6', '2022-12-20', '1550', '', '0', '0', '0', NULL, NULL),
('39', '25', '5', '2022-12-20', '1510', 'OPENING01', '3914004', '0', '0', NULL, NULL),
('40', '25', '5', '2022-12-20', '1550', '', '-3914004', '0', '0', NULL, NULL),
('41', '20', '7', '2022-12-20', '2150', '', '0', '0', '0', NULL, NULL),
('42', '20', '7', '2022-12-20', '2100', '', '0', '0', '0', '3', '6'),
('43', '20', '7', '2022-12-20', '1550', '', '0', '0', '0', NULL, NULL);

### Structure of table `0_grn_batch` ###

DROP TABLE IF EXISTS `0_grn_batch`;

CREATE TABLE `0_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) DEFAULT NULL,
  `rate` double DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_batch` ###

INSERT INTO `0_grn_batch` VALUES
('1', '9', '1', 'auto', '2022-12-16', 'DEF', '1'),
('2', '1', '2', 'auto', '2022-12-20', 'DEF', '1'),
('3', '1', '3', 'auto', '2022-12-20', 'DEF', '1'),
('4', '1', '4', 'auto', '2022-12-20', 'DEF', '1'),
('5', '6', '5', 'auto', '2022-12-20', 'DEF', '1');

### Structure of table `0_grn_items` ###

DROP TABLE IF EXISTS `0_grn_items`;

CREATE TABLE `0_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `qty_recd` double NOT NULL DEFAULT 0,
  `quantity_inv` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_items` ###

INSERT INTO `0_grn_items` VALUES
('1', '1', '1', 'SUB01', 'SUBPAPER 44&quot;X35GX400M', '0', '0'),
('2', '2', '2', 'OPENING01', 'OPENING', '0', '0'),
('3', '3', '3', 'OPENING01', 'OPENING', '0', '0'),
('4', '4', '4', 'OPENING01', 'OPENING', '0', '0'),
('5', '5', '5', 'OPENING01', 'OPENING', '1', '0');

### Structure of table `0_groups` ###

DROP TABLE IF EXISTS `0_groups`;

CREATE TABLE `0_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_groups` ###

INSERT INTO `0_groups` VALUES
('1', 'Small', '0'),
('2', 'Medium', '0'),
('3', 'Large', '0');

### Structure of table `0_item_codes` ###

DROP TABLE IF EXISTS `0_item_codes`;

CREATE TABLE `0_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) NOT NULL,
  `stock_id` varchar(20) NOT NULL,
  `description` varchar(200) NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT 1,
  `is_foreign` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_codes` ###

INSERT INTO `0_item_codes` VALUES
('1', 'SUB01', 'SUB01', 'SUBPAPER 44&quot;X35GX400M', '14', '1', '0', '0'),
('2', 'SUB02', 'SUB02', 'SUBPAPER 60&quot;X40GX300M', '14', '1', '0', '0'),
('3', 'SUBINK01', 'SUBINK01', 'SUB INK BK', '1', '1', '0', '0'),
('4', 'SUBINK02', 'SUBINK02', 'SUB INK C', '1', '1', '0', '0'),
('6', 'PRINTING02', 'PRINTING02', 'PRINTING 60&quot;', '4', '1', '0', '0'),
('7', 'PRINTING01', 'PRINTING01', 'PRINTING 44&quot;', '4', '1', '0', '0'),
('8', 'OPENING01', 'OPENING01', 'OPENING', '1', '1', '0', '0');

### Structure of table `0_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `0_item_tax_type_exemptions`;

CREATE TABLE `0_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_type_exemptions` ###


### Structure of table `0_item_tax_types` ###

DROP TABLE IF EXISTS `0_item_tax_types`;

CREATE TABLE `0_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_types` ###

INSERT INTO `0_item_tax_types` VALUES
('1', 'Regular', '0', '0');

### Structure of table `0_item_units` ###

DROP TABLE IF EXISTS `0_item_units`;

CREATE TABLE `0_item_units` (
  `abbr` varchar(20) NOT NULL,
  `name` varchar(40) NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_units` ###

INSERT INTO `0_item_units` VALUES
('BG', 'Bag', '4', '0'),
('each', 'Each', '0', '0'),
('GRM', 'GRM', '4', '0'),
('hr', 'Hours', '0', '0'),
('KG', 'KG', '4', '0'),
('LBS', 'LBS', '2', '0'),
('Ltr', 'Ltr', '-1', '0'),
('MT', 'MT', '4', '0');

### Structure of table `0_journal` ###

DROP TABLE IF EXISTS `0_journal`;

CREATE TABLE `0_journal` (
  `type` smallint(6) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `source_ref` varchar(60) NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_journal` ###

INSERT INTO `0_journal` VALUES
('0', '1', '2022-12-16', '001/2022', '', '2022-12-16', '2022-12-16', 'PKR', '0', '1');

### Structure of table `0_loc_stock` ###

DROP TABLE IF EXISTS `0_loc_stock`;

CREATE TABLE `0_loc_stock` (
  `loc_code` char(5) NOT NULL DEFAULT '',
  `stock_id` char(20) NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_loc_stock` ###

INSERT INTO `0_loc_stock` VALUES
('001', 'OPENING01', '0'),
('001', 'PRINTING01', '0'),
('001', 'PRINTING02', '0'),
('001', 'SUB01', '0'),
('001', 'SUB02', '0'),
('001', 'SUBINK01', '0'),
('001', 'SUBINK02', '0'),
('DEF', 'OPENING01', '0'),
('DEF', 'PRINTING01', '0'),
('DEF', 'PRINTING02', '0'),
('DEF', 'SUB01', '0'),
('DEF', 'SUB02', '0'),
('DEF', 'SUBINK01', '0'),
('DEF', 'SUBINK02', '0');

### Structure of table `0_locations` ###

DROP TABLE IF EXISTS `0_locations`;

CREATE TABLE `0_locations` (
  `loc_code` varchar(5) NOT NULL DEFAULT '',
  `location_name` varchar(60) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `phone` varchar(30) NOT NULL DEFAULT '',
  `phone2` varchar(30) NOT NULL DEFAULT '',
  `fax` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `contact` varchar(30) NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_locations` ###

INSERT INTO `0_locations` VALUES
('001', 'Fixed assets Loc', 'Fixed assets Loc', '', '', '', '', '', '1', '0'),
('DEF', 'Default', 'N/A', '', '', '', '', '', '0', '0');

### Structure of table `0_master_login` ###

DROP TABLE IF EXISTS `0_master_login`;

CREATE TABLE `0_master_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) NOT NULL,
  `role` int(11) NOT NULL,
  `companies` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_master_login` ###

INSERT INTO `0_master_login` VALUES
('1', 'admin', '2', 'YTowOnt9'),
('2', 'sales', '3', 'YToxOntpOjA7aTowO30='),
('3', 'trading', '11', 'YToxOntpOjA7aTowO30='),
('4', 'erp1', '12', 'YToxOntpOjA7aTowO30=');

### Structure of table `0_payment_terms` ###

DROP TABLE IF EXISTS `0_payment_terms`;

CREATE TABLE `0_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT 0,
  `day_in_following_month` smallint(6) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payment_terms` ###

INSERT INTO `0_payment_terms` VALUES
('1', 'Due 15th Of the Following Month', '0', '17', '0'),
('2', 'Due By End Of The Following Month', '0', '30', '0'),
('3', 'Payment due within 10 days', '10', '0', '0'),
('4', 'Cash Only', '0', '0', '0'),
('5', 'Prepaid', '-1', '0', '0');

### Structure of table `0_prices` ###

DROP TABLE IF EXISTS `0_prices`;

CREATE TABLE `0_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT 0,
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_prices` ###


### Structure of table `0_print_profiles` ###

DROP TABLE IF EXISTS `0_print_profiles`;

CREATE TABLE `0_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) NOT NULL,
  `report` varchar(5) DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_print_profiles` ###

INSERT INTO `0_print_profiles` VALUES
('1', 'Out of office', NULL, '0'),
('2', 'Sales Department', NULL, '0'),
('3', 'Central', NULL, '2'),
('4', 'Sales Department', '104', '2'),
('5', 'Sales Department', '105', '2'),
('6', 'Sales Department', '107', '2'),
('7', 'Sales Department', '109', '2'),
('8', 'Sales Department', '110', '2'),
('9', 'Sales Department', '201', '2');

### Structure of table `0_printers` ###

DROP TABLE IF EXISTS `0_printers`;

CREATE TABLE `0_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` varchar(60) NOT NULL,
  `queue` varchar(20) NOT NULL,
  `host` varchar(40) NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_printers` ###

INSERT INTO `0_printers` VALUES
('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20'),
('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5'),
('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

### Structure of table `0_purch_data` ###

DROP TABLE IF EXISTS `0_purch_data`;

CREATE TABLE `0_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  `suppliers_uom` char(50) NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT 1,
  `supplier_description` char(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_data` ###

INSERT INTO `0_purch_data` VALUES
('1', 'OPENING01', '3656.65', '', '1', 'OPENING'),
('6', 'OPENING01', '3914004', '', '1', 'OPENING'),
('9', 'SUB01', '9000', '', '1', 'SUBPAPER 44&quot;X35GX400M');

### Structure of table `0_purch_order_details` ###

DROP TABLE IF EXISTS `0_purch_order_details`;

CREATE TABLE `0_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `act_price` double NOT NULL DEFAULT 0,
  `std_cost_unit` double NOT NULL DEFAULT 0,
  `quantity_ordered` double NOT NULL DEFAULT 0,
  `quantity_received` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_order_details` ###

INSERT INTO `0_purch_order_details` VALUES
('5', '5', 'OPENING01', 'OPENING', '2022-12-20', '0', '3914004', '3914004', '3914004', '1', '1');

### Structure of table `0_purch_orders` ###

DROP TABLE IF EXISTS `0_purch_orders`;

CREATE TABLE `0_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext NOT NULL,
  `requisition_no` tinytext DEFAULT NULL,
  `into_stock_location` varchar(5) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_orders` ###

INSERT INTO `0_purch_orders` VALUES
('5', '6', 'opening invoice', '2022-12-20', 'auto', '001/2022', 'DEF', 'N/A', '4579384.68', '0', '0', '0');

### Structure of table `0_quick_entries` ###

DROP TABLE IF EXISTS `0_quick_entries`;

CREATE TABLE `0_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `description` varchar(60) NOT NULL,
  `usage` varchar(120) DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT 0,
  `base_desc` varchar(60) DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entries` ###


### Structure of table `0_quick_entry_lines` ###

DROP TABLE IF EXISTS `0_quick_entry_lines`;

CREATE TABLE `0_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT 0,
  `memo` tinytext NOT NULL,
  `action` varchar(2) NOT NULL,
  `dest_id` varchar(15) NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entry_lines` ###


### Structure of table `0_recurrent_invoices` ###

DROP TABLE IF EXISTS `0_recurrent_invoices`;

CREATE TABLE `0_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT 0,
  `monthly` int(11) NOT NULL DEFAULT 0,
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_recurrent_invoices` ###


### Structure of table `0_reflines` ###

DROP TABLE IF EXISTS `0_reflines`;

CREATE TABLE `0_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) NOT NULL DEFAULT '',
  `pattern` varchar(35) NOT NULL DEFAULT '1',
  `description` varchar(60) NOT NULL DEFAULT '',
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_reflines` ###

INSERT INTO `0_reflines` VALUES
('1', '0', '', '{001}/{YYYY}', '', '1', '0'),
('2', '1', '', '{001}/{YYYY}', '', '1', '0'),
('3', '2', '', '{001}/{YYYY}', '', '1', '0'),
('4', '4', '', '{001}/{YYYY}', '', '1', '0'),
('5', '10', '', '{001}/{YYYY}', '', '1', '0'),
('6', '11', '', '{001}/{YYYY}', '', '1', '0'),
('7', '12', '', '{001}/{YYYY}', '', '1', '0'),
('8', '13', '', '{001}/{YYYY}', '', '1', '0'),
('9', '16', '', '{001}/{YYYY}', '', '1', '0'),
('10', '17', '', '{001}/{YYYY}', '', '1', '0'),
('11', '18', '', '{001}/{YYYY}', '', '1', '0'),
('12', '20', '', '{001}/{YYYY}', '', '1', '0'),
('13', '21', '', '{001}/{YYYY}', '', '1', '0'),
('14', '22', '', '{001}/{YYYY}', '', '1', '0'),
('15', '25', '', '{001}/{YYYY}', '', '1', '0'),
('16', '26', '', '{001}/{YYYY}', '', '1', '0'),
('17', '28', '', '{001}/{YYYY}', '', '1', '0'),
('18', '29', '', '{001}/{YYYY}', '', '1', '0'),
('19', '30', '', '{001}/{YYYY}', '', '1', '0'),
('20', '32', '', '{001}/{YYYY}', '', '1', '0'),
('21', '35', '', '{001}/{YYYY}', '', '1', '0'),
('22', '40', '', '{001}/{YYYY}', '', '1', '0');

### Structure of table `0_refs` ###

DROP TABLE IF EXISTS `0_refs`;

CREATE TABLE `0_refs` (
  `id` int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_refs` ###

INSERT INTO `0_refs` VALUES
('1', '0', '001/2022'),
('1', '20', '001/2022'),
('2', '20', '001/2022'),
('3', '20', '001/2022'),
('4', '20', '001/2022'),
('5', '20', '001/2022'),
('6', '20', '001/2022'),
('7', '20', '001/2022');

### Structure of table `0_requisition_details` ###

DROP TABLE IF EXISTS `0_requisition_details`;

CREATE TABLE `0_requisition_details` (
  `requisition_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) DEFAULT NULL,
  `item_code` varchar(20) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `lpo_id` int(11) DEFAULT 0,
  `order_quantity` int(11) NOT NULL DEFAULT 0,
  `estimate_price` double NOT NULL DEFAULT 0,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `price` double NOT NULL DEFAULT 0,
  `purpose` varchar(320) DEFAULT NULL,
  PRIMARY KEY (`requisition_detail_id`),
  KEY `0_requisition_details_requisition_id` (`requisition_id`),
  KEY `0_requisition_details_item_code` (`item_code`),
  KEY `0_requisition_details_supplier_id` (`supplier_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisition_details` ###


### Structure of table `0_requisitions` ###

DROP TABLE IF EXISTS `0_requisitions`;

CREATE TABLE `0_requisitions` (
  `requisition_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) DEFAULT NULL,
  `narrative` varchar(240) DEFAULT NULL,
  `application_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `completed` tinyint(4) NOT NULL DEFAULT 0,
  `processed` tinyint(4) NOT NULL DEFAULT 0,
  `inactive` tinyint(4) NOT NULL DEFAULT 0,
  `details` text DEFAULT NULL,
  PRIMARY KEY (`requisition_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisitions` ###


### Structure of table `0_sales_order_details` ###

DROP TABLE IF EXISTS `0_sales_order_details`;

CREATE TABLE `0_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `stk_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `qty_sent` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `invoiced` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_order_details` ###


### Structure of table `0_sales_orders` ###

DROP TABLE IF EXISTS `0_sales_orders`;

CREATE TABLE `0_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `debtor_no` int(11) NOT NULL DEFAULT 0,
  `branch_code` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) NOT NULL DEFAULT '',
  `customer_ref` tinytext NOT NULL,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT 0,
  `ship_via` int(11) NOT NULL DEFAULT 0,
  `delivery_address` tinytext NOT NULL,
  `contact_phone` varchar(30) DEFAULT NULL,
  `contact_email` varchar(100) DEFAULT NULL,
  `deliver_to` tinytext NOT NULL,
  `freight_cost` double NOT NULL DEFAULT 0,
  `from_stk_loc` varchar(5) NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`trans_type`,`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_orders` ###


### Structure of table `0_sales_pos` ###

DROP TABLE IF EXISTS `0_sales_pos`;

CREATE TABLE `0_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_pos` ###

INSERT INTO `0_sales_pos` VALUES
('1', 'Default', '1', '1', 'DEF', '2', '0'),
('2', 'salman', '1', '1', 'DEF', '2', '0');

### Structure of table `0_sales_types` ###

DROP TABLE IF EXISTS `0_sales_types`;

CREATE TABLE `0_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT 0,
  `factor` double NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_types` ###

INSERT INTO `0_sales_types` VALUES
('1', 'Retail', '1', '1', '0'),
('2', 'Wholesale', '0', '0.7', '0'),
('3', 'Red', '0', '1', '0'),
('4', 'Platinum', '0', '1', '0'),
('5', 'Gold', '0', '1', '0');

### Structure of table `0_salesman` ###

DROP TABLE IF EXISTS `0_salesman`;

CREATE TABLE `0_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) NOT NULL DEFAULT '',
  `salesman_phone` char(30) NOT NULL DEFAULT '',
  `salesman_fax` char(30) NOT NULL DEFAULT '',
  `salesman_email` varchar(100) NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT 0,
  `break_pt` double NOT NULL DEFAULT 0,
  `provision2` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_salesman` ###

INSERT INTO `0_salesman` VALUES
('1', 'Sales Person', '', '', '', '5', '1000', '4', '0'),
('2', 'hameed', '03242149000', '`', '', '0', '0', '0', '0');

### Structure of table `0_security_roles` ###

DROP TABLE IF EXISTS `0_security_roles`;

CREATE TABLE `0_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) NOT NULL,
  `description` varchar(50) DEFAULT NULL,
  `sections` text DEFAULT NULL,
  `areas` text DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_security_roles` ###

INSERT INTO `0_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132;775', '0'),
('2', 'System Administrator', 'System Administrator', '256;512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128;287744', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;16129;16130;16131;16132;287844;287845', '0'),
('3', 'Salesman', 'Salesman', '768;3072;5632;8192;15872', '773;774;3073;3075;3081;5633;8194;15873;775', '0'),
('4', 'Stock Manager', 'Stock Manager', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '2818;2822;3073;3076;3077;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5640;5889;5890;5891;8193;8194;8450;8451;10753;11009;11010;11012;13313;13315;15882;16129;16130;16131;16132;775', '0'),
('5', 'Production Manager', 'Production Manager', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;2818;2819;2820;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5640;5640;5889;5890;5891;8193;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;2818;2819;2820;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5377;5633;5635;5640;5640;5889;5890;5891;8193;8194;8196;8197;8449;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('8', 'AP Officer', 'AP Officer', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;769;770;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5635;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15873;15874;15876;15877;15878;15879;15880;15882;16129;16130;16131;16132;775', '0'),
('11', 'Trading', 'Trading', '2816;3072;3328;5376;5632;5888;7936;8192;8448;15616;15872;16128;287744', '2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;287844;287845', '0'),
('12', 'ERP', 'ERP', '3072', '3073;3082;3075;3076;3077;3080;3081;2817;2818;2819;2820;2821;2822;2823;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;287844;287845', '0'),
('13', 'Direct Trans', 'Direct Trans', '512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;10496;10752;11008', '513;514;515;516;518;519;520;521;522;523;524;525;526;772;773;774;775;2817;2818;2819;2820;2821;2822;2823;3073;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012', '0');

### Structure of table `0_shippers` ###

DROP TABLE IF EXISTS `0_shippers`;

CREATE TABLE `0_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) NOT NULL DEFAULT '',
  `phone` varchar(30) NOT NULL DEFAULT '',
  `phone2` varchar(30) NOT NULL DEFAULT '',
  `contact` tinytext NOT NULL,
  `address` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_shippers` ###

INSERT INTO `0_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `0_sql_trail` ###

DROP TABLE IF EXISTS `0_sql_trail`;

CREATE TABLE `0_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sql_trail` ###


### Structure of table `0_stock_category` ###

DROP TABLE IF EXISTS `0_stock_category`;

CREATE TABLE `0_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `dflt_tax_type` int(11) NOT NULL DEFAULT 1,
  `dflt_units` varchar(20) NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_category` ###

INSERT INTO `0_stock_category` VALUES
('1', 'Components', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('2', 'Charges', '1', 'each', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('3', 'Systems', '1', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('4', 'Services', '1', 'hr', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('5', 'Machanical', '1', 'each', 'F', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('6', 'PUMP', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('7', 'CLEAR BOTTLE', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('8', 'PRINTED BOTTLE', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('9', 'CAPS', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('10', 'PRINTED BOXES', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('11', 'INNER', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('12', 'READY STOCKS', '1', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('13', 'PAPER BAGS', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('14', 'CARTONS', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('15', 'butail', '1', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('16', 'mek', '1', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0');

### Structure of table `0_stock_fa_class` ###

DROP TABLE IF EXISTS `0_stock_fa_class`;

CREATE TABLE `0_stock_fa_class` (
  `fa_class_id` varchar(20) NOT NULL DEFAULT '',
  `parent_id` varchar(20) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `long_description` tinytext NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_fa_class` ###

INSERT INTO `0_stock_fa_class` VALUES
('001', '01', 'Equipment', 'Equipment', '10', '0');

### Structure of table `0_stock_master` ###

DROP TABLE IF EXISTS `0_stock_master`;

CREATE TABLE `0_stock_master` (
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `description` varchar(200) NOT NULL DEFAULT '',
  `long_description` tinytext NOT NULL,
  `units` varchar(20) NOT NULL DEFAULT 'each',
  `mb_flag` char(1) NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `cogs_account` varchar(15) NOT NULL DEFAULT '',
  `inventory_account` varchar(15) NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) NOT NULL DEFAULT '',
  `wip_account` varchar(15) NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT 0,
  `material_cost` double NOT NULL DEFAULT 0,
  `labour_cost` double NOT NULL DEFAULT 0,
  `overhead_cost` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  `editable` tinyint(1) NOT NULL DEFAULT 0,
  `depreciation_method` char(1) NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `depreciation_factor` double NOT NULL DEFAULT 1,
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_master` ###

INSERT INTO `0_stock_master` VALUES
('OPENING01', '1', '1', 'OPENING', '', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '3914004', '3914004', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('PRINTING01', '4', '1', 'PRINTING 44&quot;', '', 'hr', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('PRINTING02', '4', '1', 'PRINTING 60&quot;', '', 'MT', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('SUB01', '14', '1', 'SUBPAPER 44&quot;X35GX400M', '', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '9000', '9000', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('SUB02', '14', '1', 'SUBPAPER 60&quot;X40GX300M', '', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('SUBINK01', '1', '1', 'SUB INK BK', '', 'BG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('SUBINK02', '1', '1', 'SUB INK C', '', 'BG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '');

### Structure of table `0_stock_moves` ###

DROP TABLE IF EXISTS `0_stock_moves`;

CREATE TABLE `0_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `price` double NOT NULL DEFAULT 0,
  `reference` char(40) NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT 1,
  `standard_cost` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_moves` ###

INSERT INTO `0_stock_moves` VALUES
('10', '5', 'OPENING01', '25', 'DEF', '2022-12-20', '3914004', '', '1', '3914004');

### Structure of table `0_supp_allocations` ###

DROP TABLE IF EXISTS `0_supp_allocations`;

CREATE TABLE `0_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trans_type_from` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_allocations` ###


### Structure of table `0_supp_invoice_items` ###

DROP TABLE IF EXISTS `0_supp_invoice_items`;

CREATE TABLE `0_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `quantity` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `memo_` tinytext DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_invoice_items` ###

INSERT INTO `0_supp_invoice_items` VALUES
('1', '1', '20', '0', '1', '1', 'SUB01', 'SUBPAPER 44&quot;X35GX400M', '0', '0', '1530', NULL, '0', '0'),
('2', '2', '20', '0', '1', '1', 'SUB01', 'SUBPAPER 44&quot;X35GX400M', '0', '0', '1530', NULL, '0', '0'),
('3', '3', '20', '0', '1', '1', 'SUB01', 'SUBPAPER 44&quot;X35GX400M', '0', '0', '1530', NULL, '0', '0'),
('4', '4', '20', '0', '2', '2', 'OPENING01', 'OPENING', '0', '0', '621.6305', NULL, '0', '0'),
('5', '5', '20', '0', '3', '3', 'OPENING01', 'OPENING', '0', '0', '621.63', NULL, '0', '0'),
('6', '6', '20', '0', '4', '4', 'OPENING01', 'OPENING', '0', '0', '621.6305', NULL, '0', '0'),
('7', '7', '20', '0', '5', '5', 'OPENING01', 'OPENING', '0', '0', '665380.68', NULL, '0', '0');

### Structure of table `0_supp_trans` ###

DROP TABLE IF EXISTS `0_supp_trans`;

CREATE TABLE `0_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `supplier_id` int(11) unsigned NOT NULL,
  `reference` tinytext NOT NULL,
  `supp_reference` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`type`,`trans_no`,`supplier_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_trans` ###

INSERT INTO `0_supp_trans` VALUES
('1', '20', '9', '001/2022', '1', '2022-12-16', '2022-12-16', '0', '0', '0', '1', '0', '0'),
('2', '20', '9', '001/2022', '1', '2022-12-16', '2022-12-16', '0', '0', '0', '1', '0', '0'),
('3', '20', '9', '001/2022', '1', '2022-12-16', '2022-12-16', '0', '0', '0', '1', '0', '0'),
('4', '20', '1', '001/2022', '1', '2022-12-20', '2022-12-20', '0', '0', '0', '1', '0', '0'),
('5', '20', '1', '001/2022', '1', '2022-12-20', '2022-12-20', '0', '0', '0', '1', '0', '0'),
('6', '20', '1', '001/2022', '1', '2022-12-20', '2022-12-20', '0', '0', '0', '1', '0', '0'),
('7', '20', '6', '001/2022', '001/2022', '2022-12-20', '2022-12-20', '0', '0', '0', '1', '0', '0');

### Structure of table `0_suppliers` ###

DROP TABLE IF EXISTS `0_suppliers`;

CREATE TABLE `0_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(60) NOT NULL DEFAULT '',
  `supp_ref` varchar(30) NOT NULL DEFAULT '',
  `address` tinytext NOT NULL,
  `supp_address` tinytext NOT NULL,
  `gst_no` varchar(25) NOT NULL DEFAULT '',
  `contact` varchar(60) NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) NOT NULL DEFAULT '',
  `website` varchar(100) NOT NULL DEFAULT '',
  `bank_account` varchar(60) NOT NULL DEFAULT '',
  `curr_code` char(3) DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT 0,
  `purchase_account` varchar(15) NOT NULL DEFAULT '',
  `payable_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_suppliers` ###

INSERT INTO `0_suppliers` VALUES
('1', 'ADIL BHAI', 'ADIL BHAI', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('2', 'AKBAR ENTERPRISES', 'AKBAR ENTERPRISES', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('3', 'FAHAD MANA', 'FAHAD MANA', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('4', 'FAZAL NOORANI', 'FAZAL NOORANI', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('5', 'KARACHI PAPER', 'KARACHI PAPER', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('6', 'LANYU', 'LANYU', '', '', '', '', '', '', '', 'PKR', '2', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('7', 'MAN CHINA', 'MAN CHINA', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('8', 'RAYASAT KHAN', 'RAYASAT KHAN', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('9', 'SOHAIL DESIGNER', 'SOHAIL DESIGNER', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('10', 'WANG CHINA', 'WANG CHINA', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('11', 'XPO MARITIME', 'XPO MARITIME', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('12', 'YARN PURCHASE', 'YARN PURCHASE', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0');

### Structure of table `0_sys_prefs` ###

DROP TABLE IF EXISTS `0_sys_prefs`;

CREATE TABLE `0_sys_prefs` (
  `name` varchar(35) NOT NULL DEFAULT '',
  `category` varchar(30) DEFAULT NULL,
  `type` varchar(20) NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sys_prefs` ###

INSERT INTO `0_sys_prefs` VALUES
('accounts_alpha', 'glsetup.general', 'tinyint', '1', '0'),
('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0'),
('add_pct', 'setup.company', 'int', '5', '-1'),
('allow_negative_prices', 'glsetup.inventory', 'tinyint', '1', '1'),
('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '0'),
('alternative_tax_include_on_docs', 'setup.company', 'tinyint', '1', ''),
('auto_curr_reval', 'setup.company', 'smallint', '6', '1'),
('bank_charge_act', 'glsetup.general', 'varchar', '15', '5690'),
('barcodes_on_stock', 'setup.company', 'tinyint', '1', '1'),
('base_sales', 'setup.company', 'int', '11', '0'),
('bcc_email', 'setup.company', 'varchar', '100', 'm_bilal1@hotmail.com'),
('company_logo_report', 'setup.company', 'tinyint', '1', '1'),
('coy_logo', 'setup.company', 'varchar', '100', '284375744_930632184407705_7925558631284759637_n.jpg'),
('coy_name', 'setup.company', 'varchar', '60', 'FALCONTEST'),
('coy_no', 'setup.company', 'varchar', '25', '+923322687080'),
('creditors_act', 'glsetup.purchase', 'varchar', '15', '2100'),
('curr_default', 'setup.company', 'char', '3', 'PKR'),
('debtors_act', 'glsetup.sales', 'varchar', '15', '1200'),
('default_adj_act', 'glsetup.items', 'varchar', '15', '5040'),
('default_cogs_act', 'glsetup.items', 'varchar', '15', '5010'),
('default_credit_limit', 'glsetup.customer', 'int', '11', '1000'),
('default_delivery_required', 'glsetup.sales', 'smallint', '6', '1'),
('default_dim_required', 'glsetup.dims', 'int', '11', '20'),
('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '4010'),
('default_inventory_act', 'glsetup.items', 'varchar', '15', '1510'),
('default_loss_on_asset_disposal_act', 'glsetup.items', 'varchar', '15', '5660'),
('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '4500'),
('default_quote_valid_days', 'glsetup.sales', 'smallint', '6', '30'),
('default_receival_required', 'glsetup.purchase', 'smallint', '6', '10'),
('default_sales_act', 'glsetup.sales', 'varchar', '15', '4010'),
('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '4510'),
('default_wip_act', 'glsetup.items', 'varchar', '15', '1530'),
('default_workorder_required', 'glsetup.manuf', 'int', '11', '20'),
('deferred_income_act', 'glsetup.sales', 'varchar', '15', '2105'),
('depreciation_period', 'glsetup.company', 'tinyint', '1', '1'),
('dim_on_recurrent_invoice', 'setup.company', 'tinyint', '1', '0'),
('domicile', 'setup.company', 'varchar', '55', 'KARCHI'),
('email', 'setup.company', 'varchar', '100', 'm_bilal1@hotmail.com'),
('exchange_diff_act', 'glsetup.general', 'varchar', '15', '4450'),
('f_year', 'setup.company', 'int', '11', '3'),
('fax', 'setup.company', 'varchar', '30', ''),
('freight_act', 'glsetup.customer', 'varchar', '15', '4430'),
('gl_closing_date', 'setup.closing_date', 'date', '8', ''),
('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', '1550'),
('gst_no', 'setup.company', 'varchar', '25', ''),
('legal_text', 'glsetup.customer', 'tinytext', '0', ''),
('loc_notification', 'glsetup.inventory', 'tinyint', '1', ''),
('login_tout', 'setup.company', 'smallint', '6', '6000000'),
('long_description_invoice', 'setup.company', 'tinyint', '1', '0'),
('max_days_in_docs', 'setup.company', 'smallint', '5', '180'),
('no_customer_list', 'setup.company', 'tinyint', '1', '0'),
('no_item_list', 'setup.company', 'tinyint', '1', '1'),
('no_supplier_list', 'setup.company', 'tinyint', '1', '0'),
('no_zero_lines_amount', 'glsetup.sales', 'tinyint', '1', '1'),
('past_due_days', 'glsetup.general', 'int', '11', '30'),
('phone', 'setup.company', 'varchar', '30', '+923322687080'),
('po_over_charge', 'glsetup.purchase', 'int', '11', '10'),
('po_over_receive', 'glsetup.purchase', 'int', '11', '10'),
('postal_address', 'setup.company', 'tinytext', '0', 'KARACHI PAKISTAN'),
('print_dialog_direct', 'setup.company', 'tinyint', '1', '0'),
('print_invoice_no', 'glsetup.sales', 'tinyint', '1', '0'),
('print_item_images_on_quote', 'glsetup.inventory', 'tinyint', '1', ''),
('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '9990'),
('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '5060'),
('ref_no_auto_increase', 'setup.company', 'tinyint', '1', '0'),
('retained_earnings_act', 'glsetup.general', 'varchar', '15', '3590'),
('round_to', 'setup.company', 'int', '5', '1'),
('shortname_name_in_list', 'setup.company', 'tinyint', '1', ''),
('show_po_item_codes', 'glsetup.purchase', 'tinyint', '1', ''),
('suppress_tax_rates', 'setup.company', 'tinyint', '1', ''),
('tax_algorithm', 'glsetup.customer', 'tinyint', '1', '1'),
('tax_last', 'setup.company', 'int', '11', '1'),
('tax_prd', 'setup.company', 'int', '11', '1'),
('time_zone', 'setup.company', 'tinyint', '1', '1'),
('use_dimension', 'setup.company', 'tinyint', '1', '1'),
('use_fixed_assets', 'setup.company', 'tinyint', '1', '1'),
('use_manufacturing', 'setup.company', 'tinyint', '1', '1'),
('version_id', 'system', 'varchar', '11', '2.4.1');

### Structure of table `0_tag_associations` ###

DROP TABLE IF EXISTS `0_tag_associations`;

CREATE TABLE `0_tag_associations` (
  `record_id` varchar(15) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`record_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tag_associations` ###


### Structure of table `0_tags` ###

DROP TABLE IF EXISTS `0_tags`;

CREATE TABLE `0_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(60) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tags` ###


### Structure of table `0_tax_group_items` ###

DROP TABLE IF EXISTS `0_tax_group_items`;

CREATE TABLE `0_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_shipping` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_group_items` ###

INSERT INTO `0_tax_group_items` VALUES
('1', '1', '1');

### Structure of table `0_tax_groups` ###

DROP TABLE IF EXISTS `0_tax_groups`;

CREATE TABLE `0_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_groups` ###

INSERT INTO `0_tax_groups` VALUES
('1', 'Tax', '0'),
('2', 'Tax Exempt', '0');

### Structure of table `0_tax_types` ###

DROP TABLE IF EXISTS `0_tax_types`;

CREATE TABLE `0_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT 0,
  `sales_gl_code` varchar(15) NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_types` ###

INSERT INTO `0_tax_types` VALUES
('1', '17', '2150', '2150', 'Tax', '0');

### Structure of table `0_trans_tax_details` ###

DROP TABLE IF EXISTS `0_trans_tax_details`;

CREATE TABLE `0_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 0,
  `ex_rate` double NOT NULL DEFAULT 1,
  `included_in_price` tinyint(1) NOT NULL DEFAULT 0,
  `net_amount` double NOT NULL DEFAULT 0,
  `amount` double NOT NULL DEFAULT 0,
  `memo` tinytext DEFAULT NULL,
  `reg_type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_trans_tax_details` ###

INSERT INTO `0_trans_tax_details` VALUES
('1', '20', '1', '2022-12-16', '1', '17', '1', '0', '0', '0', '1', '1'),
('2', '20', '2', '2022-12-16', '1', '17', '1', '0', '0', '0', '1', '1'),
('3', '20', '3', '2022-12-16', '1', '17', '1', '0', '0', '0', '1', '1'),
('4', '20', '4', '2022-12-20', '1', '17', '1', '0', '0', '0', '1', '1'),
('5', '20', '5', '2022-12-20', '1', '17', '1', '0', '0', '0', '1', '1'),
('6', '20', '6', '2022-12-20', '1', '17', '1', '0', '0', '0', '1', '1'),
('7', '20', '7', '2022-12-20', '1', '17', '1', '0', '0', '0', '001/2022', '1');

### Structure of table `0_useronline` ###

DROP TABLE IF EXISTS `0_useronline`;

CREATE TABLE `0_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(15) NOT NULL DEFAULT 0,
  `ip` varchar(40) NOT NULL DEFAULT '',
  `file` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_useronline` ###


### Structure of table `0_users` ###

DROP TABLE IF EXISTS `0_users`;

CREATE TABLE `0_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `real_name` varchar(100) NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT 1,
  `phone` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(100) DEFAULT NULL,
  `language` varchar(20) DEFAULT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT 0,
  `date_sep` tinyint(1) NOT NULL DEFAULT 0,
  `tho_sep` tinyint(1) NOT NULL DEFAULT 0,
  `dec_sep` tinyint(1) NOT NULL DEFAULT 0,
  `theme` varchar(20) NOT NULL DEFAULT 'LTE',
  `page_size` varchar(20) NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT 2,
  `qty_dec` smallint(6) NOT NULL DEFAULT 2,
  `rates_dec` smallint(6) NOT NULL DEFAULT 4,
  `percent_dec` smallint(6) NOT NULL DEFAULT 1,
  `show_gl` tinyint(1) NOT NULL DEFAULT 1,
  `show_codes` tinyint(1) NOT NULL DEFAULT 0,
  `show_hints` tinyint(1) NOT NULL DEFAULT 0,
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) unsigned NOT NULL DEFAULT 10,
  `graphic_links` tinyint(1) DEFAULT 1,
  `pos` smallint(6) DEFAULT 1,
  `print_profile` varchar(30) NOT NULL DEFAULT '',
  `rep_popup` tinyint(1) DEFAULT 1,
  `sticky_doc_date` tinyint(1) DEFAULT 0,
  `startup_tab` varchar(20) NOT NULL DEFAULT '',
  `transaction_days` smallint(6) NOT NULL DEFAULT 30,
  `save_report_selections` smallint(6) NOT NULL DEFAULT 0,
  `use_date_picker` tinyint(1) NOT NULL DEFAULT 1,
  `def_print_destination` tinyint(1) NOT NULL DEFAULT 0,
  `def_print_orientation` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_users` ###

INSERT INTO `0_users` VALUES
('1', 'admin', '81dc9bdb52d04dc20036dbd8313ed055', 'Administrator', '2', '', 'wrapandg@wrapandgoofficial.com', 'C', '1', '0', '0', '0', 'LTE', 'A4', '2', '2', '4', '1', '1', '0', '0', '2022-12-20 13:10:21', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('3', 'trading', '81dc9bdb52d04dc20036dbd8313ed055', 'Trading', '11', '', NULL, 'C', '0', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2022-11-29 06:37:04', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('4', 'erp1', '827ccb0eea8a706c4c34a16891f84e7b', 'ERP', '12', '', 'admin', 'C', '0', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2022-10-06 11:08:46', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('5', 'derp', '81dc9bdb52d04dc20036dbd8313ed055', 'direct trans', '13', '12345679', 'abc@gmail.com', 'C', '0', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2022-09-06 08:42:30', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0');

### Structure of table `0_voided` ###

DROP TABLE IF EXISTS `0_voided`;

CREATE TABLE `0_voided` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_voided` ###

INSERT INTO `0_voided` VALUES
('0', '1', '2022-12-20', ''),
('20', '1', '2022-12-16', 'Document reentered.'),
('20', '2', '2022-12-16', 'Document reentered.'),
('20', '3', '2022-12-20', ''),
('20', '4', '2022-12-20', ''),
('20', '5', '2022-12-20', ''),
('20', '6', '2022-12-20', ''),
('20', '7', '2022-12-20', 'void'),
('25', '1', '2022-12-20', ''),
('25', '2', '2022-12-20', ''),
('25', '3', '2022-12-20', ''),
('25', '4', '2022-12-20', '');

### Structure of table `0_wo_costing` ###

DROP TABLE IF EXISTS `0_wo_costing`;

CREATE TABLE `0_wo_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `cost_type` tinyint(1) NOT NULL DEFAULT 0,
  `trans_type` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `factor` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_costing` ###


### Structure of table `0_wo_issue_items` ###

DROP TABLE IF EXISTS `0_wo_issue_items`;

CREATE TABLE `0_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) DEFAULT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  `unit_cost` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issue_items` ###


### Structure of table `0_wo_issues` ###

DROP TABLE IF EXISTS `0_wo_issues`;

CREATE TABLE `0_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issues` ###


### Structure of table `0_wo_manufacture` ###

DROP TABLE IF EXISTS `0_wo_manufacture`;

CREATE TABLE `0_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_manufacture` ###


### Structure of table `0_wo_requirements` ###

DROP TABLE IF EXISTS `0_wo_requirements`;

CREATE TABLE `0_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT 0,
  `units_req` double NOT NULL DEFAULT 1,
  `unit_cost` double NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_requirements` ###


### Structure of table `0_workcentres` ###

DROP TABLE IF EXISTS `0_workcentres`;

CREATE TABLE `0_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) NOT NULL DEFAULT '',
  `description` char(50) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workcentres` ###

INSERT INTO `0_workcentres` VALUES
('1', 'Work Centre', '', '0'),
('2', 'Cap Station', 'Cap Station', '0'),
('3', 'Sticker Station', 'Sticker Station', '0'),
('4', 'Carton Station', 'Carton Station', '0');

### Structure of table `0_workorders` ###

DROP TABLE IF EXISTS `0_workorders`;

CREATE TABLE `0_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) NOT NULL DEFAULT '',
  `loc_code` varchar(5) NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT 1,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT 0,
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT 0,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `released` tinyint(1) NOT NULL DEFAULT 0,
  `additional_costs` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workorders` ###
