# MySQL dump of database 'nasakcaa_zone_eng' on host 'localhost'
# Backup Date and Time: 2025-06-05 15:57
# Built by digitleysystem 2.4.11
# http://digitleysystem
# Company: ZONE ENGINEERING
# User: Administrator

# Compatibility: 2.4.1


SET NAMES latin1;


### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('1', 'Global', '0');

### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_attachments` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `user` smallint(6) unsigned NOT NULL DEFAULT 0,
  `stamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `description` varchar(60) DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT 0,
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_audit_trail` ###

INSERT INTO `0_audit_trail` VALUES
('1', '17', '1', '1', '2025-05-29 04:03:40', NULL, '6', '2025-05-29', NULL),
('2', '17', '1', '1', '2025-05-29 04:03:40', 'Voided.\n', '6', '2025-05-29', '0'),
('3', '17', '2', '1', '2025-05-29 05:17:32', NULL, '6', '2025-05-29', '0'),
('4', '17', '3', '1', '2025-05-29 09:27:56', NULL, '6', '2025-05-29', '0'),
('5', '17', '4', '1', '2025-05-31 08:01:59', NULL, '6', '2025-05-31', NULL),
('6', '17', '4', '1', '2025-05-31 08:01:59', 'Voided.\n', '6', '2025-05-31', '0'),
('7', '17', '5', '1', '2025-06-02 03:00:37', NULL, '6', '2025-05-31', NULL),
('8', '17', '6', '1', '2025-06-02 03:00:25', NULL, '6', '2025-05-31', NULL),
('9', '26', '1', '1', '2025-05-31 08:08:59', NULL, '6', '2025-05-31', NULL),
('10', '26', '1', '1', '2025-05-31 08:08:59', 'Released.', '6', '2025-05-31', '0'),
('11', '29', '1', '1', '2025-05-31 08:08:59', 'Production.', '6', '2025-05-31', '0'),
('12', '28', '1', '1', '2025-05-31 08:09:00', NULL, '6', '2025-05-31', '0'),
('13', '28', '2', '1', '2025-05-31 08:09:00', NULL, '6', '2025-05-31', '0'),
('14', '0', '1', '1', '2025-06-02 04:57:16', NULL, '6', '2025-05-31', NULL),
('15', '17', '6', '1', '2025-06-02 03:00:25', 'Voided.\n', '6', '2025-06-02', '0'),
('16', '17', '5', '1', '2025-06-02 03:00:37', 'Voided.\n', '6', '2025-06-02', '0'),
('17', '35', '1', '1', '2025-06-02 04:15:32', NULL, '6', '2025-06-02', '0'),
('18', '17', '7', '1', '2025-06-02 04:16:55', NULL, '6', '2025-06-02', NULL),
('19', '0', '2', '1', '2025-06-02 04:57:13', NULL, '6', '2025-06-02', NULL),
('20', '0', '3', '1', '2025-06-02 04:57:09', NULL, '6', '2025-06-02', NULL),
('21', '17', '7', '1', '2025-06-02 04:16:55', 'Voided.\n', '6', '2025-06-02', '0'),
('22', '17', '8', '1', '2025-06-02 04:37:58', NULL, '6', '2025-06-02', NULL),
('23', '35', '2', '1', '2025-06-02 04:19:45', NULL, '6', '2025-06-02', '0'),
('24', '17', '9', '1', '2025-06-02 04:37:27', NULL, '6', '2025-06-02', NULL),
('25', '17', '10', '1', '2025-06-02 04:36:55', NULL, '6', '2025-06-02', NULL),
('26', '26', '2', '1', '2025-06-02 04:33:41', NULL, '6', '2025-06-02', NULL),
('27', '26', '2', '1', '2025-06-02 04:33:41', 'Released.', '6', '2025-06-02', '0'),
('28', '29', '2', '1', '2025-06-02 04:33:41', 'Production.', '6', '2025-06-02', '0'),
('29', '28', '3', '1', '2025-06-02 04:33:41', NULL, '6', '2025-06-02', '0'),
('30', '28', '4', '1', '2025-06-02 04:33:41', NULL, '6', '2025-06-02', '0'),
('31', '28', '5', '1', '2025-06-02 04:33:41', NULL, '6', '2025-06-02', '0'),
('32', '17', '10', '1', '2025-06-02 04:36:55', 'Voided.\n', '6', '2025-06-02', '0'),
('33', '17', '9', '1', '2025-06-02 04:37:27', 'Voided.\n', '6', '2025-06-02', '0'),
('34', '17', '8', '1', '2025-06-02 04:37:58', 'Voided.\n', '6', '2025-06-02', '0'),
('35', '17', '11', '1', '2025-06-02 04:57:56', NULL, '6', '2025-06-02', NULL),
('36', '17', '12', '1', '2025-06-02 04:57:47', NULL, '6', '2025-06-02', NULL),
('37', '0', '3', '1', '2025-06-02 04:57:09', 'Voided.\n', '6', '2025-06-02', '0'),
('38', '0', '2', '1', '2025-06-02 04:57:13', 'Voided.\n', '6', '2025-06-02', '0'),
('39', '0', '1', '1', '2025-06-02 04:57:16', 'Voided.\n', '6', '2025-06-02', '0'),
('40', '17', '12', '1', '2025-06-02 04:57:47', 'Voided.\n', '6', '2025-06-02', '0'),
('41', '17', '11', '1', '2025-06-02 04:57:56', 'Voided.\n', '6', '2025-06-02', '0'),
('42', '26', '3', '1', '2025-06-02 05:09:41', NULL, '6', '2025-06-02', NULL),
('43', '26', '3', '1', '2025-06-02 05:09:41', 'Released.', '6', '2025-06-02', '0'),
('44', '29', '3', '1', '2025-06-02 05:09:41', 'Production.', '6', '2025-06-02', '0'),
('45', '28', '6', '1', '2025-06-02 05:09:41', NULL, '6', '2025-06-02', '0'),
('46', '28', '7', '1', '2025-06-02 05:09:41', NULL, '6', '2025-06-02', '0'),
('47', '17', '13', '1', '2025-06-02 07:13:02', NULL, '6', '2025-06-02', NULL),
('48', '35', '3', '1', '2025-06-02 05:21:00', NULL, '6', '2025-06-02', '0'),
('49', '17', '14', '1', '2025-06-02 07:12:37', NULL, '6', '2025-06-02', NULL),
('50', '26', '4', '1', '2025-06-02 05:23:19', NULL, '6', '2025-06-02', NULL),
('51', '26', '4', '1', '2025-06-02 05:23:19', 'Released.', '6', '2025-06-02', '0'),
('52', '29', '4', '1', '2025-06-02 05:23:19', 'Production.', '6', '2025-06-02', '0'),
('53', '28', '8', '1', '2025-06-02 05:23:19', NULL, '6', '2025-06-02', '0'),
('54', '28', '9', '1', '2025-06-02 05:23:19', NULL, '6', '2025-06-02', '0'),
('55', '0', '4', '1', '2025-06-02 07:12:37', NULL, '6', '2025-06-02', '0'),
('56', '17', '14', '1', '2025-06-02 07:12:37', 'Voided.\n', '6', '2025-06-02', '0'),
('57', '17', '13', '1', '2025-06-02 07:13:02', 'Voided.\n', '6', '2025-06-02', '0'),
('58', '17', '15', '1', '2025-06-03 02:32:17', NULL, '6', '2025-06-03', '0'),
('59', '17', '16', '1', '2025-06-03 02:33:32', NULL, '6', '2025-06-03', '0'),
('60', '26', '5', '1', '2025-06-03 02:53:46', NULL, '6', '2025-06-03', NULL),
('61', '26', '5', '1', '2025-06-03 02:53:46', 'Released.', '6', '2025-06-03', '0'),
('62', '29', '5', '1', '2025-06-03 02:53:46', 'Production.', '6', '2025-06-03', '0'),
('63', '28', '10', '1', '2025-06-03 02:53:46', NULL, '6', '2025-06-03', '0'),
('64', '28', '11', '1', '2025-06-03 02:53:46', NULL, '6', '2025-06-03', '0'),
('65', '28', '12', '1', '2025-06-03 02:53:46', NULL, '6', '2025-06-03', '0'),
('66', '30', '1', '1', '2025-06-03 03:27:50', NULL, '6', '2025-06-03', '0'),
('67', '13', '1', '1', '2025-06-03 03:28:50', NULL, '6', '2025-06-03', NULL),
('68', '10', '1', '1', '2025-06-03 03:28:50', NULL, '6', '2025-06-03', NULL),
('69', '12', '1', '1', '2025-06-03 03:27:50', NULL, '6', '2025-06-03', '0'),
('70', '13', '1', '1', '2025-06-03 03:28:50', 'Voided.', '6', '2025-06-03', '0'),
('71', '10', '1', '1', '2025-06-03 03:28:50', 'Voided.\n', '6', '2025-06-03', '0'),
('72', '30', '2', '1', '2025-06-03 03:43:15', NULL, '6', '2025-06-03', '0'),
('73', '13', '2', '1', '2025-06-03 03:43:15', NULL, '6', '2025-06-03', '0'),
('74', '10', '2', '1', '2025-06-03 03:43:16', NULL, '6', '2025-06-03', '0'),
('75', '12', '2', '1', '2025-06-03 03:43:16', NULL, '6', '2025-06-03', '0'),
('76', '30', '3', '1', '2025-06-03 03:55:34', NULL, '6', '2025-06-03', '0'),
('77', '13', '3', '1', '2025-06-03 03:55:35', NULL, '6', '2025-06-03', '0'),
('78', '10', '3', '1', '2025-06-03 03:55:35', NULL, '6', '2025-06-03', '0'),
('79', '12', '3', '1', '2025-06-03 03:55:35', NULL, '6', '2025-06-03', '0'),
('80', '30', '4', '1', '2025-06-03 04:07:03', NULL, '6', '2025-06-03', '0'),
('81', '13', '4', '1', '2025-06-03 04:07:03', NULL, '6', '2025-06-03', '0'),
('82', '10', '4', '1', '2025-06-03 04:07:03', NULL, '6', '2025-06-03', '0'),
('83', '30', '5', '1', '2025-06-03 04:20:58', NULL, '6', '2025-06-03', '0'),
('84', '13', '5', '1', '2025-06-03 04:20:58', NULL, '6', '2025-06-03', '0'),
('85', '10', '5', '1', '2025-06-03 04:20:59', NULL, '6', '2025-06-03', '0'),
('86', '30', '6', '1', '2025-06-03 05:04:45', NULL, '6', '2025-06-03', '0'),
('87', '13', '6', '1', '2025-06-03 05:04:45', NULL, '6', '2025-06-03', '0'),
('88', '10', '6', '1', '2025-06-03 05:04:45', NULL, '6', '2025-06-03', '0'),
('89', '12', '4', '1', '2025-06-03 05:04:45', NULL, '6', '2025-06-03', '0'),
('90', '30', '7', '1', '2025-06-03 05:07:44', NULL, '6', '2025-06-03', '0'),
('91', '13', '7', '1', '2025-06-03 08:46:36', NULL, '6', '2025-06-03', NULL),
('92', '10', '7', '1', '2025-06-03 08:46:36', NULL, '6', '2025-06-03', NULL),
('93', '12', '5', '1', '2025-06-03 05:07:44', NULL, '6', '2025-06-03', '0'),
('94', '30', '8', '1', '2025-06-03 06:08:11', NULL, '6', '2025-06-03', '0'),
('95', '13', '8', '1', '2025-06-03 06:08:11', NULL, '6', '2025-06-03', '0'),
('96', '10', '8', '1', '2025-06-03 06:08:11', NULL, '6', '2025-06-03', '0'),
('97', '12', '6', '1', '2025-06-03 06:08:11', NULL, '6', '2025-06-03', '0'),
('98', '13', '7', '1', '2025-06-03 08:46:36', 'Voided.', '6', '2025-06-03', '0'),
('99', '10', '7', '1', '2025-06-03 08:46:36', 'Voided.\n', '6', '2025-06-03', '0'),
('100', '30', '9', '1', '2025-06-03 08:48:03', NULL, '6', '2025-06-03', '0'),
('101', '13', '9', '1', '2025-06-03 08:48:03', NULL, '6', '2025-06-03', '0'),
('102', '10', '9', '1', '2025-06-03 08:48:03', NULL, '6', '2025-06-03', '0'),
('103', '12', '7', '1', '2025-06-03 08:48:03', NULL, '6', '2025-06-03', '0'),
('104', '17', '17', '1', '2025-06-03 09:45:23', NULL, '6', '2025-06-03', '0'),
('105', '26', '6', '1', '2025-06-03 09:47:19', NULL, '6', '2025-06-03', NULL),
('106', '26', '6', '1', '2025-06-03 09:47:19', 'Released.', '6', '2025-06-03', '0'),
('107', '29', '6', '1', '2025-06-03 09:47:19', 'Production.', '6', '2025-06-03', '0'),
('108', '28', '13', '1', '2025-06-03 09:47:20', NULL, '6', '2025-06-03', '0'),
('109', '28', '14', '1', '2025-06-03 09:47:20', NULL, '6', '2025-06-03', '0'),
('110', '26', '7', '1', '2025-06-03 09:49:16', NULL, '6', '2025-06-03', NULL),
('111', '26', '7', '1', '2025-06-03 09:49:16', 'Released.', '6', '2025-06-03', '0'),
('112', '29', '7', '1', '2025-06-03 09:49:17', 'Production.', '6', '2025-06-03', '0'),
('113', '28', '15', '1', '2025-06-03 09:49:17', NULL, '6', '2025-06-03', '0'),
('114', '28', '16', '1', '2025-06-03 09:49:17', NULL, '6', '2025-06-03', '0'),
('115', '26', '8', '1', '2025-06-03 09:50:58', NULL, '6', '2025-06-03', NULL),
('116', '26', '8', '1', '2025-06-03 09:50:58', 'Released.', '6', '2025-06-03', '0'),
('117', '29', '8', '1', '2025-06-03 09:50:58', 'Production.', '6', '2025-06-03', '0'),
('118', '28', '17', '1', '2025-06-03 09:50:58', NULL, '6', '2025-06-03', '0'),
('119', '28', '18', '1', '2025-06-03 09:50:58', NULL, '6', '2025-06-03', '0'),
('120', '30', '10', '1', '2025-06-03 09:54:36', NULL, '6', '2025-06-03', '0'),
('121', '13', '10', '1', '2025-06-03 09:54:36', NULL, '6', '2025-06-03', '0'),
('122', '10', '10', '1', '2025-06-03 09:54:36', NULL, '6', '2025-06-03', '0'),
('123', '12', '8', '1', '2025-06-03 09:54:36', NULL, '6', '2025-06-03', '0');

### Structure of table `0_bank_accounts` ###

DROP TABLE IF EXISTS `0_bank_accounts`;

CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT 0,
  `bank_account_name` varchar(60) NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) NOT NULL DEFAULT '',
  `bank_name` varchar(60) NOT NULL DEFAULT '',
  `bank_address` tinytext DEFAULT NULL,
  `bank_curr_code` char(3) NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT 0,
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_bank_accounts` ###

INSERT INTO `0_bank_accounts` VALUES
('1060', '0', 'Current account', 'N/A', 'N/A', NULL, 'PKR', '1', '1', '5690', '0000-00-00 00:00:00', '0', '0'),
('1065', '3', 'Petty Cash account', 'N/A', 'N/A', NULL, 'PKR', '0', '2', '5690', '0000-00-00 00:00:00', '0', '0'),
('1066', '1', 'Petty Cheque Account', '', 'Petty Cheque Account', NULL, 'PKR', '0', '3', '5690', '0000-00-00 00:00:00', '0', '0'),
('1067', '3', 'Petty Cash MOHSIN', '', '', NULL, 'PKR', '0', '4', '5690', '0000-00-00 00:00:00', '0', '0'),
('1068', '3', 'Petty cash Shahbaz Engineer', '', '', NULL, 'PKR', '0', '5', '5690', '0000-00-00 00:00:00', '0', '0'),
('1070', '3', 'Petty cash Siddique', '', '', NULL, 'PKR', '0', '6', '5690', '0000-00-00 00:00:00', '0', '0'),
('1072', '3', 'Petty cash Papu', '', '', NULL, 'PKR', '0', '8', '5690', '0000-00-00 00:00:00', '0', '0'),
('1073', '3', 'Petty Cash SAIFULLAH', '', '', NULL, 'PKR', '0', '9', '5690', '0000-00-00 00:00:00', '0', '0'),
('1077', '3', 'BANK ALFALAH', '', 'bank alflah', NULL, 'PKR', '0', '10', '5690', '0000-00-00 00:00:00', '0', '0'),
('1076', '3', 'SONERI BANK', '', 'soneri bank', NULL, 'PKR', '0', '11', '5690', '0000-00-00 00:00:00', '0', '0'),
('1078', '3', 'DUBAI ISLAMIC BANK', '', 'dubai islamic bank', NULL, 'PKR', '0', '12', '5690', '0000-00-00 00:00:00', '0', '0'),
('1075', '3', 'MEZAAN BANK 4K', '', 'mezzan bank', NULL, 'PKR', '0', '13', '5690', '0000-00-00 00:00:00', '0', '0'),
('1074', '3', 'BANK ALHABIB 4K', '', 'al hbib 4k', NULL, 'PKR', '0', '14', '5690', '0000-00-00 00:00:00', '0', '0'),
('1081', '3', 'Petty Cash JHANGEER', '', 'Jhangeer petty cash', NULL, 'PKR', '0', '16', '5690', '0000-00-00 00:00:00', '0', '0'),
('1082', '3', 'Petty Cash ABDULLAH', '', 'Abdullah Petty cash ', NULL, 'PKR', '0', '17', '5690', '0000-00-00 00:00:00', '0', '0'),
('1083', '3', 'Petty Cash TAHIR LHR', '', 'Tahir petty cash', NULL, 'PKR', '0', '18', '5690', '0000-00-00 00:00:00', '0', '0'),
('1084', '3', 'BARA MAN', '', 'BARA MAN', NULL, 'PKR', '0', '19', '5690', '0000-00-00 00:00:00', '0', '0'),
('1085', '3', 'BANK ALHABIB NORTH KARACHI', '', 'al hbib north karachi', NULL, 'PKR', '0', '20', '5690', '0000-00-00 00:00:00', '0', '0'),
('1916', '3', 'Hassan', '', 'Hassan', NULL, 'PKR', '0', '22', '5690', '0000-00-00 00:00:00', '0', '0'),
('1917', '3', 'Hut ', '', 'Hut', NULL, 'PKR', '0', '23', '5690', '0000-00-00 00:00:00', '0', '0'),
('1080', '3', 'UNKNOWN ONLINE', '', '', NULL, 'PKR', '0', '25', '5690', '0000-00-00 00:00:00', '0', '0'),
('1920', '0', 'Unknow Meezan E-Zone', '', '', NULL, 'PKR', '0', '26', '5690', '0000-00-00 00:00:00', '0', '0'),
('7000', '3', 'Naveed LBR petty cash', '', 'Naveed LBR petty cash', NULL, 'PKR', '0', '27', '5690', '0000-00-00 00:00:00', '0', '0');

### Structure of table `0_bank_trans` ###

DROP TABLE IF EXISTS `0_bank_trans`;

CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) NOT NULL DEFAULT '',
  `ref` varchar(40) DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) NOT NULL DEFAULT 0,
  `person_id` tinyblob DEFAULT NULL,
  `account_no` varchar(50) NOT NULL DEFAULT '',
  `account_name` varchar(250) NOT NULL DEFAULT '',
  `entry_date` date NOT NULL DEFAULT '0000-00-00',
  `imported` tinyint(4) NOT NULL DEFAULT 0,
  `reconciled` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_bank_trans` ###

INSERT INTO `0_bank_trans` VALUES
('1', '12', '1', '2', '001/2025', '2025-06-03', '4500', '0', '0', '2', '96', '', '', '0000-00-00', '0', NULL),
('2', '12', '2', '2', '002/2025', '2025-06-03', '4500.36', '0', '0', '2', '98', '', '', '0000-00-00', '0', NULL),
('3', '12', '3', '2', '003/2025', '2025-06-03', '1923174', '0', '0', '2', '99', '', '', '0000-00-00', '0', NULL),
('4', '12', '4', '2', '004/2025', '2025-06-03', '917970', '0', '0', '2', '49', '', '', '0000-00-00', '0', NULL),
('5', '12', '5', '2', '005/2025', '2025-06-03', '273060', '0', '0', '2', '49', '', '', '0000-00-00', '0', NULL),
('6', '12', '6', '2', '006/2025', '2025-06-03', '1552665.4', '0', '0', '2', '95', '', '', '0000-00-00', '0', NULL),
('7', '12', '7', '2', '007/2025', '2025-06-03', '273060', '0', '0', '2', '43', '', '', '0000-00-00', '0', NULL),
('8', '12', '8', '2', '008/2025', '2025-06-03', '502235.65', '0', '0', '2', '100', '', '', '0000-00-00', '0', NULL);

### Structure of table `0_bom` ###

DROP TABLE IF EXISTS `0_bom`;

CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) NOT NULL DEFAULT '',
  `component` char(20) NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_bom` ###

INSERT INTO `0_bom` VALUES
('1', '187', '101', '1', 'DEF', '1'),
('2', '187', '1202', '1', 'DEF', '1'),
('3', 'T-0001', 'T-0002', '2', 'DEF', '1'),
('4', 'T-0001', 'T-0003', '3', 'DEF', '2'),
('5', 'T-0001', 'T-0004', '4', 'DEF', '1');

### Structure of table `0_budget_trans` ###

DROP TABLE IF EXISTS `0_budget_trans`;

CREATE TABLE `0_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `memo_` tinytext NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_budget_trans` ###


### Structure of table `0_chart_class` ###

DROP TABLE IF EXISTS `0_chart_class`;

CREATE TABLE `0_chart_class` (
  `cid` varchar(3) NOT NULL,
  `class_name` varchar(60) NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_chart_class` ###

INSERT INTO `0_chart_class` VALUES
('1', 'Assets', '1', '0'),
('2', 'Liabilities', '2', '0'),
('3', 'Income', '4', '0'),
('4', 'Costs', '6', '0');

### Structure of table `0_chart_master` ###

DROP TABLE IF EXISTS `0_chart_master`;

CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) NOT NULL DEFAULT '',
  `account_code2` varchar(15) NOT NULL DEFAULT '',
  `account_name` varchar(60) NOT NULL DEFAULT '',
  `account_type` varchar(10) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_chart_master` ###

INSERT INTO `0_chart_master` VALUES
('1060', '', 'Checking Account', '1', '0'),
('1065', '', 'Petty Cash', '1', '0'),
('1066', '', 'Petty Cheque', '1', '0'),
('1067', '', 'Petty Cash Mohsin', '1', '0'),
('1068', '', 'Petty cash Shahbaz engineer', '1', '0'),
('1069', '', 'Petty cash Jhangeer', '1', '0'),
('1070', '', 'Petty Cash Siddique Sandspit', '1', '0'),
('1071', '', 'Petty Cash Fahad', '1', '0'),
('1072', '', 'Petty Cash Papu', '1', '0'),
('1073', '', 'Petty cash Saif Ullah', '1', '0'),
('1074', '', 'BANK AL HABIB 4k', '1', '0'),
('1075', '', 'Mezzan Bank', '1', '0'),
('1076', '', 'Soneri Bank', '1', '0'),
('1077', '', 'Bank Al falah', '1', '0'),
('1078', '', 'Dubai Islamic', '1', '0'),
('1079', '', 'Anna', '1', '0'),
('1080', '', 'Unknown bank online', '1', '0'),
('1081', '', 'Jhangeer petty cash', '1', '0'),
('1082', '', 'Abdullah Petty Cash', '1', '0'),
('1083', '', 'Tahir Lhr Petty Cash', '1', '0'),
('1084', '', 'BARA MAN', '1', '0'),
('1085', '', 'BANK AL HABIB North Karachi', '1', '0'),
('1200', '', 'Accounts Receivables', '1', '0'),
('1205', '', 'Allowance for doubtful accounts', '1', '0'),
('1301', '', 'Emaar Giga ', '13', '0'),
('1510', '', 'Inventory', '2', '0'),
('1520', '', 'Stocks of Raw Materials', '2', '0'),
('1530', '', 'Stocks of Work In Progress', '2', '0'),
('1540', '', 'Stocks of Finished Goods', '2', '0'),
('1550', '', 'Goods Received Clearing account', '2', '0'),
('1820', '', 'Office Furniture &amp; Equipment', '3', '0'),
('1825', '', 'Accum. Amort. -Furn. &amp; Equip.', '3', '0'),
('1840', '', 'Vehicle', '3', '0'),
('1845', '', 'Accum. Amort. -Vehicle', '3', '0'),
('1846', '', 'Sandspit N-25', '14', '0'),
('1847', '', 'SITE PHASE 2', '14', '0'),
('1848', '', 'EMAAR GIGA', '14', '0'),
('1849', '', 'ZAMEEN ace Islamaabd', '14', '0'),
('1850', '', 'North town phase 2', '14', '0'),
('1851', '', 'Saima Pari Highway', '14', '0'),
('1852', '', 'capital smart city Islamabad', '14', '0'),
('1916', '', 'Hassan', '1', '0'),
('1917', '', 'Hut', '1', '0'),
('1920', '1920', 'Unknow Meezan E-Zone', '1', '0'),
('1955', '1955', 'Unknow BAHL E-Zone', '1', '0'),
('1976', '1976', 'Ali', '1', '0'),
('2100', '', 'Accounts Payable', '4', '0'),
('2105', '', 'Deferred Income', '4', '0'),
('2110', '', 'Accrued Income Tax - Federal', '4', '0'),
('2120', '', 'Accrued Income Tax - State', '4', '0'),
('2130', '', 'Accrued Franchise Tax', '4', '0'),
('2140', '', 'Accrued Real &amp; Personal Prop Tax', '4', '0'),
('2150', '', 'Sales Tax', '4', '0'),
('2160', '', 'Accrued Use Tax Payable', '4', '0'),
('2210', '', 'Accrued Wages', '4', '0'),
('2220', '', 'Accrued Comp Time', '4', '0'),
('2230', '', 'Accrued Holiday Pay', '4', '0'),
('2240', '', 'Accrued Vacation Pay', '4', '0'),
('2310', '', 'Accr. Benefits - 401K', '4', '0'),
('2320', '', 'Accr. Benefits - Stock Purchase', '4', '0'),
('2330', '', 'Accr. Benefits - Med, Den', '4', '0'),
('2340', '', 'Accr. Benefits - Payroll Taxes', '4', '0'),
('2350', '', 'Accr. Benefits - Credit Union', '4', '0'),
('2360', '', 'Accr. Benefits - Savings Bond', '4', '0'),
('2370', '', 'Accr. Benefits - Garnish', '4', '0'),
('2380', '', 'Accr. Benefits - Charity Cont.', '4', '0'),
('2381', '', 'Openinga Balances - Account', '4', '0'),
('2620', '', 'Bank Loans', '5', '0'),
('2680', '', 'Loans from Shareholders', '5', '0'),
('3350', '', 'Common Shares', '6', '0'),
('3590', '', 'Retained Earnings - prior years', '7', '0'),
('4010', '', 'Sales', '8', '0'),
('4430', '', 'Shipping &amp; Handling', '9', '0'),
('4440', '', 'Interest', '9', '0'),
('4450', '', 'Foreign Exchange Gain', '9', '0'),
('4500', '', 'Prompt Payment Discounts', '9', '0'),
('4510', '', 'Discounts Given', '9', '0'),
('5010', '', 'Cost of Goods Sold - Retail', '10', '0'),
('5020', '', 'Material Usage Varaiance', '10', '0'),
('5030', '', 'Consumable Materials', '10', '0'),
('5040', '', 'Purchase price Variance', '10', '0'),
('5050', '', 'Purchases of materials', '10', '0'),
('5060', '', 'Discounts Received', '10', '0'),
('5100', '', 'Freight', '10', '0'),
('5410', '', 'Wages &amp; Salaries', '11', '0'),
('5420', '', 'Wages - Overtime', '11', '0'),
('5430', '', 'Benefits - Comp Time', '11', '0'),
('5440', '', 'Benefits - Payroll Taxes', '11', '0'),
('5450', '', 'Benefits - Workers Comp', '11', '0'),
('5460', '', 'Benefits - Pension', '11', '0'),
('5470', '', 'Benefits - General Benefits', '11', '0'),
('5510', '', 'Inc Tax Exp - Federal', '11', '0'),
('5520', '', 'Inc Tax Exp - State', '11', '0'),
('5530', '', 'Taxes - Real Estate', '11', '0'),
('5540', '', 'Taxes - Personal Property', '11', '0'),
('5550', '', 'Taxes - Franchise', '11', '0'),
('5559', '', 'Bakht Zaman ( adda helper)', '11', '0'),
('5560', '', 'Taxes - Foreign Withholding', '11', '0'),
('5561', '', 'Rafia Zakir', '11', '0'),
('5562', '', 'Rabia Khan', '11', '0'),
('5563', '', 'Abdullah', '11', '0'),
('5564', '', 'Allah Wasaya', '11', '0'),
('5565', '', 'Ahmed Khan', '11', '0'),
('5566', '', 'Arbaz Ahmed', '11', '0'),
('5567', '', 'Ali Hassan', '11', '0'),
('5568', '', 'Asif', '11', '0'),
('5569', '', 'Babar', '11', '0'),
('5570', '', 'Bilal', '11', '0'),
('5571', '', 'Fahad Shahid', '11', '0'),
('5572', '', 'Faheem', '11', '0'),
('5573', '', 'Farman Islam', '11', '0'),
('5574', '', 'Fazal', '11', '0'),
('5575', '', 'Habib', '11', '0'),
('5576', '', 'Khan Muhammad', '11', '0'),
('5577', '', 'Liaquat', '11', '0'),
('5578', '', 'Malik Khan', '11', '0'),
('5579', '', 'Mohsin', '11', '0'),
('5580', '', 'Muhammad Hassan', '11', '0'),
('5581', '', 'Murad Khan', '11', '0'),
('5582', '', 'Naseeb Nawab', '11', '0'),
('5583', '', 'Nazeer Ahmed', '11', '0'),
('5584', '', 'Rafiq Ahmed', '11', '0'),
('5585', '', 'Rafiq ', '11', '0'),
('5586', '', 'Raheel Khan', '11', '0'),
('5587', '', 'Rahib', '11', '0'),
('5588', '', 'Saddam Hussain', '11', '0'),
('5589', '', 'Salar Khan', '11', '0'),
('5590', '', 'Sameer ', '11', '0'),
('5591', '', 'Shahbaz ', '11', '0'),
('5592', '', 'Shahbaz Khan', '11', '0'),
('5593', '', 'Shamroz Khan', '11', '0'),
('5594', '', 'Syed Hussain Adil', '11', '0'),
('5595', '', 'Shareef', '11', '0'),
('5596', '', 'Sarfaraz', '11', '0'),
('5597', '', 'Usman Khan', '11', '0'),
('5598', '', 'Usama', '11', '0'),
('5599', '', 'Zohaib', '11', '0'),
('5610', '', 'Accounting &amp; Legal', '12', '0'),
('5615', '', 'Advertising &amp; Promotions', '12', '0'),
('5620', '', 'Bad Debts', '12', '0'),
('5660', '', 'Amortization Expense', '12', '0'),
('5685', '', 'Insurance', '12', '0'),
('5690', '', 'Interest &amp; Bank Charges', '12', '0'),
('5700', '', 'Office Supplies', '12', '0'),
('5760', '', 'Rent', '12', '0'),
('5765', '', 'Repair &amp; Maintenance', '12', '0'),
('5780', '', 'Telephone', '12', '0'),
('5785', '', 'Travel &amp; Entertainment', '12', '0'),
('5790', '', 'Utilities', '12', '0'),
('5791', '', 'Office Expense', '12', '0'),
('5795', '', 'Registrations', '12', '0'),
('5800', '', 'Licenses', '12', '0'),
('5810', '', 'Foreign Exchange Loss', '12', '0'),
('5811', '', 'Delivery Lost Weight', '12', '0'),
('5812', '', 'Delivery Gain Weight', '12', '0'),
('6000', '', 'Labour Exp', '12', '0'),
('6001', '', 'Mentainance', '12', '0'),
('6002', '', 'Convince Exp', '12', '0'),
('6003', '', 'Bara Exp', '12', '0'),
('6004', '', 'Saeed Bhai Invoice', '1', '0'),
('6005', '', 'Waqas EXP', '12', '0'),
('6006', '', 'HOME EXP', '12', '0'),
('6007', '', 'Gullu Dhalai', '12', '0'),
('6008', '', 'zakat', '12', '0'),
('6009', '', 'Masjid', '12', '0'),
('6010', '', 'IDREES MADERSA', '12', '0'),
('7000', '', 'Naveed LBR petty cash', '1', '0'),
('9990', '', 'Year Profit/Loss', '12', '0');

### Structure of table `0_chart_types` ###

DROP TABLE IF EXISTS `0_chart_types`;

CREATE TABLE `0_chart_types` (
  `id` varchar(10) NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `class_id` varchar(3) NOT NULL DEFAULT '',
  `parent` varchar(10) NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_chart_types` ###

INSERT INTO `0_chart_types` VALUES
('1', 'Current Assets', '1', '', '0'),
('10', 'Cost of Goods Sold', '4', '', '0'),
('11', 'Payroll Expenses', '4', '', '0'),
('12', 'General &amp; Administrative expenses', '4', '', '0'),
('13', 'Fixed Assets', '1', '', '0'),
('14', 'Property', '1', '3', '0'),
('2', 'Inventory Assets', '1', '', '0'),
('3', 'Capital Assets', '1', '', '0'),
('4', 'Current Liabilities', '2', '', '0'),
('5', 'Long Term Liabilities', '2', '', '0'),
('6', 'Share Capital', '2', '', '0'),
('7', 'Retained Earnings', '2', '', '0'),
('8', 'Sales Revenue', '3', '', '0'),
('9', 'Other Revenue', '3', '', '0');

### Structure of table `0_comments` ###

DROP TABLE IF EXISTS `0_comments`;

CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext DEFAULT NULL,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_comments` ###

INSERT INTO `0_comments` VALUES
('0', '1', '2025-05-31', 'Zero/negative inventory handling'),
('35', '1', '2025-06-02', 'Cost was 160029 changed to -65136 for item &#039;60487735&#039;'),
('0', '2', '2025-06-02', 'Zero/negative inventory handling'),
('0', '3', '2025-06-02', 'Zero/negative inventory handling'),
('35', '2', '2025-06-02', 'Cost was 160029 changed to -65136 for item &#039;60487735&#039;'),
('35', '3', '2025-06-02', 'Cost was -5099325 changed to -4874160 for item &#039;60487735&#039;'),
('0', '4', '2025-06-02', 'Zero/negative inventory handling'),
('12', '1', '2025-06-03', 'Default #1'),
('12', '2', '2025-06-03', 'Default #2'),
('12', '3', '2025-06-03', 'Default #3'),
('12', '4', '2025-06-03', 'Default #6'),
('12', '5', '2025-06-03', 'Default #7'),
('12', '6', '2025-06-03', 'Default #8'),
('12', '7', '2025-06-03', 'Default #9'),
('12', '8', '2025-06-03', 'Default #10');

### Structure of table `0_credit_status` ###

DROP TABLE IF EXISTS `0_credit_status`;

CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_credit_status` ###

INSERT INTO `0_credit_status` VALUES
('1', 'Good History', '0', '0'),
('3', 'No more work until payment received', '1', '0'),
('4', 'In liquidation', '1', '0');

### Structure of table `0_crm_categories` ###

DROP TABLE IF EXISTS `0_crm_categories`;

CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) NOT NULL COMMENT 'contact type e.g. customer',
  `action` varchar(20) NOT NULL COMMENT 'detailed usage e.g. department',
  `name` varchar(30) NOT NULL COMMENT 'for category selector',
  `description` tinytext NOT NULL COMMENT 'usage description',
  `system` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_crm_categories` ###

INSERT INTO `0_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `0_crm_contacts` ###

DROP TABLE IF EXISTS `0_crm_contacts`;

CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT 0 COMMENT 'foreign key to crm_persons',
  `type` varchar(20) NOT NULL COMMENT 'foreign key to crm_categories',
  `action` varchar(20) NOT NULL COMMENT 'foreign key to crm_categories',
  `entity_id` varchar(11) DEFAULT NULL COMMENT 'entity id in related class table',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=214 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_crm_contacts` ###

INSERT INTO `0_crm_contacts` VALUES
('1', '1', 'cust_branch', 'general', '1'),
('2', '1', 'customer', 'general', '1'),
('3', '2', 'supplier', 'general', '1'),
('4', '3', 'cust_branch', 'general', '2'),
('5', '3', 'customer', 'general', '2'),
('6', '4', 'cust_branch', 'general', '3'),
('7', '4', 'customer', 'general', '3'),
('8', '5', 'cust_branch', 'general', '4'),
('9', '5', 'customer', 'general', '4'),
('10', '6', 'cust_branch', 'general', '5'),
('11', '6', 'customer', 'general', '5'),
('12', '7', 'cust_branch', 'general', '6'),
('13', '7', 'customer', 'general', '6'),
('14', '8', 'cust_branch', 'general', '7'),
('15', '8', 'customer', 'general', '7'),
('16', '9', 'cust_branch', 'general', '8'),
('17', '9', 'customer', 'general', '8'),
('18', '10', 'cust_branch', 'general', '9'),
('19', '10', 'customer', 'general', '9'),
('20', '11', 'cust_branch', 'general', '10'),
('21', '11', 'customer', 'general', '10'),
('22', '12', 'cust_branch', 'general', '11'),
('23', '12', 'customer', 'general', '11'),
('24', '13', 'cust_branch', 'general', '12'),
('25', '13', 'customer', 'general', '12'),
('26', '14', 'cust_branch', 'general', '13'),
('27', '14', 'customer', 'general', '13'),
('28', '15', 'cust_branch', 'general', '14'),
('29', '15', 'customer', 'general', '14'),
('30', '16', 'cust_branch', 'general', '15'),
('31', '16', 'customer', 'general', '15'),
('32', '17', 'cust_branch', 'general', '16'),
('33', '17', 'customer', 'general', '17'),
('34', '18', 'cust_branch', 'general', '17'),
('35', '18', 'customer', 'general', '20'),
('36', '19', 'cust_branch', 'general', '18'),
('37', '19', 'customer', 'general', '21'),
('38', '20', 'cust_branch', 'general', '19'),
('39', '20', 'customer', 'general', '22'),
('40', '21', 'cust_branch', 'general', '20'),
('41', '21', 'customer', 'general', '23'),
('42', '22', 'cust_branch', 'general', '21'),
('43', '22', 'customer', 'general', '24'),
('44', '23', 'cust_branch', 'general', '22'),
('45', '23', 'customer', 'general', '25'),
('46', '24', 'cust_branch', 'general', '23'),
('47', '24', 'customer', 'general', '26'),
('48', '25', 'cust_branch', 'general', '24'),
('49', '25', 'customer', 'general', '27'),
('50', '26', 'cust_branch', 'general', '25'),
('51', '26', 'customer', 'general', '28'),
('52', '27', 'cust_branch', 'general', '26'),
('53', '27', 'customer', 'general', '29'),
('54', '28', 'cust_branch', 'general', '27'),
('55', '28', 'customer', 'general', '30'),
('56', '29', 'cust_branch', 'general', '28'),
('57', '29', 'customer', 'general', '31'),
('58', '30', 'cust_branch', 'general', '29'),
('59', '30', 'customer', 'general', '32'),
('60', '31', 'cust_branch', 'general', '30'),
('61', '31', 'customer', 'general', '33'),
('62', '32', 'cust_branch', 'general', '31'),
('63', '32', 'customer', 'general', '34'),
('64', '33', 'cust_branch', 'general', '32'),
('65', '33', 'customer', 'general', '35'),
('66', '34', 'cust_branch', 'general', '33'),
('67', '34', 'customer', 'general', '36'),
('68', '35', 'cust_branch', 'general', '34'),
('69', '35', 'customer', 'general', '37'),
('70', '36', 'cust_branch', 'general', '35'),
('71', '36', 'customer', 'general', '38'),
('72', '37', 'supplier', 'general', '2'),
('73', '38', 'supplier', 'general', '3'),
('74', '39', 'supplier', 'general', '4'),
('75', '40', 'supplier', 'general', '5'),
('76', '41', 'supplier', 'general', '6'),
('77', '42', 'cust_branch', 'general', '36'),
('78', '42', 'customer', 'general', '39'),
('79', '43', 'supplier', 'general', '7'),
('80', '44', 'supplier', 'general', '8'),
('81', '45', 'supplier', 'general', '9'),
('82', '46', 'supplier', 'general', '10'),
('83', '47', 'supplier', 'general', '11'),
('84', '48', 'supplier', 'general', '12'),
('85', '49', 'supplier', 'general', '13'),
('86', '50', 'cust_branch', 'general', '37'),
('87', '50', 'customer', 'general', '40'),
('88', '51', 'supplier', 'general', '14'),
('89', '52', 'cust_branch', 'general', '38'),
('90', '52', 'customer', 'general', '41'),
('93', '54', 'cust_branch', 'general', '40'),
('94', '54', 'customer', 'general', '43'),
('95', '55', 'cust_branch', 'general', '41'),
('96', '55', 'customer', 'general', '44'),
('99', '57', 'cust_branch', 'general', '43'),
('100', '57', 'customer', 'general', '46'),
('101', '58', 'cust_branch', 'general', '44'),
('102', '58', 'customer', 'general', '47'),
('103', '59', 'cust_branch', 'general', '45'),
('104', '59', 'customer', 'general', '48'),
('105', '60', 'cust_branch', 'general', '46'),
('106', '60', 'customer', 'general', '49'),
('107', '61', 'cust_branch', 'general', '47'),
('108', '61', 'customer', 'general', '50'),
('109', '62', 'supplier', 'general', '15'),
('110', '63', 'supplier', 'general', '16'),
('111', '64', 'cust_branch', 'general', '48'),
('112', '64', 'customer', 'general', '51'),
('113', '65', 'cust_branch', 'general', '49'),
('114', '65', 'customer', 'general', '52'),
('115', '66', 'cust_branch', 'general', '50'),
('116', '66', 'customer', 'general', '53'),
('117', '67', 'cust_branch', 'general', '51'),
('118', '67', 'customer', 'general', '54'),
('119', '68', 'cust_branch', 'general', '52'),
('120', '68', 'customer', 'general', '55'),
('121', '69', 'cust_branch', 'general', '53'),
('122', '69', 'customer', 'general', '56'),
('123', '70', 'cust_branch', 'general', '54'),
('124', '70', 'customer', 'general', '57'),
('125', '71', 'cust_branch', 'general', '55'),
('126', '71', 'customer', 'general', '58'),
('127', '72', 'cust_branch', 'general', '56'),
('128', '72', 'customer', 'general', '59'),
('129', '73', 'cust_branch', 'general', '57'),
('130', '73', 'customer', 'general', '60'),
('131', '74', 'cust_branch', 'general', '58'),
('132', '74', 'customer', 'general', '61'),
('133', '75', 'cust_branch', 'general', '59'),
('134', '75', 'customer', 'general', '62'),
('135', '76', 'cust_branch', 'general', '60'),
('136', '76', 'customer', 'general', '63'),
('137', '77', 'cust_branch', 'general', '61'),
('138', '77', 'customer', 'general', '64'),
('139', '78', 'cust_branch', 'general', '62'),
('140', '78', 'customer', 'general', '65'),
('141', '79', 'cust_branch', 'general', '63'),
('142', '79', 'customer', 'general', '66'),
('143', '80', 'cust_branch', 'general', '64'),
('144', '80', 'customer', 'general', '67'),
('145', '81', 'cust_branch', 'general', '65'),
('146', '81', 'customer', 'general', '68'),
('147', '82', 'cust_branch', 'general', '67'),
('148', '82', 'customer', 'general', '73'),
('149', '83', 'cust_branch', 'general', '68'),
('150', '83', 'customer', 'general', '74'),
('151', '84', 'cust_branch', 'general', '69'),
('152', '84', 'customer', 'general', '75'),
('153', '85', 'cust_branch', 'general', '70'),
('154', '85', 'customer', 'general', '76'),
('155', '86', 'cust_branch', 'general', '71'),
('156', '86', 'customer', 'general', '77'),
('157', '87', 'cust_branch', 'general', '72'),
('158', '87', 'customer', 'general', '79'),
('159', '88', 'cust_branch', 'general', '73'),
('160', '88', 'customer', 'general', '80'),
('163', '90', 'supplier', 'general', '17'),
('164', '91', 'supplier', 'general', '18'),
('165', '92', 'supplier', 'general', '19'),
('166', '93', 'supplier', 'general', '20'),
('167', '94', 'cust_branch', 'general', '75'),
('168', '94', 'customer', 'general', '82'),
('169', '95', 'cust_branch', 'general', '76'),
('170', '95', 'customer', 'general', '83'),
('171', '96', 'supplier', 'general', '21'),
('172', '97', 'supplier', 'general', '22'),
('173', '98', 'supplier', 'general', '23'),
('174', '99', 'supplier', 'general', '24'),
('175', '100', 'supplier', 'general', '25'),
('176', '101', 'supplier', 'general', '26'),
('177', '102', 'cust_branch', 'general', '77'),
('178', '102', 'customer', 'general', '84'),
('179', '103', 'cust_branch', 'general', '78'),
('180', '103', 'customer', 'general', '85'),
('181', '104', 'cust_branch', 'general', '79'),
('182', '104', 'customer', 'general', '86'),
('183', '105', 'cust_branch', 'general', '80'),
('184', '105', 'customer', 'general', '87'),
('185', '106', 'supplier', 'general', '27'),
('186', '107', 'cust_branch', 'general', '81'),
('187', '107', 'customer', 'general', '88'),
('188', '108', 'supplier', 'general', '28'),
('189', '109', 'supplier', 'general', '29'),
('190', '110', 'supplier', 'general', '30'),
('191', '111', 'supplier', 'general', '31'),
('192', '112', 'supplier', 'general', '32'),
('193', '113', 'cust_branch', 'general', '82'),
('194', '113', 'customer', 'general', '89'),
('195', '114', 'cust_branch', 'general', '83'),
('196', '114', 'customer', 'general', '91'),
('197', '115', 'cust_branch', 'general', '84'),
('198', '115', 'customer', 'general', '92'),
('199', '116', 'cust_branch', 'general', '85'),
('200', '116', 'customer', 'general', '93'),
('201', '117', 'cust_branch', 'general', '86'),
('202', '117', 'customer', 'general', '94'),
('203', '118', 'cust_branch', 'general', '87'),
('204', '118', 'customer', 'general', '95'),
('205', '119', 'cust_branch', 'general', '88'),
('207', '119', 'customer', 'general', '96'),
('208', '120', 'cust_branch', 'general', '89'),
('209', '120', 'customer', 'general', '98'),
('210', '121', 'cust_branch', 'general', '90'),
('211', '121', 'customer', 'general', '99'),
('212', '122', 'cust_branch', 'general', '91'),
('213', '122', 'customer', 'general', '100');

### Structure of table `0_crm_persons` ###

DROP TABLE IF EXISTS `0_crm_persons`;

CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(50) NOT NULL,
  `name` varchar(60) NOT NULL,
  `name2` varchar(60) DEFAULT NULL,
  `address` tinytext DEFAULT NULL,
  `phone` varchar(30) DEFAULT NULL,
  `phone2` varchar(30) DEFAULT NULL,
  `fax` varchar(30) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `lang` char(5) DEFAULT NULL,
  `notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_crm_persons` ###

INSERT INTO `0_crm_persons` VALUES
('1', 'Osama sports', 'Osama sports', NULL, NULL, '03152100081', NULL, NULL, NULL, NULL, '', '0'),
('2', 'RIZWAN BONTANDAS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('3', 'Alla uddin Asalan', 'Alla uddin Asalan', NULL, NULL, '03136619559', NULL, NULL, NULL, NULL, '', '0'),
('4', 'Haji anwar hyd', 'Haji anwar hyd', NULL, NULL, '03003030615', NULL, NULL, NULL, NULL, '', '0'),
('5', 'Afzal Awan', 'Afzal Awan', NULL, NULL, '03332268485', NULL, NULL, NULL, NULL, '', '0'),
('6', 'Hamza orangi', 'Hamza orangi', NULL, NULL, '03359999695', NULL, NULL, NULL, NULL, '', '0'),
('7', 'humayun', 'humayun', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('8', 'Al Makkah (Akram)', 'Al Makkah (Akram)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('9', 'Habib kabul', 'Habib kabul', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('10', 'Al Noor Hani', 'Al Noor Hani', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('11', 'ikram and sons ', 'ikram and sons ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('12', 'juaid hamza ', 'juaid hamza ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('13', 'Ansari Steel (Haji Basheer)', 'Ansari Steel (Haji Basheer Landhi)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('14', 'Arshad Garden ', 'Arshad Garden ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('15', 'Asad Lalukhait', 'Asad Lalukhait', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('16', 'Khurram Butt', 'Khurram Butt', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('17', 'Bilal Lalukhait', 'Bilal Lalukhait', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('18', 'Moin market', 'Moin market', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('19', 'Dubai Hardware', 'Dubai Hardware', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('20', 'Nadeem lalokhait', 'Nadeem lalokhait', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('21', 'Ehtesham Hyderabad', 'Ehtesham Hyderabad', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('22', 'Nadeem mughal', 'Nadeem mughal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('23', 'Green Hardware Daniyal', 'Green Hardware Daniyal', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('24', 'NADEEM ALMUNIUM', 'NADEEM ALMUNIUM', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('25', 'NAEEM KHALIL ', 'NAEEM KHALIL ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('26', 'Owais Touseef Cutter', 'Owais Touseef Cutter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('27', 'UNITED STEEL rasheed', 'UNITED STEEL rasheed', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('28', 'Qadri Steel Imran', 'Qadri Steel Imran', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('29', 'Raja Orangi Riaz', 'Raja Orangi Riaz', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('30', 'Razaq Scrap (Lahore)', 'Razaq Scrap (Lahore)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('31', 'Rizwan Babar Market', 'Rizwan Babar Market', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('32', 'Sattar Scrap (Lahore)', 'Sattar Scrap (Lahore)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('33', 'S.B.Traders Muzamil', 'S.B.Traders Muzamil', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('34', 'Sarim Marmonex', 'Sarim Marmonex', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('35', 'Shakeel Pipe', 'Shakeel Pipe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('36', 'Tahir Timber ', 'Tahir Timber ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('37', 'Hammad Bontandas', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('38', 'DIC F#850', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('39', 'DIB F#851', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('40', 'DIB F#852', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('41', 'BAF F#853', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('42', 'cash party', 'Cash Party', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('43', 'F# 852 ALICE ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('44', 'WAQAR BROKER ', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('45', 'Adnan Broker', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('46', 'BAF    F# 850', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('47', 'DIB.  F#851', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('48', 'Ilyas Khatki', '', NULL, NULL, '03333993841', NULL, NULL, NULL, NULL, '', '0'),
('49', 'Junaid Noor Hr Broker', '', NULL, NULL, '03219286905', NULL, NULL, NULL, NULL, '', '0'),
('50', 'Qaiser latif', 'qaiser latif', NULL, NULL, '03008465529', NULL, NULL, NULL, NULL, '', '0'),
('51', 'qaiser latif', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('52', 'Khalil Nagan ', 'Khalil Nagan ', NULL, NULL, NULL, NULL, '03152130704', NULL, NULL, '', '0'),
('53', 'CASH PARTIES', 'CASH PARTIES', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('54', 'Imran malir', 'Imran Malir', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('55', 'idrees butt', 'idrees butt', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('56', 'moin market # 90', 'moin market # 90', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('57', 'Huzaifa Co Nadeem Lalukhait', 'huzaifa lalukhait', NULL, NULL, '3118159011', '3118159011', '3118159011', NULL, NULL, '', '0'),
('58', 'SHANI MALIR', 'SHANI MALIR', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('59', 'Madina Pipe Azeem Pata Pipe', 'MADINA PIPE AZEEM', NULL, NULL, '03132745524', NULL, NULL, NULL, NULL, '', '0'),
('60', 'Yasir Shoukat Nazimabad', 'Yasir Shoukat', NULL, NULL, '03330379426', NULL, NULL, NULL, NULL, '', '0'),
('61', 'NADEEM NAEM GODHRA', 'NADEEM NAEEM GODHRA', NULL, '', NULL, NULL, NULL, NULL, NULL, '', '0'),
('62', 'ABDUL RAFAY', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('63', 'File no 855', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('64', 'Ayan Pipe', 'Ayan Pipe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('65', 'Ayan Pipe ABEER NAEEM', 'Ayan Pipe ABEER NAEEM', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('66', 'ABEER NAEEM', 'ABEER NAEEM', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('67', 'Ahtisham Green', 'Ahtisham Green', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('68', 'Abdul Wahab Shairsha', 'Abdul Wahab Shairsha', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('69', 'Abbas Iron', 'Abbas Iron', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('70', 'Atif Sahab', 'Atif Sahab', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('71', 'Abid Scrape Shairsha', 'Abid Scrape Shairsha', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('72', 'Abid Bhai--Orangi', 'Abid Bhai--Orangi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('73', 'ADNAN BHAI-- ANNA', 'ADNAN BHAI-- ANNA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('74', 'ADNAN BHAI-- ANNA Afzal Awan', 'ADNAN BHAI-- ANNA Afzal Awan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('75', 'Ahmar Lalukhat', 'Ahmar Lalukhat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('76', 'AKRAM BEAUTY STEEL', 'AKRAM BEAUTY STEEL', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('77', 'Akhtar Bhai', 'Akhtar Bhai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('78', 'ALI Raza Behria', 'ALI Raza Behria', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('79', 'Al-Makkah (Akram)', 'Al-Makkah (Akram)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('80', 'AL-NABEEL Pipe', 'AL-NABEEL Pipe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('81', 'AL-NOOR -- HANI', 'AL-NOOR -- HANI', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('82', 'ANSARI STEEL (HAJI BASHEER LANDHI)', 'ANSARI STEEL (HAJI BASHEER LANDHI)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('83', 'ARSHAD -- GARDEN', 'ARSHAD -- GARDEN', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('84', 'Asad Lalukhat', 'Asad Lalukhat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('85', 'Azeem Butt Jubilee Pipe', 'Azeem Butt Jubilee Pipe', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('86', 'Abdul Wali Khan', 'Abdul Wali Khan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('87', 'Ali Orangi', 'Ali Orangi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('88', 'Bilal Welder', 'Bilal Welder', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('89', 'AS', 'Abdus Sami', NULL, 'Karachi', '0372774748347', '0333737747747', NULL, 'info@digitleysystem.com', NULL, '', '0'),
('90', 'AS', 'abdul khalid', NULL, 'a-10 villa gulshan e iqbal karachi', '03213372663', '03442847647', NULL, 'info@digitleysystem.com', NULL, '', '0'),
('91', 'AS', '', NULL, 'a-10 villa gulshan e iqbal karachi', '03664773664', '03664637646', NULL, 'info@digitleysystem.com', NULL, '', '0'),
('92', 'AS', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('93', 'Sajid', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('94', 'Shahid', 'Shahid ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('95', 'Aliyan', 'Aliyan', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('96', 'Saeed', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('97', 'Mazhar', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('98', 'Mazhar', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('99', 'Mazhar', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('100', 'Ali', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('101', 'A &amp; A Pipe', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('102', 'Shahid Hyd Pipe Maqbool Tube Well', 'Shahid Hyd Pipe Maqbool Tube Well', NULL, NULL, '03003057841', NULL, NULL, NULL, NULL, '', '0'),
('103', 'UNKNOWN ENTRIES', 'UNKNOWN ENTRIES', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('104', 'IRFAN SCRAP', 'IRFAN SCRAP', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('105', 'SAEED BHAI INVOICE', 'SAEED BHAI INVOICE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('106', 'File # 864', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('107', 'Mirza Orangi', 'Mirza Orangi', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('108', 'File No 863', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('109', 'File No 862', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('110', 'file # 865', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('111', 'File No 866', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('112', 'File No 866', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('113', 'New Qadri ', 'New Qadri ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('114', 'M. Ali', 'M. Ali', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('115', 'Amir', 'Amir Osama', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('116', 'Ashiq', 'Aashiq Hardware', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('117', 'Sameer', 'Sameer bhai', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('118', 'Qaadri', 'Qadri Iron', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('119', 'Najeeb Ullah.', 'Najeeb.', NULL, 'Lalukhait', NULL, NULL, NULL, NULL, NULL, '', '0'),
('120', '(Najeeb Ullah)', '(Najeeb Ullah)', NULL, '(Najeeb Ullah)', NULL, NULL, NULL, NULL, NULL, '', '0'),
('121', 'Bashir Landhi.', 'Bashir Landhi.', NULL, 'Bashir Landhi.', NULL, NULL, NULL, NULL, NULL, '', '0'),
('122', 'Saima Paari', 'Saima Paari Jinnah Avenue', NULL, 'Saima Paari Mall, North Nazimabad, Karachi.', NULL, NULL, NULL, NULL, NULL, '', '0');

### Structure of table `0_currencies` ###

DROP TABLE IF EXISTS `0_currencies`;

CREATE TABLE `0_currencies` (
  `currency` varchar(60) NOT NULL DEFAULT '',
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) NOT NULL DEFAULT '',
  `country` varchar(100) NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_currencies` ###

INSERT INTO `0_currencies` VALUES
('CA Dollars', 'CAD', '$', 'Canada', 'Cents', '1', '0'),
('Euro', 'EUR', '€', 'Europe', 'Cents', '1', '0'),
('Pounds', 'GBP', '£', 'England', 'Pence', '1', '0'),
('Rupee', 'PKR', 'Rs', 'Pakistan', 'Rupees', '1', '0'),
('US Dollars', 'USD', '$', 'United States', 'Cents', '1', '0');

### Structure of table `0_cust_allocations` ###

DROP TABLE IF EXISTS `0_cust_allocations`;

CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trans_type_from` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_cust_allocations` ###

INSERT INTO `0_cust_allocations` VALUES
('2', '98', '4500.36', '2025-06-03', '2', '12', '2', '10'),
('3', '99', '1923174', '2025-06-03', '3', '12', '3', '10'),
('4', '49', '917970', '2025-06-03', '4', '12', '6', '10'),
('6', '95', '1552665.4', '2025-06-03', '6', '12', '8', '10'),
('7', '43', '273060', '2025-06-03', '7', '12', '9', '10'),
('8', '100', '502235.65', '2025-06-03', '8', '12', '10', '10');

### Structure of table `0_cust_branch` ###

DROP TABLE IF EXISTS `0_cust_branch`;

CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT 0,
  `br_name` varchar(60) NOT NULL DEFAULT '',
  `branch_ref` varchar(50) NOT NULL,
  `br_address` tinytext NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT 0,
  `default_location` varchar(5) NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) NOT NULL DEFAULT '',
  `receivables_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT 1,
  `br_post_address` tinytext NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT 0,
  `notes` tinytext NOT NULL,
  `bank_account` varchar(60) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_cust_branch` ###

INSERT INTO `0_cust_branch` VALUES
('1', '1', 'Osama sports', 'Osama sports', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('2', '2', 'Alla uddin Asalan', 'Alla uddin Asalan', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('3', '3', 'Haji anwar hyd', 'Haji anwar hyd', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('4', '4', 'Afzal Awan', 'Afzal Awan', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('5', '5', 'Hamza orangi', 'Hamza orangi', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('6', '6', 'humayun', 'humayun', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('7', '7', 'Al Makkah (Akram)', 'Al Makkah (Akram)', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('8', '8', 'Habib kabul', 'Habib kabul', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('9', '9', 'Al Noor Hani', 'Al Noor Hani', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('10', '10', 'ikram and sons ', 'ikram and sons ', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('11', '11', 'juaid hamza ', 'juaid hamza ', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('12', '12', 'Ansari Steel (Haji Basheer Landhi)', 'Ansari Steel (Haji Basheer)', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('13', '13', 'Arshad Garden ', 'Arshad Garden ', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('14', '14', 'Asad Lalukhait', 'Asad Lalukhait', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('15', '15', 'Khurram Butt', 'Khurram Butt', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('16', '17', 'Bilal Lalukhait', 'Bilal Lalukhait', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('17', '20', 'Moin market', 'Moin market', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('18', '21', 'Dubai Hardware', 'Dubai Hardware', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('19', '22', 'Nadeem lalokhait', 'Nadeem lalokhait', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('20', '23', 'Ehtesham Hyderabad', 'Ehtesham Hyderabad', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('21', '24', 'Nadeem mughal', 'Nadeem mughal', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('22', '25', 'Green Hardware Daniyal', 'Green Hardware Daniyal', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('23', '26', 'NADEEM ALMUNIUM', 'NADEEM ALMUNIUM', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('24', '27', 'NAEEM KHALIL ', 'NAEEM KHALIL ', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('25', '28', 'Owais Touseef Cutter', 'Owais Touseef Cutter', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('26', '29', 'UNITED STEEL rasheed', 'UNITED STEEL rasheed', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('27', '30', 'Qadri Steel Imran', 'Qadri Steel Imran', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('28', '31', 'Raja Orangi Riaz', 'Raja Orangi Riaz', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('29', '32', 'Razaq Scrap (Lahore)', 'Razaq Scrap (Lahore)', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('30', '33', 'Rizwan Babar Market', 'Rizwan Babar Market', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('31', '34', 'Sattar Scrap (Lahore)', 'Sattar Scrap (Lahore)', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('32', '35', 'S.B.Traders Muzamil', 'S.B.Traders Muzamil', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('33', '36', 'Sarim Marmonex', 'Sarim Marmonex', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('34', '37', 'Shakeel Pipe', 'Shakeel Pipe', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('35', '38', 'Tahir Timber ', 'Tahir Timber ', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('36', '39', 'Cash Party', 'cash party', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('37', '40', 'qaiser latif', 'Qaiser latif', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('38', '41', 'Khalil Nagan ', 'Khalil Nagan ', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('40', '43', 'Imran Malir', 'Imran malir', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('41', '44', 'idrees butt', 'idrees butt', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('43', '46', 'huzaifa lalukhait', 'Huzaifa Co Nadeem Lalukhait', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('44', '47', 'SHANI MALIR', 'SHANI MALIR', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('45', '48', 'MADINA PIPE AZEEM', 'Madina Pipe Azeem Pata Pipe', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('46', '49', 'Yasir Shoukat', 'Yasir Shoukat Nazimabad', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('47', '50', 'NADEEM NAEEM GODHRA', 'NADEEM NAEM GODHRA', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('48', '51', 'Ayan Pipe', 'Ayan Pipe', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('49', '52', 'Ayan Pipe ABEER NAEEM', 'Ayan Pipe ABEER NAEEM', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('50', '53', 'ABEER NAEEM', 'ABEER NAEEM', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('51', '54', 'Ahtisham Green', 'Ahtisham Green', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('52', '55', 'Abdul Wahab Shairsha', 'Abdul Wahab Shairsha', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('53', '56', 'Abbas Iron', 'Abbas Iron', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('54', '57', 'Atif Sahab', 'Atif Sahab', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('55', '58', 'Abid Scrape Shairsha', 'Abid Scrape Shairsha', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('56', '59', 'Abid Bhai--Orangi', 'Abid Bhai--Orangi', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('57', '60', 'ADNAN BHAI-- ANNA', 'ADNAN BHAI-- ANNA', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('58', '61', 'ADNAN BHAI-- ANNA Afzal Awan', 'ADNAN BHAI-- ANNA Afzal Awan', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('59', '62', 'Ahmar Lalukhat', 'Ahmar Lalukhat', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('60', '63', 'AKRAM BEAUTY STEEL', 'AKRAM BEAUTY STEEL', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('61', '64', 'Akhtar Bhai', 'Akhtar Bhai', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('62', '65', 'ALI Raza Behria', 'ALI Raza Behria', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('63', '66', 'Al-Makkah (Akram)', 'Al-Makkah (Akram)', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('64', '67', 'AL-NABEEL Pipe', 'AL-NABEEL Pipe', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('65', '68', 'AL-NOOR -- HANI', 'AL-NOOR -- HANI', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('67', '73', 'ANSARI STEEL (HAJI BASHEER LANDHI)', 'ANSARI STEEL (HAJI BASHEER LANDHI)', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('68', '74', 'ARSHAD -- GARDEN', 'ARSHAD -- GARDEN', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('69', '75', 'Asad Lalukhat', 'Asad Lalukhat', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('70', '76', 'Azeem Butt Jubilee Pipe', 'Azeem Butt Jubilee Pipe', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('71', '77', 'Abdul Wali Khan', 'Abdul Wali Khan', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('72', '79', 'Ali Orangi', 'Ali Orangi', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('73', '80', 'Bilal Welder', 'Bilal Welder', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('75', '82', 'Shahid ', 'Shahid', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('76', '83', 'Aliyan', 'Aliyan', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('77', '84', 'Shahid Hyd Pipe Maqbool Tube Well', 'Shahid Hyd Pipe Maqbool Tube Well', '', '1', '1', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('78', '85', 'UNKNOWN ENTRIES', 'UNKNOWN ENTRIES', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('79', '86', 'IRFAN SCRAP', 'IRFAN SCRAP', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('80', '87', 'SAEED BHAI INVOICE', 'SAEED BHAI INVOICE', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('81', '88', 'Mirza Orangi', 'Mirza Orangi', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('82', '89', 'New Qadri ', 'New Qadri ', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('83', '91', 'M. Ali', 'M. Ali', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('84', '92', 'Amir Osama', 'Amir', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('85', '93', 'Aashiq Hardware', 'Ashiq', '', '1', '1', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('86', '94', 'Sameer bhai', 'Sameer', '', '1', '1', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('87', '95', 'Qadri Iron', 'Qaadri', '', '1', '1', 'DEF', '1', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('88', '96', 'Azhar Lalukhait', 'Azhar Lalukhait', 'Lalukhait', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Lalukhait', '0', '', NULL, '0'),
('89', '98', '(Najeeb Ullah)', '(Najeeb Ullah)', '(Najeeb Ullah)', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '(Najeeb Ullah)', '0', '', NULL, '0'),
('90', '99', 'Bashir Landhi.', 'Bashir Landhi.', 'Bashir Landhi.', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Bashir Landhi.', '0', '', NULL, '0'),
('91', '100', 'Saima Paari Jinnah Avenue', 'Saima Paari', 'Saima Paari Mall, North Nazimabad, Karachi.', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', 'Saima Paari Mall, North Nazimabad, Karachi.', '0', '', NULL, '0');

### Structure of table `0_debtor_trans` ###

DROP TABLE IF EXISTS `0_debtor_trans`;

CREATE TABLE `0_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `debtor_no` int(11) unsigned NOT NULL,
  `branch_code` int(11) NOT NULL DEFAULT -1,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT 0,
  `order_` int(11) NOT NULL DEFAULT 0,
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `ov_freight` double NOT NULL DEFAULT 0,
  `ov_freight_tax` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `gross_weight` varchar(225) NOT NULL DEFAULT '0',
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`),
  KEY `order_` (`order_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_debtor_trans` ###

INSERT INTO `0_debtor_trans` VALUES
('1', '10', '2', '96', '88', '2025-06-03', '2025-06-03', '001/2025', '1', '1', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0', ''),
('2', '10', '0', '98', '89', '2025-06-03', '2025-06-03', '001/2025', '1', '2', '4500.36', '0', '0', '0', '0', '4500.36', '0', '1', '1', '0', '0', '4', '0', ''),
('3', '10', '0', '99', '90', '2025-06-03', '2025-06-03', '002/2025', '1', '3', '1923174', '0', '0', '0', '0', '1923174', '0', '1', '1', '0', '0', '4', '0', ''),
('4', '10', '0', '31', '28', '2025-06-03', '2025-06-23', '003/2025', '1', '4', '1802629', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '2', '0', '6325'),
('5', '10', '0', '84', '77', '2025-06-03', '2025-06-18', '004/2025', '1', '5', '2450519.84', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0', '11345'),
('6', '10', '0', '49', '46', '2025-06-03', '2025-06-03', '005/2025', '1', '6', '917970', '0', '0', '0', '0', '917970', '0', '1', '1', '0', '0', '4', '0', '4135'),
('7', '10', '2', '49', '46', '2025-06-03', '2025-06-03', '006/2025', '1', '7', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0', '1230'),
('8', '10', '0', '95', '87', '2025-06-03', '2025-06-03', '007/2025', '1', '8', '1552665.4', '0', '0', '0', '0', '1552665.4', '0', '1', '1', '0', '0', '4', '0', '6970'),
('9', '10', '0', '43', '40', '2025-06-03', '2025-06-03', '008/2025', '1', '9', '273060', '0', '0', '0', '0', '273060', '0', '1', '1', '0', '0', '4', '0', '1230'),
('10', '10', '0', '100', '91', '2025-06-03', '2025-06-03', '009/2025', '1', '10', '502235.65', '0', '0', '0', '0', '502235.65', '0', '1', '1', '0', '0', '4', '0', '2101'),
('1', '12', '0', '96', '88', '2025-06-03', '0000-00-00', '001/2025', '0', '0', '4500', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', NULL, '0', '0'),
('2', '12', '0', '98', '89', '2025-06-03', '0000-00-00', '002/2025', '0', '0', '4500.36', '0', '0', '0', '0', '4500.36', '0', '1', '0', '0', '0', NULL, '0', '0'),
('3', '12', '0', '99', '90', '2025-06-03', '0000-00-00', '003/2025', '0', '0', '1923174', '0', '0', '0', '0', '1923174', '0', '1', '0', '0', '0', NULL, '0', '0'),
('4', '12', '0', '49', '46', '2025-06-03', '0000-00-00', '004/2025', '0', '0', '917970', '0', '0', '0', '0', '917970', '0', '1', '0', '0', '0', NULL, '0', '0'),
('5', '12', '0', '49', '46', '2025-06-03', '0000-00-00', '005/2025', '0', '0', '273060', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', NULL, '0', '0'),
('6', '12', '0', '95', '87', '2025-06-03', '0000-00-00', '006/2025', '0', '0', '1552665.4', '0', '0', '0', '0', '1552665.4', '0', '1', '0', '0', '0', NULL, '0', '0'),
('7', '12', '0', '43', '40', '2025-06-03', '0000-00-00', '007/2025', '0', '0', '273060', '0', '0', '0', '0', '273060', '0', '1', '0', '0', '0', NULL, '0', '0'),
('8', '12', '0', '100', '91', '2025-06-03', '0000-00-00', '008/2025', '0', '0', '502235.65', '0', '0', '0', '0', '502235.65', '0', '1', '0', '0', '0', NULL, '0', '0'),
('1', '13', '2', '96', '88', '2025-06-03', '2025-06-03', 'auto', '1', '1', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0', ''),
('2', '13', '1', '98', '89', '2025-06-03', '2025-06-03', 'auto', '1', '2', '4500.36', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0', ''),
('3', '13', '1', '99', '90', '2025-06-03', '2025-06-03', 'auto', '1', '3', '1923174', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0', ''),
('4', '13', '1', '31', '28', '2025-06-03', '2025-06-23', 'auto', '1', '4', '1802629', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '2', '0', '6325'),
('5', '13', '1', '84', '77', '2025-06-03', '2025-06-18', 'auto', '1', '5', '2450519.84', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0', '11345'),
('6', '13', '1', '49', '46', '2025-06-03', '2025-06-03', 'auto', '1', '6', '917970', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0', '4135'),
('7', '13', '2', '49', '46', '2025-06-03', '2025-06-03', 'auto', '1', '7', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0', '1230'),
('8', '13', '1', '95', '87', '2025-06-03', '2025-06-03', 'auto', '1', '8', '1552665.4', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0', '6970'),
('9', '13', '1', '43', '40', '2025-06-03', '2025-06-03', 'auto', '1', '9', '273060', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0', '1230'),
('10', '13', '1', '100', '91', '2025-06-03', '2025-06-03', 'auto', '1', '10', '502235.65', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0', '2101');

### Structure of table `0_debtor_trans_details` ###

DROP TABLE IF EXISTS `0_debtor_trans_details`;

CREATE TABLE `0_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `batch_no` varchar(30) NOT NULL,
  `exp_date` date NOT NULL,
  `description` tinytext DEFAULT NULL,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  `standard_cost` double NOT NULL DEFAULT 0,
  `qty_done` double NOT NULL DEFAULT 0,
  `src_id` int(11) NOT NULL,
  `price_type` int(11) NOT NULL DEFAULT 0,
  `price_type_per` varchar(225) NOT NULL,
  `list_and_weight` varchar(225) NOT NULL,
  `factory_weight` varchar(225) NOT NULL,
  `unit_id` varchar(225) NOT NULL,
  `loss_weight` varchar(500) NOT NULL DEFAULT '0',
  `gain_weight` varchar(500) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_debtor_trans_details` ###

INSERT INTO `0_debtor_trans_details` VALUES
('1', '1', '13', '14581374', '001/2025', '2025-06-03', '1&quot;1/4 x 1&quot;1/4 20 gauge', '0', '0', '0', '0', '0', '4', '0', '1', '-7.14', '0', '19', 'Pcs', '0', '0'),
('2', '1', '10', '14581374', '001/2025', '2025-06-03', '1&quot;1/4 x 1&quot;1/4 20 gauge', '0', '0', '0', '0', '0', '0', '0', '1', '-7.14', '0', '19', 'Pcs', '0', '0'),
('3', '2', '13', '14581374', '001/2025', '2025-06-03', '1&quot;1/4 x 1&quot;1/4 20 gauge', '1125.09', '0', '4', '0', '960', '4', '2', '1', '-7.14', '0', '19', 'Pcs', '0', '0'),
('4', '2', '10', '14581374', '001/2025', '2025-06-03', '1&quot;1/4 x 1&quot;1/4 20 gauge', '1125.09', '0', '4', '0', '960', '0', '3', '1', '-7.14', '0', '19', 'Pcs', '0', '0'),
('5', '3', '13', '14581450', '003/2025', '2025-06-03', '1&quot; x 3&quot; 23 gauge', '1068.43', '0', '1800', '0', '950', '1800', '3', '2', '285', '0', '6748', 'Pcs', '0', '0'),
('6', '3', '10', '14581450', '003/2025', '2025-06-03', '1&quot; x 3&quot; 23 gauge', '1068.43', '0', '1800', '0', '950', '0', '5', '2', '285', '0', '6748', 'Pcs', '0', '0'),
('7', '4', '13', '22197504', '003/2025', '2025-06-03', '1&quot; x 3&quot; 23 guage 18Ft', '967.03', '0', '1300', '0', '0', '1300', '4', '2', '285', '', '4411', 'KG', '0', '0'),
('8', '4', '13', '14581450', '003/2025', '2025-06-03', '1&quot; x 3&quot; 23 gauge', '1090.98', '0', '500', '0', '950', '500', '5', '2', '285', '', '1914', 'Pcs', '0', '0'),
('9', '4', '10', '22197504', '003/2025', '2025-06-03', '1&quot; x 3&quot; 23 guage 18Ft', '967.03', '0', '1300', '0', '0', '0', '7', '2', '285', '', '4411', 'KG', '0', '0'),
('10', '4', '10', '14581450', '003/2025', '2025-06-03', '1&quot; x 3&quot; 23 gauge', '1090.98', '0', '500', '0', '950', '0', '8', '2', '285', '', '1914', 'Pcs', '0', '0'),
('11', '5', '13', '10000086', '002/2025', '2025-06-03', '3/4&quot; x 3/4&quot; 20 guage', '621.16', '0.00000000000011664861906506', '499', '0', '769.2', '499', '6', '2', '216', '0', '1435', 'Pcs', '0', '0'),
('12', '5', '13', '10000087', '002/2025', '2025-06-03', '3/4&quot; x 3/4&quot; 18 guage', '878.69', '0', '500', '0', '1048.2', '500', '7', '2', '216', '0', '2034', 'Pcs', '0', '0'),
('13', '5', '13', '10000088', '001/2025', '2025-06-03', '3/4&quot; x 3/4&quot; 16 guage', '1161.36', '0.00000000000019402553637822', '300', '0', '976.49', '300', '8', '2', '216', '0', '1613', 'Pcs', '0', '0'),
('14', '5', '13', '14581483', '002/2025', '2025-06-03', '2&quot; x 4&quot; 16 gauge', '4433.4', '0.00000000000058207660913467', '200', '0', '5746', '200', '9', '2', '216', '0', '4105', 'Pcs', '0', '0'),
('15', '5', '13', '14581438', '005/2025', '2025-06-03', '1&quot; x 1&quot;1/2 18 gauge', '1473.12', '0', '100', '0', '0', '100', '10', '2', '216', '0', '682', 'Pcs', '0', '0'),
('16', '5', '13', '14581439', '005/2025', '2025-06-03', '1&quot; x 1&quot;1/2 16 gauge', '2006.64', '0', '100', '0', '0', '100', '11', '2', '216', '0', '929', 'Pcs', '0', '0'),
('17', '5', '13', '14581418', '002/2025', '2025-06-03', '1/2 x 1&quot; 16 gauge', '1181.52', '0', '100', '0', '1358', '100', '12', '2', '216', '0', '547', 'Pcs', '0', '0'),
('18', '5', '10', '10000086', '002/2025', '2025-06-03', '3/4&quot; x 3/4&quot; 20 guage', '621.16', '0.00000000000011664861906506', '499', '0', '769.2', '0', '11', '2', '216', '0', '1435', 'Pcs', '0', '0'),
('19', '5', '10', '10000087', '002/2025', '2025-06-03', '3/4&quot; x 3/4&quot; 18 guage', '878.69', '0', '500', '0', '1048.2', '0', '12', '2', '216', '0', '2034', 'Pcs', '0', '0'),
('20', '5', '10', '10000088', '001/2025', '2025-06-03', '3/4&quot; x 3/4&quot; 16 guage', '1161.36', '0.00000000000019402553637822', '300', '0', '976.49', '0', '13', '2', '216', '0', '1613', 'Pcs', '0', '0'),
('21', '5', '10', '14581483', '002/2025', '2025-06-03', '2&quot; x 4&quot; 16 gauge', '4433.4', '0.00000000000058207660913467', '200', '0', '5746', '0', '14', '2', '216', '0', '4105', 'Pcs', '0', '0'),
('22', '5', '10', '14581438', '005/2025', '2025-06-03', '1&quot; x 1&quot;1/2 18 gauge', '1473.12', '0', '100', '0', '0', '0', '15', '2', '216', '0', '682', 'Pcs', '0', '0'),
('23', '5', '10', '14581439', '005/2025', '2025-06-03', '1&quot; x 1&quot;1/2 16 gauge', '2006.64', '0', '100', '0', '0', '0', '16', '2', '216', '0', '929', 'Pcs', '0', '0'),
('24', '5', '10', '14581418', '002/2025', '2025-06-03', '1/2 x 1&quot; 16 gauge', '1181.52', '0', '100', '0', '1358', '0', '17', '2', '216', '0', '547', 'Pcs', '0', '0'),
('25', '6', '13', '14581417', '002/2025', '2025-06-03', '1/2 x 1&quot; 18 gauge', '915.38', '0', '300', '0', '1048.2', '300', '13', '2', '222', '0', '1237', 'Pcs', '0', '0'),
('26', '6', '13', '10000087', '002/2025', '2025-06-03', '3/4&quot; x 3/4&quot; 18 guage', '909.09', '0', '200', '0', '1048.2', '200', '14', '2', '222', '0', '819', 'Pcs', '0', '0'),
('27', '6', '13', '14581438', '005/2025', '2025-06-03', '1&quot; x 1&quot;1/2 18 gauge', '1519.59', '0', '200', '0', '0', '200', '15', '2', '222', '0', '1369', 'Pcs', '0', '0'),
('28', '6', '13', '14581458', '001/2025', '2025-06-03', '1&quot;1/4 x 2&quot;1/2 18 gauge', '2153.4', '0', '10', '0', '1960', '10', '16', '2', '222', '0', '97', 'Pcs', '0', '0'),
('29', '6', '13', '14581483', '002/2025', '2025-06-03', '2&quot; x 4&quot; 16 gauge', '4536.2', '0', '30', '0', '5746', '30', '17', '2', '222', '0', '613', 'Pcs', '0', '0'),
('30', '6', '10', '14581417', '002/2025', '2025-06-03', '1/2 x 1&quot; 18 gauge', '915.38', '0', '300', '0', '1048.2', '0', '25', '2', '222', '0', '1237', 'Pcs', '0', '0'),
('31', '6', '10', '10000087', '002/2025', '2025-06-03', '3/4&quot; x 3/4&quot; 18 guage', '909.09', '0', '200', '0', '1048.2', '0', '26', '2', '222', '0', '819', 'Pcs', '0', '0'),
('32', '6', '10', '14581438', '005/2025', '2025-06-03', '1&quot; x 1&quot;1/2 18 gauge', '1519.59', '0', '200', '0', '0', '0', '27', '2', '222', '0', '1369', 'Pcs', '0', '0'),
('33', '6', '10', '14581458', '001/2025', '2025-06-03', '1&quot;1/4 x 2&quot;1/2 18 gauge', '2153.4', '0', '10', '0', '1960', '0', '28', '2', '222', '0', '97', 'Pcs', '0', '0'),
('34', '6', '10', '14581483', '002/2025', '2025-06-03', '2&quot; x 4&quot; 16 gauge', '4536.2', '0', '30', '0', '5746', '0', '29', '2', '222', '0', '613', 'Pcs', '0', '0'),
('35', '7', '13', '14581483', '002/2025', '2025-06-03', '2&quot; x 4&quot; 16 gauge', '0', '0', '0', '0', '0', '60', '0', '2', '222', '0', '1230', 'Pcs', '0', '0'),
('36', '7', '10', '14581483', '002/2025', '2025-06-03', '2&quot; x 4&quot; 16 gauge', '0', '0', '0', '0', '0', '0', '0', '2', '222', '0', '1230', 'Pcs', '0', '0'),
('37', '8', '13', '14581393', '001/2025', '2025-06-03', '45 x 45 18 gauge', '2205.9', '0', '100', '0', '1960', '100', '19', '1', '-10', '0', '996', 'Pcs', '0', '0'),
('38', '8', '13', '14581438', '005/2025', '2025-06-03', '1&quot; x 1&quot;1/2 18 gauge', '1562.4', '0', '200', '0', '0', '200', '20', '1', '-10', '0', '1433', 'Pcs', '0', '0'),
('39', '8', '13', '14581454', '001/2025', '2025-06-03', '1&quot; x 3&quot; 18 gauge', '2205.9', '0', '10', '0', '1960', '10', '21', '1', '-10', '0', '99', 'Pcs', '0', '0'),
('40', '8', '13', '14581439', '005/2025', '2025-06-03', '1&quot; x 1&quot;1/2 16 gauge', '2071.8', '0', '150', '0', '0', '150', '22', '1', '-10', '0', '1404', 'Pcs', '0', '0'),
('41', '8', '13', '10000013', '002/2025', '2025-06-03', '1&quot; round 16 guage', '1222.2', '0', '100', '0', '1358', '100', '23', '1', '-10', '0', '545', 'Pcs', '0', '0'),
('42', '8', '13', '10000051', '001/2025', '2025-06-03', '2&quot;1/4 round 14 guage', '3478', '0', '30', '0', '3200', '30', '24', '2', '222', '0', '470', 'Pcs', '0', '0'),
('43', '8', '13', '10000068', '001/2025', '2025-06-03', '95mm round 14 guage', '5752.58', '0', '80', '0', '5200', '80', '25', '2', '222', '0', '2073', 'Pcs', '0', '0'),
('44', '8', '10', '14581393', '001/2025', '2025-06-03', '45 x 45 18 gauge', '2205.9', '0', '100', '0', '1960', '0', '37', '1', '-10', '0', '996', 'Pcs', '0', '0'),
('45', '8', '10', '14581438', '005/2025', '2025-06-03', '1&quot; x 1&quot;1/2 18 gauge', '1562.4', '0', '200', '0', '0', '0', '38', '1', '-10', '0', '1433', 'Pcs', '0', '0'),
('46', '8', '10', '14581454', '001/2025', '2025-06-03', '1&quot; x 3&quot; 18 gauge', '2205.9', '0', '10', '0', '1960', '0', '39', '1', '-10', '0', '99', 'Pcs', '0', '0'),
('47', '8', '10', '14581439', '005/2025', '2025-06-03', '1&quot; x 1&quot;1/2 16 gauge', '2071.8', '0', '150', '0', '0', '0', '40', '1', '-10', '0', '1404', 'Pcs', '0', '0'),
('48', '8', '10', '10000013', '002/2025', '2025-06-03', '1&quot; round 16 guage', '1222.2', '0', '100', '0', '1358', '0', '41', '1', '-10', '0', '545', 'Pcs', '0', '0'),
('49', '8', '10', '10000051', '001/2025', '2025-06-03', '2&quot;1/4 round 14 guage', '3478', '0', '30', '0', '3200', '0', '42', '2', '222', '0', '470', 'Pcs', '0', '0'),
('50', '8', '10', '10000068', '001/2025', '2025-06-03', '95mm round 14 guage', '5752.58', '0', '80', '0', '5200', '0', '43', '2', '222', '0', '2073', 'Pcs', '0', '0'),
('51', '9', '13', '14581483', '002/2025', '2025-06-03', '2&quot; x 4&quot; 16 gauge', '4551', '0', '60', '0', '5746', '60', '26', '2', '222', '0', '1230', 'Pcs', '0', '0'),
('52', '9', '10', '14581483', '002/2025', '2025-06-03', '2&quot; x 4&quot; 16 gauge', '4551', '0', '60', '0', '5746', '0', '51', '2', '222', '0', '1230', 'Pcs', '0', '0'),
('53', '10', '13', '10000094', '008/2025', '2025-06-03', '1&quot; x 1&quot; 18 guage', '1227.97', '0', '310', '0', '0', '310', '27', '1', '-7', '0', '1575', 'Pcs', '0', '0'),
('54', '10', '13', '14581445', '007/2025', '2025-06-03', '1&quot; x 2&quot; 18 gauge', '1870.23', '0', '65', '0', '0', '65', '28', '1', '-7', '0', '526', 'Pcs', '0', '0'),
('55', '10', '10', '10000094', '008/2025', '2025-06-03', '1&quot; x 1&quot; 18 guage', '1227.97', '0', '310', '0', '0', '0', '53', '1', '-7', '0', '1575', 'Pcs', '0', '0'),
('56', '10', '10', '14581445', '007/2025', '2025-06-03', '1&quot; x 2&quot; 18 gauge', '1870.23', '0', '65', '0', '0', '0', '54', '1', '-7', '0', '526', 'Pcs', '0', '0');

### Structure of table `0_debtors_master` ###

DROP TABLE IF EXISTS `0_debtors_master`;

CREATE TABLE `0_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `debtor_ref` varchar(50) NOT NULL,
  `address` tinytext DEFAULT NULL,
  `tax_id` varchar(55) NOT NULL DEFAULT '',
  `curr_code` char(3) NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT 1,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `credit_status` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT 0,
  `pymt_discount` double NOT NULL DEFAULT 0,
  `credit_limit` float NOT NULL DEFAULT 1000,
  `notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_debtors_master` ###

INSERT INTO `0_debtors_master` VALUES
('1', 'Osama sports', 'Osama sports', NULL, '', 'PKR', '1', '0', '0', '1', '1', '0', '0', '1500000', '', '0'),
('2', 'Alla uddin Asalan', 'Alla uddin Asalan', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '25000000', '', '0'),
('3', 'Haji anwar hyd', 'Haji anwar hyd', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '15000000', '', '0'),
('4', 'Afzal Awan', 'Afzal Awan', NULL, '', 'PKR', '1', '0', '0', '1', '1', '0', '0', '1000000', '', '0'),
('5', 'Hamza orangi', 'Hamza orangi', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '8000000', '', '0'),
('6', 'humayun', 'humayun', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '1500000', '', '0'),
('7', 'Al Makkah (Akram)', 'Al Makkah (Akram)', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '500000', '', '0'),
('8', 'Habib kabul', 'Habib kabul', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '1500000', '', '0'),
('9', 'Al Noor Hani', 'Al Noor Hani', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '2500000', '', '0'),
('10', 'ikram and sons ', 'ikram and sons ', NULL, '', 'PKR', '1', '0', '0', '1', '1', '0', '0', '1500000', '', '0'),
('11', 'juaid hamza ', 'juaid hamza ', NULL, '', 'PKR', '1', '0', '0', '1', '1', '0', '0', '500000', '', '0'),
('12', 'Ansari Steel (Haji Basheer Landhi)', 'Ansari Steel (Haji Basheer)', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '8000000', '', '0'),
('13', 'Arshad Garden ', 'Arshad Garden ', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '4000000', '', '0'),
('14', 'Asad Lalukhait', 'Asad Lalukhait', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '3000000', '', '0'),
('15', 'Khurram Butt', 'Khurram Butt', NULL, '', 'PKR', '1', '0', '0', '1', '1', '0', '0', '500000', '', '0'),
('17', 'Bilal Lalukhait', 'Bilal Lalukhait', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '3000000', '', '0'),
('20', 'Moin market', 'Moin market', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '2500000', '', '0'),
('21', 'Dubai Hardware', 'Dubai Hardware', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '3500000', '', '0'),
('22', 'Nadeem lalokhait', 'Nadeem lalokhait', NULL, '', 'PKR', '1', '0', '0', '1', '3', '0', '0', '5000000', '', '0'),
('23', 'Ehtesham Hyderabad', 'Ehtesham Hyderabad', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '3500000', '', '0'),
('24', 'Nadeem mughal', 'Nadeem mughal', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '3500000', '', '0'),
('25', 'Green Hardware Daniyal', 'Green Hardware Daniyal', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '5000000', '', '0'),
('26', 'NADEEM ALMUNIUM', 'NADEEM ALMUNIUM', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '2000000', '', '0'),
('27', 'NAEEM KHALIL ', 'NAEEM KHALIL ', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '2500000', '', '0'),
('28', 'Owais Touseef Cutter', 'Owais Touseef Cutter', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '5000000', '', '0'),
('29', 'UNITED STEEL rasheed', 'UNITED STEEL rasheed', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '0', '', '0'),
('30', 'Qadri Steel Imran', 'Qadri Steel Imran', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '15000000', '', '0'),
('31', 'Raja Orangi Riaz', 'Raja Orangi Riaz', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '8000000', '', '0'),
('32', 'Razaq Scrap (Lahore)', 'Razaq Scrap (Lahore)', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '2000000', '', '0'),
('33', 'Rizwan Babar Market', 'Rizwan Babar Market', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '6000000', '', '0'),
('34', 'Sattar Scrap (Lahore)', 'Sattar Scrap (Lahore)', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '2500000', '', '0'),
('35', 'S.B.Traders Muzamil', 'S.B.Traders Muzamil', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '15000000', '', '0'),
('36', 'Sarim Marmonex', 'Sarim Marmonex', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '2500000', '', '0'),
('37', 'Shakeel Pipe', 'Shakeel Pipe', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '0', '', '0'),
('38', 'Tahir Timber ', 'Tahir Timber ', NULL, '', 'PKR', '1', '0', '0', '1', '1', '0', '0', '2500000', '', '0'),
('39', 'Cash Party', 'cash party', NULL, '', 'PKR', '1', '0', '0', '1', '1', '0', '0', '2500000', '', '0'),
('40', 'qaiser latif', 'Qaiser latif', NULL, '', 'PKR', '1', '0', '0', '1', '5', '0', '0', '1000', '', '0'),
('41', 'Khalil Nagan ', 'Khalil Nagan ', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('43', 'Imran Malir', 'Imran malir', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('44', 'idrees butt', 'idrees butt', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('46', 'huzaifa lalukhait', 'Huzaifa Co Nadeem Lalukhait', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('47', 'SHANI MALIR', 'SHANI MALIR', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('48', 'MADINA PIPE AZEEM', 'Madina Pipe Azeem Pata Pipe', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('49', 'Yasir Shoukat', 'Yasir Shoukat Nazimabad', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('50', 'NADEEM NAEEM GODHRA', 'NADEEM NAEM GODHRA', '', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('51', 'Ayan Pipe', 'Ayan Pipe', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('52', 'Ayan Pipe ABEER NAEEM', 'Ayan Pipe ABEER NAEEM', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('53', 'ABEER NAEEM', 'ABEER NAEEM', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('54', 'Ahtisham Green', 'Ahtisham Green', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('55', 'Abdul Wahab Shairsha', 'Abdul Wahab Shairsha', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('56', 'Abbas Iron', 'Abbas Iron', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('57', 'Atif Sahab', 'Atif Sahab', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('58', 'Abid Scrape Shairsha', 'Abid Scrape Shairsha', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('59', 'Abid Bhai--Orangi', 'Abid Bhai--Orangi', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('60', 'ADNAN BHAI-- ANNA', 'ADNAN BHAI-- ANNA', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('61', 'ADNAN BHAI-- ANNA Afzal Awan', 'ADNAN BHAI-- ANNA Afzal Awan', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('62', 'Ahmar Lalukhat', 'Ahmar Lalukhat', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('63', 'AKRAM BEAUTY STEEL', 'AKRAM BEAUTY STEEL', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('64', 'Akhtar Bhai', 'Akhtar Bhai', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('65', 'ALI Raza Behria', 'ALI Raza Behria', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('66', 'Al-Makkah (Akram)', 'Al-Makkah (Akram)', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('67', 'AL-NABEEL Pipe', 'AL-NABEEL Pipe', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('68', 'AL-NOOR -- HANI', 'AL-NOOR -- HANI', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('73', 'ANSARI STEEL (HAJI BASHEER LANDHI)', 'ANSARI STEEL (HAJI BASHEER LANDHI)', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('74', 'ARSHAD -- GARDEN', 'ARSHAD -- GARDEN', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('75', 'Asad Lalukhat', 'Asad Lalukhat', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('76', 'Azeem Butt Jubilee Pipe', 'Azeem Butt Jubilee Pipe', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('77', 'Abdul Wali Khan', 'Abdul Wali Khan', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('79', 'Ali Orangi', 'Ali Orangi', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('80', 'Bilal Welder', 'Bilal Welder', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('82', 'Shahid ', 'Shahid', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '1000', '', '0'),
('83', 'Aliyan', 'Aliyan', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '1000', '', '0'),
('84', 'Shahid Hyd Pipe Maqbool Tube Well', 'Shahid Hyd Pipe Maqbool Tube Well', NULL, '', 'PKR', '1', '0', '0', '1', '1', '0', '0', '10000000', '', '0'),
('85', 'UNKNOWN ENTRIES', 'UNKNOWN ENTRIES', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '1000000', '', '0'),
('86', 'IRFAN SCRAP', 'IRFAN SCRAP', NULL, '', 'PKR', '1', '0', '0', '1', '1', '0', '0', '1000', '', '0'),
('87', 'SAEED BHAI INVOICE', 'SAEED BHAI INVOICE', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('88', 'Mirza Orangi', 'Mirza Orangi', NULL, '', 'PKR', '1', '0', '0', '1', '2', '0', '0', '1000', '', '0'),
('89', 'New Qadri ', 'New Qadri ', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('91', 'M. Ali', 'M. Ali', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('92', 'Amir Osama', 'Amir', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('93', 'Aashiq Hardware', 'Ashiq', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('94', 'Sameer bhai', 'Sameer', NULL, '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('95', 'Qadri Iron', 'Qaadri Iron', 'Qaadri Iron', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('96', 'NAJEEB ULLAH.', 'NAJEEB ULLAH.', 'NAJEEB ULLAH.', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('98', '(Najeeb Ullah)', '(Najeeb Ullah)', '(Najeeb Ullah)', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('99', 'Bashir Landhi.', 'Bashir Landhi.', 'Bashir Landhi.', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('100', 'Saima Paari Jinnah Avenue', 'Saima Paari', 'Saima Paari Mall, North Nazimabad, Karachi.', '', 'PKR', '1', '0', '0', '1', '4', '0', '0', '1000', '', '0');

### Structure of table `0_dimensions` ###

DROP TABLE IF EXISTS `0_dimensions`;

CREATE TABLE `0_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT 1,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `dimension_id` int(11) DEFAULT NULL COMMENT 'dimension_id is sub id of dimension l..',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_dimensions` ###

INSERT INTO `0_dimensions` VALUES
('1', '001/2022', 'F B Area DIM', '1', '0', '2022-03-30', '2022-04-19', NULL);

### Structure of table `0_exchange_rates` ###

DROP TABLE IF EXISTS `0_exchange_rates`;

CREATE TABLE `0_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT 0,
  `rate_sell` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_exchange_rates` ###

INSERT INTO `0_exchange_rates` VALUES
('1', 'USD', '189.28', '189.28', '2022-05-11'),
('2', 'USD', '189.28', '189.28', '2022-05-17'),
('3', 'USD', '189.28', '189.28', '2022-05-19'),
('4', 'USD', '189.28', '189.28', '2022-05-20'),
('5', 'USD', '189.28', '189.28', '2022-05-22'),
('6', 'USD', '189.28', '189.28', '2022-06-02'),
('7', 'USD', '189.28', '189.28', '2022-06-03'),
('8', 'USD', '189.28', '189.28', '2022-06-09'),
('9', 'USD', '189.28', '189.28', '2022-06-15'),
('10', 'USD', '189.28', '189.28', '2022-09-26');

### Structure of table `0_fiscal_year` ###

DROP TABLE IF EXISTS `0_fiscal_year`;

CREATE TABLE `0_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_fiscal_year` ###

INSERT INTO `0_fiscal_year` VALUES
('1', '2020-01-01', '2020-12-31', '1'),
('2', '2021-01-01', '2021-12-31', '0'),
('3', '2022-01-01', '2022-12-31', '0'),
('4', '2023-01-01', '2023-12-31', '0'),
('5', '2024-01-01', '2024-12-31', '0'),
('6', '2025-01-01', '2025-12-31', '0');

### Structure of table `0_gl_trans` ###

DROP TABLE IF EXISTS `0_gl_trans`;

CREATE TABLE `0_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT 0,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) NOT NULL DEFAULT '',
  `memo_` tinytext NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob DEFAULT NULL,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=459 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_gl_trans` ###

INSERT INTO `0_gl_trans` VALUES
('1', '17', '1', '2025-05-29', '5040', '', '0', '0', '0', NULL, NULL),
('2', '17', '1', '2025-05-29', '1510', '', '0', '0', '0', NULL, NULL),
('3', '17', '1', '2025-05-29', '5040', '', '0', '0', '0', NULL, NULL),
('4', '17', '1', '2025-05-29', '1510', '', '0', '0', '0', NULL, NULL),
('5', '17', '1', '2025-05-29', '5040', '', '0', '0', '0', NULL, NULL),
('6', '17', '1', '2025-05-29', '1510', '', '0', '0', '0', NULL, NULL),
('7', '17', '2', '2025-05-29', '5040', '', '-80602', '0', '0', NULL, NULL),
('8', '17', '2', '2025-05-29', '1510', '', '80602', '0', '0', NULL, NULL),
('9', '17', '2', '2025-05-29', '5040', '', '-80602', '0', '0', NULL, NULL),
('10', '17', '2', '2025-05-29', '1510', '', '80602', '0', '0', NULL, NULL),
('11', '17', '2', '2025-05-29', '5040', '', '-50800', '0', '0', NULL, NULL),
('12', '17', '2', '2025-05-29', '1510', '', '50800', '0', '0', NULL, NULL),
('13', '17', '2', '2025-05-29', '5040', '', '-50800', '0', '0', NULL, NULL),
('14', '17', '2', '2025-05-29', '1510', '', '50800', '0', '0', NULL, NULL),
('15', '17', '2', '2025-05-29', '5040', '', '-65196.48', '0', '0', NULL, NULL),
('16', '17', '2', '2025-05-29', '1510', '', '65196.48', '0', '0', NULL, NULL),
('17', '17', '2', '2025-05-29', '5040', '', '-65196.48', '0', '0', NULL, NULL),
('18', '17', '2', '2025-05-29', '1510', '', '65196.48', '0', '0', NULL, NULL),
('19', '17', '2', '2025-05-29', '5040', '', '-65196.48', '0', '0', NULL, NULL),
('20', '17', '2', '2025-05-29', '1510', '', '65196.48', '0', '0', NULL, NULL),
('21', '17', '2', '2025-05-29', '5040', '', '-65196.48', '0', '0', NULL, NULL),
('22', '17', '2', '2025-05-29', '1510', '', '65196.48', '0', '0', NULL, NULL),
('23', '17', '2', '2025-05-29', '5040', '', '-65196.48', '0', '0', NULL, NULL),
('24', '17', '2', '2025-05-29', '1510', '', '65196.48', '0', '0', NULL, NULL),
('25', '17', '2', '2025-05-29', '5040', '', '-85140', '0', '0', NULL, NULL),
('26', '17', '2', '2025-05-29', '1510', '', '85140', '0', '0', NULL, NULL),
('27', '17', '2', '2025-05-29', '5040', '', '-85140', '0', '0', NULL, NULL),
('28', '17', '2', '2025-05-29', '1510', '', '85140', '0', '0', NULL, NULL),
('29', '17', '2', '2025-05-29', '5040', '', '-17080', '0', '0', NULL, NULL),
('30', '17', '2', '2025-05-29', '1510', '', '17080', '0', '0', NULL, NULL),
('31', '17', '2', '2025-05-29', '5040', '', '-66000', '0', '0', NULL, NULL),
('32', '17', '2', '2025-05-29', '1510', '', '66000', '0', '0', NULL, NULL),
('33', '17', '2', '2025-05-29', '5040', '', '-66000', '0', '0', NULL, NULL),
('34', '17', '2', '2025-05-29', '1510', '', '66000', '0', '0', NULL, NULL),
('35', '17', '2', '2025-05-29', '5040', '', '-66000', '0', '0', NULL, NULL),
('36', '17', '2', '2025-05-29', '1510', '', '66000', '0', '0', NULL, NULL),
('37', '17', '2', '2025-05-29', '5040', '', '-66000', '0', '0', NULL, NULL),
('38', '17', '2', '2025-05-29', '1510', '', '66000', '0', '0', NULL, NULL),
('39', '17', '2', '2025-05-29', '5040', '', '-82720', '0', '0', NULL, NULL),
('40', '17', '2', '2025-05-29', '1510', '', '82720', '0', '0', NULL, NULL),
('41', '17', '2', '2025-05-29', '5040', '', '-82720', '0', '0', NULL, NULL),
('42', '17', '2', '2025-05-29', '1510', '', '82720', '0', '0', NULL, NULL),
('43', '17', '2', '2025-05-29', '5040', '', '-82720', '0', '0', NULL, NULL),
('44', '17', '2', '2025-05-29', '1510', '', '82720', '0', '0', NULL, NULL),
('45', '17', '2', '2025-05-29', '5040', '', '-82720', '0', '0', NULL, NULL),
('46', '17', '2', '2025-05-29', '1510', '', '82720', '0', '0', NULL, NULL),
('47', '17', '2', '2025-05-29', '5040', '', '-82720', '0', '0', NULL, NULL),
('48', '17', '2', '2025-05-29', '1510', '', '82720', '0', '0', NULL, NULL),
('49', '17', '2', '2025-05-29', '5040', '', '-82720', '0', '0', NULL, NULL),
('50', '17', '2', '2025-05-29', '1510', '', '82720', '0', '0', NULL, NULL),
('51', '17', '2', '2025-05-29', '5040', '', '-191100', '0', '0', NULL, NULL),
('52', '17', '2', '2025-05-29', '1510', '', '191100', '0', '0', NULL, NULL),
('53', '17', '2', '2025-05-29', '5040', '', '-191100', '0', '0', NULL, NULL),
('54', '17', '2', '2025-05-29', '1510', '', '191100', '0', '0', NULL, NULL),
('55', '17', '2', '2025-05-29', '5040', '', '-191100', '0', '0', NULL, NULL),
('56', '17', '2', '2025-05-29', '1510', '', '191100', '0', '0', NULL, NULL),
('57', '17', '2', '2025-05-29', '5040', '', '-191100', '0', '0', NULL, NULL),
('58', '17', '2', '2025-05-29', '1510', '', '191100', '0', '0', NULL, NULL),
('59', '17', '2', '2025-05-29', '5040', '', '-58800', '0', '0', NULL, NULL),
('60', '17', '2', '2025-05-29', '1510', '', '58800', '0', '0', NULL, NULL),
('61', '17', '2', '2025-05-29', '5040', '', '-134400', '0', '0', NULL, NULL),
('62', '17', '2', '2025-05-29', '1510', '', '134400', '0', '0', NULL, NULL),
('63', '17', '2', '2025-05-29', '5040', '', '-88060', '0', '0', NULL, NULL),
('64', '17', '2', '2025-05-29', '1510', '', '88060', '0', '0', NULL, NULL),
('65', '17', '2', '2025-05-29', '5040', '', '-88060', '0', '0', NULL, NULL),
('66', '17', '2', '2025-05-29', '1510', '', '88060', '0', '0', NULL, NULL),
('67', '17', '2', '2025-05-29', '5040', '', '-97649', '0', '0', NULL, NULL),
('68', '17', '2', '2025-05-29', '1510', '', '97649', '0', '0', NULL, NULL),
('69', '17', '2', '2025-05-29', '5040', '', '-97649', '0', '0', NULL, NULL),
('70', '17', '2', '2025-05-29', '1510', '', '97649', '0', '0', NULL, NULL),
('71', '17', '2', '2025-05-29', '5040', '', '-97649', '0', '0', NULL, NULL),
('72', '17', '2', '2025-05-29', '1510', '', '97649', '0', '0', NULL, NULL),
('73', '17', '2', '2025-05-29', '5040', '', '-19600', '0', '0', NULL, NULL),
('74', '17', '2', '2025-05-29', '1510', '', '19600', '0', '0', NULL, NULL),
('75', '17', '2', '2025-05-29', '5040', '', '-384800', '0', '0', NULL, NULL),
('76', '17', '2', '2025-05-29', '1510', '', '384800', '0', '0', NULL, NULL),
('77', '17', '2', '2025-05-29', '5040', '', '-384800', '0', '0', NULL, NULL),
('78', '17', '2', '2025-05-29', '1510', '', '384800', '0', '0', NULL, NULL),
('79', '17', '2', '2025-05-29', '5040', '', '-279466.67', '0', '0', NULL, NULL),
('80', '17', '2', '2025-05-29', '1510', '', '279466.67', '0', '0', NULL, NULL),
('81', '17', '2', '2025-05-29', '5040', '', '-279466.67', '0', '0', NULL, NULL),
('82', '17', '2', '2025-05-29', '1510', '', '279466.67', '0', '0', NULL, NULL),
('83', '17', '2', '2025-05-29', '5040', '', '-279466.67', '0', '0', NULL, NULL),
('84', '17', '2', '2025-05-29', '1510', '', '279466.67', '0', '0', NULL, NULL),
('85', '17', '3', '2025-05-29', '5040', '', '-116730', '0', '0', NULL, NULL),
('86', '17', '3', '2025-05-29', '1510', '', '116730', '0', '0', NULL, NULL),
('87', '17', '3', '2025-05-29', '5040', '', '-116730', '0', '0', NULL, NULL),
('88', '17', '3', '2025-05-29', '1510', '', '116730', '0', '0', NULL, NULL),
('89', '17', '3', '2025-05-29', '5040', '', '-116730', '0', '0', NULL, NULL),
('90', '17', '3', '2025-05-29', '1510', '', '116730', '0', '0', NULL, NULL),
('91', '17', '3', '2025-05-29', '5040', '', '-109787.2', '0', '0', NULL, NULL),
('92', '17', '3', '2025-05-29', '1510', '', '109787.2', '0', '0', NULL, NULL),
('93', '17', '3', '2025-05-29', '5040', '', '-109787.2', '0', '0', NULL, NULL),
('94', '17', '3', '2025-05-29', '1510', '', '109787.2', '0', '0', NULL, NULL),
('95', '17', '3', '2025-05-29', '5040', '', '-109787.2', '0', '0', NULL, NULL),
('96', '17', '3', '2025-05-29', '1510', '', '109787.2', '0', '0', NULL, NULL),
('97', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('98', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('99', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('100', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('101', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('102', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('103', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('104', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('105', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('106', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('107', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('108', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('109', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('110', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('111', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('112', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('113', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('114', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('115', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('116', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('117', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('118', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('119', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('120', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('121', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('122', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('123', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('124', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('125', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('126', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('127', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('128', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('129', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('130', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('131', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('132', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('133', '17', '3', '2025-05-29', '5040', '', '-75948.38', '0', '0', NULL, NULL),
('134', '17', '3', '2025-05-29', '1510', '', '75948.38', '0', '0', NULL, NULL),
('135', '17', '3', '2025-05-29', '5040', '', '-48705.6', '0', '0', NULL, NULL),
('136', '17', '3', '2025-05-29', '1510', '', '48705.6', '0', '0', NULL, NULL),
('137', '17', '3', '2025-05-29', '5040', '', '-48705.6', '0', '0', NULL, NULL),
('138', '17', '3', '2025-05-29', '1510', '', '48705.6', '0', '0', NULL, NULL),
('139', '17', '3', '2025-05-29', '5040', '', '-48705.6', '0', '0', NULL, NULL),
('140', '17', '3', '2025-05-29', '1510', '', '48705.6', '0', '0', NULL, NULL),
('141', '17', '3', '2025-05-29', '5040', '', '-76766.16', '0', '0', NULL, NULL),
('142', '17', '3', '2025-05-29', '1510', '', '76766.16', '0', '0', NULL, NULL),
('143', '17', '3', '2025-05-29', '5040', '', '-76766.16', '0', '0', NULL, NULL),
('144', '17', '3', '2025-05-29', '1510', '', '76766.16', '0', '0', NULL, NULL),
('145', '17', '3', '2025-05-29', '5040', '', '-76766.16', '0', '0', NULL, NULL),
('146', '17', '3', '2025-05-29', '1510', '', '76766.16', '0', '0', NULL, NULL),
('147', '17', '3', '2025-05-29', '5040', '', '-76766.16', '0', '0', NULL, NULL),
('148', '17', '3', '2025-05-29', '1510', '', '76766.16', '0', '0', NULL, NULL),
('149', '17', '3', '2025-05-29', '5040', '', '-76766.16', '0', '0', NULL, NULL),
('150', '17', '3', '2025-05-29', '1510', '', '76766.16', '0', '0', NULL, NULL),
('151', '17', '3', '2025-05-29', '5040', '', '-40320', '0', '0', NULL, NULL),
('152', '17', '3', '2025-05-29', '1510', '', '40320', '0', '0', NULL, NULL),
('153', '17', '3', '2025-05-29', '5040', '', '-40320', '0', '0', NULL, NULL),
('154', '17', '3', '2025-05-29', '1510', '', '40320', '0', '0', NULL, NULL),
('155', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('156', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('157', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('158', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('159', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('160', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('161', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('162', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('163', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('164', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('165', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('166', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('167', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('168', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('169', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('170', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('171', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('172', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('173', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('174', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('175', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('176', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('177', '17', '3', '2025-05-29', '5040', '', '-100801.9', '0', '0', NULL, NULL),
('178', '17', '3', '2025-05-29', '1510', '', '100801.9', '0', '0', NULL, NULL),
('179', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('180', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('181', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('182', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('183', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('184', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('185', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('186', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('187', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('188', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('189', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('190', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('191', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('192', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('193', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('194', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('195', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('196', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('197', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('198', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('199', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('200', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('201', '17', '3', '2025-05-29', '5040', '', '-104645.3', '0', '0', NULL, NULL),
('202', '17', '3', '2025-05-29', '1510', '', '104645.3', '0', '0', NULL, NULL),
('203', '17', '3', '2025-05-29', '5040', '', '-68629', '0', '0', NULL, NULL),
('204', '17', '3', '2025-05-29', '1510', '', '68629', '0', '0', NULL, NULL),
('205', '17', '3', '2025-05-29', '5040', '', '-129613.56', '0', '0', NULL, NULL),
('206', '17', '3', '2025-05-29', '1510', '', '129613.56', '0', '0', NULL, NULL),
('207', '17', '3', '2025-05-29', '5040', '', '-129613.56', '0', '0', NULL, NULL),
('208', '17', '3', '2025-05-29', '1510', '', '129613.56', '0', '0', NULL, NULL),
('209', '17', '3', '2025-05-29', '5040', '', '-129613.56', '0', '0', NULL, NULL),
('210', '17', '3', '2025-05-29', '1510', '', '129613.56', '0', '0', NULL, NULL),
('211', '17', '3', '2025-05-29', '5040', '', '-129613.56', '0', '0', NULL, NULL),
('212', '17', '3', '2025-05-29', '1510', '', '129613.56', '0', '0', NULL, NULL),
('213', '17', '3', '2025-05-29', '5040', '', '-129613.56', '0', '0', NULL, NULL),
('214', '17', '3', '2025-05-29', '1510', '', '129613.56', '0', '0', NULL, NULL),
('215', '17', '3', '2025-05-29', '5040', '', '-129613.56', '0', '0', NULL, NULL),
('216', '17', '3', '2025-05-29', '1510', '', '129613.56', '0', '0', NULL, NULL),
('217', '17', '3', '2025-05-29', '5040', '', '-129613.56', '0', '0', NULL, NULL),
('218', '17', '3', '2025-05-29', '1510', '', '129613.56', '0', '0', NULL, NULL),
('219', '17', '3', '2025-05-29', '5040', '', '-129613.56', '0', '0', NULL, NULL),
('220', '17', '3', '2025-05-29', '1510', '', '129613.56', '0', '0', NULL, NULL),
('221', '17', '3', '2025-05-29', '5040', '', '-129613.56', '0', '0', NULL, NULL),
('222', '17', '3', '2025-05-29', '1510', '', '129613.56', '0', '0', NULL, NULL),
('223', '17', '3', '2025-05-29', '5040', '', '-7251', '0', '0', NULL, NULL),
('224', '17', '3', '2025-05-29', '1510', '', '7251', '0', '0', NULL, NULL),
('225', '17', '3', '2025-05-29', '5040', '', '-132540.8', '0', '0', NULL, NULL),
('226', '17', '3', '2025-05-29', '1510', '', '132540.8', '0', '0', NULL, NULL),
('227', '17', '3', '2025-05-29', '5040', '', '-132540.8', '0', '0', NULL, NULL),
('228', '17', '3', '2025-05-29', '1510', '', '132540.8', '0', '0', NULL, NULL),
('229', '17', '3', '2025-05-29', '5040', '', '-132540.8', '0', '0', NULL, NULL),
('230', '17', '3', '2025-05-29', '1510', '', '132540.8', '0', '0', NULL, NULL),
('231', '17', '3', '2025-05-29', '5040', '', '-132540.8', '0', '0', NULL, NULL),
('232', '17', '3', '2025-05-29', '1510', '', '132540.8', '0', '0', NULL, NULL),
('233', '17', '3', '2025-05-29', '5040', '', '-132540.8', '0', '0', NULL, NULL),
('234', '17', '3', '2025-05-29', '1510', '', '132540.8', '0', '0', NULL, NULL),
('235', '17', '3', '2025-05-29', '5040', '', '-459680', '0', '0', NULL, NULL),
('236', '17', '3', '2025-05-29', '1510', '', '459680', '0', '0', NULL, NULL),
('237', '17', '3', '2025-05-29', '5040', '', '-522886', '0', '0', NULL, NULL),
('238', '17', '3', '2025-05-29', '1510', '', '522886', '0', '0', NULL, NULL),
('239', '17', '3', '2025-05-29', '5040', '', '-522886', '0', '0', NULL, NULL),
('240', '17', '3', '2025-05-29', '1510', '', '522886', '0', '0', NULL, NULL),
('241', '17', '3', '2025-05-29', '5040', '', '-522886', '0', '0', NULL, NULL),
('242', '17', '3', '2025-05-29', '1510', '', '522886', '0', '0', NULL, NULL),
('243', '17', '3', '2025-05-29', '5040', '', '-522886', '0', '0', NULL, NULL),
('244', '17', '3', '2025-05-29', '1510', '', '522886', '0', '0', NULL, NULL),
('245', '17', '3', '2025-05-29', '5040', '', '-522886', '0', '0', NULL, NULL),
('246', '17', '3', '2025-05-29', '1510', '', '522886', '0', '0', NULL, NULL),
('247', '17', '3', '2025-05-29', '5040', '', '-436800', '0', '0', NULL, NULL),
('248', '17', '3', '2025-05-29', '1510', '', '436800', '0', '0', NULL, NULL),
('249', '17', '3', '2025-05-29', '5040', '', '-21840', '0', '0', NULL, NULL),
('250', '17', '3', '2025-05-29', '1510', '', '21840', '0', '0', NULL, NULL),
('251', '17', '3', '2025-05-29', '5040', '', '-581560', '0', '0', NULL, NULL),
('252', '17', '3', '2025-05-29', '1510', '', '581560', '0', '0', NULL, NULL),
('253', '17', '3', '2025-05-29', '5040', '', '-581560', '0', '0', NULL, NULL),
('254', '17', '3', '2025-05-29', '1510', '', '581560', '0', '0', NULL, NULL),
('255', '17', '3', '2025-05-29', '5040', '', '-581560', '0', '0', NULL, NULL),
('256', '17', '3', '2025-05-29', '1510', '', '581560', '0', '0', NULL, NULL),
('257', '17', '3', '2025-05-29', '5040', '', '-343000', '0', '0', NULL, NULL),
('258', '17', '3', '2025-05-29', '1510', '', '343000', '0', '0', NULL, NULL),
('259', '17', '3', '2025-05-29', '5040', '', '-343000', '0', '0', NULL, NULL),
('260', '17', '3', '2025-05-29', '1510', '', '343000', '0', '0', NULL, NULL),
('261', '17', '3', '2025-05-29', '5040', '', '-343000', '0', '0', NULL, NULL),
('262', '17', '3', '2025-05-29', '1510', '', '343000', '0', '0', NULL, NULL),
('263', '17', '4', '2025-05-31', '5040', '', '0', '0', '0', NULL, NULL),
('264', '17', '4', '2025-05-31', '1510', '', '0', '0', '0', NULL, NULL),
('265', '17', '4', '2025-05-31', '5040', '', '0', '0', '0', NULL, NULL),
('266', '17', '4', '2025-05-31', '1510', '', '0', '0', '0', NULL, NULL),
('267', '17', '5', '2025-05-31', '5040', '', '0', '0', '0', NULL, NULL),
('268', '17', '5', '2025-05-31', '1510', '', '0', '0', '0', NULL, NULL),
('269', '17', '6', '2025-05-31', '5040', '', '0', '0', '0', NULL, NULL),
('270', '17', '6', '2025-05-31', '1510', '', '0', '0', '0', NULL, NULL),
('271', '28', '1', '2025-05-31', '1510', '31/05/2025: Issue of HR Coil', '-4939296', '0', '0', NULL, NULL),
('272', '28', '1', '2025-05-31', '1530', '31/05/2025: Issue to Production', '4939296', '0', '0', NULL, NULL),
('273', '28', '2', '2025-05-31', '1510', '31/05/2025: Issue of HR 295 MM', '19320', '0', '0', NULL, NULL),
('274', '28', '2', '2025-05-31', '1510', '31/05/2025: Issue of HR 127 MM', '171672', '0', '0', NULL, NULL),
('275', '28', '2', '2025-05-31', '1510', '31/05/2025: Issue of HR 127 MM', '1022304', '0', '0', NULL, NULL),
('276', '28', '2', '2025-05-31', '1510', '31/05/2025: Issue of HR 127 MM', '1441824', '0', '0', NULL, NULL),
('277', '28', '2', '2025-05-31', '1510', '31/05/2025: Issue of HR 127 MM', '1822152', '0', '0', NULL, NULL),
('278', '28', '2', '2025-05-31', '1510', '31/05/2025: Issue of HR 127 MM', '64584', '0', '0', NULL, NULL),
('279', '28', '2', '2025-05-31', '1530', '31/05/2025: Issue to Production', '-4541856', '0', '0', NULL, NULL),
('280', '0', '1', '2025-05-31', '1510', 'Zero/negative inventory handling', '0', '0', '0', NULL, NULL),
('281', '0', '1', '2025-05-31', '5040', 'Zero/negative inventory handling', '0', '0', '0', NULL, NULL),
('282', '17', '7', '2025-06-02', '5040', '', '0', '0', '0', NULL, NULL),
('283', '17', '7', '2025-06-02', '1510', '', '0', '0', '0', NULL, NULL),
('284', '35', '1', '2025-06-02', '5010', '', '225165', '0', '0', NULL, NULL),
('285', '35', '1', '2025-06-02', '1510', '', '-225165', '0', '0', NULL, NULL),
('286', '17', '7', '2025-06-02', '5040', '', '0', '0', '0', NULL, NULL),
('287', '17', '7', '2025-06-02', '1510', '', '0', '0', '0', NULL, NULL),
('288', '0', '2', '2025-06-02', '1510', 'Zero/negative inventory handling', '0', '0', '0', NULL, NULL),
('289', '0', '2', '2025-06-02', '5040', 'Zero/negative inventory handling', '0', '0', '0', NULL, NULL),
('290', '0', '3', '2025-06-02', '1510', 'Zero/negative inventory handling', '0', '0', '0', NULL, NULL),
('291', '0', '3', '2025-06-02', '5040', 'Zero/negative inventory handling', '0', '0', '0', NULL, NULL),
('292', '17', '8', '2025-06-02', '5040', '', '0', '0', '0', NULL, NULL),
('293', '17', '8', '2025-06-02', '1510', '', '0', '0', '0', NULL, NULL),
('294', '35', '2', '2025-06-02', '5010', '', '225165', '0', '0', NULL, NULL),
('295', '35', '2', '2025-06-02', '1510', '', '-225165', '0', '0', NULL, NULL),
('296', '17', '9', '2025-06-02', '5040', '', '0', '0', '0', NULL, NULL),
('297', '17', '9', '2025-06-02', '1510', '', '0', '0', '0', NULL, NULL),
('298', '17', '10', '2025-06-02', '5040', '', '0', '0', '0', NULL, NULL),
('299', '17', '10', '2025-06-02', '1510', '', '0', '0', '0', NULL, NULL),
('300', '28', '3', '2025-06-02', '1510', '02/06/2025: Issue of HR Coil', '-5099325', '0', '0', NULL, NULL),
('301', '28', '3', '2025-06-02', '1530', '02/06/2025: Issue to Production', '5099325', '0', '0', NULL, NULL),
('302', '28', '4', '2025-06-02', '1510', '02/06/2025: Issue of HR 177 MM', '1522840.46', '0', '0', NULL, NULL),
('303', '28', '4', '2025-06-02', '1510', '02/06/2025: Issue of HR 177 MM', '1143211.5', '0', '0', NULL, NULL),
('304', '28', '4', '2025-06-02', '1510', '02/06/2025: Issue of HR 177 MM', '832024.82', '0', '0', NULL, NULL),
('305', '28', '4', '2025-06-02', '1510', '02/06/2025: Issue of HR 177 MM', '68442.27', '0', '0', NULL, NULL),
('306', '28', '4', '2025-06-02', '1510', '02/06/2025: Issue of HR 177 MM', '1164270.66', '0', '0', NULL, NULL),
('307', '28', '4', '2025-06-02', '1530', '02/06/2025: Issue to Production', '-4730789.71', '0', '0', NULL, NULL),
('308', '28', '5', '2025-06-02', '1510', '02/06/2025: Issue of Sheet Tukra', '39485.92', '0', '0', NULL, NULL),
('309', '28', '5', '2025-06-02', '1510', '02/06/2025: Issue of Side Cutting', '39485.92', '0', '0', NULL, NULL),
('310', '28', '5', '2025-06-02', '1530', '02/06/2025: Issue to Production', '-78971.84', '0', '0', NULL, NULL),
('311', '17', '11', '2025-06-02', '5040', '', '0', '0', '0', NULL, NULL),
('312', '17', '11', '2025-06-02', '1510', '', '0', '0', '0', NULL, NULL),
('313', '17', '12', '2025-06-02', '5040', '', '0', '0', '0', NULL, NULL),
('314', '17', '12', '2025-06-02', '1510', '', '0', '0', '0', NULL, NULL),
('315', '28', '6', '2025-06-02', '1510', '02/06/2025: Issue of HR 177 MM', '-4730789.71', '0', '0', NULL, NULL),
('316', '28', '6', '2025-06-02', '1530', '02/06/2025: Issue to Production', '4730789.71', '0', '0', NULL, NULL),
('317', '28', '7', '2025-06-02', '1510', '02/06/2025: Issue of 1&quot; x 3&quot; 23 gauge', '1522840.46', '0', '0', NULL, NULL),
('318', '28', '7', '2025-06-02', '1510', '02/06/2025: Issue of 1&quot; x 3&quot; 23 gauge', '1143211.5', '0', '0', NULL, NULL),
('319', '28', '7', '2025-06-02', '1510', '02/06/2025: Issue of 1&quot; x 3&quot; 23 guage 18Ft', '832024.82', '0', '0', NULL, NULL),
('320', '28', '7', '2025-06-02', '1510', '02/06/2025: Issue of 1&quot; x 3&quot; 23 gauge', '68442.27', '0', '0', NULL, NULL),
('321', '28', '7', '2025-06-02', '1510', '02/06/2025: Issue of 1&quot; x 3&quot; 23 guage 18Ft', '1164270.66', '0', '0', NULL, NULL),
('322', '28', '7', '2025-06-02', '1530', '02/06/2025: Issue to Production', '-4730789.71', '0', '0', NULL, NULL),
('323', '17', '13', '2025-06-02', '5040', '', '0', '0', '0', NULL, NULL),
('324', '17', '13', '2025-06-02', '1510', '', '0', '0', '0', NULL, NULL),
('325', '35', '3', '2025-06-02', '5010', '', '-225165', '0', '0', NULL, NULL),
('326', '35', '3', '2025-06-02', '1510', '', '225165', '0', '0', NULL, NULL),
('327', '17', '14', '2025-06-02', '5040', '', '0', '0', '0', NULL, NULL),
('328', '17', '14', '2025-06-02', '1510', '', '0', '0', '0', NULL, NULL),
('329', '28', '8', '2025-06-02', '1510', '02/06/2025: Issue of HR 295 MM', '-19320', '0', '0', NULL, NULL),
('330', '28', '8', '2025-06-02', '1530', '02/06/2025: Issue to Production', '19320', '0', '0', NULL, NULL),
('331', '28', '9', '2025-06-02', '1510', '02/06/2025: Issue of 95mm round 14 guage', '19320', '0', '0', NULL, NULL),
('332', '28', '9', '2025-06-02', '1530', '02/06/2025: Issue to Production', '-19320', '0', '0', NULL, NULL),
('333', '0', '4', '2025-06-02', '1510', 'Zero/negative inventory handling', '4874160', '0', '0', NULL, NULL),
('334', '0', '4', '2025-06-02', '5040', 'Zero/negative inventory handling', '-4874160', '0', '0', NULL, NULL),
('335', '17', '15', '2025-06-03', '5040', '', '-5099325', '0', '0', NULL, NULL),
('336', '17', '15', '2025-06-03', '1510', '', '5099325', '0', '0', NULL, NULL),
('337', '17', '16', '2025-06-03', '5040', '', '-4939296', '0', '0', NULL, NULL),
('338', '17', '16', '2025-06-03', '1510', '', '4939296', '0', '0', NULL, NULL),
('339', '28', '10', '2025-06-03', '1510', '03/06/2025: Issue of HR 127 MM', '-4522536', '0', '0', NULL, NULL),
('340', '28', '10', '2025-06-03', '1530', '03/06/2025: Issue to Production', '4522536', '0', '0', NULL, NULL),
('341', '28', '11', '2025-06-03', '1510', '03/06/2025: Issue of 1&quot; x 1&quot;1/2 16 gauge', '165257.75', '0', '0', NULL, NULL),
('342', '28', '11', '2025-06-03', '1510', '03/06/2025: Issue of 1&quot; x 1&quot;1/2 16 gauge', '984107.23', '0', '0', NULL, NULL),
('343', '28', '11', '2025-06-03', '1510', '03/06/2025: Issue of 1&quot; x 1&quot;1/2 18 gauge', '1350756.26', '0', '0', NULL, NULL),
('344', '28', '11', '2025-06-03', '1510', '03/06/2025: Issue of 1&quot; x 1&quot;1/2 18 gauge', '1690659.39', '0', '0', NULL, NULL),
('345', '28', '11', '2025-06-03', '1510', '03/06/2025: Issue of 1&quot; x 1&quot;1/2 20 gauge', '62170.92', '0', '0', NULL, NULL),
('346', '28', '11', '2025-06-03', '1530', '03/06/2025: Issue to Production', '-4252951.55', '0', '0', NULL, NULL),
('347', '28', '12', '2025-06-03', '1510', '03/06/2025: Issue of Patra', '56325.79', '0', '0', NULL, NULL),
('348', '28', '12', '2025-06-03', '1510', '03/06/2025: Issue of Burada', '44281.28', '0', '0', NULL, NULL),
('349', '28', '12', '2025-06-03', '1530', '03/06/2025: Issue to Production', '-100607.07', '0', '0', NULL, NULL),
('350', '13', '1', '2025-06-03', '5010', '', '0', '0', '0', NULL, NULL),
('351', '13', '1', '2025-06-03', '1510', '', '0', '0', '0', NULL, NULL),
('352', '10', '1', '2025-06-03', '4010', '', '0', '0', '0', NULL, NULL),
('353', '10', '1', '2025-06-03', '1200', '', '0', '0', '0', '2', '96'),
('354', '12', '1', '2025-06-03', '1065', '', '4500', '0', '0', NULL, NULL),
('355', '12', '1', '2025-06-03', '1200', '', '-4500', '0', '0', '2', '96'),
('356', '13', '2', '2025-06-03', '5010', '', '3840', '0', '0', NULL, NULL),
('357', '13', '2', '2025-06-03', '1510', '', '-3840', '0', '0', NULL, NULL),
('358', '10', '2', '2025-06-03', '4010', '', '-4500.36', '0', '0', NULL, NULL),
('359', '10', '2', '2025-06-03', '1200', '', '4500.36', '0', '0', '2', '98'),
('360', '12', '2', '2025-06-03', '1065', '', '4500.36', '0', '0', NULL, NULL),
('361', '12', '2', '2025-06-03', '1200', '', '-4500.36', '0', '0', '2', '98'),
('362', '13', '3', '2025-06-03', '5010', '', '1710000', '0', '0', NULL, NULL),
('363', '13', '3', '2025-06-03', '1510', '', '-1710000', '0', '0', NULL, NULL),
('364', '10', '3', '2025-06-03', '4010', '', '-1923174', '0', '0', NULL, NULL),
('365', '10', '3', '2025-06-03', '1200', '', '1923174', '0', '0', '2', '99'),
('366', '12', '3', '2025-06-03', '1065', '', '1923174', '0', '0', NULL, NULL),
('367', '12', '3', '2025-06-03', '1200', '', '-1923174', '0', '0', '2', '99'),
('368', '13', '4', '2025-06-03', '5010', '', '475000', '0', '0', NULL, NULL),
('369', '13', '4', '2025-06-03', '1510', '', '-475000', '0', '0', NULL, NULL),
('370', '10', '4', '2025-06-03', '4010', '', '-1257139', '0', '0', NULL, NULL),
('371', '10', '4', '2025-06-03', '4010', '', '-545490', '0', '0', NULL, NULL),
('372', '10', '4', '2025-06-03', '1200', '', '1802629', '0', '0', '2', '31'),
('373', '13', '5', '2025-06-03', '5010', '', '383830.8', '0', '0', NULL, NULL),
('374', '13', '5', '2025-06-03', '1510', '', '-383830.8', '0', '0', NULL, NULL),
('375', '13', '5', '2025-06-03', '5010', '', '524100', '0', '0', NULL, NULL),
('376', '13', '5', '2025-06-03', '1510', '', '-524100', '0', '0', NULL, NULL),
('377', '13', '5', '2025-06-03', '5010', '', '292947', '0', '0', NULL, NULL),
('378', '13', '5', '2025-06-03', '1510', '', '-292947', '0', '0', NULL, NULL),
('379', '13', '5', '2025-06-03', '5010', '', '1149200', '0', '0', NULL, NULL),
('380', '13', '5', '2025-06-03', '1510', '', '-1149200', '0', '0', NULL, NULL),
('381', '13', '5', '2025-06-03', '5010', '', '135800', '0', '0', NULL, NULL),
('382', '13', '5', '2025-06-03', '1510', '', '-135800', '0', '0', NULL, NULL),
('383', '10', '5', '2025-06-03', '4010', '', '-309958.84', '0', '0', NULL, NULL),
('384', '10', '5', '2025-06-03', '4010', '', '-439345', '0', '0', NULL, NULL),
('385', '10', '5', '2025-06-03', '4010', '', '-348408', '0', '0', NULL, NULL),
('386', '10', '5', '2025-06-03', '4010', '', '-886680', '0', '0', NULL, NULL),
('387', '10', '5', '2025-06-03', '4010', '', '-147312', '0', '0', NULL, NULL),
('388', '10', '5', '2025-06-03', '4010', '', '-200664', '0', '0', NULL, NULL),
('389', '10', '5', '2025-06-03', '4010', '', '-118152', '0', '0', NULL, NULL),
('390', '10', '5', '2025-06-03', '1200', '', '2450519.84', '0', '0', '2', '84'),
('391', '13', '6', '2025-06-03', '5010', '', '314460', '0', '0', NULL, NULL),
('392', '13', '6', '2025-06-03', '1510', '', '-314460', '0', '0', NULL, NULL),
('393', '13', '6', '2025-06-03', '5010', '', '209640', '0', '0', NULL, NULL),
('394', '13', '6', '2025-06-03', '1510', '', '-209640', '0', '0', NULL, NULL),
('395', '13', '6', '2025-06-03', '5010', '', '19600', '0', '0', NULL, NULL),
('396', '13', '6', '2025-06-03', '1510', '', '-19600', '0', '0', NULL, NULL),
('397', '13', '6', '2025-06-03', '5010', '', '172380', '0', '0', NULL, NULL),
('398', '13', '6', '2025-06-03', '1510', '', '-172380', '0', '0', NULL, NULL),
('399', '10', '6', '2025-06-03', '4010', '', '-274614', '0', '0', NULL, NULL),
('400', '10', '6', '2025-06-03', '4010', '', '-181818', '0', '0', NULL, NULL),
('401', '10', '6', '2025-06-03', '4010', '', '-303918', '0', '0', NULL, NULL),
('402', '10', '6', '2025-06-03', '4010', '', '-21534', '0', '0', NULL, NULL),
('403', '10', '6', '2025-06-03', '4010', '', '-136086', '0', '0', NULL, NULL),
('404', '10', '6', '2025-06-03', '1200', '', '917970', '0', '0', '2', '49'),
('405', '12', '4', '2025-06-03', '1065', '', '917970', '0', '0', NULL, NULL),
('406', '12', '4', '2025-06-03', '1200', '', '-917970', '0', '0', '2', '49'),
('407', '13', '7', '2025-06-03', '5010', '', '0', '0', '0', NULL, NULL),
('408', '13', '7', '2025-06-03', '1510', '', '0', '0', '0', NULL, NULL),
('409', '10', '7', '2025-06-03', '4010', '', '0', '0', '0', NULL, NULL),
('410', '10', '7', '2025-06-03', '1200', '', '0', '0', '0', '2', '49'),
('411', '12', '5', '2025-06-03', '1065', '', '273060', '0', '0', NULL, NULL),
('412', '12', '5', '2025-06-03', '1200', '', '-273060', '0', '0', '2', '49'),
('413', '13', '8', '2025-06-03', '5010', '', '196000', '0', '0', NULL, NULL),
('414', '13', '8', '2025-06-03', '1510', '', '-196000', '0', '0', NULL, NULL),
('415', '13', '8', '2025-06-03', '5010', '', '19600', '0', '0', NULL, NULL),
('416', '13', '8', '2025-06-03', '1510', '', '-19600', '0', '0', NULL, NULL),
('417', '13', '8', '2025-06-03', '5010', '', '135800', '0', '0', NULL, NULL),
('418', '13', '8', '2025-06-03', '1510', '', '-135800', '0', '0', NULL, NULL),
('419', '13', '8', '2025-06-03', '5010', '', '96000', '0', '0', NULL, NULL),
('420', '13', '8', '2025-06-03', '1510', '', '-96000', '0', '0', NULL, NULL),
('421', '13', '8', '2025-06-03', '5010', '', '416000', '0', '0', NULL, NULL),
('422', '13', '8', '2025-06-03', '1510', '', '-416000', '0', '0', NULL, NULL),
('423', '10', '8', '2025-06-03', '4010', '', '-220590', '0', '0', NULL, NULL),
('424', '10', '8', '2025-06-03', '4010', '', '-312480', '0', '0', NULL, NULL),
('425', '10', '8', '2025-06-03', '4010', '', '-22059', '0', '0', NULL, NULL),
('426', '10', '8', '2025-06-03', '4010', '', '-310770', '0', '0', NULL, NULL),
('427', '10', '8', '2025-06-03', '4010', '', '-122220', '0', '0', NULL, NULL),
('428', '10', '8', '2025-06-03', '4010', '', '-104340', '0', '0', NULL, NULL),
('429', '10', '8', '2025-06-03', '4010', '', '-460206.4', '0', '0', NULL, NULL),
('430', '10', '8', '2025-06-03', '1200', '', '1552665.4', '0', '0', '2', '95'),
('431', '12', '6', '2025-06-03', '1065', '', '1552665.4', '0', '0', NULL, NULL),
('432', '12', '6', '2025-06-03', '1200', '', '-1552665.4', '0', '0', '2', '95'),
('433', '13', '9', '2025-06-03', '5010', '', '344760', '0', '0', NULL, NULL),
('434', '13', '9', '2025-06-03', '1510', '', '-344760', '0', '0', NULL, NULL),
('435', '10', '9', '2025-06-03', '4010', '', '-273060', '0', '0', NULL, NULL),
('436', '10', '9', '2025-06-03', '1200', '', '273060', '0', '0', '2', '43'),
('437', '12', '7', '2025-06-03', '1065', '', '273060', '0', '0', NULL, NULL),
('438', '12', '7', '2025-06-03', '1200', '', '-273060', '0', '0', '2', '43'),
('439', '17', '17', '2025-06-03', '5040', '', '-386584', '0', '0', NULL, NULL),
('440', '17', '17', '2025-06-03', '1510', '', '386584', '0', '0', NULL, NULL),
('441', '28', '13', '2025-06-03', '1510', '03/06/2025: Issue of HR Coil', '-386584', '0', '0', NULL, NULL),
('442', '28', '13', '2025-06-03', '1530', '03/06/2025: Issue to Production', '386584', '0', '0', NULL, NULL),
('443', '28', '14', '2025-06-03', '1510', '03/06/2025: Issue of HR 97 MM', '289800', '0', '0', NULL, NULL),
('444', '28', '14', '2025-06-03', '1510', '03/06/2025: Issue of HR 147 MM', '96784', '0', '0', NULL, NULL),
('445', '28', '14', '2025-06-03', '1530', '03/06/2025: Issue to Production', '-386584', '0', '0', NULL, NULL),
('446', '28', '15', '2025-06-03', '1510', '03/06/2025: Issue of HR 147 MM', '-96784', '0', '0', NULL, NULL),
('447', '28', '15', '2025-06-03', '1530', '03/06/2025: Issue to Production', '96784', '0', '0', NULL, NULL),
('448', '28', '16', '2025-06-03', '1510', '03/06/2025: Issue of 1&quot; x 2&quot; 18 gauge', '96784', '0', '0', NULL, NULL),
('449', '28', '16', '2025-06-03', '1530', '03/06/2025: Issue to Production', '-96784', '0', '0', NULL, NULL),
('450', '28', '17', '2025-06-03', '1510', '03/06/2025: Issue of HR 97 MM', '-289800', '0', '0', NULL, NULL),
('451', '28', '17', '2025-06-03', '1530', '03/06/2025: Issue to Production', '289800', '0', '0', NULL, NULL),
('452', '28', '18', '2025-06-03', '1510', '03/06/2025: Issue of 1&quot; x 1&quot; 18 guage', '289800', '0', '0', NULL, NULL),
('453', '28', '18', '2025-06-03', '1530', '03/06/2025: Issue to Production', '-289800', '0', '0', NULL, NULL),
('454', '10', '10', '2025-06-03', '4010', '', '-380670.7', '0', '0', NULL, NULL),
('455', '10', '10', '2025-06-03', '4010', '', '-121564.95', '0', '0', NULL, NULL),
('456', '10', '10', '2025-06-03', '1200', '', '502235.65', '0', '0', '2', '100'),
('457', '12', '8', '2025-06-03', '1065', '', '502235.65', '0', '0', NULL, NULL),
('458', '12', '8', '2025-06-03', '1200', '', '-502235.65', '0', '0', '2', '100');

### Structure of table `0_grn_batch` ###

DROP TABLE IF EXISTS `0_grn_batch`;

CREATE TABLE `0_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) DEFAULT NULL,
  `rate` double DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_grn_batch` ###


### Structure of table `0_grn_items` ###

DROP TABLE IF EXISTS `0_grn_items`;

CREATE TABLE `0_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `batch_no` varchar(30) NOT NULL,
  `exp_date` date DEFAULT NULL,
  `description` tinytext DEFAULT NULL,
  `qty_recd` double NOT NULL DEFAULT 0,
  `quantity_inv` double NOT NULL DEFAULT 0,
  `thickness` varchar(225) NOT NULL,
  `width` varchar(225) NOT NULL,
  `unit_id` varchar(225) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_grn_items` ###


### Structure of table `0_groups` ###

DROP TABLE IF EXISTS `0_groups`;

CREATE TABLE `0_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_groups` ###

INSERT INTO `0_groups` VALUES
('1', 'Small', '0'),
('2', 'Medium', '0'),
('3', 'Large', '0');

### Structure of table `0_item_codes` ###

DROP TABLE IF EXISTS `0_item_codes`;

CREATE TABLE `0_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) NOT NULL,
  `stock_id` varchar(20) NOT NULL,
  `description` varchar(200) NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT 1,
  `is_foreign` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=537 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_item_codes` ###

INSERT INTO `0_item_codes` VALUES
('1', '60487735', '60487735', 'HR Coil', '7', '1', '0', '0'),
('2', '50196340', '50196340', 'Production', '1', '1', '0', '0'),
('4', '33010403', '33010403', 'HR 77 MM', '1', '1', '0', '0'),
('6', '77615985', '77615985', 'Patra', '9', '1', '0', '0'),
('7', '53186355', '53186355', 'B Pipe', '9', '1', '0', '0'),
('8', '91000026', '91000026', 'Burada', '9', '1', '0', '0'),
('10', '47221925', '47221925', 'CR Coil', '7', '1', '0', '0'),
('11', '24616744', '24616744', 'HR 97 MM', '1', '1', '0', '0'),
('13', '39858313', '39858313', 'Sheet Tukra', '9', '1', '0', '0'),
('14', '62064910', '62064910', 'Side Cutting', '9', '1', '0', '0'),
('15', '28488323', '28488323', 'Weight Diffrence', '9', '1', '0', '0'),
('76', '27003244', '27003244', 'HR 117 MM', '1', '1', '0', '0'),
('78', '57921181', '57921181', 'HR 227 MM', '1', '1', '0', '0'),
('79', '83895982', '83895982', 'HR 127 MM', '1', '1', '0', '0'),
('80', '82239695', '82239695', 'HR 295 MM', '1', '1', '0', '0'),
('81', '38001291', '38001291', 'HR 147 MM', '1', '1', '0', '0'),
('82', '57781471', '57781471', 'HR 177 MM', '1', '1', '0', '0'),
('83', '29121137', '29121137', 'HR 197 MM', '1', '1', '0', '0'),
('84', '51875008', '51875008', 'HR 257 MM', '1', '1', '0', '0'),
('86', '71846835', '71846835', 'HR 272 MM', '1', '1', '0', '0'),
('290', '10000001', '10000001', '5/8 round 23 guage', '10', '1', '0', '0'),
('291', '10000002', '10000002', '5/8 round 22 guage', '10', '1', '0', '0'),
('292', '10000003', '10000003', '5/8 round 21 guage', '10', '1', '0', '0'),
('293', '10000004', '10000004', '5/8 round 20 guage', '10', '1', '0', '0'),
('294', '10000005', '10000005', '5/8 round 18 guage', '10', '1', '0', '0'),
('295', '10000006', '10000006', '5/8 round 16 guage', '10', '1', '0', '0'),
('296', '10000007', '10000007', '5/8 round 14 guage', '10', '1', '0', '0'),
('297', '10000008', '10000008', '1&quot; round 23 guage', '10', '1', '0', '0'),
('298', '10000009', '10000009', '1&quot; round 22 guage', '10', '1', '0', '0'),
('299', '10000010', '10000010', '1&quot; round 21 guage', '10', '1', '0', '0'),
('300', '10000011', '10000011', '1&quot; round 20 guage', '10', '1', '0', '0'),
('301', '10000012', '10000012', '1&quot; round 18 guage', '10', '1', '0', '0'),
('302', '10000013', '10000013', '1&quot; round 16 guage', '10', '1', '0', '0'),
('303', '10000014', '10000014', '1&quot; round 14 guage', '10', '1', '0', '0'),
('304', '10000015', '10000015', '1&quot;1/4 round 23 guage', '10', '1', '0', '0'),
('305', '10000016', '10000016', '1&quot;1/4 round 22 guage', '10', '1', '0', '0'),
('306', '10000017', '10000017', '1&quot;1/4 round 21 guage', '10', '1', '0', '0'),
('307', '10000018', '10000018', '1&quot;1/4 round 20 guage', '10', '1', '0', '0'),
('308', '10000019', '10000019', '1&quot;1/4 round 18 guage', '10', '1', '0', '0'),
('309', '10000020', '10000020', '1&quot;1/4 round 16 guage', '10', '1', '0', '0'),
('310', '10000021', '10000021', '1&quot;1/4 round 14 guage', '10', '1', '0', '0'),
('311', '10000022', '10000022', '1&quot;1/2 round 23 guage', '10', '1', '0', '0'),
('312', '10000023', '10000023', '1&quot;1/2 round 22 guage', '10', '1', '0', '0'),
('313', '10000024', '10000024', '1&quot;1/2 round 21 guage', '10', '1', '0', '0'),
('314', '10000025', '10000025', '1&quot;1/2 round 20 guage', '10', '1', '0', '0'),
('315', '10000026', '10000026', '1&quot;1/2 round 18 guage', '10', '1', '0', '0'),
('316', '10000027', '10000027', '1&quot;1/2 round 16 guage', '10', '1', '0', '0'),
('317', '10000028', '10000028', '1&quot;1/2 round 14 guage', '10', '1', '0', '0'),
('318', '10000029', '10000029', '1&quot; 5/8 round 20 guage', '10', '1', '0', '0'),
('319', '10000030', '10000030', '1&quot; 5/8 round 18 guage', '10', '1', '0', '0'),
('320', '10000031', '10000031', '1&quot; 5/8 round 16 guage', '10', '1', '0', '0'),
('321', '10000032', '10000032', '1&quot; 7/8 round 23 guage', '10', '1', '0', '0'),
('322', '10000033', '10000033', '1&quot; 7/8 round 22 guage', '10', '1', '0', '0'),
('323', '10000034', '10000034', '1&quot; 7/8 round 21 guage', '10', '1', '0', '0'),
('324', '10000035', '10000035', '1&quot; 7/8 round 20 guage', '10', '1', '0', '0'),
('325', '10000036', '10000036', '1&quot; 7/8 round 18 guage', '10', '1', '0', '0'),
('326', '10000037', '10000037', '1&quot; 7/8 round 16 guage', '10', '1', '0', '0'),
('327', '10000038', '10000038', '1&quot; 7/8 round 14 guage', '10', '1', '0', '0'),
('328', '10000039', '10000039', '1&quot; 7/8 round 12 guage', '10', '1', '0', '0'),
('329', '10000040', '10000040', '1&quot; 7/8 round 10 guage', '10', '1', '0', '0'),
('330', '10000041', '10000041', '1&quot; 7/8 round 5.4 kg 21ft', '10', '1', '0', '0'),
('331', '10000042', '10000042', '1&quot; 7/8 round 9.8 kg 21ft', '10', '1', '0', '0'),
('332', '10000043', '10000043', '1&quot; 7/8 round 4 kg 21ft', '10', '1', '0', '0'),
('333', '10000044', '10000044', '1&quot; 7/8 round 4.8 kg 21ft', '10', '1', '0', '0'),
('334', '10000045', '10000045', '2&quot;1/4 round 23 guage', '10', '1', '0', '0'),
('335', '10000046', '10000046', '2&quot;1/4 round 22 guage', '10', '1', '0', '0'),
('336', '10000047', '10000047', '2&quot;1/4 round 21 guage', '10', '1', '0', '0'),
('337', '10000048', '10000048', '2&quot;1/4 round 20 guage', '10', '1', '0', '0'),
('338', '10000049', '10000049', '2&quot;1/4 round 18 guage', '10', '1', '0', '0'),
('339', '10000050', '10000050', '2&quot;1/4 round 16 guage', '10', '1', '0', '0'),
('340', '10000051', '10000051', '2&quot;1/4 round 14 guage', '10', '1', '0', '0'),
('341', '10000052', '10000052', '2&quot;1/4 round 5.5 kg 21ft', '10', '1', '0', '0'),
('342', '10000053', '10000053', '2&quot;7/8 round 20 guage', '10', '1', '0', '0'),
('343', '10000054', '10000054', '2&quot;7/8 round 18 guage', '10', '1', '0', '0'),
('344', '10000055', '10000055', '2&quot;7/8 round 16 guage', '10', '1', '0', '0'),
('345', '10000056', '10000056', '2&quot;7/8 round 14 guage', '10', '1', '0', '0'),
('346', '10000057', '10000057', '2&quot;7/8 round 12 guage', '10', '1', '0', '0'),
('347', '10000058', '10000058', '2&quot;7/8 round 10 guage', '10', '1', '0', '0'),
('348', '10000059', '10000059', '87mm round 20 guage', '10', '1', '0', '0'),
('349', '10000060', '10000060', '87mm round 18 guage', '10', '1', '0', '0'),
('350', '10000061', '10000061', '87mm round 16 guage', '10', '1', '0', '0'),
('351', '10000062', '10000062', '87mm round 14 guage', '10', '1', '0', '0'),
('352', '10000063', '10000063', '87mm round 12 guage', '10', '1', '0', '0'),
('353', '10000064', '10000064', '87mm round 10 guage', '10', '1', '0', '0'),
('354', '10000065', '10000065', '95mm round 20 guage', '10', '1', '0', '0'),
('355', '10000066', '10000066', '95mm round 18 guage', '10', '1', '0', '0'),
('356', '10000067', '10000067', '95mm round 16 guage', '10', '1', '0', '0'),
('357', '10000068', '10000068', '95mm round 14 guage', '10', '1', '0', '0'),
('358', '10000069', '10000069', '95mm round 12 guage', '10', '1', '0', '0'),
('359', '10000070', '10000070', '95mm round 10 guage', '10', '1', '0', '0'),
('360', '10000071', '10000071', '113mm round 18 guage', '10', '1', '0', '0'),
('361', '10000072', '10000072', '113mm round 16 guage', '10', '1', '0', '0'),
('362', '10000073', '10000073', '113mm round 14 guage', '10', '1', '0', '0'),
('363', '10000074', '10000074', '113mm round 12 guage', '10', '1', '0', '0'),
('364', '10000075', '10000075', '113mm round 10 guage', '10', '1', '0', '0'),
('365', '10000076', '10000076', '1/2&quot; x 1/2&quot; 23 guage', '10', '1', '0', '0'),
('366', '10000077', '10000077', '1/2&quot; x 1/2&quot; 22 guage', '10', '1', '0', '0'),
('367', '10000078', '10000078', '1/2&quot; x 1/2&quot; 21 guage', '10', '1', '0', '0'),
('368', '10000079', '10000079', '1/2&quot; x 1/2&quot; 20 guage', '10', '1', '0', '0'),
('369', '10000080', '10000080', '1/2&quot; x 1/2&quot; 18 guage', '10', '1', '0', '0'),
('370', '10000081', '10000081', '1/2&quot; x 1/2&quot; 16 guage', '10', '1', '0', '0'),
('371', '10000082', '10000082', '1/2&quot; x 1/2&quot; 14 guage', '10', '1', '0', '0'),
('372', '10000083', '10000083', '3/4&quot; x 3/4&quot; 23 guage', '10', '1', '0', '0'),
('373', '10000084', '10000084', '3/4&quot; x 3/4&quot; 22 guage', '10', '1', '0', '0'),
('374', '10000085', '10000085', '3/4&quot; x 3/4&quot; 21 guage', '10', '1', '0', '0'),
('375', '10000086', '10000086', '3/4&quot; x 3/4&quot; 20 guage', '10', '1', '0', '0'),
('376', '10000087', '10000087', '3/4&quot; x 3/4&quot; 18 guage', '10', '1', '0', '0'),
('377', '10000088', '10000088', '3/4&quot; x 3/4&quot; 16 guage', '10', '1', '0', '0'),
('378', '10000089', '10000089', '3/4&quot; x 3/4&quot; 14 guage', '10', '1', '0', '0'),
('379', '10000090', '10000090', '1&quot; x 1&quot; 23 guage', '10', '1', '0', '0'),
('380', '10000091', '10000091', '1&quot; x 1&quot; 22 guage', '10', '1', '0', '0'),
('381', '10000092', '10000092', '1&quot; x 1&quot; 21 guage', '10', '1', '0', '0'),
('382', '10000093', '10000093', '1&quot; x 1&quot; 20 guage', '10', '1', '0', '0'),
('383', '10000094', '10000094', '1&quot; x 1&quot; 18 guage', '10', '1', '0', '0'),
('384', '90538834', '90538834', '1&quot; x 1&quot; 16 guage', '10', '1', '0', '0'),
('385', '37277987', '37277987', 'Hr strips', '7', '1', '0', '0'),
('388', '14581371', '14581371', '1&quot;1/4 x 1&quot;1/4 23 gauge', '10', '1', '0', '0'),
('389', '14581372', '14581372', '1&quot;1/4 x 1&quot;1/4 22 gauge', '10', '1', '0', '0'),
('390', '14581373', '14581373', '1&quot;1/4 x 1&quot;1/4 21 gauge', '10', '1', '0', '0'),
('391', '14581374', '14581374', '1&quot;1/4 x 1&quot;1/4 20 gauge', '10', '1', '0', '0'),
('392', '14581375', '14581375', '1&quot;1/4 x 1&quot;1/4 18 gauge', '10', '1', '0', '0'),
('393', '14581376', '14581376', '1&quot;1/4 x 1&quot;1/4 16 gauge', '10', '1', '0', '0'),
('394', '14581377', '14581377', '1&quot;1/4 x 1&quot;1/4 14 gauge', '10', '1', '0', '0'),
('395', '14581378', '14581378', '1&quot;1/4 x 1&quot;1/4 12 gauge', '10', '1', '0', '0'),
('396', '14581379', '14581379', '1&quot;1/4 x 1&quot;1/4 10 gauge', '10', '1', '0', '0'),
('397', '14581380', '14581380', '1&quot;1/2 x 1&quot;1/2 23 gauge', '10', '1', '0', '0'),
('398', '14581381', '14581381', '1&quot;1/2 x 1&quot;1/2 22 gauge', '10', '1', '0', '0'),
('399', '14581382', '14581382', '1&quot;1/2 x 1&quot;1/2 21 gauge', '10', '1', '0', '0'),
('400', '14581383', '14581383', '1&quot;1/2 x 1&quot;1/2 20 gauge', '10', '1', '0', '0'),
('401', '14581384', '14581384', '1&quot;1/2 x 1&quot;1/2 18 gauge', '10', '1', '0', '0'),
('402', '14581385', '14581385', '1&quot;1/2 x 1&quot;1/2 16 gauge', '10', '1', '0', '0'),
('403', '14581386', '14581386', '1&quot;1/2 x 1&quot;1/2 14 gauge', '10', '1', '0', '0'),
('404', '14581387', '14581387', '1&quot;1/2 x 1&quot;1/2 12 gauge', '10', '1', '0', '0'),
('405', '14581388', '14581388', '1&quot;1/2 x 1&quot;1/2 10 gauge', '10', '1', '0', '0'),
('406', '14581389', '14581389', '45 x 45 23 gauge', '10', '1', '0', '0'),
('407', '14581390', '14581390', '45 x 45 22 gauge', '10', '1', '0', '0'),
('408', '14581391', '14581391', '45 x 45 21 gauge', '10', '1', '0', '0'),
('409', '14581392', '14581392', '45 x 45 20 gauge', '10', '1', '0', '0'),
('410', '14581393', '14581393', '45 x 45 18 gauge', '10', '1', '0', '0'),
('411', '14581394', '14581394', '45 x 45 16 gauge', '10', '1', '0', '0'),
('412', '14581395', '14581395', '45 x 45 14 gauge', '10', '1', '0', '0'),
('413', '14581396', '14581396', '45 x 45 12 gauge', '10', '1', '0', '0'),
('414', '14581397', '14581397', '45 x 45 10 gauge', '10', '1', '0', '0'),
('415', '14581398', '14581398', '50 x 50 23 gauge', '10', '1', '0', '0'),
('416', '14581399', '14581399', '50 x 50 22 gauge', '10', '1', '0', '0'),
('417', '14581400', '14581400', '50 x 50 21 gauge', '10', '1', '0', '0'),
('418', '14581401', '14581401', '50 x 50 20 gauge', '10', '1', '0', '0'),
('419', '14581402', '14581402', '50 x 50 18 gauge', '10', '1', '0', '0'),
('420', '14581403', '14581403', '50 x 50 16 gauge', '10', '1', '0', '0'),
('421', '14581404', '14581404', '50 x 50 14 gauge', '10', '1', '0', '0'),
('422', '14581405', '14581405', '50 x 50 12 gauge', '10', '1', '0', '0'),
('423', '14581406', '14581406', '50 x 50 10 gauge', '10', '1', '0', '0'),
('424', '14581407', '14581407', '3&quot; x 3&quot; 20 gauge', '10', '1', '0', '0'),
('425', '14581408', '14581408', '3&quot; x 3&quot; 18 gauge', '10', '1', '0', '0'),
('426', '14581409', '14581409', '3&quot; x 3&quot; 16 gauge', '10', '1', '0', '0'),
('427', '14581410', '14581410', '3&quot; x 3&quot; 14 gauge', '10', '1', '0', '0'),
('428', '14581411', '14581411', '3&quot; x 3&quot; 12 gauge', '10', '1', '0', '0'),
('429', '14581412', '14581412', '3&quot; x 3&quot; 10 gauge', '10', '1', '0', '0'),
('430', '14581413', '14581413', '1/2 x 1&quot; 23 gauge', '10', '1', '0', '0'),
('431', '14581414', '14581414', '1/2 x 1&quot; 22 gauge', '10', '1', '0', '0'),
('432', '14581415', '14581415', '1/2 x 1&quot; 21 gauge', '10', '1', '0', '0'),
('433', '14581416', '14581416', '1/2 x 1&quot; 20 gauge', '10', '1', '0', '0'),
('434', '14581417', '14581417', '1/2 x 1&quot; 18 gauge', '10', '1', '0', '0'),
('435', '14581418', '14581418', '1/2 x 1&quot; 16 gauge', '10', '1', '0', '0'),
('436', '14581419', '14581419', '1/2 x 1&quot; 14 gauge', '10', '1', '0', '0'),
('437', '14581420', '14581420', '1/2 x 1&quot;1/2 23 gauge', '10', '1', '0', '0'),
('438', '14581421', '14581421', '1/2 x 1&quot;1/2 22 gauge', '10', '1', '0', '0'),
('439', '14581422', '14581422', '1/2 x 1&quot;1/2 21 gauge', '10', '1', '0', '0'),
('440', '14581423', '14581423', '1/2 x 1&quot;1/2 20 gauge', '10', '1', '0', '0'),
('441', '14581424', '14581424', '1/2 x 1&quot;1/2 18 gauge', '10', '1', '0', '0'),
('442', '14581425', '14581425', '1/2 x 1&quot;1/2 16 gauge', '10', '1', '0', '0'),
('443', '14581426', '14581426', '1/2 x 1&quot;1/2 14 gauge', '10', '1', '0', '0'),
('444', '14581427', '14581427', '3/4 x 1&quot;1/2 23 gauge', '10', '1', '0', '0'),
('445', '14581428', '14581428', '3/4 x 1&quot;1/2 22 gauge', '10', '1', '0', '0'),
('446', '14581429', '14581429', '3/4 x 1&quot;1/2 21 gauge', '10', '1', '0', '0'),
('447', '14581430', '14581430', '3/4 x 1&quot;1/2 20 gauge', '10', '1', '0', '0'),
('448', '14581431', '14581431', '3/4 x 1&quot;1/2 18 gauge', '10', '1', '0', '0'),
('449', '14581432', '14581432', '3/4 x 1&quot;1/2 16 gauge', '10', '1', '0', '0'),
('450', '14581433', '14581433', '3/4 x 1&quot;1/2 14 gauge', '10', '1', '0', '0'),
('451', '14581434', '14581434', '1&quot; x 1&quot;1/2 23 gauge', '10', '1', '0', '0'),
('452', '14581435', '14581435', '1&quot; x 1&quot;1/2 22 gauge', '10', '1', '0', '0'),
('453', '14581436', '14581436', '1&quot; x 1&quot;1/2 21 gauge', '10', '1', '0', '0'),
('454', '14581437', '14581437', '1&quot; x 1&quot;1/2 20 gauge', '10', '1', '0', '0'),
('455', '14581438', '14581438', '1&quot; x 1&quot;1/2 18 gauge', '10', '1', '0', '0'),
('456', '14581439', '14581439', '1&quot; x 1&quot;1/2 16 gauge', '10', '1', '0', '0'),
('457', '14581440', '14581440', '1&quot; x 1&quot;1/2 14 gauge', '10', '1', '0', '0'),
('458', '14581441', '14581441', '1&quot; x 2&quot; 23 gauge', '10', '1', '0', '0'),
('459', '14581442', '14581442', '1&quot; x 2&quot; 22 gauge', '10', '1', '0', '0'),
('460', '14581443', '14581443', '1&quot; x 2&quot; 21 gauge', '10', '1', '0', '0'),
('461', '14581444', '14581444', '1&quot; x 2&quot; 20 gauge', '10', '1', '0', '0'),
('462', '14581445', '14581445', '1&quot; x 2&quot; 18 gauge', '10', '1', '0', '0'),
('463', '14581446', '14581446', '1&quot; x 2&quot; 16 gauge', '10', '1', '0', '0'),
('464', '14581447', '14581447', '1&quot; x 2&quot; 14 gauge', '10', '1', '0', '0'),
('465', '14581448', '14581448', '1&quot; x 2&quot; 12 gauge', '10', '1', '0', '0'),
('466', '14581449', '14581449', '1&quot; x 2&quot; 10 gauge', '10', '1', '0', '0'),
('467', '14581450', '14581450', '1&quot; x 3&quot; 23 gauge', '10', '1', '0', '0'),
('468', '14581451', '14581451', '1&quot; x 3&quot; 22 gauge', '10', '1', '0', '0'),
('469', '14581452', '14581452', '1&quot; x 3&quot; 21 gauge', '10', '1', '0', '0'),
('470', '14581453', '14581453', '1&quot; x 3&quot; 20 gauge', '10', '1', '0', '0'),
('471', '14581454', '14581454', '1&quot; x 3&quot; 18 gauge', '10', '1', '0', '0'),
('472', '14581455', '14581455', '1&quot; x 3&quot; 16 gauge', '10', '1', '0', '0'),
('473', '14581456', '14581456', '1&quot; x 3&quot; 14 gauge', '10', '1', '0', '0'),
('474', '14581457', '14581457', '1&quot;1/4 x 2&quot;1/2 20 gauge', '10', '1', '0', '0'),
('475', '14581458', '14581458', '1&quot;1/4 x 2&quot;1/2 18 gauge', '10', '1', '0', '0'),
('476', '14581459', '14581459', '1&quot;1/4 x 2&quot;1/2 16 gauge', '10', '1', '0', '0'),
('477', '14581460', '14581460', '1&quot;1/4 x 2&quot;1/2 14 gauge', '10', '1', '0', '0'),
('478', '14581461', '14581461', '1&quot;1/4 x 2&quot;1/2 12 gauge', '10', '1', '0', '0'),
('479', '14581462', '14581462', '1&quot;1/4 x 2&quot;1/2 10 gauge', '10', '1', '0', '0'),
('480', '14581463', '14581463', '1&quot; x 4&quot; 20 gauge', '10', '1', '0', '0'),
('481', '14581464', '14581464', '1&quot; x 4&quot; 18 gauge', '10', '1', '0', '0'),
('482', '14581465', '14581465', '1&quot; x 4&quot; 16 gauge', '10', '1', '0', '0'),
('483', '14581466', '14581466', '1&quot; x 4&quot; 14 gauge', '10', '1', '0', '0'),
('484', '14581467', '14581467', '1&quot; x 4&quot; 12 gauge', '10', '1', '0', '0'),
('485', '14581468', '14581468', '1&quot; x 4&quot; 10 gauge', '10', '1', '0', '0'),
('486', '14581469', '14581469', '1&quot;1/2 x 3&quot; 20 gauge', '10', '1', '0', '0'),
('487', '14581470', '14581470', '1&quot;1/2 x 3&quot; 18 gauge', '10', '1', '0', '0'),
('488', '14581471', '14581471', '1&quot;1/2 x 3&quot; 16 gauge', '10', '1', '0', '0'),
('489', '14581472', '14581472', '1&quot;1/2 x 3&quot; 14 gauge', '10', '1', '0', '0'),
('490', '14581473', '14581473', '1&quot;1/2 x 3&quot; 12 gauge', '10', '1', '0', '0'),
('491', '14581474', '14581474', '1&quot;1/2 x 3&quot; 10 gauge', '10', '1', '0', '0'),
('492', '14581475', '14581475', '1&quot;1/2 x 4&quot; 20 gauge', '10', '1', '0', '0'),
('493', '14581476', '14581476', '1&quot;1/2 x 4&quot; 18 gauge', '10', '1', '0', '0'),
('494', '14581477', '14581477', '1&quot;1/2 x 4&quot; 16 gauge', '10', '1', '0', '0'),
('495', '14581478', '14581478', '1&quot;1/2 x 4&quot; 14 gauge', '10', '1', '0', '0'),
('496', '14581479', '14581479', '1&quot;1/2 x 4&quot; 12 gauge', '10', '1', '0', '0'),
('497', '14581480', '14581480', '1&quot;1/2 x 4&quot; 10 gauge', '10', '1', '0', '0'),
('498', '14581481', '14581481', '2&quot; x 4&quot; 20 gauge', '10', '1', '0', '0'),
('499', '14581482', '14581482', '2&quot; x 4&quot; 18 gauge', '10', '1', '0', '0'),
('500', '14581483', '14581483', '2&quot; x 4&quot; 16 gauge', '10', '1', '0', '0'),
('501', '14581484', '14581484', '2&quot; x 4&quot; 14 gauge', '10', '1', '0', '0'),
('502', '14581485', '14581485', '2&quot; x 4&quot; 12 gauge', '10', '1', '0', '0'),
('503', '14581486', '14581486', '2&quot; x 4&quot; 10 gauge', '10', '1', '0', '0'),
('504', '14581487', '14581487', '2&quot; x 5&quot; 20 gauge', '10', '1', '0', '0'),
('505', '14581488', '14581488', '2&quot; x 5&quot; 18 gauge', '10', '1', '0', '0'),
('506', '14581489', '14581489', '2&quot; x 5&quot; 16 gauge', '10', '1', '0', '0'),
('507', '14581490', '14581490', '2&quot; x 5&quot; 14 gauge', '10', '1', '0', '0'),
('508', '14581491', '14581491', '2&quot; x 5&quot; 12 gauge', '10', '1', '0', '0'),
('509', '14581492', '14581492', '2&quot; x 5&quot; 10 gauge', '10', '1', '0', '0'),
('510', '14581493', '14581493', 'D SADA 20 gauge', '10', '1', '0', '0'),
('511', '14581494', '14581494', 'D SADA 18 gauge', '10', '1', '0', '0'),
('512', '14581495', '14581495', 'D SADA 16 gauge', '10', '1', '0', '0'),
('513', '14581496', '14581496', 'D JUMBO 20 gauge', '10', '1', '0', '0'),
('514', '14581497', '14581497', 'D JUMBO 18 gauge', '10', '1', '0', '0'),
('515', '14581498', '14581498', 'D JUMBO 16 gauge', '10', '1', '0', '0'),
('516', '56876383', '56876383', '1&quot; x 3&quot; 3.80 kg', '10', '1', '0', '0'),
('517', '35147091', '35147091', '1&quot; x 3&quot; 4.00 kg', '10', '1', '0', '0'),
('518', '38632044', '38632044', 'HR 48 MM', '1', '1', '0', '0'),
('519', '83980428', '83980428', 'HR 354 MM', '1', '1', '0', '0'),
('521', '37613624', '37613624', 'HR  231 MM', '1', '1', '0', '0'),
('522', '82995317', '82995317', '2 1/2 x  2 1/2 16 Gauge', '10', '1', '0', '0'),
('523', '43317004', '43317004', '2 1/2 x  2 1/2 18 Gauge', '10', '1', '0', '0'),
('524', '22197504', '22197504', '1&quot; x 3&quot; 23 guage 18Ft', '10', '1', '0', '0'),
('525', '49858495', '49858495', '2&#039;&#039;1/2 x 2&#039;&#039;1/2 18 guage ', '10', '1', '0', '0'),
('526', '50143139', '50143139', '2 1/2   18 Gauge', '10', '1', '0', '0'),
('527', '00000010', '00000010', 'Finish Good', '10', '1', '0', '0'),
('528', '32641899', '32641899', '1&quot;7/8 5.Kg 21.ft', '10', '1', '0', '0'),
('529', '69839917', '69839917', '95mm round 24 KG', '10', '1', '0', '0'),
('530', '89871836', '89871836', '95mm round 20 KG', '10', '1', '0', '0'),
('531', '14653407', '14653407', '2&quot; 1/4 Round 23.G 21 Ft.', '1', '1', '0', '0'),
('532', '32476125', '32476125', '2&quot; 1/4 Round 4KG 21 Ft.', '10', '1', '0', '0'),
('533', '46115744', '46115744', '2&quot; 1/4 Round 4.KG 21 Ft.', '10', '1', '0', '0'),
('534', '68279509', '68279509', '1&quot; 5/8 Round 9.35KG 21 Ft', '10', '1', '0', '0'),
('535', '12625871', '12625871', '2&quot; x 4&quot; 33.5KG 17 Ft.', '10', '1', '0', '0'),
('536', '32910179', '32910179', '95 MM 20 KG', '10', '1', '0', '0');

### Structure of table `0_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `0_item_tax_type_exemptions`;

CREATE TABLE `0_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_item_tax_type_exemptions` ###


### Structure of table `0_item_tax_types` ###

DROP TABLE IF EXISTS `0_item_tax_types`;

CREATE TABLE `0_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_item_tax_types` ###

INSERT INTO `0_item_tax_types` VALUES
('1', 'Regular', '0', '0');

### Structure of table `0_item_units` ###

DROP TABLE IF EXISTS `0_item_units`;

CREATE TABLE `0_item_units` (
  `abbr` varchar(20) NOT NULL,
  `name` varchar(40) NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_item_units` ###

INSERT INTO `0_item_units` VALUES
('BG', 'Bag', '4', '0'),
('each', 'Each', '0', '0'),
('GRM', 'GRM', '4', '0'),
('hr', 'Hours', '0', '0'),
('KG', 'KG', '4', '0'),
('MT', 'MT', '4', '0'),
('Pcs', 'Pcs', '-1', '0'),
('Pound', 'Pound', '4', '0');

### Structure of table `0_journal` ###

DROP TABLE IF EXISTS `0_journal`;

CREATE TABLE `0_journal` (
  `type` smallint(6) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) NOT NULL DEFAULT '',
  `source_ref` varchar(60) NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_journal` ###

INSERT INTO `0_journal` VALUES
('0', '1', '2025-05-31', '001/2025', '', '0000-00-00', '0000-00-00', 'PKR', '0', '1'),
('0', '2', '2025-06-02', '002/2025', '', '0000-00-00', '0000-00-00', 'PKR', '0', '1'),
('0', '3', '2025-06-02', '003/2025', '', '0000-00-00', '0000-00-00', 'PKR', '0', '1'),
('0', '4', '2025-06-02', '001/2025', '', '0000-00-00', '0000-00-00', 'PKR', '-4874160', '1'),
('35', '1', '2025-06-02', '001/2025', '', '2025-06-02', '2025-06-02', 'PKR', '225165', '1'),
('35', '2', '2025-06-02', '002/2025', '', '2025-06-02', '2025-06-02', 'PKR', '225165', '1'),
('35', '3', '2025-06-02', '003/2025', '', '2025-06-02', '2025-06-02', 'PKR', '225165', '1');

### Structure of table `0_kv_bank_trans_settings` ###

DROP TABLE IF EXISTS `0_kv_bank_trans_settings`;

CREATE TABLE `0_kv_bank_trans_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_name` varchar(250) DEFAULT NULL,
  `pay_type` int(11) DEFAULT -1,
  `person_id` text NOT NULL,
  `keyword` text NOT NULL,
  `min_price` int(11) NOT NULL,
  `max_price` int(11) NOT NULL,
  `negative_only` tinyint(4) NOT NULL DEFAULT 0,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_kv_bank_trans_settings` ###


### Structure of table `0_loc_stock` ###

DROP TABLE IF EXISTS `0_loc_stock`;

CREATE TABLE `0_loc_stock` (
  `loc_code` char(5) NOT NULL DEFAULT '',
  `stock_id` char(20) NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_loc_stock` ###

INSERT INTO `0_loc_stock` VALUES
('001', '00000010', '0'),
('001', '11374466', '0'),
('001', '11797913', '0'),
('001', '11880905', '0'),
('001', '12200610', '0'),
('001', '12271344', '0'),
('001', '12625871', '0'),
('001', '13403775', '0'),
('001', '13917388', '0'),
('001', '14653407', '0'),
('001', '15026439', '0'),
('001', '15256331', '0'),
('001', '15455659', '0'),
('001', '15539380', '0'),
('001', '15607515', '0'),
('001', '16127968', '0'),
('001', '16678026', '0'),
('001', '17621984', '0'),
('001', '17625166', '0'),
('001', '18592429', '0'),
('001', '19188850', '0'),
('001', '19415826', '0'),
('001', '21278952', '0'),
('001', '22197504', '0'),
('001', '22317476', '0'),
('001', '22421692', '0'),
('001', '22580528', '0'),
('001', '22945167', '0'),
('001', '23005136', '0'),
('001', '23129313', '0'),
('001', '23551985', '0'),
('001', '24128728', '0'),
('001', '24616744', '0'),
('001', '25428933', '0'),
('001', '25461817', '0'),
('001', '25626292', '0'),
('001', '26336862', '0'),
('001', '26898834', '0'),
('001', '27003244', '0'),
('001', '27038857', '0'),
('001', '27344910', '0'),
('001', '28298984', '0'),
('001', '28488323', '0'),
('001', '28758426', '0'),
('001', '29121137', '0'),
('001', '29765263', '0'),
('001', '29928019', '0'),
('001', '30388635', '0'),
('001', '31757539', '0'),
('001', '31845304', '0'),
('001', '32476125', '0'),
('001', '32641899', '0'),
('001', '32910179', '0'),
('001', '33010403', '0'),
('001', '33014630', '0'),
('001', '33161341', '0'),
('001', '33852171', '0'),
('001', '34282793', '0'),
('001', '34351079', '0'),
('001', '34772638', '0'),
('001', '35100379', '0'),
('001', '35147091', '0'),
('001', '35760849', '0'),
('001', '35856511', '0'),
('001', '36854509', '0'),
('001', '36967377', '0'),
('001', '37226985', '0'),
('001', '37277987', '0'),
('001', '37613624', '0'),
('001', '37933388', '0'),
('001', '37953591', '0'),
('001', '38001291', '0'),
('001', '38396434', '0'),
('001', '38632044', '0'),
('001', '38676123', '0'),
('001', '39363473', '0'),
('001', '39858313', '0'),
('001', '40102160', '0'),
('001', '41310243', '0'),
('001', '42187257', '0'),
('001', '42196402', '0'),
('001', '42269250', '0'),
('001', '43317004', '0'),
('001', '43506903', '0'),
('001', '43606917', '0'),
('001', '43753536', '0'),
('001', '44606343', '0'),
('001', '44888404', '0'),
('001', '45090547', '0'),
('001', '45382888', '0'),
('001', '46115744', '0'),
('001', '46848437', '0'),
('001', '47221925', '0'),
('001', '47558502', '0'),
('001', '47893269', '0'),
('001', '47937208', '0'),
('001', '48312592', '0'),
('001', '48525985', '0'),
('001', '48755290', '0'),
('001', '49062199', '0'),
('001', '49492408', '0'),
('001', '49858495', '0'),
('001', '49916706', '0'),
('001', '50143139', '0'),
('001', '50181056', '0'),
('001', '50196340', '0'),
('001', '50356355', '0'),
('001', '50516162', '0'),
('001', '50957330', '0'),
('001', '51873912', '0'),
('001', '51875008', '0'),
('001', '52157509', '0'),
('001', '53061478', '0'),
('001', '53186355', '0'),
('001', '53339355', '0'),
('001', '54353046', '0'),
('001', '54485648', '0'),
('001', '54487901', '0'),
('001', '55199216', '0'),
('001', '55717946', '0'),
('001', '55964364', '0'),
('001', '56537086', '0'),
('001', '56817805', '0'),
('001', '56876383', '0'),
('001', '57044996', '0'),
('001', '57054766', '0'),
('001', '57191928', '0'),
('001', '57199481', '0'),
('001', '57426570', '0'),
('001', '57781471', '0'),
('001', '57921181', '0'),
('001', '58281154', '0'),
('001', '59131656', '0'),
('001', '59629344', '0'),
('001', '59726944', '0'),
('001', '60306395', '0'),
('001', '60487735', '0'),
('001', '60896421', '0'),
('001', '61226944', '0'),
('001', '62064910', '0'),
('001', '62259644', '0'),
('001', '63120059', '0'),
('001', '63275896', '0'),
('001', '63919011', '0'),
('001', '64423197', '0'),
('001', '65049693', '0'),
('001', '65334676', '0'),
('001', '65684450', '0'),
('001', '67217885', '0'),
('001', '68279509', '0'),
('001', '68299156', '0'),
('001', '68491130', '0'),
('001', '69557439', '0'),
('001', '69839917', '0'),
('001', '70943160', '0'),
('001', '71370200', '0'),
('001', '71404882', '0'),
('001', '71846835', '0'),
('001', '72607022', '0'),
('001', '73803553', '0'),
('001', '74142163', '0'),
('001', '74212033', '0'),
('001', '74470815', '0'),
('001', '74539390', '0'),
('001', '74756629', '0'),
('001', '75376024', '0'),
('001', '75658922', '0'),
('001', '75888725', '0'),
('001', '76288142', '0'),
('001', '76448850', '0'),
('001', '77080967', '0'),
('001', '77148827', '0'),
('001', '77520777', '0'),
('001', '77615985', '0'),
('001', '78812307', '0'),
('001', '79067294', '0'),
('001', '79665766', '0'),
('001', '80160250', '0'),
('001', '81080342', '0'),
('001', '81626281', '0'),
('001', '82239695', '0'),
('001', '82995317', '0'),
('001', '83564802', '0'),
('001', '83895982', '0'),
('001', '83933127', '0'),
('001', '83980428', '0'),
('001', '87164503', '0'),
('001', '88255262', '0'),
('001', '88585802', '0'),
('001', '88756837', '0'),
('001', '88903453', '0'),
('001', '89370704', '0'),
('001', '89405017', '0'),
('001', '89871836', '0'),
('001', '90538834', '0'),
('001', '91000026', '0'),
('001', '92436268', '0'),
('001', '92495401', '0'),
('001', '93528870', '0'),
('001', '93692922', '0'),
('001', '94370522', '0'),
('001', '94463217', '0'),
('001', '95420905', '0'),
('001', '96703151', '0'),
('001', '96816141', '0'),
('001', '97608271', '0'),
('001', '98373062', '0'),
('001', '98482139', '0'),
('DEF', '00000010', '0'),
('DEF', '11374466', '0'),
('DEF', '11797913', '0'),
('DEF', '11880905', '0'),
('DEF', '12200610', '0'),
('DEF', '12271344', '0'),
('DEF', '12625871', '0'),
('DEF', '13403775', '0'),
('DEF', '13917388', '0'),
('DEF', '14653407', '0'),
('DEF', '15026439', '0'),
('DEF', '15256331', '0'),
('DEF', '15455659', '0'),
('DEF', '15539380', '0'),
('DEF', '15607515', '0'),
('DEF', '16127968', '0'),
('DEF', '16678026', '0'),
('DEF', '17621984', '0'),
('DEF', '17625166', '0'),
('DEF', '18592429', '0'),
('DEF', '19188850', '0'),
('DEF', '19415826', '0'),
('DEF', '21278952', '0'),
('DEF', '22197504', '0'),
('DEF', '22317476', '0'),
('DEF', '22421692', '0'),
('DEF', '22580528', '0'),
('DEF', '22945167', '0'),
('DEF', '23005136', '0'),
('DEF', '23129313', '0'),
('DEF', '23551985', '0'),
('DEF', '24128728', '0'),
('DEF', '24616744', '0'),
('DEF', '25428933', '0'),
('DEF', '25461817', '0'),
('DEF', '25626292', '0'),
('DEF', '26336862', '0'),
('DEF', '26898834', '0'),
('DEF', '27003244', '0'),
('DEF', '27038857', '0'),
('DEF', '27344910', '0'),
('DEF', '28298984', '0'),
('DEF', '28488323', '0'),
('DEF', '28758426', '0'),
('DEF', '29121137', '0'),
('DEF', '29765263', '0'),
('DEF', '29928019', '0'),
('DEF', '30388635', '0'),
('DEF', '31757539', '0'),
('DEF', '31845304', '0'),
('DEF', '32476125', '0'),
('DEF', '32641899', '0'),
('DEF', '32910179', '0'),
('DEF', '33010403', '0'),
('DEF', '33014630', '0'),
('DEF', '33161341', '0'),
('DEF', '33852171', '0'),
('DEF', '34282793', '0'),
('DEF', '34351079', '0'),
('DEF', '34772638', '0'),
('DEF', '35100379', '0'),
('DEF', '35147091', '0'),
('DEF', '35760849', '0'),
('DEF', '35856511', '0'),
('DEF', '36854509', '0'),
('DEF', '36967377', '0'),
('DEF', '37226985', '0'),
('DEF', '37277987', '0'),
('DEF', '37613624', '0'),
('DEF', '37933388', '0'),
('DEF', '37953591', '0'),
('DEF', '38001291', '0'),
('DEF', '38396434', '0'),
('DEF', '38632044', '0'),
('DEF', '38676123', '0'),
('DEF', '39363473', '0'),
('DEF', '39858313', '0'),
('DEF', '40102160', '0'),
('DEF', '41310243', '0'),
('DEF', '42187257', '0'),
('DEF', '42196402', '0'),
('DEF', '42269250', '0'),
('DEF', '43317004', '0'),
('DEF', '43506903', '0'),
('DEF', '43606917', '0'),
('DEF', '43753536', '0'),
('DEF', '44606343', '0'),
('DEF', '44888404', '0'),
('DEF', '45090547', '0'),
('DEF', '45382888', '0'),
('DEF', '46115744', '0'),
('DEF', '46848437', '0'),
('DEF', '47221925', '0'),
('DEF', '47558502', '0'),
('DEF', '47893269', '0'),
('DEF', '47937208', '0'),
('DEF', '48312592', '0'),
('DEF', '48525985', '0'),
('DEF', '48755290', '0'),
('DEF', '49062199', '0'),
('DEF', '49492408', '0'),
('DEF', '49858495', '0'),
('DEF', '49916706', '0'),
('DEF', '50143139', '0'),
('DEF', '50181056', '0'),
('DEF', '50196340', '0'),
('DEF', '50356355', '0'),
('DEF', '50516162', '0'),
('DEF', '50957330', '0'),
('DEF', '51873912', '0'),
('DEF', '51875008', '0'),
('DEF', '52157509', '0'),
('DEF', '53061478', '0'),
('DEF', '53186355', '0'),
('DEF', '53339355', '0'),
('DEF', '54353046', '0'),
('DEF', '54485648', '0'),
('DEF', '54487901', '0'),
('DEF', '55199216', '0'),
('DEF', '55717946', '0'),
('DEF', '55964364', '0'),
('DEF', '56537086', '0'),
('DEF', '56817805', '0'),
('DEF', '56876383', '0'),
('DEF', '57044996', '0'),
('DEF', '57054766', '0'),
('DEF', '57191928', '0'),
('DEF', '57199481', '0'),
('DEF', '57426570', '0'),
('DEF', '57781471', '0'),
('DEF', '57921181', '0'),
('DEF', '58281154', '0'),
('DEF', '59131656', '0'),
('DEF', '59629344', '0'),
('DEF', '59726944', '0'),
('DEF', '60306395', '0'),
('DEF', '60487735', '0'),
('DEF', '60896421', '0'),
('DEF', '61226944', '0'),
('DEF', '62064910', '0'),
('DEF', '62259644', '0'),
('DEF', '63120059', '0'),
('DEF', '63275896', '0'),
('DEF', '63919011', '0'),
('DEF', '64423197', '0'),
('DEF', '65049693', '0'),
('DEF', '65334676', '0'),
('DEF', '65684450', '0'),
('DEF', '67217885', '0'),
('DEF', '68279509', '0'),
('DEF', '68299156', '0'),
('DEF', '68491130', '0'),
('DEF', '69557439', '0'),
('DEF', '69839917', '0'),
('DEF', '70943160', '0'),
('DEF', '71370200', '0'),
('DEF', '71404882', '0'),
('DEF', '71846835', '0'),
('DEF', '72607022', '0'),
('DEF', '73803553', '0'),
('DEF', '74142163', '0'),
('DEF', '74212033', '0'),
('DEF', '74470815', '0'),
('DEF', '74539390', '0'),
('DEF', '74756629', '0'),
('DEF', '75376024', '0'),
('DEF', '75658922', '0'),
('DEF', '75888725', '0'),
('DEF', '76288142', '0'),
('DEF', '76448850', '0'),
('DEF', '77080967', '0'),
('DEF', '77148827', '0'),
('DEF', '77520777', '0'),
('DEF', '77615985', '0'),
('DEF', '78812307', '0'),
('DEF', '79067294', '0'),
('DEF', '79665766', '0'),
('DEF', '80160250', '0'),
('DEF', '81080342', '0'),
('DEF', '81626281', '0'),
('DEF', '82239695', '0'),
('DEF', '82995317', '0'),
('DEF', '83564802', '0'),
('DEF', '83895982', '0'),
('DEF', '83933127', '0'),
('DEF', '83980428', '0'),
('DEF', '87164503', '0'),
('DEF', '88255262', '0'),
('DEF', '88585802', '0'),
('DEF', '88756837', '0'),
('DEF', '88903453', '0'),
('DEF', '89370704', '0'),
('DEF', '89405017', '0'),
('DEF', '89871836', '0'),
('DEF', '90538834', '0'),
('DEF', '91000026', '0'),
('DEF', '92436268', '0'),
('DEF', '92495401', '0'),
('DEF', '93528870', '0'),
('DEF', '93692922', '0'),
('DEF', '94370522', '0'),
('DEF', '94463217', '0'),
('DEF', '95420905', '0'),
('DEF', '96703151', '0'),
('DEF', '96816141', '0'),
('DEF', '97608271', '0'),
('DEF', '98373062', '0'),
('DEF', '98482139', '0'),
('STORE', '00000010', '0'),
('STORE', '11374466', '0'),
('STORE', '11797913', '0'),
('STORE', '11880905', '0'),
('STORE', '12200610', '0'),
('STORE', '12271344', '0'),
('STORE', '12625871', '0'),
('STORE', '13403775', '0'),
('STORE', '13917388', '0'),
('STORE', '14653407', '0'),
('STORE', '15026439', '0'),
('STORE', '15256331', '0'),
('STORE', '15455659', '0'),
('STORE', '15539380', '0'),
('STORE', '15607515', '0'),
('STORE', '16127968', '0'),
('STORE', '16678026', '0'),
('STORE', '17621984', '0'),
('STORE', '17625166', '0'),
('STORE', '18592429', '0'),
('STORE', '19188850', '0'),
('STORE', '19415826', '0'),
('STORE', '21278952', '0'),
('STORE', '22197504', '0'),
('STORE', '22317476', '0'),
('STORE', '22421692', '0'),
('STORE', '22580528', '0'),
('STORE', '22945167', '0'),
('STORE', '23005136', '0'),
('STORE', '23129313', '0'),
('STORE', '23551985', '0'),
('STORE', '24128728', '0'),
('STORE', '24616744', '0'),
('STORE', '25428933', '0'),
('STORE', '25461817', '0'),
('STORE', '25626292', '0'),
('STORE', '26336862', '0'),
('STORE', '26898834', '0'),
('STORE', '27003244', '0'),
('STORE', '27038857', '0'),
('STORE', '27344910', '0'),
('STORE', '28298984', '0'),
('STORE', '28488323', '0'),
('STORE', '28758426', '0'),
('STORE', '29121137', '0'),
('STORE', '29765263', '0'),
('STORE', '29928019', '0'),
('STORE', '30388635', '0'),
('STORE', '31757539', '0'),
('STORE', '31845304', '0'),
('STORE', '32476125', '0'),
('STORE', '32641899', '0'),
('STORE', '32910179', '0'),
('STORE', '33010403', '0'),
('STORE', '33014630', '0'),
('STORE', '33161341', '0'),
('STORE', '33852171', '0'),
('STORE', '34282793', '0'),
('STORE', '34351079', '0'),
('STORE', '34772638', '0'),
('STORE', '35100379', '0'),
('STORE', '35147091', '0'),
('STORE', '35760849', '0'),
('STORE', '35856511', '0'),
('STORE', '36854509', '0'),
('STORE', '36967377', '0'),
('STORE', '37226985', '0'),
('STORE', '37277987', '0'),
('STORE', '37613624', '0'),
('STORE', '37933388', '0'),
('STORE', '37953591', '0'),
('STORE', '38001291', '0'),
('STORE', '38396434', '0'),
('STORE', '38632044', '0'),
('STORE', '38676123', '0'),
('STORE', '39363473', '0'),
('STORE', '39858313', '0'),
('STORE', '40102160', '0'),
('STORE', '41310243', '0'),
('STORE', '42187257', '0'),
('STORE', '42196402', '0'),
('STORE', '42269250', '0'),
('STORE', '43317004', '0'),
('STORE', '43506903', '0'),
('STORE', '43606917', '0'),
('STORE', '43753536', '0'),
('STORE', '44606343', '0'),
('STORE', '44888404', '0'),
('STORE', '45090547', '0'),
('STORE', '45382888', '0'),
('STORE', '46115744', '0'),
('STORE', '46848437', '0'),
('STORE', '47221925', '0'),
('STORE', '47558502', '0'),
('STORE', '47893269', '0'),
('STORE', '47937208', '0'),
('STORE', '48312592', '0'),
('STORE', '48525985', '0'),
('STORE', '48755290', '0'),
('STORE', '49062199', '0'),
('STORE', '49492408', '0'),
('STORE', '49858495', '0'),
('STORE', '49916706', '0'),
('STORE', '50143139', '0'),
('STORE', '50181056', '0'),
('STORE', '50196340', '0'),
('STORE', '50356355', '0'),
('STORE', '50516162', '0'),
('STORE', '50957330', '0'),
('STORE', '51873912', '0'),
('STORE', '51875008', '0'),
('STORE', '52157509', '0'),
('STORE', '53061478', '0'),
('STORE', '53186355', '0'),
('STORE', '53339355', '0'),
('STORE', '54353046', '0'),
('STORE', '54485648', '0'),
('STORE', '54487901', '0'),
('STORE', '55199216', '0'),
('STORE', '55717946', '0'),
('STORE', '55964364', '0'),
('STORE', '56537086', '0'),
('STORE', '56817805', '0'),
('STORE', '56876383', '0'),
('STORE', '57044996', '0'),
('STORE', '57054766', '0'),
('STORE', '57191928', '0'),
('STORE', '57199481', '0'),
('STORE', '57426570', '0'),
('STORE', '57781471', '0'),
('STORE', '57921181', '0'),
('STORE', '58281154', '0'),
('STORE', '59131656', '0'),
('STORE', '59629344', '0'),
('STORE', '59726944', '0'),
('STORE', '60306395', '0'),
('STORE', '60487735', '0'),
('STORE', '60896421', '0'),
('STORE', '61226944', '0'),
('STORE', '62064910', '0'),
('STORE', '62259644', '0'),
('STORE', '63120059', '0'),
('STORE', '63275896', '0'),
('STORE', '63919011', '0'),
('STORE', '64423197', '0'),
('STORE', '65049693', '0'),
('STORE', '65334676', '0'),
('STORE', '65684450', '0'),
('STORE', '67217885', '0'),
('STORE', '68279509', '0'),
('STORE', '68299156', '0'),
('STORE', '68491130', '0'),
('STORE', '69557439', '0'),
('STORE', '69839917', '0'),
('STORE', '70943160', '0'),
('STORE', '71370200', '0'),
('STORE', '71404882', '0'),
('STORE', '71846835', '0'),
('STORE', '72607022', '0'),
('STORE', '73803553', '0'),
('STORE', '74142163', '0'),
('STORE', '74212033', '0'),
('STORE', '74470815', '0'),
('STORE', '74539390', '0'),
('STORE', '74756629', '0'),
('STORE', '75376024', '0'),
('STORE', '75658922', '0'),
('STORE', '75888725', '0'),
('STORE', '76288142', '0'),
('STORE', '76448850', '0'),
('STORE', '77080967', '0'),
('STORE', '77148827', '0'),
('STORE', '77520777', '0'),
('STORE', '77615985', '0'),
('STORE', '78812307', '0'),
('STORE', '79067294', '0'),
('STORE', '79665766', '0'),
('STORE', '80160250', '0'),
('STORE', '81080342', '0'),
('STORE', '81626281', '0'),
('STORE', '82239695', '0'),
('STORE', '82995317', '0'),
('STORE', '83564802', '0'),
('STORE', '83895982', '0'),
('STORE', '83933127', '0'),
('STORE', '83980428', '0'),
('STORE', '87164503', '0'),
('STORE', '88255262', '0'),
('STORE', '88585802', '0'),
('STORE', '88756837', '0'),
('STORE', '88903453', '0'),
('STORE', '89370704', '0'),
('STORE', '89405017', '0'),
('STORE', '89871836', '0'),
('STORE', '90538834', '0'),
('STORE', '91000026', '0'),
('STORE', '92436268', '0'),
('STORE', '92495401', '0'),
('STORE', '93528870', '0'),
('STORE', '93692922', '0'),
('STORE', '94370522', '0'),
('STORE', '94463217', '0'),
('STORE', '95420905', '0'),
('STORE', '96703151', '0'),
('STORE', '96816141', '0'),
('STORE', '97608271', '0'),
('STORE', '98373062', '0'),
('STORE', '98482139', '0');

### Structure of table `0_locations` ###

DROP TABLE IF EXISTS `0_locations`;

CREATE TABLE `0_locations` (
  `loc_code` varchar(5) NOT NULL DEFAULT '',
  `location_name` varchar(60) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `phone` varchar(30) NOT NULL DEFAULT '',
  `phone2` varchar(30) NOT NULL DEFAULT '',
  `fax` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `contact` varchar(30) NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_locations` ###

INSERT INTO `0_locations` VALUES
('001', 'Fixed assets Loc', 'Fixed assets Loc', '', '', '', '', '', '1', '0'),
('DEF', 'Default', 'N/A', '', '', '', '', '', '0', '0'),
('STORE', 'Store', '', '', '', '', '', '', '0', '0');

### Structure of table `0_master_login` ###

DROP TABLE IF EXISTS `0_master_login`;

CREATE TABLE `0_master_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) NOT NULL,
  `role` int(11) NOT NULL,
  `companies` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_master_login` ###

INSERT INTO `0_master_login` VALUES
('1', 'admin', '4', 'YToxOntpOjA7aTowO30=');

### Structure of table `0_payment_terms` ###

DROP TABLE IF EXISTS `0_payment_terms`;

CREATE TABLE `0_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT 0,
  `day_in_following_month` smallint(6) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_payment_terms` ###

INSERT INTO `0_payment_terms` VALUES
('1', 'Due 15th Days', '15', '0', '0'),
('2', 'Due 20th Days', '20', '0', '0'),
('3', 'Due 30 days', '30', '0', '0'),
('4', 'Cash Only', '0', '0', '0'),
('5', 'Prepaid', '-1', '0', '0'),
('6', 'Due 40 Days', '40', '0', '0'),
('7', 'Due 45 days', '45', '0', '0'),
('8', 'Due To 72 Days', '72', '0', '0'),
('9', 'Due 111 Days', '111', '0', '0'),
('10', 'Due 117 Days', '117', '0', '0'),
('11', 'Due 143 Days', '143', '0', '0');

### Structure of table `0_prices` ###

DROP TABLE IF EXISTS `0_prices`;

CREATE TABLE `0_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT 0,
  `curr_abrev` char(3) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB AUTO_INCREMENT=441 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_prices` ###

INSERT INTO `0_prices` VALUES
('1', '94463217', '2', 'PKR', '328.6'),
('2', '60487735', '2', 'PKR', '20'),
('3', '81080342', '1', 'PKR', '660'),
('4', '11374466', '1', 'PKR', '931'),
('5', '15607515', '1', 'PKR', '2496'),
('6', '17625166', '1', 'PKR', '374'),
('7', '22421692', '1', 'PKR', '1629.4'),
('8', '22580528', '1', 'PKR', '1441'),
('9', '22945167', '1', 'PKR', '1761'),
('10', '23129313', '1', 'PKR', '1441'),
('11', '23551985', '1', 'PKR', '949'),
('12', '25461817', '1', 'PKR', '1761'),
('13', '26336862', '1', 'PKR', '915'),
('14', '27038857', '1', 'PKR', '3043'),
('15', '15256331', '1', 'PKR', '3300'),
('16', '15455659', '1', 'PKR', '2496'),
('17', '17621984', '1', 'PKR', '4200'),
('18', '56537086', '1', 'PKR', '3300'),
('19', '44606343', '1', 'PKR', '5300'),
('20', '44888404', '1', 'PKR', '2496'),
('22', '56817805', '1', 'PKR', '3043'),
('23', '57199481', '1', 'PKR', '3043'),
('24', '59629344', '1', 'PKR', '1629.4'),
('25', '68491130', '1', 'PKR', '5300'),
('26', '70943160', '1', 'PKR', '1284'),
('28', '76288142', '1', 'PKR', '1892'),
('30', '31757539', '1', 'PKR', '3800'),
('31', '25428933', '1', 'PKR', '3870'),
('32', '29928019', '1', 'PKR', '2305.4'),
('33', '40102160', '1', 'PKR', '2305.4'),
('35', '42187257', '1', 'PKR', '1340'),
('36', '46848437', '1', 'PKR', '1242'),
('37', '50957330', '1', 'PKR', '1892'),
('38', '53339355', '1', 'PKR', '2305.4'),
('39', '62259644', '1', 'PKR', '1892'),
('40', '63275896', '1', 'PKR', '2305.4'),
('41', '83933127', '1', 'PKR', '1242'),
('42', '88585802', '1', 'PKR', '1892'),
('43', '29765263', '1', 'PKR', '2234.6'),
('44', '50181056', '1', 'PKR', '665.6'),
('45', '55964364', '1', 'PKR', '1557'),
('47', '93692922', '1', 'PKR', '1250'),
('48', '96816141', '1', 'PKR', '837'),
('49', '94463217', '1', 'PKR', '1160.8'),
('50', '33852171', '1', 'PKR', '962'),
('51', '58281154', '1', 'PKR', '739'),
('52', '59131656', '1', 'PKR', '1333'),
('53', '65334676', '1', 'PKR', '1333'),
('54', '65684450', '1', 'PKR', '613'),
('55', '68299156', '1', 'PKR', '1333'),
('56', '77520777', '1', 'PKR', '1156'),
('58', '60896421', '1', 'PKR', '1156'),
('59', '75658922', '1', 'PKR', '775.6'),
('60', '98373062', '1', 'PKR', '417.2'),
('61', '47893269', '1', 'PKR', '328.6'),
('62', '97608271', '1', 'PKR', '510.4'),
('63', '34282793', '1', 'PKR', '721.2'),
('64', '12200610', '1', 'PKR', '990.6'),
('65', '22317476', '1', 'PKR', '1285'),
('66', '23005136', '1', 'PKR', '660'),
('67', '33014630', '1', 'PKR', '739'),
('68', '36967377', '1', 'PKR', '1633'),
('69', '50356355', '1', 'PKR', '1104.4'),
('70', '69557439', '1', 'PKR', '825'),
('71', '80160250', '1', 'PKR', '2169'),
('72', '89370704', '1', 'PKR', '1557'),
('73', '74756629', '1', 'PKR', '3917'),
('74', '88756837', '1', 'PKR', '2962'),
('75', '49916706', '1', 'PKR', '949'),
('76', '79665766', '1', 'PKR', '739'),
('77', '93528870', '1', 'PKR', '837'),
('78', '12271344', '1', 'PKR', '374'),
('79', '21278952', '1', 'PKR', '775.6'),
('80', '47937208', '1', 'PKR', '596.2'),
('81', '53061478', '1', 'PKR', '462'),
('82', '64423197', '1', 'PKR', '417.2'),
('83', '79067294', '1', 'PKR', '328.6'),
('84', '15026439', '1', 'PKR', '665.6'),
('85', '49492408', '1', 'PKR', '510.4'),
('86', '35100379', '1', 'PKR', '721.2'),
('87', '37953591', '1', 'PKR', '613'),
('88', '55717946', '1', 'PKR', '721.2'),
('89', '63919011', '1', 'PKR', '1285'),
('90', '71404882', '1', 'PKR', '1285'),
('91', '73803553', '1', 'PKR', '990.6'),
('92', '75888725', '1', 'PKR', '990.6'),
('93', '78812307', '1', 'PKR', '665.6'),
('94', '81626281', '1', 'PKR', '613'),
('95', '24128728', '1', 'PKR', '510.4'),
('96', '15539380', '1', 'PKR', '1507'),
('97', '47558502', '1', 'PKR', '1997'),
('98', '50516162', '1', 'PKR', '1134.4'),
('99', '88255262', '1', 'PKR', '1023'),
('100', '94370522', '1', 'PKR', '754.2'),
('101', '19188850', '1', 'PKR', '1997'),
('102', '33161341', '1', 'PKR', '1507'),
('103', '55199216', '1', 'PKR', '754'),
('104', '65049693', '1', 'PKR', '915'),
('105', '75376024', '1', 'PKR', '1134.4'),
('106', '96703151', '1', 'PKR', '1507'),
('107', '11797913', '1', 'PKR', '1997'),
('108', '16678026', '1', 'PKR', '1134.4'),
('110', '51873912', '1', 'PKR', '1250'),
('111', '48525985', '1', 'PKR', '1633'),
('112', '49062199', '1', 'PKR', '1284.4'),
('113', '61226944', '1', 'PKR', '2496'),
('114', '63120059', '1', 'PKR', '972.2'),
('115', '31845304', '1', 'PKR', '1441'),
('116', '39363473', '1', 'PKR', '1284.4'),
('117', '72607022', '1', 'PKR', '1892'),
('118', '41310243', '1', 'PKR', '2530.2'),
('119', '57054766', '1', 'PKR', '1441'),
('120', '74142163', '1', 'PKR', '3308'),
('121', '34351079', '1', 'PKR', '4303.4'),
('122', '92436268', '1', 'PKR', '2694'),
('123', '101', '1', 'PKR', '0'),
('124', '100001', '1', 'PKR', '0'),
('125', '100002', '1', 'PKR', '0'),
('126', '100003', '1', 'PKR', '0'),
('127', '100004', '1', 'PKR', '0'),
('128', '100005', '1', 'PKR', '0'),
('129', '100006', '1', 'PKR', '0'),
('130', '100007', '1', 'PKR', '0'),
('131', '100008', '1', 'PKR', '0'),
('132', '100009', '1', 'PKR', '0'),
('133', '100010', '1', 'PKR', '0'),
('134', '100011', '1', 'PKR', '0'),
('135', '100012', '1', 'PKR', '0'),
('136', '100013', '1', 'PKR', '0'),
('137', '100014', '1', 'PKR', '0'),
('138', '100015', '1', 'PKR', '0'),
('139', '100016', '1', 'PKR', '0'),
('140', '100017', '1', 'PKR', '0'),
('141', '100018', '1', 'PKR', '0'),
('142', '100019', '1', 'PKR', '0'),
('143', '100020', '1', 'PKR', '0'),
('144', '100021', '1', 'PKR', '0'),
('145', '100022', '1', 'PKR', '0'),
('146', '100023', '1', 'PKR', '0'),
('147', '100024', '1', 'PKR', '0'),
('148', '100025', '1', 'PKR', '0'),
('149', '100026', '1', 'PKR', '0'),
('150', '100027', '1', 'PKR', '0'),
('151', '100028', '1', 'PKR', '0'),
('152', '100029', '1', 'PKR', '0'),
('153', '100030', '1', 'PKR', '0'),
('154', '100031', '1', 'PKR', '0'),
('155', '100032', '1', 'PKR', '0'),
('156', '100033', '1', 'PKR', '0'),
('157', '100034', '1', 'PKR', '0'),
('158', '100035', '1', 'PKR', '0'),
('159', '100036', '1', 'PKR', '0'),
('160', '100037', '1', 'PKR', '0'),
('161', '100038', '1', 'PKR', '0'),
('162', '100039', '1', 'PKR', '0'),
('163', '100040', '1', 'PKR', '0'),
('164', '100041', '1', 'PKR', '0'),
('165', '100042', '1', 'PKR', '0'),
('166', '100043', '1', 'PKR', '0'),
('167', '100044', '1', 'PKR', '0'),
('168', '100045', '1', 'PKR', '0'),
('169', '100046', '1', 'PKR', '0'),
('170', '100047', '1', 'PKR', '0'),
('171', '100048', '1', 'PKR', '0'),
('172', '100049', '1', 'PKR', '0'),
('173', '100050', '1', 'PKR', '0'),
('174', '100051', '1', 'PKR', '0'),
('175', '100052', '1', 'PKR', '0'),
('176', '100053', '1', 'PKR', '0'),
('177', '100054', '1', 'PKR', '0'),
('178', '100055', '1', 'PKR', '0'),
('179', '100056', '1', 'PKR', '0'),
('180', '100057', '1', 'PKR', '0'),
('181', '100058', '1', 'PKR', '0'),
('182', '100059', '1', 'PKR', '0'),
('183', '100060', '1', 'PKR', '0'),
('184', '100061', '1', 'PKR', '0'),
('185', '100062', '1', 'PKR', '0'),
('186', '100063', '1', 'PKR', '0'),
('187', '100064', '1', 'PKR', '0'),
('188', '100065', '1', 'PKR', '0'),
('189', '100066', '1', 'PKR', '0'),
('190', '100067', '1', 'PKR', '0'),
('191', '100068', '1', 'PKR', '0'),
('192', '100069', '1', 'PKR', '0'),
('193', '100070', '1', 'PKR', '0'),
('194', '100071', '1', 'PKR', '0'),
('195', '100072', '1', 'PKR', '0'),
('196', '100073', '1', 'PKR', '0'),
('197', '100074', '1', 'PKR', '0'),
('198', '100075', '1', 'PKR', '0'),
('199', '100076', '1', 'PKR', '0'),
('200', '100077', '1', 'PKR', '0'),
('201', '100078', '1', 'PKR', '0'),
('202', '100079', '1', 'PKR', '0'),
('203', '100080', '1', 'PKR', '0'),
('204', '100081', '1', 'PKR', '0'),
('205', '100082', '1', 'PKR', '0'),
('206', '100083', '1', 'PKR', '0'),
('207', '100084', '1', 'PKR', '0'),
('208', '100085', '1', 'PKR', '0'),
('209', '100086', '1', 'PKR', '0'),
('210', '100087', '1', 'PKR', '0'),
('211', '100088', '1', 'PKR', '0'),
('212', '100089', '1', 'PKR', '0'),
('213', '100090', '1', 'PKR', '0'),
('214', '100091', '1', 'PKR', '0'),
('215', '100092', '1', 'PKR', '0'),
('216', '100093', '1', 'PKR', '0'),
('217', '100094', '1', 'PKR', '0'),
('218', '10000001', '1', 'PKR', '373.6'),
('219', '10000002', '1', 'PKR', '422.4'),
('220', '10000003', '1', 'PKR', '460'),
('221', '10000004', '1', 'PKR', '500.4'),
('222', '10000005', '1', 'PKR', '640'),
('223', '10000006', '1', 'PKR', '825'),
('224', '10000007', '1', 'PKR', '0'),
('225', '10000008', '1', 'PKR', '568.2'),
('226', '10000009', '1', 'PKR', '678.8'),
('227', '10000010', '1', 'PKR', '721.2'),
('228', '10000011', '1', 'PKR', '769.2'),
('229', '10000012', '1', 'PKR', '1048.2'),
('230', '10000013', '1', 'PKR', '1358'),
('231', '10000014', '1', 'PKR', '0'),
('232', '10000015', '1', 'PKR', '737.4'),
('233', '10000016', '1', 'PKR', '822.6'),
('234', '10000017', '1', 'PKR', '909.4'),
('235', '10000018', '1', 'PKR', '1013.8'),
('236', '10000019', '1', 'PKR', '1320.4'),
('237', '10000020', '1', 'PKR', '1729.6'),
('238', '10000021', '1', 'PKR', '0'),
('239', '10000022', '1', 'PKR', '844'),
('240', '10000023', '1', 'PKR', '1018.2'),
('241', '10000024', '1', 'PKR', '1111.4'),
('242', '10000025', '1', 'PKR', '1211.6'),
('243', '10000026', '1', 'PKR', '1602'),
('244', '10000027', '1', 'PKR', '1729.6'),
('245', '10000028', '1', 'PKR', '0'),
('246', '10000029', '1', 'PKR', '1335.4'),
('247', '10000030', '1', 'PKR', '1736'),
('248', '10000031', '1', 'PKR', '2302'),
('249', '10000032', '1', 'PKR', '1086.4'),
('250', '10000033', '1', 'PKR', '1286'),
('251', '10000034', '1', 'PKR', '1395.6'),
('252', '10000035', '1', 'PKR', '1539.4'),
('253', '10000036', '1', 'PKR', '2011'),
('254', '10000037', '1', 'PKR', '2661.2'),
('255', '10000038', '1', 'PKR', '0'),
('256', '10000039', '1', 'PKR', '0'),
('257', '10000040', '1', 'PKR', '0'),
('258', '10000041', '1', 'PKR', '0'),
('259', '10000042', '1', 'PKR', '0'),
('260', '10000043', '1', 'PKR', '0'),
('261', '10000044', '1', 'PKR', '0'),
('262', '10000045', '1', 'PKR', '1297'),
('263', '10000046', '1', 'PKR', '1483.4'),
('264', '10000047', '1', 'PKR', '1690'),
('265', '10000048', '1', 'PKR', '1879.4'),
('266', '10000049', '1', 'PKR', '2451'),
('267', '10000050', '1', 'PKR', '3225.6'),
('268', '10000051', '1', 'PKR', '0'),
('269', '10000052', '1', 'PKR', '0'),
('270', '10000053', '1', 'PKR', '2385'),
('271', '10000054', '1', 'PKR', '3148'),
('272', '10000055', '1', 'PKR', '4143'),
('273', '10000056', '1', 'PKR', '0'),
('274', '10000057', '1', 'PKR', '0'),
('275', '10000058', '1', 'PKR', '0'),
('276', '10000059', '1', 'PKR', '3091.4'),
('277', '10000060', '1', 'PKR', '4037'),
('278', '10000061', '1', 'PKR', '5330'),
('279', '10000062', '1', 'PKR', '0'),
('280', '10000063', '1', 'PKR', '0'),
('281', '10000064', '1', 'PKR', '0'),
('282', '10000065', '1', 'PKR', '3318'),
('283', '10000066', '1', 'PKR', '4392'),
('284', '10000067', '1', 'PKR', '5746'),
('285', '10000068', '1', 'PKR', '0'),
('286', '10000069', '1', 'PKR', '0'),
('287', '10000070', '1', 'PKR', '0'),
('288', '10000071', '1', 'PKR', '0'),
('289', '10000072', '1', 'PKR', '0'),
('290', '10000073', '1', 'PKR', '0'),
('291', '10000074', '1', 'PKR', '0'),
('292', '10000075', '1', 'PKR', '0'),
('293', '10000076', '1', 'PKR', '373.6'),
('294', '10000077', '1', 'PKR', '422.4'),
('295', '10000078', '1', 'PKR', '460'),
('296', '10000079', '1', 'PKR', '500.4'),
('297', '10000080', '1', 'PKR', '640'),
('298', '10000081', '1', 'PKR', '825'),
('299', '10000082', '1', 'PKR', '0'),
('300', '10000083', '1', 'PKR', '568.2'),
('301', '10000084', '1', 'PKR', '678.8'),
('302', '10000085', '1', 'PKR', '721.2'),
('303', '10000086', '1', 'PKR', '769.2'),
('304', '10000087', '1', 'PKR', '1048.2'),
('305', '10000088', '1', 'PKR', '1358'),
('306', '10000089', '1', 'PKR', '0'),
('307', '10000090', '1', 'PKR', '737.4'),
('308', '10000091', '1', 'PKR', '822.6'),
('309', '10000092', '1', 'PKR', '909.4'),
('310', '10000093', '1', 'PKR', '1013.8'),
('311', '10000094', '1', 'PKR', '1320.4'),
('312', '14581371', '1', 'PKR', '844'),
('313', '14581372', '1', 'PKR', '1018.2'),
('314', '14581373', '1', 'PKR', '1211.6'),
('315', '14581374', '1', 'PKR', '1211.6'),
('316', '14581375', '1', 'PKR', '1602'),
('317', '14581376', '1', 'PKR', '2119.4'),
('318', '14581377', '1', 'PKR', '0'),
('319', '14581378', '1', 'PKR', '0'),
('320', '14581379', '1', 'PKR', '0'),
('321', '14581380', '1', 'PKR', '1086.4'),
('322', '14581381', '1', 'PKR', '1286'),
('323', '14581382', '1', 'PKR', '1395.6'),
('324', '14581383', '1', 'PKR', '1539.4'),
('325', '14581384', '1', 'PKR', '2011'),
('326', '14581385', '1', 'PKR', '2661.2'),
('327', '14581386', '1', 'PKR', '0'),
('328', '14581387', '1', 'PKR', '0'),
('329', '14581388', '1', 'PKR', '0'),
('330', '14581389', '1', 'PKR', '1297'),
('331', '14581390', '1', 'PKR', '1483.4'),
('332', '14581391', '1', 'PKR', '1690'),
('333', '14581392', '1', 'PKR', '1879.4'),
('334', '14581393', '1', 'PKR', '2451'),
('335', '14581394', '1', 'PKR', '3225.6'),
('336', '14581395', '1', 'PKR', '0'),
('337', '14581396', '1', 'PKR', '0'),
('338', '14581397', '1', 'PKR', '0'),
('339', '14581398', '1', 'PKR', '0'),
('340', '14581399', '1', 'PKR', '0'),
('341', '14581400', '1', 'PKR', '0'),
('342', '14581401', '1', 'PKR', '0'),
('343', '14581402', '1', 'PKR', '2212'),
('344', '14581403', '1', 'PKR', '2783'),
('345', '14581404', '1', 'PKR', '0'),
('346', '14581405', '1', 'PKR', '0'),
('347', '14581406', '1', 'PKR', '0'),
('348', '14581407', '1', 'PKR', '3318'),
('349', '14581408', '1', 'PKR', '4392'),
('350', '14581409', '1', 'PKR', '5746'),
('351', '14581410', '1', 'PKR', '0'),
('352', '14581411', '1', 'PKR', '0'),
('353', '14581412', '1', 'PKR', '0'),
('354', '14581413', '1', 'PKR', '568.2'),
('355', '14581414', '1', 'PKR', '678.8'),
('356', '14581415', '1', 'PKR', '721.2'),
('357', '14581416', '1', 'PKR', '769.2'),
('358', '14581417', '1', 'PKR', '1048.2'),
('359', '14581418', '1', 'PKR', '1358'),
('360', '14581419', '1', 'PKR', '0'),
('361', '14581420', '1', 'PKR', '737.4'),
('362', '14581421', '1', 'PKR', '822.6'),
('363', '14581422', '1', 'PKR', '909.4'),
('364', '14581423', '1', 'PKR', '1013.8'),
('365', '14581424', '1', 'PKR', '1320.4'),
('366', '14581425', '1', 'PKR', '1729.6'),
('367', '14581426', '1', 'PKR', '0'),
('368', '14581427', '1', 'PKR', '844'),
('369', '14581428', '1', 'PKR', '1018.2'),
('370', '14581429', '1', 'PKR', '1111.4'),
('371', '14581430', '1', 'PKR', '1211.6'),
('372', '14581431', '1', 'PKR', '1602'),
('373', '14581432', '1', 'PKR', '2119.4'),
('374', '14581433', '1', 'PKR', '0'),
('375', '14581434', '1', 'PKR', '921.8'),
('376', '14581435', '1', 'PKR', '1070.6'),
('377', '14581436', '1', 'PKR', '1200'),
('378', '14581437', '1', 'PKR', '1335.4'),
('379', '14581438', '1', 'PKR', '1736'),
('380', '14581439', '1', 'PKR', '2302'),
('381', '14581440', '1', 'PKR', '0'),
('382', '14581441', '1', 'PKR', '1086.4'),
('383', '14581442', '1', 'PKR', '1286'),
('384', '14581443', '1', 'PKR', '1395.6'),
('385', '14581444', '1', 'PKR', '1539.4'),
('386', '14581445', '1', 'PKR', '2011'),
('387', '14581446', '1', 'PKR', '2661.2'),
('388', '14581447', '1', 'PKR', '0'),
('389', '14581448', '1', 'PKR', '0'),
('390', '14581449', '1', 'PKR', '0'),
('391', '14581450', '1', 'PKR', '1297'),
('392', '14581451', '1', 'PKR', '1483.4'),
('393', '14581452', '1', 'PKR', '1690'),
('394', '14581453', '1', 'PKR', '1879.4'),
('395', '14581454', '1', 'PKR', '2451'),
('396', '14581455', '1', 'PKR', '3225.6'),
('397', '14581456', '1', 'PKR', '0'),
('398', '14581457', '1', 'PKR', '1879.4'),
('399', '14581458', '1', 'PKR', '2451'),
('400', '14581459', '1', 'PKR', '3225.6'),
('401', '14581460', '1', 'PKR', '0'),
('402', '14581461', '1', 'PKR', '0'),
('403', '14581462', '1', 'PKR', '0'),
('404', '14581463', '1', 'PKR', '2385'),
('405', '14581464', '1', 'PKR', '3148'),
('406', '14581465', '1', 'PKR', '4143'),
('407', '14581466', '1', 'PKR', '0'),
('408', '14581467', '1', 'PKR', '0'),
('409', '14581468', '1', 'PKR', '0'),
('410', '14581469', '1', 'PKR', '2385'),
('411', '14581470', '1', 'PKR', '3148'),
('412', '14581471', '1', 'PKR', '4143'),
('413', '14581472', '1', 'PKR', '0'),
('414', '14581473', '1', 'PKR', '0'),
('415', '14581474', '1', 'PKR', '0'),
('416', '14581475', '1', 'PKR', '3091.4'),
('417', '14581476', '1', 'PKR', '4037'),
('418', '14581477', '1', 'PKR', '5330'),
('419', '14581478', '1', 'PKR', '0'),
('420', '14581479', '1', 'PKR', '0'),
('421', '14581480', '1', 'PKR', '0'),
('422', '14581481', '1', 'PKR', '3318'),
('423', '14581482', '1', 'PKR', '4392'),
('424', '14581483', '1', 'PKR', '5746'),
('425', '14581484', '1', 'PKR', '0'),
('426', '14581485', '1', 'PKR', '0'),
('427', '14581486', '1', 'PKR', '0'),
('428', '14581487', '1', 'PKR', '0'),
('429', '14581488', '1', 'PKR', '0'),
('430', '14581489', '1', 'PKR', '0'),
('431', '14581490', '1', 'PKR', '0'),
('432', '14581491', '1', 'PKR', '0'),
('433', '14581492', '1', 'PKR', '0'),
('434', '14581493', '1', 'PKR', '1539.4'),
('435', '14581494', '1', 'PKR', '2011'),
('436', '14581495', '1', 'PKR', '2661.2'),
('437', '14581496', '1', 'PKR', '1879.4'),
('438', '14581497', '1', 'PKR', '2451'),
('439', '14581498', '1', 'PKR', '3225.6'),
('440', '90538834', '1', 'PKR', '1729.6');

### Structure of table `0_print_profiles` ###

DROP TABLE IF EXISTS `0_print_profiles`;

CREATE TABLE `0_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) NOT NULL,
  `report` varchar(5) DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_print_profiles` ###

INSERT INTO `0_print_profiles` VALUES
('1', 'Out of office', NULL, '0'),
('2', 'Sales Department', NULL, '0'),
('3', 'Central', NULL, '2'),
('4', 'Sales Department', '104', '2'),
('5', 'Sales Department', '105', '2'),
('6', 'Sales Department', '107', '2'),
('7', 'Sales Department', '109', '2'),
('8', 'Sales Department', '110', '2'),
('9', 'Sales Department', '201', '2');

### Structure of table `0_printers` ###

DROP TABLE IF EXISTS `0_printers`;

CREATE TABLE `0_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` varchar(60) NOT NULL,
  `queue` varchar(20) NOT NULL,
  `host` varchar(40) NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_printers` ###

INSERT INTO `0_printers` VALUES
('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20'),
('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5'),
('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

### Structure of table `0_purch_data` ###

DROP TABLE IF EXISTS `0_purch_data`;

CREATE TABLE `0_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  `suppliers_uom` char(50) NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT 1,
  `supplier_description` char(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_purch_data` ###

INSERT INTO `0_purch_data` VALUES
('1', '60487735', '225', '', '1', 'HR Coil'),
('3', '60487735', '210', '', '1', 'HR Coil'),
('5', '60487735', '240', '', '1', 'HR Coil'),
('6', '60487735', '210', '', '1', 'HR Coil'),
('8', '60487735', '245', '', '1', 'HR Coil'),
('9', '60487735', '196', '', '1', 'HR Coil'),
('12', '60487735', '227.5', '', '1', 'HR Coil'),
('13', '60487735', '205', '', '1', 'HR Coil'),
('14', '60487735', '198', '', '1', 'HR Coil'),
('15', '11374466', '228', '', '1', '1&quot; 7/8 round  3.8kg   21ft'),
('15', '60487735', '200', '', '1', 'HR Coil'),
('16', '60487735', '215.5', '', '1', 'HR Coil'),
('21', '60487735', '218', '', '1', 'HR Coil'),
('25', '60487735', '200', '', '1', 'HR Coil'),
('26', '60487735', '182', '', '1', 'HR Coil'),
('26', '83980428', '110', '', '1', 'HR 354 MM'),
('27', '60487735', '209', '', '1', 'HR Coil'),
('29', '60487735', '230', '', '1', 'HR Coil'),
('30', '60487735', '200', '', '1', 'HR Coil');

### Structure of table `0_purch_order_details` ###

DROP TABLE IF EXISTS `0_purch_order_details`;

CREATE TABLE `0_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `act_price` double NOT NULL DEFAULT 0,
  `std_cost_unit` double NOT NULL DEFAULT 0,
  `quantity_ordered` double NOT NULL DEFAULT 0,
  `quantity_received` double NOT NULL DEFAULT 0,
  `thickness` varchar(225) NOT NULL,
  `width` varchar(225) NOT NULL,
  `unit_id` varchar(225) NOT NULL,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_purch_order_details` ###


### Structure of table `0_purch_orders` ###

DROP TABLE IF EXISTS `0_purch_orders`;

CREATE TABLE `0_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext NOT NULL,
  `requisition_no` tinytext DEFAULT NULL,
  `into_stock_location` varchar(5) NOT NULL DEFAULT '',
  `delivery_address` tinytext NOT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_purch_orders` ###


### Structure of table `0_quick_entries` ###

DROP TABLE IF EXISTS `0_quick_entries`;

CREATE TABLE `0_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `description` varchar(60) NOT NULL,
  `usage` varchar(120) DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT 0,
  `base_desc` varchar(60) DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_quick_entries` ###


### Structure of table `0_quick_entry_lines` ###

DROP TABLE IF EXISTS `0_quick_entry_lines`;

CREATE TABLE `0_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT 0,
  `memo` tinytext NOT NULL,
  `action` varchar(2) NOT NULL,
  `dest_id` varchar(15) NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_quick_entry_lines` ###


### Structure of table `0_recurrent_invoices` ###

DROP TABLE IF EXISTS `0_recurrent_invoices`;

CREATE TABLE `0_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT 0,
  `monthly` int(11) NOT NULL DEFAULT 0,
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_recurrent_invoices` ###


### Structure of table `0_reflines` ###

DROP TABLE IF EXISTS `0_reflines`;

CREATE TABLE `0_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) NOT NULL DEFAULT '',
  `pattern` varchar(35) NOT NULL DEFAULT '1',
  `description` varchar(60) NOT NULL DEFAULT '',
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_reflines` ###

INSERT INTO `0_reflines` VALUES
('1', '0', '', '{001}/{YYYY}', '', '1', '0'),
('2', '1', '', '{001}/{YYYY}', '', '1', '0'),
('3', '2', '', '{001}/{YYYY}', '', '1', '0'),
('4', '4', '', '{001}/{YYYY}', '', '1', '0'),
('5', '10', '', '{001}/{YYYY}', '', '1', '0'),
('6', '11', '', '{001}/{YYYY}', '', '1', '0'),
('7', '12', '', '{001}/{YYYY}', '', '1', '0'),
('8', '13', '', '{001}/{YYYY}', '', '1', '0'),
('9', '16', '', '{001}/{YYYY}', '', '1', '0'),
('10', '17', '', '{001}/{YYYY}', '', '1', '0'),
('11', '18', '', '{001}/{YYYY}', '', '1', '0'),
('12', '20', '', '{001}/{YYYY}', '', '1', '0'),
('13', '21', '', '{001}/{YYYY}', '', '1', '0'),
('14', '22', '', '{001}/{YYYY}', '', '1', '0'),
('15', '25', '', '{001}/{YYYY}', '', '1', '0'),
('16', '26', '', '{001}/{YYYY}', '', '1', '0'),
('17', '28', '', '{001}/{YYYY}', '', '1', '0'),
('18', '29', '', '{001}/{YYYY}', '', '1', '0'),
('19', '30', '', '{001}/{YYYY}', '', '1', '0'),
('20', '32', '', '{001}/{YYYY}', '', '1', '0'),
('21', '35', '', '{001}/{YYYY}', '', '1', '0'),
('22', '40', '', '{001}/{YYYY}', '', '1', '0');

### Structure of table `0_refs` ###

DROP TABLE IF EXISTS `0_refs`;

CREATE TABLE `0_refs` (
  `id` int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_refs` ###

INSERT INTO `0_refs` VALUES
('1', '0', '001/2025'),
('4', '0', '001/2025'),
('2', '0', '002/2025'),
('3', '0', '003/2025'),
('1', '10', '001/2025'),
('2', '10', '001/2025'),
('3', '10', '002/2025'),
('4', '10', '003/2025'),
('5', '10', '004/2025'),
('6', '10', '005/2025'),
('7', '10', '006/2025'),
('8', '10', '007/2025'),
('9', '10', '008/2025'),
('10', '10', '009/2025'),
('1', '12', '001/2025'),
('2', '12', '002/2025'),
('3', '12', '003/2025'),
('4', '12', '004/2025'),
('5', '12', '005/2025'),
('6', '12', '006/2025'),
('7', '12', '007/2025'),
('8', '12', '008/2025'),
('1', '17', '001/2025'),
('2', '17', '001/2025'),
('3', '17', '002/2025'),
('4', '17', '003/2025'),
('5', '17', '003/2025'),
('7', '17', '003/2025'),
('8', '17', '003/2025'),
('11', '17', '003/2025'),
('13', '17', '003/2025'),
('15', '17', '003/2025'),
('6', '17', '004/2025'),
('9', '17', '004/2025'),
('12', '17', '004/2025'),
('14', '17', '004/2025'),
('16', '17', '004/2025'),
('10', '17', '005/2025'),
('17', '17', '005/2025'),
('1', '26', '001/2025'),
('2', '26', '002/2025'),
('3', '26', '003/2025'),
('4', '26', '004/2025'),
('5', '26', '005/2025'),
('6', '26', '006/2025'),
('7', '26', '007/2025'),
('8', '26', '008/2025'),
('1', '28', '001/2025'),
('2', '28', '002/2025'),
('3', '28', '003/2025'),
('4', '28', '004/2025'),
('5', '28', '005/2025'),
('6', '28', '006/2025'),
('7', '28', '007/2025'),
('8', '28', '008/2025'),
('9', '28', '009/2025'),
('10', '28', '010/2025'),
('11', '28', '011/2025'),
('12', '28', '012/2025'),
('13', '28', '013/2025'),
('14', '28', '014/2025'),
('15', '28', '015/2025'),
('16', '28', '016/2025'),
('17', '28', '017/2025'),
('18', '28', '018/2025'),
('1', '29', '001/2025'),
('2', '29', '002/2025'),
('3', '29', '003/2025'),
('4', '29', '004/2025'),
('5', '29', '005/2025'),
('6', '29', '006/2025'),
('7', '29', '007/2025'),
('8', '29', '008/2025'),
('1', '35', '001/2025'),
('2', '35', '002/2025'),
('3', '35', '003/2025');

### Structure of table `0_requisition_details` ###

DROP TABLE IF EXISTS `0_requisition_details`;

CREATE TABLE `0_requisition_details` (
  `requisition_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) DEFAULT NULL,
  `item_code` varchar(20) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `lpo_id` int(11) DEFAULT 0,
  `order_quantity` int(11) NOT NULL DEFAULT 0,
  `estimate_price` double NOT NULL DEFAULT 0,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `price` double NOT NULL DEFAULT 0,
  `purpose` varchar(320) DEFAULT NULL,
  PRIMARY KEY (`requisition_detail_id`),
  KEY `0_requisition_details_requisition_id` (`requisition_id`),
  KEY `0_requisition_details_item_code` (`item_code`),
  KEY `0_requisition_details_supplier_id` (`supplier_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_requisition_details` ###

INSERT INTO `0_requisition_details` VALUES
('1', '1', '78540', '3', '16', '10', '150', '10', '150', 'Purpose '),
('2', '1', '20147', '1', '15', '1', '160', '1', '160', 'Purpose '),
('3', '2', '101', '1', '0', '20', '150', '20', '150', 'test');

### Structure of table `0_requisitions` ###

DROP TABLE IF EXISTS `0_requisitions`;

CREATE TABLE `0_requisitions` (
  `requisition_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) DEFAULT NULL,
  `narrative` varchar(240) DEFAULT NULL,
  `application_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `completed` tinyint(4) NOT NULL DEFAULT 0,
  `processed` tinyint(4) NOT NULL DEFAULT 0,
  `inactive` tinyint(4) NOT NULL DEFAULT 0,
  `details` text DEFAULT NULL,
  PRIMARY KEY (`requisition_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_requisitions` ###

INSERT INTO `0_requisitions` VALUES
('1', 'Point of us', 'Narrative', '2022-05-20 16:04:34', '1', '0', '0', 'Details Details Details Details Details '),
('2', 'TEST', 'ABCD', '2022-05-22 07:25:08', '1', '0', '0', 'test1');

### Structure of table `0_sales_order_details` ###

DROP TABLE IF EXISTS `0_sales_order_details`;

CREATE TABLE `0_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `stk_code` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `qty_sent` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `invoiced` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  `price_type` int(11) NOT NULL DEFAULT 0,
  `price_type_per` varchar(225) NOT NULL DEFAULT '0',
  `list_and_weight` varchar(225) NOT NULL DEFAULT '0',
  `factory_weight` varchar(225) NOT NULL DEFAULT '0',
  `unit_id` varchar(225) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_sales_order_details` ###

INSERT INTO `0_sales_order_details` VALUES
('1', '1', '30', '14581374', '1&quot;1/4 x 1&quot;1/4 20 gauge', '0', '1125', '0', '0', '0', '1', '-7.14', '0', '19', 'Pcs'),
('2', '2', '30', '14581374', '1&quot;1/4 x 1&quot;1/4 20 gauge', '4', '1125.09', '4', '0', '0', '1', '-7.14', '0', '19', 'Pcs'),
('3', '3', '30', '14581450', '1&quot; x 3&quot; 23 gauge', '1800', '1068.43', '1800', '0', '0', '2', '285', '0', '6748', 'Pcs'),
('4', '4', '30', '22197504', '1&quot; x 3&quot; 23 guage 18Ft', '1300', '967.03', '1300', '0', '0', '2', '285', '', '4411', 'KG'),
('5', '4', '30', '14581450', '1&quot; x 3&quot; 23 gauge', '500', '1090.98', '500', '0', '0', '2', '285', '', '1914', 'Pcs'),
('6', '5', '30', '10000086', '3/4&quot; x 3/4&quot; 20 guage', '499', '621.16', '499', '0', '0', '2', '216', '0', '1435', 'Pcs'),
('7', '5', '30', '10000087', '3/4&quot; x 3/4&quot; 18 guage', '500', '878.69', '500', '0', '0', '2', '216', '0', '2034', 'Pcs'),
('8', '5', '30', '10000088', '3/4&quot; x 3/4&quot; 16 guage', '300', '1161.36', '300', '0', '0', '2', '216', '0', '1613', 'Pcs'),
('9', '5', '30', '14581483', '2&quot; x 4&quot; 16 gauge', '200', '4433.4', '200', '0', '0', '2', '216', '0', '4105', 'Pcs'),
('10', '5', '30', '14581438', '1&quot; x 1&quot;1/2 18 gauge', '100', '1473.12', '100', '0', '0', '2', '216', '0', '682', 'Pcs'),
('11', '5', '30', '14581439', '1&quot; x 1&quot;1/2 16 gauge', '100', '2006.64', '100', '0', '0', '2', '216', '0', '929', 'Pcs'),
('12', '5', '30', '14581418', '1/2 x 1&quot; 16 gauge', '100', '1181.52', '100', '0', '0', '2', '216', '0', '547', 'Pcs'),
('13', '6', '30', '14581417', '1/2 x 1&quot; 18 gauge', '300', '915.38', '300', '0', '0', '2', '222', '0', '1237', 'Pcs'),
('14', '6', '30', '10000087', '3/4&quot; x 3/4&quot; 18 guage', '200', '909.09', '200', '0', '0', '2', '222', '0', '819', 'Pcs'),
('15', '6', '30', '14581438', '1&quot; x 1&quot;1/2 18 gauge', '200', '1519.59', '200', '0', '0', '2', '222', '0', '1369', 'Pcs'),
('16', '6', '30', '14581458', '1&quot;1/4 x 2&quot;1/2 18 gauge', '10', '2153.4', '10', '0', '0', '2', '222', '0', '97', 'Pcs'),
('17', '6', '30', '14581483', '2&quot; x 4&quot; 16 gauge', '30', '4536.2', '30', '0', '0', '2', '222', '0', '613', 'Pcs'),
('18', '7', '30', '14581483', '2&quot; x 4&quot; 16 gauge', '0', '4551', '0', '0', '0', '2', '222', '0', '1230', 'Pcs'),
('19', '8', '30', '14581393', '45 x 45 18 gauge', '100', '2205.9', '100', '0', '0', '1', '-10', '0', '996', 'Pcs'),
('20', '8', '30', '14581438', '1&quot; x 1&quot;1/2 18 gauge', '200', '1562.4', '200', '0', '0', '1', '-10', '0', '1433', 'Pcs'),
('21', '8', '30', '14581454', '1&quot; x 3&quot; 18 gauge', '10', '2205.9', '10', '0', '0', '1', '-10', '0', '99', 'Pcs'),
('22', '8', '30', '14581439', '1&quot; x 1&quot;1/2 16 gauge', '150', '2071.8', '150', '0', '0', '1', '-10', '0', '1404', 'Pcs'),
('23', '8', '30', '10000013', '1&quot; round 16 guage', '100', '1222.2', '100', '0', '0', '1', '-10', '0', '545', 'Pcs'),
('24', '8', '30', '10000051', '2&quot;1/4 round 14 guage', '30', '3478', '30', '0', '0', '2', '222', '0', '470', 'Pcs'),
('25', '8', '30', '10000068', '95mm round 14 guage', '80', '5752.58', '80', '0', '0', '2', '222', '0', '2073', 'Pcs'),
('26', '9', '30', '14581483', '2&quot; x 4&quot; 16 gauge', '60', '4551', '60', '0', '0', '2', '222', '0', '1230', 'Pcs'),
('27', '10', '30', '10000094', '1&quot; x 1&quot; 18 guage', '310', '1227.97', '310', '0', '0', '1', '-7', '0', '1575', 'Pcs'),
('28', '10', '30', '14581445', '1&quot; x 2&quot; 18 gauge', '65', '1870.23', '65', '0', '0', '1', '-7', '0', '526', 'Pcs');

### Structure of table `0_sales_orders` ###

DROP TABLE IF EXISTS `0_sales_orders`;

CREATE TABLE `0_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `debtor_no` int(11) NOT NULL DEFAULT 0,
  `branch_code` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) NOT NULL DEFAULT '',
  `customer_ref` tinytext NOT NULL,
  `comments` tinytext DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT 0,
  `ship_via` int(11) NOT NULL DEFAULT 0,
  `delivery_address` tinytext NOT NULL,
  `contact_phone` varchar(30) DEFAULT NULL,
  `contact_email` varchar(100) DEFAULT NULL,
  `deliver_to` tinytext NOT NULL,
  `freight_cost` double NOT NULL DEFAULT 0,
  `from_stk_loc` varchar(5) NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `so_due_date` date NOT NULL DEFAULT '0000-00-00',
  `gross_weight` varchar(225) NOT NULL DEFAULT '0',
  PRIMARY KEY (`trans_type`,`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_sales_orders` ###

INSERT INTO `0_sales_orders` VALUES
('1', '30', '1', '0', '96', '88', 'auto', '', NULL, '2025-06-03', '1', '1', 'Lalukhait', NULL, NULL, 'Azhar Lalukhait', '0', 'DEF', '2025-06-03', '4', '4500', '0', '0', '0000-00-00', ''),
('2', '30', '1', '0', '98', '89', 'auto', '', NULL, '2025-06-03', '1', '1', '(Najeeb Ullah)', NULL, NULL, '(Najeeb Ullah)', '0', 'DEF', '2025-06-03', '4', '4500.36', '0', '0', '0000-00-00', ''),
('3', '30', '1', '0', '99', '90', 'auto', '', NULL, '2025-06-03', '1', '1', 'Bashir Landhi.', NULL, NULL, 'Bashir Landhi.', '0', 'DEF', '2025-06-03', '4', '1923174', '0', '0', '0000-00-00', ''),
('4', '30', '1', '0', '31', '28', 'auto', '', NULL, '2025-06-03', '1', '1', 'Orangi.', NULL, NULL, 'Raja Orangi Riaz', '0', 'DEF', '2025-06-23', '2', '1802629', '0', '0', '0000-00-00', '6325'),
('5', '30', '1', '0', '84', '77', 'auto', '', NULL, '2025-06-03', '1', '1', 'Hyderabad.', '03003057841', NULL, 'Shahid Hyd Pipe Maqbool Tube Well', '0', 'DEF', '2025-06-18', '1', '2450519.84', '0', '0', '0000-00-00', '11345'),
('6', '30', '1', '0', '49', '46', 'auto', '', NULL, '2025-06-03', '1', '1', '', '03330379426', NULL, 'Yasir Shoukat', '0', 'DEF', '2025-06-03', '4', '917970', '0', '0', '0000-00-00', '4135'),
('7', '30', '1', '0', '49', '46', 'auto', '', NULL, '2025-06-03', '1', '1', '', '03330379426', NULL, 'Yasir Shoukat', '0', 'DEF', '2025-06-03', '4', '273060', '0', '0', '0000-00-00', '1230'),
('8', '30', '1', '0', '95', '87', 'auto', '', NULL, '2025-06-03', '1', '1', 'Qaadri Iron', NULL, NULL, 'Qadri Iron', '0', 'DEF', '2025-06-03', '4', '1552665.4', '0', '0', '0000-00-00', '6970'),
('9', '30', '1', '0', '43', '40', 'auto', '', NULL, '2025-06-03', '1', '1', '', NULL, NULL, 'Imran Malir', '0', 'DEF', '2025-06-03', '4', '273060', '0', '0', '0000-00-00', '1230'),
('10', '30', '1', '0', '100', '91', 'auto', '', NULL, '2025-06-03', '1', '1', 'Saima Paari Mall, North Nazimabad, Karachi.', NULL, NULL, 'Saima Paari Jinnah Avenue', '0', 'DEF', '2025-06-03', '4', '502235.65', '0', '0', '0000-00-00', '2101');

### Structure of table `0_sales_pos` ###

DROP TABLE IF EXISTS `0_sales_pos`;

CREATE TABLE `0_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_sales_pos` ###

INSERT INTO `0_sales_pos` VALUES
('1', 'Default', '1', '1', 'DEF', '2', '0');

### Structure of table `0_sales_types` ###

DROP TABLE IF EXISTS `0_sales_types`;

CREATE TABLE `0_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT 0,
  `factor` double NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_sales_types` ###

INSERT INTO `0_sales_types` VALUES
('1', 'Retail', '0', '1', '0'),
('2', 'Wholesale', '0', '0.7', '0');

### Structure of table `0_salesman` ###

DROP TABLE IF EXISTS `0_salesman`;

CREATE TABLE `0_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) NOT NULL DEFAULT '',
  `salesman_phone` char(30) NOT NULL DEFAULT '',
  `salesman_fax` char(30) NOT NULL DEFAULT '',
  `salesman_email` varchar(100) NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT 0,
  `break_pt` double NOT NULL DEFAULT 0,
  `provision2` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_salesman` ###

INSERT INTO `0_salesman` VALUES
('1', 'Sales Person', '', '', '', '5', '1000', '4', '0');

### Structure of table `0_security_roles` ###

DROP TABLE IF EXISTS `0_security_roles`;

CREATE TABLE `0_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) NOT NULL,
  `description` varchar(50) DEFAULT NULL,
  `sections` text DEFAULT NULL,
  `areas` text DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_security_roles` ###

INSERT INTO `0_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132;775', '0'),
('2', 'System Administrator', 'System Administrator', '256;512;768;2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128;287744;418816', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;2817;2818;2824;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;16129;16130;16131;16132;287844;287845;418916;418917', '0'),
('3', 'Salesman', 'Salesman', '768;3072;5632;8192;15872', '773;774;3073;3075;3081;5633;8194;15873;775', '0'),
('4', 'Stock Manager', 'Stock Manager', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '2818;2822;3073;3076;3077;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5640;5889;5890;5891;8193;8194;8450;8451;10753;11009;11010;11012;13313;13315;15882;16129;16130;16131;16132;775', '0'),
('5', 'Production Manager', 'Production Manager', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;2818;2819;2820;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5640;5640;5889;5890;5891;8193;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;2818;2819;2820;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5377;5633;5635;5640;5640;5889;5890;5891;8193;8194;8196;8197;8449;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('8', 'AP Officer', 'AP Officer', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;769;770;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5635;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15873;15874;15876;15877;15878;15879;15880;15882;16129;16130;16131;16132;775', '0'),
('11', 'Trading', 'Trading', '2816;3072;3328;5376;5632;5888;7936;8192;8448;15616;15872;16128;287744', '2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;287844;287845', '0'),
('12', 'ERP', 'ERP', '2816;3072;3328;5376;5632;5888;7936;8192;8448;9216;9472;9728;10496;10752;11008;13056;13312;15616;15872;16128;287744', '2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;287844;287845', '0');

### Structure of table `0_shippers` ###

DROP TABLE IF EXISTS `0_shippers`;

CREATE TABLE `0_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) NOT NULL DEFAULT '',
  `phone` varchar(30) NOT NULL DEFAULT '',
  `phone2` varchar(30) NOT NULL DEFAULT '',
  `contact` tinytext NOT NULL,
  `address` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_shippers` ###

INSERT INTO `0_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `0_sql_trail` ###

DROP TABLE IF EXISTS `0_sql_trail`;

CREATE TABLE `0_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_sql_trail` ###


### Structure of table `0_stock_category` ###

DROP TABLE IF EXISTS `0_stock_category`;

CREATE TABLE `0_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `dflt_tax_type` int(11) NOT NULL DEFAULT 1,
  `dflt_units` varchar(20) NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_stock_category` ###

INSERT INTO `0_stock_category` VALUES
('1', 'Semi/Finish Good ', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('7', 'Raw Material', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('8', 'Slit', '1', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('9', 'Westage', '1', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('10', 'Finish', '1', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0');

### Structure of table `0_stock_fa_class` ###

DROP TABLE IF EXISTS `0_stock_fa_class`;

CREATE TABLE `0_stock_fa_class` (
  `fa_class_id` varchar(20) NOT NULL DEFAULT '',
  `parent_id` varchar(20) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `long_description` tinytext NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_stock_fa_class` ###

INSERT INTO `0_stock_fa_class` VALUES
('001', '01', 'Equipment', 'Equipment', '10', '0');

### Structure of table `0_stock_master` ###

DROP TABLE IF EXISTS `0_stock_master`;

CREATE TABLE `0_stock_master` (
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `description` varchar(200) NOT NULL DEFAULT '',
  `long_description` tinytext NOT NULL,
  `units` varchar(20) NOT NULL DEFAULT 'each',
  `mb_flag` char(1) NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) NOT NULL DEFAULT '',
  `cogs_account` varchar(15) NOT NULL DEFAULT '',
  `inventory_account` varchar(15) NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) NOT NULL DEFAULT '',
  `wip_account` varchar(15) NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT 0,
  `material_cost` double NOT NULL DEFAULT 0,
  `labour_cost` double NOT NULL DEFAULT 0,
  `overhead_cost` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  `editable` tinyint(1) NOT NULL DEFAULT 0,
  `depreciation_method` char(1) NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `depreciation_factor` double NOT NULL DEFAULT 1,
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) NOT NULL DEFAULT '',
  `default_weight` varchar(225) NOT NULL DEFAULT '0',
  `serial_stock_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_stock_master` ###

INSERT INTO `0_stock_master` VALUES
('00000010', '10', '1', 'Finish Good', '1&quot;7/8 Round 5 Kg 21.ft', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '', NULL),
('10000001', '10', '1', '5/8 round 23 guage', '5/8 round 23 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000001'),
('10000002', '10', '1', '5/8 round 22 guage', '5/8 round 22 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000002'),
('10000003', '10', '1', '5/8 round 21 guage', '5/8 round 21 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000003'),
('10000004', '10', '1', '5/8 round 20 guage', '5/8 round 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '500.4', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000004'),
('10000005', '10', '1', '5/8 round 18 guage', '5/8 round 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '640', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000005'),
('10000006', '10', '1', '5/8 round 16 guage', '5/8 round 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000006'),
('10000007', '10', '1', '5/8 round 14 guage', '5/8 round 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000007'),
('10000008', '10', '1', '1&quot; round 23 guage', '1&quot; round 23 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000008'),
('10000009', '10', '1', '1&quot; round 22 guage', '1&quot; round 22 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000009'),
('10000010', '10', '1', '1&quot; round 21 guage', '1&quot; round 21 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000010'),
('10000011', '10', '1', '1&quot; round 20 guage', '1&quot; round 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000011'),
('10000012', '10', '1', '1&quot; round 18 guage', '1&quot; round 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000012'),
('10000013', '10', '1', '1&quot; round 16 guage', '1&quot; round 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1358', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000013'),
('10000014', '10', '1', '1&quot; round 14 guage', '1&quot; round 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000014'),
('10000015', '10', '1', '1&quot;1/4 round 23 guage', '1&quot;1/4 round 23 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '800', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000015'),
('10000016', '10', '1', '1&quot;1/4 round 22 guage', '1&quot;1/4 round 22 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000016'),
('10000017', '10', '1', '1&quot;1/4 round 21 guage', '1&quot;1/4 round 21 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000017'),
('10000018', '10', '1', '1&quot;1/4 round 20 guage', '1&quot;1/4 round 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000018'),
('10000019', '10', '1', '1&quot;1/4 round 18 guage', '1&quot;1/4 round 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000019'),
('10000020', '10', '1', '1&quot;1/4 round 16 guage', '1&quot;1/4 round 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000020'),
('10000021', '10', '1', '1&quot;1/4 round 14 guage', '1&quot;1/4 round 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000021'),
('10000022', '10', '1', '1&quot;1/2 round 23 guage', '1&quot;1/2 round 23 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000022'),
('10000023', '10', '1', '1&quot;1/2 round 22 guage', '1&quot;1/2 round 22 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000023'),
('10000024', '10', '1', '1&quot;1/2 round 21 guage', '1&quot;1/2 round 21 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000024'),
('10000025', '10', '1', '1&quot;1/2 round 20 guage', '1&quot;1/2 round 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000025'),
('10000026', '10', '1', '1&quot;1/2 round 18 guage', '1&quot;1/2 round 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000026'),
('10000027', '10', '1', '1&quot;1/2 round 16 guage', '1&quot;1/2 round 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000027'),
('10000028', '10', '1', '1&quot;1/2 round 14 guage', '1&quot;1/2 round 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000028'),
('10000029', '10', '1', '1&quot; 5/8 round 20 guage', '1&quot; 5/8 round 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000029'),
('10000030', '10', '1', '1&quot; 5/8 round 18 guage', '1&quot; 5/8 round 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000030'),
('10000031', '10', '1', '1&quot; 5/8 round 16 guage', '1&quot; 5/8 round 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000031'),
('10000032', '10', '1', '1&quot; 7/8 round 23 guage', '1&quot; 7/8 round 23 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000032'),
('10000033', '10', '1', '1&quot; 7/8 round 22 guage', '1&quot; 7/8 round 22 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000033'),
('10000034', '10', '1', '1&quot; 7/8 round 21 guage', '1&quot; 7/8 round 21 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1395.6', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000034'),
('10000035', '10', '1', '1&quot; 7/8 round 20 guage', '1&quot; 7/8 round 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000035'),
('10000036', '10', '1', '1&quot; 7/8 round 18 guage', '1&quot; 7/8 round 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000036'),
('10000037', '10', '1', '1&quot; 7/8 round 16 guage', '1&quot; 7/8 round 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000037'),
('10000038', '10', '1', '1&quot; 7/8 round 14 guage', '1&quot; 7/8 round 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000038'),
('10000039', '10', '1', '1&quot; 7/8 round 12 guage', '1&quot; 7/8 round 12 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000039'),
('10000040', '10', '1', '1&quot; 7/8 round 10 guage', '1&quot; 7/8 round 10 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000040'),
('10000041', '10', '1', '1&quot; 7/8 round 5.4 kg 21ft', '1&quot; 7/8 round 5.4 kg 21ft', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1080', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000041'),
('10000042', '10', '1', '1&quot; 7/8 round 9.8 kg 21ft', '1&quot; 7/8 round 9.8 kg 21ft', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000042'),
('10000043', '10', '1', '1&quot; 7/8 round 4 kg 21ft', '1&quot; 7/8 round 4 kg 21ft', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000043'),
('10000044', '10', '1', '1&quot; 7/8 round 4.8 kg 21ft', '1&quot; 7/8 round 4.8 kg 21ft', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000044'),
('10000045', '10', '1', '2&quot;1/4 round 23 guage', '2&quot;1/4 round 23 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000045'),
('10000046', '10', '1', '2&quot;1/4 round 22 guage', '2&quot;1/4 round 22 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1483.4', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000046'),
('10000047', '10', '1', '2&quot;1/4 round 21 guage', '2&quot;1/4 round 21 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000047'),
('10000048', '10', '1', '2&quot;1/4 round 20 guage', '2&quot;1/4 round 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000048'),
('10000049', '10', '1', '2&quot;1/4 round 18 guage', '2&quot;1/4 round 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000049'),
('10000050', '10', '1', '2&quot;1/4 round 16 guage', '2&quot;1/4 round 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000050'),
('10000051', '10', '1', '2&quot;1/4 round 14 guage', '2&quot;1/4 round 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3200', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000051'),
('10000052', '10', '1', '2&quot;1/4 round 5.5 kg 21ft', '2&quot;1/4 round 5.5 kg 21ft', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000052'),
('10000053', '10', '1', '2&quot;7/8 round 20 guage', '2&quot;7/8 round 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000053'),
('10000054', '10', '1', '2&quot;7/8 round 18 guage', '2&quot;7/8 round 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000054'),
('10000055', '10', '1', '2&quot;7/8 round 16 guage', '2&quot;7/8 round 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3350', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000055'),
('10000056', '10', '1', '2&quot;7/8 round 14 guage', '2&quot;7/8 round 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000056'),
('10000057', '10', '1', '2&quot;7/8 round 12 guage', '2&quot;7/8 round 12 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000057'),
('10000058', '10', '1', '2&quot;7/8 round 10 guage', '2&quot;7/8 round 10 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000058'),
('10000059', '10', '1', '87mm round 20 guage', '87mm round 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000059'),
('10000060', '10', '1', '87mm round 18 guage', '87mm round 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '4037', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000060'),
('10000061', '10', '1', '87mm round 16 guage', '87mm round 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000061'),
('10000062', '10', '1', '87mm round 14 guage', '87mm round 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000062'),
('10000063', '10', '1', '87mm round 12 guage', '87mm round 12 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000063'),
('10000064', '10', '1', '87mm round 10 guage', '87mm round 10 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000064'),
('10000065', '10', '1', '95mm round 20 guage', '95mm round 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000065'),
('10000066', '10', '1', '95mm round 18 guage', '95mm round 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000066'),
('10000067', '10', '1', '95mm round 16 guage', '95mm round 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '5746', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000067'),
('10000068', '10', '1', '95mm round 14 guage', '95mm round 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '5200', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000068'),
('10000069', '10', '1', '95mm round 12 guage', '95mm round 12 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000069'),
('10000070', '10', '1', '95mm round 10 guage', '95mm round 10 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000070'),
('10000071', '10', '1', '113mm round 18 guage', '113mm round 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000071'),
('10000072', '10', '1', '113mm round 16 guage', '113mm round 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000072'),
('10000073', '10', '1', '113mm round 14 guage', '113mm round 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000073'),
('10000074', '10', '1', '113mm round 12 guage', '113mm round 12 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000074'),
('10000075', '10', '1', '113mm round 10 guage', '113mm round 10 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000075'),
('10000076', '10', '1', '1/2&quot; x 1/2&quot; 23 guage', '1/2&quot; x 1/2&quot; 23 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000076'),
('10000077', '10', '1', '1/2&quot; x 1/2&quot; 22 guage', '1/2&quot; x 1/2&quot; 22 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000077'),
('10000078', '10', '1', '1/2&quot; x 1/2&quot; 21 guage', '1/2&quot; x 1/2&quot; 21 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000078'),
('10000079', '10', '1', '1/2&quot; x 1/2&quot; 20 guage', '1/2&quot; x 1/2&quot; 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000079'),
('10000080', '10', '1', '1/2&quot; x 1/2&quot; 18 guage', '1/2&quot; x 1/2&quot; 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000080'),
('10000081', '10', '1', '1/2&quot; x 1/2&quot; 16 guage', '1/2&quot; x 1/2&quot; 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000081'),
('10000082', '10', '1', '1/2&quot; x 1/2&quot; 14 guage', '1/2&quot; x 1/2&quot; 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000082'),
('10000083', '10', '1', '3/4&quot; x 3/4&quot; 23 guage', '3/4&quot; x 3/4&quot; 23 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000083'),
('10000084', '10', '1', '3/4&quot; x 3/4&quot; 22 guage', '3/4&quot; x 3/4&quot; 22 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000084'),
('10000085', '10', '1', '3/4&quot; x 3/4&quot; 21 guage', '3/4&quot; x 3/4&quot; 21 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '721.2', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000085'),
('10000086', '10', '1', '3/4&quot; x 3/4&quot; 20 guage', '3/4&quot; x 3/4&quot; 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '769.2', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000086'),
('10000087', '10', '1', '3/4&quot; x 3/4&quot; 18 guage', '3/4&quot; x 3/4&quot; 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1048.2', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000087'),
('10000088', '10', '1', '3/4&quot; x 3/4&quot; 16 guage', '3/4&quot; x 3/4&quot; 16 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '976.49', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000088'),
('10000089', '10', '1', '3/4&quot; x 3/4&quot; 14 guage', '3/4&quot; x 3/4&quot; 14 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000089'),
('10000090', '10', '1', '1&quot; x 1&quot; 23 guage', '1&quot; x 1&quot; 23 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000090'),
('10000091', '10', '1', '1&quot; x 1&quot; 22 guage', '1&quot; x 1&quot; 22 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000091'),
('10000092', '10', '1', '1&quot; x 1&quot; 21 guage', '1&quot; x 1&quot; 21 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000092'),
('10000093', '10', '1', '1&quot; x 1&quot; 20 guage', '1&quot; x 1&quot; 20 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '10000093'),
('10000094', '10', '1', '1&quot; x 1&quot; 18 guage', '1&quot; x 1&quot; 18 guage', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '10000094'),
('12625871', '10', '1', '2&quot; x 4&quot; 33.5KG 17 Ft.', '2&quot; x 4&quot; 33.5KG 17 Ft.', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '7035', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '33.5', NULL),
('14581371', '10', '1', '1&quot;1/4 x 1&quot;1/4 23 gauge', '1&quot;1/4 x 1&quot;1/4 23 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '844', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581371'),
('14581372', '10', '1', '1&quot;1/4 x 1&quot;1/4 22 gauge', '1&quot;1/4 x 1&quot;1/4 22 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581372'),
('14581373', '10', '1', '1&quot;1/4 x 1&quot;1/4 21 gauge', '1&quot;1/4 x 1&quot;1/4 21 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '860', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581373'),
('14581374', '10', '1', '1&quot;1/4 x 1&quot;1/4 20 gauge', '1&quot;1/4 x 1&quot;1/4 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '960', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581374'),
('14581375', '10', '1', '1&quot;1/4 x 1&quot;1/4 18 gauge', '1&quot;1/4 x 1&quot;1/4 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581375'),
('14581376', '10', '1', '1&quot;1/4 x 1&quot;1/4 16 gauge', '1&quot;1/4 x 1&quot;1/4 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581376'),
('14581377', '10', '1', '1&quot;1/4 x 1&quot;1/4 14 gauge', '1&quot;1/4 x 1&quot;1/4 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581377'),
('14581378', '10', '1', '1&quot;1/4 x 1&quot;1/4 12 gauge', '1&quot;1/4 x 1&quot;1/4 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581378'),
('14581379', '10', '1', '1&quot;1/4 x 1&quot;1/4 10 gauge', '1&quot;1/4 x 1&quot;1/4 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581379'),
('14581380', '10', '1', '1&quot;1/2 x 1&quot;1/2 23 gauge', '1&quot;1/2 x 1&quot;1/2 23 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581380'),
('14581381', '10', '1', '1&quot;1/2 x 1&quot;1/2 22 gauge', '1&quot;1/2 x 1&quot;1/2 22 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581381'),
('14581382', '10', '1', '1&quot;1/2 x 1&quot;1/2 21 gauge', '1&quot;1/2 x 1&quot;1/2 21 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581382'),
('14581383', '10', '1', '1&quot;1/2 x 1&quot;1/2 20 gauge', '1&quot;1/2 x 1&quot;1/2 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1220', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581383'),
('14581384', '10', '1', '1&quot;1/2 x 1&quot;1/2 18 gauge', '1&quot;1/2 x 1&quot;1/2 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581384'),
('14581385', '10', '1', '1&quot;1/2 x 1&quot;1/2 16 gauge', '1&quot;1/2 x 1&quot;1/2 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2150', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581385'),
('14581386', '10', '1', '1&quot;1/2 x 1&quot;1/2 14 gauge', '1&quot;1/2 x 1&quot;1/2 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581386'),
('14581387', '10', '1', '1&quot;1/2 x 1&quot;1/2 12 gauge', '1&quot;1/2 x 1&quot;1/2 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581387'),
('14581388', '10', '1', '1&quot;1/2 x 1&quot;1/2 10 gauge', '1&quot;1/2 x 1&quot;1/2 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581388'),
('14581389', '10', '1', '45 x 45 23 gauge', '45 x 45 23 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581389'),
('14581390', '10', '1', '45 x 45 22 gauge', '45 x 45 22 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581390'),
('14581391', '10', '1', '45 x 45 21 gauge', '45 x 45 21 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581391'),
('14581392', '10', '1', '45 x 45 20 gauge', '45 x 45 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1480', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581392'),
('14581393', '10', '1', '45 x 45 18 gauge', '45 x 45 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1960', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581393'),
('14581394', '10', '1', '45 x 45 16 gauge', '45 x 45 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2600', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581394'),
('14581395', '10', '1', '45 x 45 14 gauge', '45 x 45 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3200', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581395'),
('14581396', '10', '1', '45 x 45 12 gauge', '45 x 45 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581396'),
('14581397', '10', '1', '45 x 45 10 gauge', '45 x 45 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581397'),
('14581398', '10', '1', '50 x 50 23 gauge', '50 x 50 23 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581398'),
('14581399', '10', '1', '50 x 50 22 gauge', '50 x 50 22 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581399'),
('14581400', '10', '1', '50 x 50 21 gauge', '50 x 50 21 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581400'),
('14581401', '10', '1', '50 x 50 20 gauge', '50 x 50 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581401'),
('14581402', '10', '1', '50 x 50 18 gauge', '50 x 50 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581402'),
('14581403', '10', '1', '50 x 50 16 gauge', '50 x 50 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581403'),
('14581404', '10', '1', '50 x 50 14 gauge', '50 x 50 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581404'),
('14581405', '10', '1', '50 x 50 12 gauge', '50 x 50 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581405'),
('14581406', '10', '1', '50 x 50 10 gauge', '50 x 50 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581406'),
('14581407', '10', '1', '3&quot; x 3&quot; 20 gauge', '3&quot; x 3&quot; 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581407'),
('14581408', '10', '1', '3&quot; x 3&quot; 18 gauge', '3&quot; x 3&quot; 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581408'),
('14581409', '10', '1', '3&quot; x 3&quot; 16 gauge', '3&quot; x 3&quot; 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581409'),
('14581410', '10', '1', '3&quot; x 3&quot; 14 gauge', '3&quot; x 3&quot; 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '5460', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581410'),
('14581411', '10', '1', '3&quot; x 3&quot; 12 gauge', '3&quot; x 3&quot; 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581411'),
('14581412', '10', '1', '3&quot; x 3&quot; 10 gauge', '3&quot; x 3&quot; 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581412'),
('14581413', '10', '1', '1/2 x 1&quot; 23 gauge', '1/2 x 1&quot; 23 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581413'),
('14581414', '10', '1', '1/2 x 1&quot; 22 gauge', '1/2 x 1&quot; 22 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581414'),
('14581415', '10', '1', '1/2 x 1&quot; 21 gauge', '1/2 x 1&quot; 21 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581415'),
('14581416', '10', '1', '1/2 x 1&quot; 20 gauge', '1/2 x 1&quot; 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '769.2', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581416'),
('14581417', '10', '1', '1/2 x 1&quot; 18 gauge', '1/2 x 1&quot; 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1048.2', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581417'),
('14581418', '10', '1', '1/2 x 1&quot; 16 gauge', '1/2 x 1&quot; 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1358', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581418'),
('14581419', '10', '1', '1/2 x 1&quot; 14 gauge', '1/2 x 1&quot; 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581419'),
('14581420', '10', '1', '1/2 x 1&quot;1/2 23 gauge', '1/2 x 1&quot;1/2 23 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581420'),
('14581421', '10', '1', '1/2 x 1&quot;1/2 22 gauge', '1/2 x 1&quot;1/2 22 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581421'),
('14581422', '10', '1', '1/2 x 1&quot;1/2 21 gauge', '1/2 x 1&quot;1/2 21 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581422'),
('14581423', '10', '1', '1/2 x 1&quot;1/2 20 gauge', '1/2 x 1&quot;1/2 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '800', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581423'),
('14581424', '10', '1', '1/2 x 1&quot;1/2 18 gauge', '1/2 x 1&quot;1/2 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581424'),
('14581425', '10', '1', '1/2 x 1&quot;1/2 16 gauge', '1/2 x 1&quot;1/2 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581425'),
('14581426', '10', '1', '1/2 x 1&quot;1/2 14 gauge', '1/2 x 1&quot;1/2 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581426'),
('14581427', '10', '1', '3/4 x 1&quot;1/2 23 gauge', '3/4 x 1&quot;1/2 23 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581427'),
('14581428', '10', '1', '3/4 x 1&quot;1/2 22 gauge', '3/4 x 1&quot;1/2 22 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581428'),
('14581429', '10', '1', '3/4 x 1&quot;1/2 21 gauge', '3/4 x 1&quot;1/2 21 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581429'),
('14581430', '10', '1', '3/4 x 1&quot;1/2 20 gauge', '3/4 x 1&quot;1/2 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581430'),
('14581431', '10', '1', '3/4 x 1&quot;1/2 18 gauge', '3/4 x 1&quot;1/2 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581431'),
('14581432', '10', '1', '3/4 x 1&quot;1/2 16 gauge', '3/4 x 1&quot;1/2 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581432'),
('14581433', '10', '1', '3/4 x 1&quot;1/2 14 gauge', '3/4 x 1&quot;1/2 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581433'),
('14581434', '10', '1', '1&quot; x 1&quot;1/2 23 gauge', '1&quot; x 1&quot;1/2 23 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581434'),
('14581435', '10', '1', '1&quot; x 1&quot;1/2 22 gauge', '1&quot; x 1&quot;1/2 22 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '800', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581435'),
('14581436', '10', '1', '1&quot; x 1&quot;1/2 21 gauge', '1&quot; x 1&quot;1/2 21 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581436'),
('14581437', '10', '1', '1&quot; x 1&quot;1/2 20 gauge', '1&quot; x 1&quot;1/2 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581437'),
('14581438', '10', '1', '1&quot; x 1&quot;1/2 18 gauge', '1&quot; x 1&quot;1/2 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581438'),
('14581439', '10', '1', '1&quot; x 1&quot;1/2 16 gauge', '1&quot; x 1&quot;1/2 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581439'),
('14581440', '10', '1', '1&quot; x 1&quot;1/2 14 gauge', '1&quot; x 1&quot;1/2 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581440'),
('14581441', '10', '1', '1&quot; x 2&quot; 23 gauge', '1&quot; x 2&quot; 23 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581441'),
('14581442', '10', '1', '1&quot; x 2&quot; 22 gauge', '1&quot; x 2&quot; 22 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581442'),
('14581443', '10', '1', '1&quot; x 2&quot; 21 gauge', '1&quot; x 2&quot; 21 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581443'),
('14581444', '10', '1', '1&quot; x 2&quot; 20 gauge', '1&quot; x 2&quot; 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1220', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581444'),
('14581445', '10', '1', '1&quot; x 2&quot; 18 gauge', '1&quot; x 2&quot; 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581445'),
('14581446', '10', '1', '1&quot; x 2&quot; 16 gauge', '1&quot; x 2&quot; 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581446'),
('14581447', '10', '1', '1&quot; x 2&quot; 14 gauge', '1&quot; x 2&quot; 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581447'),
('14581448', '10', '1', '1&quot; x 2&quot; 12 gauge', '1&quot; x 2&quot; 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581448'),
('14581449', '10', '1', '1&quot; x 2&quot; 10 gauge', '1&quot; x 2&quot; 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581449'),
('14581450', '10', '1', '1&quot; x 3&quot; 23 gauge', '1&quot; x 3&quot; 23 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '950', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581450'),
('14581451', '10', '1', '1&quot; x 3&quot; 22 gauge', '1&quot; x 3&quot; 22 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581451'),
('14581452', '10', '1', '1&quot; x 3&quot; 21 gauge', '1&quot; x 3&quot; 21 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581452'),
('14581453', '10', '1', '1&quot; x 3&quot; 20 gauge', '1&quot; x 3&quot; 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581453'),
('14581454', '10', '1', '1&quot; x 3&quot; 18 gauge', '1&quot; x 3&quot; 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1960', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581454'),
('14581455', '10', '1', '1&quot; x 3&quot; 16 gauge', '1&quot; x 3&quot; 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2600', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581455'),
('14581456', '10', '1', '1&quot; x 3&quot; 14 gauge', '1&quot; x 3&quot; 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581456'),
('14581457', '10', '1', '1&quot;1/4 x 2&quot;1/2 20 gauge', '1&quot;1/4 x 2&quot;1/2 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581457'),
('14581458', '10', '1', '1&quot;1/4 x 2&quot;1/2 18 gauge', '1&quot;1/4 x 2&quot;1/2 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1960', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581458'),
('14581459', '10', '1', '1&quot;1/4 x 2&quot;1/2 16 gauge', '1&quot;1/4 x 2&quot;1/2 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2600', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581459'),
('14581460', '10', '1', '1&quot;1/4 x 2&quot;1/2 14 gauge', '1&quot;1/4 x 2&quot;1/2 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3200', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581460'),
('14581461', '10', '1', '1&quot;1/4 x 2&quot;1/2 12 gauge', '1&quot;1/4 x 2&quot;1/2 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581461'),
('14581462', '10', '1', '1&quot;1/4 x 2&quot;1/2 10 gauge', '1&quot;1/4 x 2&quot;1/2 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581462'),
('14581463', '10', '1', '1&quot; x 4&quot; 20 gauge', '1&quot; x 4&quot; 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581463'),
('14581464', '10', '1', '1&quot; x 4&quot; 18 gauge', '1&quot; x 4&quot; 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581464'),
('14581465', '10', '1', '1&quot; x 4&quot; 16 gauge', '1&quot; x 4&quot; 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581465'),
('14581466', '10', '1', '1&quot; x 4&quot; 14 gauge', '1&quot; x 4&quot; 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581466'),
('14581467', '10', '1', '1&quot; x 4&quot; 12 gauge', '1&quot; x 4&quot; 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581467'),
('14581468', '10', '1', '1&quot; x 4&quot; 10 gauge', '1&quot; x 4&quot; 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581468'),
('14581469', '10', '1', '1&quot;1/2 x 3&quot; 20 gauge', '1&quot;1/2 x 3&quot; 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581469'),
('14581470', '10', '1', '1&quot;1/2 x 3&quot; 18 gauge', '1&quot;1/2 x 3&quot; 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2520', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581470'),
('14581471', '10', '1', '1&quot;1/2 x 3&quot; 16 gauge', '1&quot;1/2 x 3&quot; 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '3350', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581471'),
('14581472', '10', '1', '1&quot;1/2 x 3&quot; 14 gauge', '1&quot;1/2 x 3&quot; 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '4200', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581472'),
('14581473', '10', '1', '1&quot;1/2 x 3&quot; 12 gauge', '1&quot;1/2 x 3&quot; 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581473'),
('14581474', '10', '1', '1&quot;1/2 x 3&quot; 10 gauge', '1&quot;1/2 x 3&quot; 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581474'),
('14581475', '10', '1', '1&quot;1/2 x 4&quot; 20 gauge', '1&quot;1/2 x 4&quot; 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581475');
INSERT INTO `0_stock_master` VALUES
('14581476', '10', '1', '1&quot;1/2 x 4&quot; 18 gauge', '1&quot;1/2 x 4&quot; 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581476'),
('14581477', '10', '1', '1&quot;1/2 x 4&quot; 16 gauge', '1&quot;1/2 x 4&quot; 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581477'),
('14581478', '10', '1', '1&quot;1/2 x 4&quot; 14 gauge', '1&quot;1/2 x 4&quot; 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581478'),
('14581479', '10', '1', '1&quot;1/2 x 4&quot; 12 gauge', '1&quot;1/2 x 4&quot; 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581479'),
('14581480', '10', '1', '1&quot;1/2 x 4&quot; 10 gauge', '1&quot;1/2 x 4&quot; 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581480'),
('14581481', '10', '1', '2&quot; x 4&quot; 20 gauge', '2&quot; x 4&quot; 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581481'),
('14581482', '10', '1', '2&quot; x 4&quot; 18 gauge', '2&quot; x 4&quot; 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581482'),
('14581483', '10', '1', '2&quot; x 4&quot; 16 gauge', '2&quot; x 4&quot; 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '5746', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581483'),
('14581484', '10', '1', '2&quot; x 4&quot; 14 gauge', '2&quot; x 4&quot; 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '5460', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581484'),
('14581485', '10', '1', '2&quot; x 4&quot; 12 gauge', '2&quot; x 4&quot; 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581485'),
('14581486', '10', '1', '2&quot; x 4&quot; 10 gauge', '2&quot; x 4&quot; 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '6800', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581486'),
('14581487', '10', '1', '2&quot; x 5&quot; 20 gauge', '2&quot; x 5&quot; 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581487'),
('14581488', '10', '1', '2&quot; x 5&quot; 18 gauge', '2&quot; x 5&quot; 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581488'),
('14581489', '10', '1', '2&quot; x 5&quot; 16 gauge', '2&quot; x 5&quot; 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581489'),
('14581490', '10', '1', '2&quot; x 5&quot; 14 gauge', '2&quot; x 5&quot; 14 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581490'),
('14581491', '10', '1', '2&quot; x 5&quot; 12 gauge', '2&quot; x 5&quot; 12 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581491'),
('14581492', '10', '1', '2&quot; x 5&quot; 10 gauge', '2&quot; x 5&quot; 10 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581492'),
('14581493', '10', '1', 'D SADA 20 gauge', 'D SADA 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581493'),
('14581494', '10', '1', 'D SADA 18 gauge', 'D SADA 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581494'),
('14581495', '10', '1', 'D SADA 16 gauge', 'D SADA 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581495'),
('14581496', '10', '1', 'D JUMBO 20 gauge', 'D JUMBO 20 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581496'),
('14581497', '10', '1', 'D JUMBO 18 gauge', 'D JUMBO 18 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581497'),
('14581498', '10', '1', 'D JUMBO 16 gauge', 'D JUMBO 16 gauge', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', 'S', '0', '1', '0000-00-00', '0000-00-00', '', '0', '14581498'),
('14653407', '1', '1', '2&quot; 1/4 Round 23.G 21 Ft.', '', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('22197504', '10', '1', '1&quot; x 3&quot; 23 guage 18Ft', '1&quot; x 3&quot; 23 guage 18Ft', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('24616744', '1', '1', 'HR 97 MM', 'HR 97 MM', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '168.70310391363', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '24616744'),
('27003244', '1', '1', 'HR 117 MM', 'HR 117 MM', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '228.85562049248', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '27003244'),
('28488323', '9', '1', 'Weight Diffrence', 'Weight Diffrence', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '28488323'),
('29121137', '1', '1', 'HR 197 MM', 'HR 197 MM', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '29121137'),
('32476125', '10', '1', '2&quot; 1/4 Round 4KG 21 Ft.', '2&quot; 1/4 Round 4KG 21 Ft.', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1297', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('32641899', '10', '1', '1&quot;7/8 5.Kg 21.ft', '1&quot;7/8 5.Kg 21.ft', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1000', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '', NULL),
('32910179', '10', '1', '95 MM 20 KG', '95 MM 20 KG', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '20', NULL),
('33010403', '1', '1', 'HR 77 MM', 'HR 77 MM', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '183', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '33010403'),
('35147091', '10', '1', '1&quot; x 3&quot; 4.00 kg', '1&quot; x 3&quot; 4.00 kg', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '35147091'),
('37277987', '7', '1', 'Hr strips', 'Hr strips', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '37277987'),
('37613624', '1', '1', 'HR  231 MM', 'HR  231 MM', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('38001291', '1', '1', 'HR 147 MM', 'HR 147 MM', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '99.417733990148', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '38001291'),
('38632044', '1', '1', 'HR 48 MM', 'HR 48 MM', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('39858313', '9', '1', 'Sheet Tukra', 'Sheet Tukra', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '100', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '39858313'),
('43317004', '10', '1', '2 1/2 x  2 1/2 18 Gauge', '2 1/2 x  2 1/2 18 Gauge', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('46115744', '10', '1', '2&quot; 1/4 Round 4.KG 21 Ft.', '2&quot; 1/4 Round 4.KG 21 Ft.', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1297', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '4', NULL),
('47221925', '7', '1', 'CR Coil', 'CR Coil', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '47221925'),
('49858495', '10', '1', '2&#039;&#039;1/2 x 2&#039;&#039;1/2 18 guage ', '2&#039;&#039;1/2 x 2&#039;&#039;1/2 18 guage ', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('50143139', '10', '1', '2 1/2   18 Gauge', '2 1/2   18 Gauge', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('50196340', '1', '1', 'Production', 'Production', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '50196340'),
('51875008', '1', '1', 'HR 257 MM', 'HR 257 MM', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '51875008'),
('53186355', '9', '1', 'B Pipe', 'B Pipe', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '100', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '53186355'),
('56876383', '10', '1', '1&quot; x 3&quot; 3.80 kg', '1&quot; x 3&quot; 3.80 kg', 'Pcs', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '56876383'),
('57781471', '1', '1', 'HR 177 MM', 'HR 177 MM', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '57781471'),
('57921181', '1', '1', 'HR 227 MM', 'HR 227 MM', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '41.743040157674', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '57921181'),
('60487735', '7', '1', 'HR Coil', 'HR Coil', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '182', '184', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '60487735'),
('62064910', '9', '1', 'Side Cutting', 'Side Cutting', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '62064910'),
('68279509', '10', '1', '1&quot; 5/8 Round 9.35KG 21 Ft', '1&quot; 5/8 Round 9.35KG 21 Ft', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '2417', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '9.35', NULL),
('69839917', '10', '1', '95mm round 24 KG', '', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('71846835', '1', '1', 'HR 272 MM', 'HR 272 MM', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '71846835'),
('77615985', '9', '1', 'Patra', 'Patra', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '90', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '77615985'),
('82239695', '1', '1', 'HR 295 MM', 'HR 295 MM', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '183', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '82239695'),
('82995317', '10', '1', '2 1/2 x  2 1/2 16 Gauge', '2 1/2 x  2 1/2 16 Gauge', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('83895982', '1', '1', 'HR 127 MM', 'HR 127 MM', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '183', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '83895982'),
('83980428', '1', '1', 'HR 354 MM', 'HR 354 MM', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '110', '110', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('89871836', '10', '1', '95mm round 20 KG', '', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '4200', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', NULL),
('90538834', '10', '1', '1&quot; x 1&quot; 16 guage', '1&quot; x 1&quot; 16 guage', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '10000095'),
('91000026', '9', '1', 'Burada', 'Burada', 'KG', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '120', '0', '0', '0', '0', '1', '0', '', '0', '0', '0000-00-00', '0000-00-00', '', '0', '91000026');

### Structure of table `0_stock_moves` ###

DROP TABLE IF EXISTS `0_stock_moves`;

CREATE TABLE `0_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `batch_no` varchar(30) NOT NULL,
  `exp_date` date NOT NULL,
  `type` smallint(6) NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `price` double NOT NULL DEFAULT 0,
  `reference` char(40) NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT 1,
  `standard_cost` double NOT NULL DEFAULT 0,
  `thickness` varchar(225) NOT NULL,
  `width` varchar(225) NOT NULL,
  `unit_id` varchar(225) NOT NULL,
  `bundle` varchar(100) NOT NULL DEFAULT '0',
  `weight` varchar(100) NOT NULL DEFAULT '0',
  `length` varchar(100) NOT NULL DEFAULT '0',
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=222 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_stock_moves` ###

INSERT INTO `0_stock_moves` VALUES
('4', '2', '14581371', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '95.5', '844', '0', '0', 'Pcs', '1', '296.05', '20'),
('5', '2', '14581371', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '95.5', '844', '0', '0', 'Pcs', '1', '296.05', '20'),
('6', '2', '14581435', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '63.5', '800', '0', '0', 'Pcs', '1', '254', '20'),
('7', '2', '14581435', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '63.5', '800', '0', '0', 'Pcs', '1', '254', '20'),
('8', '2', '10000085', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '90.4', '721.2', '0', '0', 'Pcs', '1', '253.12', '20'),
('9', '2', '10000085', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '90.4', '721.2', '0', '0', 'Pcs', '1', '253.12', '20'),
('10', '2', '10000085', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '90.4', '721.2', '0', '0', 'Pcs', '1', '253.12', '20'),
('11', '2', '10000085', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '90.4', '721.2', '0', '0', 'Pcs', '1', '253.12', '20'),
('12', '2', '10000085', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '90.4', '721.2', '0', '0', 'Pcs', '1', '253.12', '20'),
('13', '2', '14581373', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '99', '860', '0', '0', 'Pcs', '1', '425.7', '20'),
('14', '2', '14581373', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '99', '860', '0', '0', 'Pcs', '1', '425.7', '20'),
('15', '2', '14581444', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '14', '1220', '0', '0', 'Pcs', '1', '85.4', '20'),
('16', '2', '14581423', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '82.5', '800', '0', '0', 'Pcs', '1', '330', '20'),
('17', '2', '14581423', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '82.5', '800', '0', '0', 'Pcs', '1', '330', '20'),
('18', '2', '14581423', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '82.5', '800', '0', '0', 'Pcs', '1', '330', '20'),
('19', '2', '14581423', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '82.5', '800', '0', '0', 'Pcs', '1', '330', '20'),
('20', '2', '14581374', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '86.166666666667', '960', '0', '0', 'Pcs', '1', '413.6', '20'),
('21', '2', '14581374', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '86.166666666667', '960', '0', '0', 'Pcs', '1', '413.6', '20'),
('22', '2', '14581374', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '86.166666666667', '960', '0', '0', 'Pcs', '1', '413.6', '20'),
('23', '2', '14581374', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '86.166666666667', '960', '0', '0', 'Pcs', '1', '413.6', '20'),
('24', '2', '14581374', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '86.166666666667', '960', '0', '0', 'Pcs', '1', '413.6', '20'),
('25', '2', '14581374', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '86.166666666667', '960', '0', '0', 'Pcs', '1', '413.6', '20'),
('26', '2', '14581393', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '97.5', '1960', '0', '0', 'Pcs', '1', '955.5', '20'),
('27', '2', '14581393', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '97.5', '1960', '0', '0', 'Pcs', '1', '955.5', '20'),
('28', '2', '14581393', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '97.5', '1960', '0', '0', 'Pcs', '1', '955.5', '20'),
('29', '2', '14581393', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '97.5', '1960', '0', '0', 'Pcs', '1', '955.5', '20'),
('30', '2', '14581454', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '30', '1960', '0', '0', 'Pcs', '1', '294', '20'),
('31', '2', '14581395', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '42', '3200', '0', '0', 'Pcs', '1', '672', '20'),
('32', '2', '14581392', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '59.5', '1480', '0', '0', 'Pcs', '1', '440.3', '20'),
('33', '2', '14581392', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '59.5', '1480', '0', '0', 'Pcs', '1', '440.3', '20'),
('34', '2', '10000088', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '100', '976.49', '0', '0', 'Pcs', '1', '550', '20'),
('35', '2', '10000088', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '100', '976.49', '0', '0', 'Pcs', '1', '550', '20'),
('36', '2', '10000088', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '100', '976.49', '0', '0', 'Pcs', '1', '550', '20'),
('37', '2', '14581458', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '10', '1960', '0', '0', 'Pcs', '1', '98', '20'),
('38', '2', '10000068', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '74', '5200', '0', '0', 'Pcs', '1', '1924', '20'),
('39', '2', '10000068', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '74', '5200', '0', '0', 'Pcs', '1', '1924', '20'),
('40', '2', '10000051', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '87.333333333333', '3200', '0', '0', 'Pcs', '1', '1397.3333333333', '20'),
('41', '2', '10000051', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '87.333333333333', '3200', '0', '0', 'Pcs', '1', '1397.3333333333', '20'),
('42', '2', '10000051', '001/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '001/2025', '87.333333333333', '3200', '0', '0', 'Pcs', '1', '1397.3333333333', '20'),
('43', '3', '46115744', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '90', '1297', '0', '0', 'KG', '1', '360', '21'),
('44', '3', '46115744', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '90', '1297', '0', '0', 'KG', '1', '360', '21'),
('45', '3', '46115744', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '90', '1297', '0', '0', 'KG', '1', '360', '21'),
('46', '3', '10000034', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '78.666666666667', '1395.6', '0', '0', 'Pcs', '1', '424.8', '20'),
('47', '3', '10000034', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '78.666666666667', '1395.6', '0', '0', 'Pcs', '1', '424.8', '20'),
('48', '3', '10000034', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '78.666666666667', '1395.6', '0', '0', 'Pcs', '1', '424.8', '20'),
('49', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('50', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('51', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('52', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('53', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('54', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('55', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('56', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('57', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('58', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('59', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('60', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('61', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('62', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('63', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('64', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('65', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('66', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('67', '3', '14581416', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '98.736842105263', '769.2', '0', '0', 'Pcs', '1', '296.21052631579', '20'),
('68', '3', '10000004', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '97.333333333333', '500.4', '0', '0', 'Pcs', '1', '184.93333333333', '20'),
('69', '3', '10000004', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '97.333333333333', '500.4', '0', '0', 'Pcs', '1', '184.93333333333', '20'),
('70', '3', '10000004', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '97.333333333333', '500.4', '0', '0', 'Pcs', '1', '184.93333333333', '20'),
('71', '3', '10000086', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.8', '769.2', '0', '0', 'Pcs', '1', '299.4', '20'),
('72', '3', '10000086', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.8', '769.2', '0', '0', 'Pcs', '1', '299.4', '20'),
('73', '3', '10000086', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.8', '769.2', '0', '0', 'Pcs', '1', '299.4', '20'),
('74', '3', '10000086', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.8', '769.2', '0', '0', 'Pcs', '1', '299.4', '20'),
('75', '3', '10000086', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.8', '769.2', '0', '0', 'Pcs', '1', '299.4', '20'),
('76', '3', '10000005', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '63', '640', '0', '0', 'Pcs', '1', '157.5', '20'),
('77', '3', '10000005', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '63', '640', '0', '0', 'Pcs', '1', '157.5', '20'),
('78', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('79', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('80', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('81', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('82', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('83', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('84', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('85', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('86', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('87', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('88', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('89', '3', '14581417', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '96.166666666667', '1048.2', '0', '0', 'Pcs', '1', '403.9', '20'),
('90', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('91', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('92', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('93', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('94', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('95', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('96', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('97', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('98', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('99', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('100', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('101', '3', '10000087', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '99.833333333333', '1048.2', '0', '0', 'Pcs', '1', '419.3', '20'),
('102', '3', '10000060', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '17', '4037', '0', '0', 'Pcs', '1', '255', '20'),
('103', '3', '14581418', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '95.444444444444', '1358', '0', '0', 'Pcs', '1', '524.94444444444', '20'),
('104', '3', '14581418', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '95.444444444444', '1358', '0', '0', 'Pcs', '1', '524.94444444444', '20'),
('105', '3', '14581418', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '95.444444444444', '1358', '0', '0', 'Pcs', '1', '524.94444444444', '20'),
('106', '3', '14581418', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '95.444444444444', '1358', '0', '0', 'Pcs', '1', '524.94444444444', '20'),
('107', '3', '14581418', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '95.444444444444', '1358', '0', '0', 'Pcs', '1', '524.94444444444', '20'),
('108', '3', '14581418', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '95.444444444444', '1358', '0', '0', 'Pcs', '1', '524.94444444444', '20'),
('109', '3', '14581418', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '95.444444444444', '1358', '0', '0', 'Pcs', '1', '524.94444444444', '20'),
('110', '3', '14581418', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '95.444444444444', '1358', '0', '0', 'Pcs', '1', '524.94444444444', '20'),
('111', '3', '14581418', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '95.444444444444', '1358', '0', '0', 'Pcs', '1', '524.94444444444', '20'),
('112', '3', '68279509', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '3', '2417', '0', '0', 'KG', '1', '28.05', '21'),
('113', '3', '10000013', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '97.6', '1358', '0', '0', 'Pcs', '1', '536.8', '20'),
('114', '3', '10000013', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '97.6', '1358', '0', '0', 'Pcs', '1', '536.8', '20'),
('115', '3', '10000013', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '97.6', '1358', '0', '0', 'Pcs', '1', '536.8', '20'),
('116', '3', '10000013', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '97.6', '1358', '0', '0', 'Pcs', '1', '536.8', '20'),
('117', '3', '10000013', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '97.6', '1358', '0', '0', 'Pcs', '1', '536.8', '20'),
('118', '3', '10000067', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '80', '5746', '0', '0', 'Pcs', '1', '1680', '20'),
('119', '3', '14581483', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '91', '5746', '0', '0', 'Pcs', '1', '1911', '20'),
('120', '3', '14581483', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '91', '5746', '0', '0', 'Pcs', '1', '1911', '20'),
('121', '3', '14581483', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '91', '5746', '0', '0', 'Pcs', '1', '1911', '20'),
('122', '3', '14581483', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '91', '5746', '0', '0', 'Pcs', '1', '1911', '20'),
('123', '3', '14581483', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '91', '5746', '0', '0', 'Pcs', '1', '1911', '20'),
('124', '3', '14581484', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '80', '5460', '0', '0', 'Pcs', '1', '2080', '20'),
('125', '3', '14581410', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '4', '5460', '0', '0', 'Pcs', '1', '104', '20'),
('126', '3', '12625871', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '82.666666666667', '7035', '0', '0', 'KG', '1', '2769.3333333333', '17'),
('127', '3', '12625871', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '82.666666666667', '7035', '0', '0', 'KG', '1', '2769.3333333333', '17'),
('128', '3', '12625871', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '82.666666666667', '7035', '0', '0', 'KG', '1', '2769.3333333333', '17'),
('129', '3', '89871836', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '81.666666666667', '4200', '0', '0', 'KG', '1', '1633.3333333333', '20'),
('130', '3', '89871836', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '81.666666666667', '4200', '0', '0', 'KG', '1', '1633.3333333333', '20'),
('131', '3', '89871836', '002/2025', '2025-05-29', '17', 'DEF', '2025-05-29', '0', '002/2025', '81.666666666667', '4200', '0', '0', 'KG', '1', '1633.3333333333', '20'),
('136', '1', '50196340', '', '2025-05-31', '26', 'DEF', '2025-05-31', '0', '001/2025', '1', '0', '3', '1260', '0', '0', '0', '0'),
('137', '1', '60487735', '004/2025-1', '2025-05-31', '28', 'DEF', '2025-05-31', '184', '', '-26844', '184', '3.0', '1260', '0', '0', '0', '0'),
('138', '2', '82239695', '001/2025', '2025-05-31', '28', 'DEF', '2025-05-31', '184', '', '105', '184', '3.0', '297', '0', '0', '0', '0'),
('139', '2', '83895982', '001/2025', '2025-05-31', '28', 'DEF', '2025-05-31', '184', '', '933', '184', '3.0', '127', '0', '0', '0', '0'),
('140', '2', '83895982', '001/2025', '2025-05-31', '28', 'DEF', '2025-05-31', '184', '', '5556', '184', '3.0', '127', '0', '0', '0', '0'),
('141', '2', '83895982', '001/2025', '2025-05-31', '28', 'DEF', '2025-05-31', '184', '', '7836', '184', '3.0', '127', '0', '0', '0', '0'),
('142', '2', '83895982', '001/2025', '2025-05-31', '28', 'DEF', '2025-05-31', '184', '', '9903', '184', '3.0', '127', '0', '0', '0', '0'),
('143', '2', '83895982', '001/2025', '2025-05-31', '28', 'DEF', '2025-05-31', '184', '', '351', '184', '3.0', '127', '0', '0', '0', '0'),
('149', '2', '50196340', '', '2025-06-02', '26', 'DEF', '2025-06-02', '0', '002/2025', '1', '0', '3', '1260', '0', '0', '0', '0'),
('150', '3', '60487735', '003/2025-1', '2025-06-02', '28', 'DEF', '2025-06-02', '192.5', '', '-26490', '192.5', '3.0', '1260', '0', '0', '0', '0'),
('151', '4', '57781471', '002/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '188.0282079646', '', '8099', '188.0282079646', '3.0', '177', '0', '0', '0', '0'),
('152', '4', '57781471', '002/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '188.0282079646', '', '6080', '188.0282079646', '3.0', '177', '0', '0', '0', '0'),
('153', '4', '57781471', '002/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '188.0282079646', '', '4425', '188.0282079646', '3.0', '177', '0', '0', '0', '0'),
('154', '4', '57781471', '002/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '188.0282079646', '', '364', '188.0282079646', '3.0', '177', '0', '0', '0', '0'),
('155', '4', '57781471', '002/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '188.0282079646', '', '6192', '188.0282079646', '3.0', '177', '0', '0', '0', '0'),
('156', '5', '39858313', '002/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '188.0282079646', '', '210', '188.0282079646', '0', '0', '0', '0', '0', '0'),
('157', '5', '62064910', '002/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '188.0282079646', '', '210', '188.0282079646', '0', '0', '0', '0', '0', '0'),
('160', '3', '50196340', '', '2025-06-02', '26', 'DEF', '2025-06-02', '0', '003/2025', '1', '0', '3', '177', '0', '0', '0', '0'),
('161', '6', '57781471', '002/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '188.0282079646', '', '-25160', '188.0282079646', '3.0', '177', '0', '0', '0', '0'),
('162', '7', '14581450', '003/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '725.16212205014', '', '2100', '725.16212205014', '', '', '0', '0', '0', '0'),
('163', '7', '14581450', '003/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '714.50719026548', '', '1600', '714.50719026548', '', '', '0', '0', '0', '0'),
('164', '7', '22197504', '003/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '640.01909249489', '', '1300', '640.01909249489', '', '', '0', '0', '0', '0'),
('165', '7', '14581450', '003/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '684.42267699114', '', '100', '684.42267699114', '', '', '0', '0', '0', '0'),
('166', '7', '22197504', '003/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '623.60506894312', '', '1867', '623.60506894312', '', '', '0', '0', '0', '0'),
('169', '4', '50196340', '', '2025-06-02', '26', 'DEF', '2025-06-02', '0', '004/2025', '1', '0', '3', '297', '0', '0', '0', '0'),
('170', '8', '82239695', '001/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '184', '', '-105', '184', '3.0', '297', '0', '0', '0', '0'),
('171', '9', '10000068', '004/2025', '2025-06-02', '28', 'DEF', '2025-06-02', '4830', '', '4', '4830', '', '', '0', '0', '0', '0'),
('172', '15', '60487735', '003/2025-1', '2025-06-03', '17', 'DEF', '2025-06-03', '0', '003/2025', '26490', '192.5', '3.0', '1260', 'KG', '', '', ''),
('173', '16', '60487735', '004/2025-1', '2025-06-03', '17', 'DEF', '2025-06-03', '0', '004/2025', '26844', '184', '3.0', '1260', 'KG', '', '', ''),
('174', '5', '50196340', '', '2025-06-03', '26', 'DEF', '2025-06-03', '0', '005/2025', '1', '0', '3', '127', '0', '0', '0', '0'),
('175', '10', '83895982', '001/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '184', '', '-24579', '184', '3.0', '127', '0', '0', '0', '0'),
('176', '11', '14581439', '005/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '1652.577483257', '', '100', '1652.577483257', '', '', '0', '0', '0', '0'),
('177', '11', '14581439', '005/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '1640.1787240042', '', '600', '1640.1787240042', '', '', '0', '0', '0', '0'),
('178', '11', '14581438', '005/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '1227.9602345628', '', '1100', '1227.9602345628', '', '', '0', '0', '0', '0'),
('179', '11', '14581438', '005/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '1222.457980243', '', '1383', '1222.457980243', '', '', '0', '0', '0', '0'),
('180', '11', '14581437', '005/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '941.98365751274', '', '66', '941.98365751274', '', '', '0', '0', '0', '0'),
('181', '12', '77615985', '005/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '177.12513218188', '', '318', '177.12513218188', '0', '0', '0', '0', '0', '0'),
('182', '12', '91000026', '005/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '177.12513218188', '', '250', '177.12513218188', '0', '0', '0', '0', '0', '0'),
('184', '2', '14581374', '001/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '1125.09', 'auto', '-4', '960', '0', '0', 'Pcs', '0', '0', '0'),
('185', '3', '14581450', '003/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '1068.43', 'auto', '-1800', '950', '0', '0', 'Pcs', '0', '0', '0'),
('186', '4', '22197504', '003/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '967.03', 'auto', '-1300', '0', '0', '0', 'KG', '0', '0', '0'),
('187', '4', '14581450', '003/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '1090.98', 'auto', '-500', '950', '0', '0', 'Pcs', '0', '0', '0'),
('188', '5', '10000086', '002/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '621.16', 'auto', '-499', '769.2', '0', '0', 'Pcs', '0', '0', '0'),
('189', '5', '10000087', '002/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '878.69', 'auto', '-500', '1048.2', '0', '0', 'Pcs', '0', '0', '0'),
('190', '5', '10000088', '001/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '1161.36', 'auto', '-300', '976.49', '0', '0', 'Pcs', '0', '0', '0'),
('191', '5', '14581483', '002/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '4433.4', 'auto', '-200', '5746', '0', '0', 'Pcs', '0', '0', '0'),
('192', '5', '14581438', '005/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '1473.12', 'auto', '-100', '0', '0', '0', 'Pcs', '0', '0', '0'),
('193', '5', '14581439', '005/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '2006.64', 'auto', '-100', '0', '0', '0', 'Pcs', '0', '0', '0'),
('194', '5', '14581418', '002/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '1181.52', 'auto', '-100', '1358', '0', '0', 'Pcs', '0', '0', '0'),
('195', '6', '14581417', '002/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '915.38', 'auto', '-300', '1048.2', '0', '0', 'Pcs', '0', '0', '0'),
('196', '6', '10000087', '002/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '909.09', 'auto', '-200', '1048.2', '0', '0', 'Pcs', '0', '0', '0'),
('197', '6', '14581438', '005/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '1519.59', 'auto', '-200', '0', '0', '0', 'Pcs', '0', '0', '0'),
('198', '6', '14581458', '001/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '2153.4', 'auto', '-10', '1960', '0', '0', 'Pcs', '0', '0', '0'),
('199', '6', '14581483', '002/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '4536.2', 'auto', '-30', '5746', '0', '0', 'Pcs', '0', '0', '0'),
('201', '8', '14581393', '001/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '2205.9', 'auto', '-100', '1960', '0', '0', 'Pcs', '0', '0', '0'),
('202', '8', '14581438', '005/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '1562.4', 'auto', '-200', '0', '0', '0', 'Pcs', '0', '0', '0'),
('203', '8', '14581454', '001/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '2205.9', 'auto', '-10', '1960', '0', '0', 'Pcs', '0', '0', '0'),
('204', '8', '14581439', '005/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '2071.8', 'auto', '-150', '0', '0', '0', 'Pcs', '0', '0', '0'),
('205', '8', '10000013', '002/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '1222.2', 'auto', '-100', '1358', '0', '0', 'Pcs', '0', '0', '0'),
('206', '8', '10000051', '001/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '3478', 'auto', '-30', '3200', '0', '0', 'Pcs', '0', '0', '0'),
('207', '8', '10000068', '001/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '5752.58', 'auto', '-80', '5200', '0', '0', 'Pcs', '0', '0', '0'),
('208', '9', '14581483', '002/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '4551', 'auto', '-60', '5746', '0', '0', 'Pcs', '0', '0', '0'),
('209', '17', '60487735', '005/2025-1', '2025-06-03', '17', 'DEF', '2025-06-03', '0', '005/2025', '2101', '184', '3.0', '244', 'KG', '', '', ''),
('210', '6', '50196340', '', '2025-06-03', '26', 'DEF', '2025-06-03', '0', '006/2025', '1', '0', '3', '244', '0', '0', '0', '0'),
('211', '13', '60487735', '005/2025-1', '2025-06-03', '28', 'DEF', '2025-06-03', '184', '', '-2101', '184', '3.0', '244', '0', '0', '0', '0'),
('212', '14', '24616744', '006/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '184', '', '1575', '184', '3.0', '97', '0', '0', '0', '0'),
('213', '14', '38001291', '006/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '184', '', '526', '184', '3.0', '147', '0', '0', '0', '0'),
('214', '7', '50196340', '', '2025-06-03', '26', 'DEF', '2025-06-03', '0', '007/2025', '1', '0', '3', '147', '0', '0', '0', '0'),
('215', '15', '38001291', '006/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '184', '', '-526', '184', '3.0', '147', '0', '0', '0', '0'),
('216', '16', '14581445', '007/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '1488.9846153846', '', '65', '1488.9846153846', '', '', '0', '0', '0', '0'),
('217', '8', '50196340', '', '2025-06-03', '26', 'DEF', '2025-06-03', '0', '008/2025', '1', '0', '3', '97', '0', '0', '0', '0'),
('218', '17', '24616744', '006/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '184', '', '-1575', '184', '3.0', '97', '0', '0', '0', '0'),
('219', '18', '10000094', '008/2025', '2025-06-03', '28', 'DEF', '2025-06-03', '934.83870967742', '', '310', '934.83870967742', '', '', '0', '0', '0', '0'),
('220', '10', '10000094', '008/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '1227.97', 'auto', '-310', '0', '0', '0', 'Pcs', '0', '0', '0'),
('221', '10', '14581445', '007/2025', '2025-06-03', '13', 'DEF', '2025-06-03', '1870.23', 'auto', '-65', '0', '0', '0', 'Pcs', '0', '0', '0');

### Structure of table `0_supp_allocations` ###

DROP TABLE IF EXISTS `0_supp_allocations`;

CREATE TABLE `0_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trans_type_from` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_supp_allocations` ###


### Structure of table `0_supp_invoice_items` ###

DROP TABLE IF EXISTS `0_supp_invoice_items`;

CREATE TABLE `0_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `description` tinytext DEFAULT NULL,
  `quantity` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `memo_` tinytext DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `thickness` varchar(225) NOT NULL,
  `width` varchar(225) NOT NULL,
  `unit_id` varchar(225) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_supp_invoice_items` ###


### Structure of table `0_supp_trans` ###

DROP TABLE IF EXISTS `0_supp_trans`;

CREATE TABLE `0_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `supplier_id` int(11) unsigned NOT NULL,
  `reference` tinytext NOT NULL,
  `supp_reference` varchar(60) NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`type`,`trans_no`,`supplier_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_supp_trans` ###


### Structure of table `0_suppliers` ###

DROP TABLE IF EXISTS `0_suppliers`;

CREATE TABLE `0_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(60) NOT NULL DEFAULT '',
  `supp_ref` varchar(30) NOT NULL DEFAULT '',
  `address` tinytext NOT NULL,
  `supp_address` tinytext NOT NULL,
  `gst_no` varchar(25) NOT NULL DEFAULT '',
  `contact` varchar(60) NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) NOT NULL DEFAULT '',
  `website` varchar(100) NOT NULL DEFAULT '',
  `bank_account` varchar(60) NOT NULL DEFAULT '',
  `curr_code` char(3) DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT 0,
  `purchase_account` varchar(15) NOT NULL DEFAULT '',
  `payable_account` varchar(15) NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) NOT NULL DEFAULT '',
  `notes` tinytext NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_suppliers` ###

INSERT INTO `0_suppliers` VALUES
('1', 'Rizwan Botandas', 'RIZWAN BONTANDAS', '', '', '', '', '', '', '', 'PKR', '3', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('2', 'Hammad botandas', 'Hammad Bontandas', '', '', '', '', '', '', '', 'PKR', '6', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('3', 'LC 231510010-L', 'DIC F#850', '', '', '', '', '', '', '', 'PKR', '8', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('4', 'LC # 231930002-L', 'DIB F#851', '', '', '', '', '', '', '', 'PKR', '9', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('5', 'LC # 232230003-L', 'DIB F#852', '', '', '', '', '', '', '', 'PKR', '11', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('6', 'LC # 2106607-L', 'BAF F#853', '', '', '', '', '', '', '', 'PKR', '10', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('8', 'WAQAR BROKER ', 'WAQAR BROKER ', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('9', 'Adnan Broker', 'Adnan Broker', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('12', 'Ilyas Khatki', 'Ilyas Khatki', '', '', '', '', '', '', 'Ilyas Khatki', 'PKR', '3', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('13', 'Junaid Noor Hr Broker', 'Junaid Noor Hr Broker', '', '', '', '', '', '', 'Junaid Noor Hr Broker', 'PKR', '3', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('14', 'qaiser latif', 'qaiser latif', '', '', '', '', '', '', '', 'PKR', '5', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('15', 'ABDUL RAFAY', 'ABDUL RAFAY', '', '', '', '', '', '', '', 'PKR', '3', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('16', 'File no 855', 'File no 855', '', '', '', '', '', '', '', 'PKR', '3', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('21', 'Saeed', 'Saeed', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('23', 'Mazhar', 'Mazhar', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('24', 'Mazhar', 'Mazhar', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('25', 'Ali', 'Ali', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('26', 'A &amp; A Pipe', 'A &amp; A Pipe', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('27', 'File # 864', 'File # 864', '', '', '', '', '', '', '', 'PKR', '9', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('28', 'File No 863', 'File No 863', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('29', 'File No 862', 'File No 862', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('30', 'file # 865', 'file # 865', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('31', 'File No 867', 'File No 867', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '2', '0', '', '2100', '5060', '', '0'),
('32', 'File No 866', 'File No 866', '', '', '', '', '', '', '', 'PKR', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0');

### Structure of table `0_sys_prefs` ###

DROP TABLE IF EXISTS `0_sys_prefs`;

CREATE TABLE `0_sys_prefs` (
  `name` varchar(35) NOT NULL DEFAULT '',
  `category` varchar(30) DEFAULT NULL,
  `type` varchar(20) NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_sys_prefs` ###

INSERT INTO `0_sys_prefs` VALUES
('accounts_alpha', 'glsetup.general', 'tinyint', '1', '0'),
('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0'),
('add_pct', 'setup.company', 'int', '5', '-1'),
('allow_negative_prices', 'glsetup.inventory', 'tinyint', '1', '1'),
('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '0'),
('alternative_tax_include_on_docs', 'setup.company', 'tinyint', '1', ''),
('auto_curr_reval', 'setup.company', 'smallint', '6', '1'),
('bank_charge_act', 'glsetup.general', 'varchar', '15', '5690'),
('barcodes_on_stock', 'setup.company', 'tinyint', '1', '1'),
('base_sales', 'setup.company', 'int', '11', '1'),
('bcc_email', 'setup.company', 'varchar', '100', ''),
('company_logo_report', 'setup.company', 'tinyint', '1', '1'),
('coy_logo', 'setup.company', 'varchar', '100', ''),
('coy_name', 'setup.company', 'varchar', '60', 'Engineering Zone '),
('coy_no', 'setup.company', 'varchar', '25', '0321 8888073'),
('credit_labour_acc', 'glsetup.general', 'varchar', '225', '2100'),
('credit_overhead_acc', 'glsetup.general', 'varchar', '225', '1065'),
('creditors_act', 'glsetup.purchase', 'varchar', '15', '2100'),
('curr_default', 'setup.company', 'char', '3', 'PKR'),
('debtors_act', 'glsetup.sales', 'varchar', '15', '1200'),
('default_adj_act', 'glsetup.items', 'varchar', '15', '5040'),
('default_cogs_act', 'glsetup.items', 'varchar', '15', '5010'),
('default_credit_limit', 'glsetup.customer', 'int', '11', '1000'),
('default_delivery_required', 'glsetup.sales', 'smallint', '6', '1'),
('default_dim_required', 'glsetup.dims', 'int', '11', '20'),
('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '4010'),
('default_inventory_act', 'glsetup.items', 'varchar', '15', '1510'),
('default_loss_on_asset_disposal_act', 'glsetup.items', 'varchar', '15', '5660'),
('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '4500'),
('default_quote_valid_days', 'glsetup.sales', 'smallint', '6', '30'),
('default_receival_required', 'glsetup.purchase', 'smallint', '6', '10'),
('default_sales_act', 'glsetup.sales', 'varchar', '15', '4010'),
('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '4510'),
('default_wip_act', 'glsetup.items', 'varchar', '15', '1530'),
('default_workorder_required', 'glsetup.manuf', 'int', '11', '20'),
('deferred_income_act', 'glsetup.sales', 'varchar', '15', '2105'),
('depreciation_period', 'glsetup.company', 'tinyint', '1', '1'),
('dim_on_recurrent_invoice', 'setup.company', 'tinyint', '1', '0'),
('dim1_name', 'setup.company', 'tinyint', '1', 'Dimension'),
('dim2_name', 'setup.company', 'tinyint', '1', 'Dimension 2'),
('domicile', 'setup.company', 'varchar', '55', ''),
('email', 'setup.company', 'varchar', '100', 'Tariqint@gmail.com'),
('exchange_diff_act', 'glsetup.general', 'varchar', '15', '4450'),
('f_year', 'setup.company', 'int', '11', '6'),
('fax', 'setup.company', 'varchar', '30', ''),
('freight_act', 'glsetup.customer', 'varchar', '15', '4430'),
('gain_acc', 'glsetup.inventory', 'tinyint', '1', '5812'),
('gl_closing_date', 'setup.closing_date', 'date', '8', ''),
('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', '1550'),
('gst_no', 'setup.company', 'varchar', '25', ''),
('kv_batch', 'setup.company', 'tinyint', '1', '1'),
('kv_exp_date', 'setup.company', 'tinyint', '1', '0'),
('legal_text', 'glsetup.customer', 'tinytext', '0', ''),
('loc_notification', 'glsetup.inventory', 'tinyint', '1', ''),
('login_tout', 'setup.company', 'smallint', '6', '9000000000'),
('long_description_invoice', 'setup.company', 'tinyint', '1', '0'),
('loss_acc', 'glsetup.inventory', 'tinyint', '1', '5811'),
('max_days_in_docs', 'setup.company', 'smallint', '5', '180'),
('no_customer_list', 'setup.company', 'tinyint', '1', '0'),
('no_item_list', 'setup.company', 'tinyint', '1', '0'),
('no_supplier_list', 'setup.company', 'tinyint', '1', '0'),
('no_zero_lines_amount', 'glsetup.sales', 'tinyint', '1', '1'),
('past_due_days', 'glsetup.general', 'int', '11', '30'),
('phone', 'setup.company', 'varchar', '30', '0321 8888073'),
('po_over_charge', 'glsetup.purchase', 'int', '11', '10'),
('po_over_receive', 'glsetup.purchase', 'int', '11', '10'),
('postal_address', 'setup.company', 'tinytext', '0', 'Plot # 1 marked D survey # 189 NC 109, Gadap Town, Karachi, Karachi City, Sindh 74700'),
('print_dialog_direct', 'setup.company', 'tinyint', '1', '0'),
('print_invoice_no', 'glsetup.sales', 'tinyint', '1', '0'),
('print_item_images_on_quote', 'glsetup.inventory', 'tinyint', '1', ''),
('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '9990'),
('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '5060'),
('ref_no_auto_increase', 'setup.company', 'tinyint', '1', '0'),
('retained_earnings_act', 'glsetup.general', 'varchar', '15', '3590'),
('round_to', 'setup.company', 'int', '5', '1'),
('shortname_name_in_list', 'setup.company', 'tinyint', '1', ''),
('show_po_item_codes', 'glsetup.purchase', 'tinyint', '1', ''),
('suppress_tax_rates', 'setup.company', 'tinyint', '1', ''),
('tax_algorithm', 'glsetup.customer', 'tinyint', '1', '1'),
('tax_last', 'setup.company', 'int', '11', '1'),
('tax_prd', 'setup.company', 'int', '11', '1'),
('time_zone', 'setup.company', 'tinyint', '1', '0'),
('use_dimension', 'setup.company', 'tinyint', '1', '0'),
('use_fixed_assets', 'setup.company', 'tinyint', '1', ''),
('use_manufacturing', 'setup.company', 'tinyint', '1', '1'),
('version_id', 'system', 'varchar', '11', '2.4.1');

### Structure of table `0_tag_associations` ###

DROP TABLE IF EXISTS `0_tag_associations`;

CREATE TABLE `0_tag_associations` (
  `record_id` varchar(15) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`record_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_tag_associations` ###


### Structure of table `0_tags` ###

DROP TABLE IF EXISTS `0_tags`;

CREATE TABLE `0_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(60) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_tags` ###


### Structure of table `0_tax_group_items` ###

DROP TABLE IF EXISTS `0_tax_group_items`;

CREATE TABLE `0_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_shipping` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_tax_group_items` ###


### Structure of table `0_tax_groups` ###

DROP TABLE IF EXISTS `0_tax_groups`;

CREATE TABLE `0_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_tax_groups` ###

INSERT INTO `0_tax_groups` VALUES
('1', 'Tax', '0'),
('2', 'Tax Exempt', '0');

### Structure of table `0_tax_types` ###

DROP TABLE IF EXISTS `0_tax_types`;

CREATE TABLE `0_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT 0,
  `sales_gl_code` varchar(15) NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_tax_types` ###

INSERT INTO `0_tax_types` VALUES
('1', '17', '2150', '2150', 'Tax', '0');

### Structure of table `0_trans_tax_details` ###

DROP TABLE IF EXISTS `0_trans_tax_details`;

CREATE TABLE `0_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 0,
  `ex_rate` double NOT NULL DEFAULT 1,
  `included_in_price` tinyint(1) NOT NULL DEFAULT 0,
  `net_amount` double NOT NULL DEFAULT 0,
  `amount` double NOT NULL DEFAULT 0,
  `memo` tinytext DEFAULT NULL,
  `reg_type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_trans_tax_details` ###

INSERT INTO `0_trans_tax_details` VALUES
('1', '13', '1', '2025-06-03', '0', '0', '1', '0', '0', '0', 'auto', NULL),
('2', '10', '1', '2025-06-03', '0', '0', '1', '0', '0', '0', '001/2025', '0'),
('3', '13', '2', '2025-06-03', '0', '0', '1', '0', '4500.36', '0', 'auto', NULL),
('4', '10', '2', '2025-06-03', '0', '0', '1', '0', '4500.36', '0', '001/2025', '0'),
('5', '13', '3', '2025-06-03', '0', '0', '1', '0', '1923174', '0', 'auto', NULL),
('6', '10', '3', '2025-06-03', '0', '0', '1', '0', '1923174', '0', '002/2025', '0'),
('7', '13', '4', '2025-06-03', '0', '0', '1', '0', '1802629', '0', 'auto', NULL),
('8', '10', '4', '2025-06-03', '0', '0', '1', '0', '1802629', '0', '003/2025', '0'),
('9', '13', '5', '2025-06-03', '0', '0', '1', '0', '2450519.84', '0', 'auto', NULL),
('10', '10', '5', '2025-06-03', '0', '0', '1', '0', '2450519.84', '0', '004/2025', '0'),
('11', '13', '6', '2025-06-03', '0', '0', '1', '0', '917970', '0', 'auto', NULL),
('12', '10', '6', '2025-06-03', '0', '0', '1', '0', '917970', '0', '005/2025', '0'),
('13', '13', '7', '2025-06-03', '0', '0', '1', '0', '0', '0', 'auto', NULL),
('14', '10', '7', '2025-06-03', '0', '0', '1', '0', '0', '0', '006/2025', '0'),
('15', '13', '8', '2025-06-03', '0', '0', '1', '0', '1552665.4', '0', 'auto', NULL),
('16', '10', '8', '2025-06-03', '0', '0', '1', '0', '1552665.4', '0', '007/2025', '0'),
('17', '13', '9', '2025-06-03', '0', '0', '1', '0', '273060', '0', 'auto', NULL),
('18', '10', '9', '2025-06-03', '0', '0', '1', '0', '273060', '0', '008/2025', '0'),
('19', '13', '10', '2025-06-03', '0', '0', '1', '0', '502235.65', '0', 'auto', NULL),
('20', '10', '10', '2025-06-03', '0', '0', '1', '0', '502235.65', '0', '009/2025', '0');

### Structure of table `0_unit_mapping` ###

DROP TABLE IF EXISTS `0_unit_mapping`;

CREATE TABLE `0_unit_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(100) NOT NULL,
  `unit_id` varchar(255) NOT NULL,
  `qty` double NOT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=795 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_unit_mapping` ###

INSERT INTO `0_unit_mapping` VALUES
('530', '10000001', 'Pcs', '1', '0'),
('531', '10000002', 'Pcs', '1', '0'),
('532', '10000003', 'Pcs', '1', '0'),
('533', '10000004', 'Pcs', '1', '0'),
('534', '10000005', 'Pcs', '1', '0'),
('535', '10000006', 'Pcs', '1', '0'),
('536', '10000007', 'Pcs', '1', '0'),
('537', '10000008', 'Pcs', '1', '0'),
('538', '10000009', 'Pcs', '1', '0'),
('539', '10000010', 'Pcs', '1', '0'),
('540', '10000011', 'Pcs', '1', '0'),
('541', '10000012', 'Pcs', '1', '0'),
('542', '10000013', 'Pcs', '1', '0'),
('543', '10000014', 'Pcs', '1', '0'),
('544', '10000015', 'Pcs', '1', '0'),
('545', '10000016', 'Pcs', '1', '0'),
('546', '10000017', 'Pcs', '1', '0'),
('547', '10000018', 'Pcs', '1', '0'),
('548', '10000019', 'Pcs', '1', '0'),
('549', '10000020', 'Pcs', '1', '0'),
('550', '10000021', 'Pcs', '1', '0'),
('551', '10000022', 'Pcs', '1', '0'),
('552', '10000023', 'Pcs', '1', '0'),
('553', '10000024', 'Pcs', '1', '0'),
('554', '10000025', 'Pcs', '1', '0'),
('555', '10000026', 'Pcs', '1', '0'),
('556', '10000027', 'Pcs', '1', '0'),
('557', '10000028', 'Pcs', '1', '0'),
('558', '10000029', 'Pcs', '1', '0'),
('559', '10000030', 'Pcs', '1', '0'),
('560', '10000031', 'Pcs', '1', '0'),
('561', '10000032', 'Pcs', '1', '0'),
('562', '10000033', 'Pcs', '1', '0'),
('563', '10000034', 'Pcs', '1', '0'),
('564', '10000035', 'Pcs', '1', '0'),
('565', '10000036', 'Pcs', '1', '0'),
('566', '10000037', 'Pcs', '1', '0'),
('567', '10000038', 'Pcs', '1', '0'),
('568', '10000039', 'Pcs', '1', '0'),
('569', '10000040', 'Pcs', '1', '0'),
('570', '10000041', 'Pcs', '1', '0'),
('571', '10000042', 'Pcs', '1', '0'),
('572', '10000043', 'Pcs', '1', '0'),
('573', '10000044', 'Pcs', '1', '0'),
('574', '10000045', 'Pcs', '1', '0'),
('575', '10000046', 'Pcs', '1', '0'),
('576', '10000047', 'Pcs', '1', '0'),
('577', '10000048', 'Pcs', '1', '0'),
('578', '10000049', 'Pcs', '1', '0'),
('579', '10000050', 'Pcs', '1', '0'),
('580', '10000051', 'Pcs', '1', '0'),
('581', '10000052', 'Pcs', '1', '0'),
('582', '10000053', 'Pcs', '1', '0'),
('583', '10000054', 'Pcs', '1', '0'),
('584', '10000055', 'Pcs', '1', '0'),
('585', '10000056', 'Pcs', '1', '0'),
('586', '10000057', 'Pcs', '1', '0'),
('587', '10000058', 'Pcs', '1', '0'),
('588', '10000059', 'Pcs', '1', '0'),
('589', '10000060', 'Pcs', '1', '0'),
('590', '10000061', 'Pcs', '1', '0'),
('591', '10000062', 'Pcs', '1', '0'),
('592', '10000063', 'Pcs', '1', '0'),
('593', '10000064', 'Pcs', '1', '0'),
('594', '10000065', 'Pcs', '1', '0'),
('595', '10000066', 'Pcs', '1', '0'),
('596', '10000067', 'Pcs', '1', '0'),
('597', '10000068', 'Pcs', '1', '0'),
('598', '10000069', 'Pcs', '1', '0'),
('599', '10000070', 'Pcs', '1', '0'),
('600', '10000071', 'Pcs', '1', '0'),
('601', '10000072', 'Pcs', '1', '0'),
('602', '10000073', 'Pcs', '1', '0'),
('603', '10000074', 'Pcs', '1', '0'),
('604', '10000075', 'Pcs', '1', '0'),
('605', '10000076', 'Pcs', '1', '0'),
('606', '10000077', 'Pcs', '1', '0'),
('607', '10000078', 'Pcs', '1', '0'),
('608', '10000079', 'Pcs', '1', '0'),
('609', '10000080', 'Pcs', '1', '0'),
('610', '10000081', 'Pcs', '1', '0'),
('611', '10000082', 'Pcs', '1', '0'),
('612', '10000083', 'Pcs', '1', '0'),
('613', '10000084', 'Pcs', '1', '0'),
('614', '10000085', 'Pcs', '1', '0'),
('615', '10000086', 'Pcs', '1', '0'),
('616', '10000087', 'Pcs', '1', '0'),
('617', '10000088', 'Pcs', '1', '0'),
('618', '10000089', 'Pcs', '1', '0'),
('619', '10000090', 'Pcs', '1', '0'),
('620', '10000091', 'Pcs', '1', '0'),
('621', '10000092', 'Pcs', '1', '0'),
('622', '10000093', 'Pcs', '1', '0'),
('623', '10000094', 'Pcs', '1', '0'),
('624', '14581371', 'Pcs', '1', '0'),
('625', '14581372', 'Pcs', '1', '0'),
('626', '14581373', 'Pcs', '1', '0'),
('627', '14581374', 'Pcs', '1', '0'),
('628', '14581375', 'Pcs', '1', '0'),
('629', '14581376', 'Pcs', '1', '0'),
('630', '14581377', 'Pcs', '1', '0'),
('631', '14581378', 'Pcs', '1', '0'),
('632', '14581379', 'Pcs', '1', '0'),
('633', '14581380', 'Pcs', '1', '0'),
('634', '14581381', 'Pcs', '1', '0'),
('635', '14581382', 'Pcs', '1', '0'),
('636', '14581383', 'Pcs', '1', '0'),
('637', '14581384', 'Pcs', '1', '0'),
('638', '14581385', 'Pcs', '1', '0'),
('639', '14581386', 'Pcs', '1', '0'),
('640', '14581387', 'Pcs', '1', '0'),
('641', '14581388', 'Pcs', '1', '0'),
('642', '14581389', 'Pcs', '1', '0'),
('643', '14581390', 'Pcs', '1', '0'),
('644', '14581391', 'Pcs', '1', '0'),
('645', '14581392', 'Pcs', '1', '0'),
('646', '14581393', 'Pcs', '1', '0'),
('647', '14581394', 'Pcs', '1', '0'),
('648', '14581395', 'Pcs', '1', '0'),
('649', '14581396', 'Pcs', '1', '0'),
('650', '14581397', 'Pcs', '1', '0'),
('651', '14581398', 'Pcs', '1', '0'),
('652', '14581399', 'Pcs', '1', '0'),
('653', '14581400', 'Pcs', '1', '0'),
('654', '14581401', 'Pcs', '1', '0'),
('655', '14581402', 'Pcs', '1', '0'),
('656', '14581403', 'Pcs', '1', '0'),
('657', '14581404', 'Pcs', '1', '0'),
('658', '14581405', 'Pcs', '1', '0'),
('659', '14581406', 'Pcs', '1', '0'),
('660', '14581407', 'Pcs', '1', '0'),
('661', '14581408', 'Pcs', '1', '0'),
('662', '14581409', 'Pcs', '1', '0'),
('663', '14581410', 'Pcs', '1', '0'),
('664', '14581411', 'Pcs', '1', '0'),
('665', '14581412', 'Pcs', '1', '0'),
('666', '14581413', 'Pcs', '1', '0'),
('667', '14581414', 'Pcs', '1', '0'),
('668', '14581415', 'Pcs', '1', '0'),
('669', '14581416', 'Pcs', '1', '0'),
('670', '14581417', 'Pcs', '1', '0'),
('671', '14581418', 'Pcs', '1', '0'),
('672', '14581419', 'Pcs', '1', '0'),
('673', '14581420', 'Pcs', '1', '0'),
('674', '14581421', 'Pcs', '1', '0'),
('675', '14581422', 'Pcs', '1', '0'),
('676', '14581423', 'Pcs', '1', '0'),
('677', '14581424', 'Pcs', '1', '0'),
('678', '14581425', 'Pcs', '1', '0'),
('679', '14581426', 'Pcs', '1', '0'),
('680', '14581427', 'Pcs', '1', '0'),
('681', '14581428', 'Pcs', '1', '0'),
('682', '14581429', 'Pcs', '1', '0'),
('683', '14581430', 'Pcs', '1', '0'),
('684', '14581431', 'Pcs', '1', '0'),
('685', '14581432', 'Pcs', '1', '0'),
('686', '14581433', 'Pcs', '1', '0'),
('687', '14581434', 'Pcs', '1', '0'),
('688', '14581435', 'Pcs', '1', '0'),
('689', '14581436', 'Pcs', '1', '0'),
('690', '14581437', 'Pcs', '1', '0'),
('691', '14581438', 'Pcs', '1', '0'),
('692', '14581439', 'Pcs', '1', '0'),
('693', '14581440', 'Pcs', '1', '0'),
('694', '14581441', 'Pcs', '1', '0'),
('695', '14581442', 'Pcs', '1', '0'),
('696', '14581443', 'Pcs', '1', '0'),
('697', '14581444', 'Pcs', '1', '0'),
('698', '14581445', 'Pcs', '1', '0'),
('699', '14581446', 'Pcs', '1', '0'),
('700', '14581447', 'Pcs', '1', '0'),
('701', '14581448', 'Pcs', '1', '0'),
('702', '14581449', 'Pcs', '1', '0'),
('703', '14581450', 'Pcs', '1', '0'),
('704', '14581451', 'Pcs', '1', '0'),
('705', '14581452', 'Pcs', '1', '0'),
('706', '14581453', 'Pcs', '1', '0'),
('707', '14581454', 'Pcs', '1', '0'),
('708', '14581455', 'Pcs', '1', '0'),
('709', '14581456', 'Pcs', '1', '0'),
('710', '14581457', 'Pcs', '1', '0'),
('711', '14581458', 'Pcs', '1', '0'),
('712', '14581459', 'Pcs', '1', '0'),
('713', '14581460', 'Pcs', '1', '0'),
('714', '14581461', 'Pcs', '1', '0'),
('715', '14581462', 'Pcs', '1', '0'),
('716', '14581463', 'Pcs', '1', '0'),
('717', '14581464', 'Pcs', '1', '0'),
('718', '14581465', 'Pcs', '1', '0'),
('719', '14581466', 'Pcs', '1', '0'),
('720', '14581467', 'Pcs', '1', '0'),
('721', '14581468', 'Pcs', '1', '0'),
('722', '14581469', 'Pcs', '1', '0'),
('723', '14581470', 'Pcs', '1', '0'),
('724', '14581471', 'Pcs', '1', '0'),
('725', '14581472', 'Pcs', '1', '0'),
('726', '14581473', 'Pcs', '1', '0'),
('727', '14581474', 'Pcs', '1', '0'),
('728', '14581475', 'Pcs', '1', '0'),
('729', '14581476', 'Pcs', '1', '0'),
('730', '14581477', 'Pcs', '1', '0'),
('731', '14581478', 'Pcs', '1', '0'),
('732', '14581479', 'Pcs', '1', '0'),
('733', '14581480', 'Pcs', '1', '0'),
('734', '14581481', 'Pcs', '1', '0'),
('735', '14581482', 'Pcs', '1', '0'),
('736', '14581483', 'Pcs', '1', '0'),
('737', '14581484', 'Pcs', '1', '0'),
('738', '14581485', 'Pcs', '1', '0'),
('739', '14581486', 'Pcs', '1', '0'),
('740', '14581487', 'Pcs', '1', '0'),
('741', '14581488', 'Pcs', '1', '0'),
('742', '14581489', 'Pcs', '1', '0'),
('743', '14581490', 'Pcs', '1', '0'),
('744', '14581491', 'Pcs', '1', '0'),
('745', '14581492', 'Pcs', '1', '0'),
('746', '14581493', 'Pcs', '1', '0'),
('747', '14581494', 'Pcs', '1', '0'),
('748', '14581495', 'Pcs', '1', '0'),
('749', '14581496', 'Pcs', '1', '0'),
('750', '14581497', 'Pcs', '1', '0'),
('751', '14581498', 'Pcs', '1', '0'),
('752', '24616744', 'KG', '1', '0'),
('753', '27003244', 'Pcs', '1', '0'),
('754', '28488323', 'Pcs', '1', '0'),
('755', '29121137', 'Pcs', '1', '0'),
('756', '33010403', 'KG', '1', '0'),
('757', '35147091', 'Pcs', '1', '0'),
('758', '37277987', 'KG', '1', '0'),
('759', '38001291', 'Pcs', '1', '0'),
('760', '38632044', 'Pcs', '1', '0'),
('761', '39858313', 'KG', '1', '0'),
('762', '47221925', 'KG', '1', '0'),
('763', '50196340', 'Pcs', '1', '0'),
('764', '51875008', 'Pcs', '1', '0'),
('765', '53186355', 'KG', '1', '0'),
('766', '56876383', 'Pcs', '1', '0'),
('767', '57781471', 'Pcs', '1', '0'),
('768', '57921181', 'Pcs', '1', '0'),
('769', '60487735', 'KG', '1', '0'),
('770', '62064910', 'KG', '1', '0'),
('771', '71846835', 'KG', '1', '0'),
('772', '77615985', 'KG', '1', '0'),
('773', '82239695', 'Pcs', '1', '0'),
('774', '83895982', 'Pcs', '1', '0'),
('775', '90538834', 'Pcs', '1', '0'),
('776', '91000026', 'KG', '1', '0'),
('777', '83980428', 'each', '1', '0'),
('778', '80726142', 'each', '1', '0'),
('779', '37613624', 'KG', '1', '0'),
('780', '82995317', 'KG', '1', '0'),
('781', '43317004', 'KG', '1', '0'),
('782', '22197504', 'KG', '1', '0'),
('783', '49858495', 'KG', '1', '0'),
('784', '50143139', 'KG', '1', '0'),
('785', '00000010', 'KG', '1', '0'),
('786', '32641899', 'KG', '1', '0'),
('787', '69839917', 'KG', '1', '0'),
('788', '89871836', 'KG', '1', '0'),
('789', '14653407', 'each', '1', '0'),
('790', '32476125', 'KG', '1', '0'),
('791', '46115744', 'KG', '1', '0'),
('792', '68279509', 'KG', '1', '0'),
('793', '12625871', 'KG', '1', '0'),
('794', '32910179', 'KG', '1', '0');

### Structure of table `0_useronline` ###

DROP TABLE IF EXISTS `0_useronline`;

CREATE TABLE `0_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(15) NOT NULL DEFAULT 0,
  `ip` varchar(40) NOT NULL DEFAULT '',
  `file` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_useronline` ###


### Structure of table `0_users` ###

DROP TABLE IF EXISTS `0_users`;

CREATE TABLE `0_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `real_name` varchar(100) NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT 1,
  `phone` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(100) DEFAULT NULL,
  `language` varchar(20) DEFAULT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT 0,
  `date_sep` tinyint(1) NOT NULL DEFAULT 0,
  `tho_sep` tinyint(1) NOT NULL DEFAULT 0,
  `dec_sep` tinyint(1) NOT NULL DEFAULT 0,
  `theme` varchar(20) NOT NULL DEFAULT 'LTE',
  `page_size` varchar(20) NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT 2,
  `qty_dec` smallint(6) NOT NULL DEFAULT 2,
  `rates_dec` smallint(6) NOT NULL DEFAULT 4,
  `percent_dec` smallint(6) NOT NULL DEFAULT 1,
  `show_gl` tinyint(1) NOT NULL DEFAULT 1,
  `show_codes` tinyint(1) NOT NULL DEFAULT 0,
  `show_hints` tinyint(1) NOT NULL DEFAULT 0,
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) unsigned NOT NULL DEFAULT 10,
  `graphic_links` tinyint(1) DEFAULT 1,
  `pos` smallint(6) DEFAULT 1,
  `print_profile` varchar(30) NOT NULL DEFAULT '',
  `rep_popup` tinyint(1) DEFAULT 1,
  `sticky_doc_date` tinyint(1) DEFAULT 0,
  `startup_tab` varchar(20) NOT NULL DEFAULT '',
  `transaction_days` smallint(6) NOT NULL DEFAULT 30,
  `save_report_selections` smallint(6) NOT NULL DEFAULT 0,
  `use_date_picker` tinyint(1) NOT NULL DEFAULT 1,
  `def_print_destination` tinyint(1) NOT NULL DEFAULT 0,
  `def_print_orientation` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_users` ###

INSERT INTO `0_users` VALUES
('1', 'admin', '81dc9bdb52d04dc20036dbd8313ed055', 'Administrator', '2', '', 'wrapandg@wrapandgoofficial.com', 'C', '1', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2025-06-05 12:35:38', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('2', 'sales', '81dc9bdb52d04dc20036dbd8313ed055', 'salesman', '3', '', 'sales@salesman.com', 'C', '0', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2022-03-30 21:01:48', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('3', 'trading', '81dc9bdb52d04dc20036dbd8313ed055', 'Trading', '11', '', NULL, 'C', '0', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2022-09-09 10:46:28', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('4', 'erp1', '81dc9bdb52d04dc20036dbd8313ed055', 'ERP', '12', '', NULL, 'C', '0', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2022-07-08 10:08:16', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0');

### Structure of table `0_voided` ###

DROP TABLE IF EXISTS `0_voided`;

CREATE TABLE `0_voided` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_voided` ###

INSERT INTO `0_voided` VALUES
('0', '1', '2025-06-02', ''),
('0', '2', '2025-06-02', ''),
('0', '3', '2025-06-02', ''),
('10', '1', '2025-06-03', ''),
('10', '7', '2025-06-03', ''),
('13', '1', '2025-06-03', ''),
('13', '7', '2025-06-03', ''),
('17', '1', '2025-05-29', ''),
('17', '4', '2025-05-31', ''),
('17', '5', '2025-06-02', ''),
('17', '6', '2025-06-02', ''),
('17', '7', '2025-06-02', ''),
('17', '8', '2025-06-02', ''),
('17', '9', '2025-06-02', ''),
('17', '10', '2025-06-02', ''),
('17', '11', '2025-06-02', ''),
('17', '12', '2025-06-02', ''),
('17', '13', '2025-06-02', ''),
('17', '14', '2025-06-02', '');

### Structure of table `0_wo_costing` ###

DROP TABLE IF EXISTS `0_wo_costing`;

CREATE TABLE `0_wo_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `cost_type` tinyint(1) NOT NULL DEFAULT 0,
  `trans_type` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `factor` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_wo_costing` ###


### Structure of table `0_wo_issue_items` ###

DROP TABLE IF EXISTS `0_wo_issue_items`;

CREATE TABLE `0_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) DEFAULT NULL,
  `batch_no` varchar(30) NOT NULL,
  `exp_date` date NOT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  `unit_cost` double NOT NULL DEFAULT 0,
  `thickness` varchar(225) NOT NULL,
  `width` varchar(225) NOT NULL,
  `bundle` varchar(225) NOT NULL,
  `weight` varchar(225) NOT NULL,
  `length` varchar(225) NOT NULL,
  `westage` varchar(225) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_wo_issue_items` ###

INSERT INTO `0_wo_issue_items` VALUES
('1', '60487735', '004/2025-1', '2025-05-31', '1', '-26844', '184', '3.0', '1260', '', '', '', ''),
('2', '82239695', '001/2025', '2025-05-31', '2', '105', '184', '3.0', '297', '', '', '', ''),
('3', '83895982', '001/2025', '2025-05-31', '2', '933', '184', '3.0', '127', '', '', '', ''),
('4', '83895982', '001/2025', '2025-05-31', '2', '5556', '184', '3.0', '127', '', '', '', ''),
('5', '83895982', '001/2025', '2025-05-31', '2', '7836', '184', '3.0', '127', '', '', '', ''),
('6', '83895982', '001/2025', '2025-05-31', '2', '9903', '184', '3.0', '127', '', '', '', ''),
('7', '83895982', '001/2025', '2025-05-31', '2', '351', '184', '3.0', '127', '', '', '', ''),
('8', '60487735', '003/2025-1', '2025-06-02', '3', '-26490', '192.5', '3.0', '1260', '', '', '', ''),
('9', '57781471', '002/2025', '2025-06-02', '4', '8099', '188.0282079646', '3.0', '177', '', '', '', ''),
('10', '57781471', '002/2025', '2025-06-02', '4', '6080', '188.0282079646', '3.0', '177', '', '', '', ''),
('11', '57781471', '002/2025', '2025-06-02', '4', '4425', '188.0282079646', '3.0', '177', '', '', '', ''),
('12', '57781471', '002/2025', '2025-06-02', '4', '364', '188.0282079646', '3.0', '177', '', '', '', ''),
('13', '57781471', '002/2025', '2025-06-02', '4', '6192', '188.0282079646', '3.0', '177', '', '', '', ''),
('14', '39858313', '002/2025', '2025-06-02', '5', '210', '188.0282079646', '0', '0', '0', '0', '0', ''),
('15', '62064910', '002/2025', '2025-06-02', '5', '210', '188.0282079646', '0', '0', '0', '0', '0', ''),
('16', '57781471', '002/2025', '2025-06-02', '6', '-25160', '188.0282079646', '3.0', '177', '', '', '', ''),
('17', '14581450', '003/2025', '2025-06-02', '7', '2100', '725.16212205014', '', '', '21', '8099', '20', ''),
('18', '14581450', '003/2025', '2025-06-02', '7', '1600', '714.50719026548', '', '', '16', '6080', '20', ''),
('19', '22197504', '003/2025', '2025-06-02', '7', '1300', '640.01909249489', '', '', '13', '4425', '18', ''),
('20', '14581450', '003/2025', '2025-06-02', '7', '100', '684.42267699114', '', '', '1', '364', '20', ''),
('21', '22197504', '003/2025', '2025-06-02', '7', '1867', '623.60506894312', '', '', '19', '6192', '18', ''),
('22', '82239695', '001/2025', '2025-06-02', '8', '-105', '184', '3.0', '297', '', '', '', ''),
('23', '10000068', '004/2025', '2025-06-02', '9', '4', '4830', '', '', '1', '105', '20', ''),
('24', '83895982', '001/2025', '2025-06-03', '10', '-24579', '184', '3.0', '127', '', '', '', ''),
('25', '14581439', '005/2025', '2025-06-03', '11', '100', '1652.577483257', '', '', '1', '933', '20', ''),
('26', '14581439', '005/2025', '2025-06-03', '11', '600', '1640.1787240042', '', '', '6', '5556', '20', ''),
('27', '14581438', '005/2025', '2025-06-03', '11', '1100', '1227.9602345628', '', '', '11', '7626', '20', ''),
('28', '14581438', '005/2025', '2025-06-03', '11', '1383', '1222.457980243', '', '', '14', '9545', '20', ''),
('29', '14581437', '005/2025', '2025-06-03', '11', '66', '941.98365751274', '', '', '1', '351', '20', ''),
('30', '77615985', '005/2025', '2025-06-03', '12', '318', '177.12513218188', '0', '0', '0', '0', '0', ''),
('31', '91000026', '005/2025', '2025-06-03', '12', '250', '177.12513218188', '0', '0', '0', '0', '0', ''),
('32', '60487735', '005/2025-1', '2025-06-03', '13', '-2101', '184', '3.0', '244', '', '', '', ''),
('33', '24616744', '006/2025', '2025-06-03', '14', '1575', '184', '3.0', '97', '', '', '', ''),
('34', '38001291', '006/2025', '2025-06-03', '14', '526', '184', '3.0', '147', '', '', '', ''),
('35', '38001291', '006/2025', '2025-06-03', '15', '-526', '184', '3.0', '147', '', '', '', ''),
('36', '14581445', '007/2025', '2025-06-03', '16', '65', '1488.9846153846', '', '', '1', '526', '20', ''),
('37', '24616744', '006/2025', '2025-06-03', '17', '-1575', '184', '3.0', '97', '', '', '', ''),
('38', '10000094', '008/2025', '2025-06-03', '18', '310', '934.83870967742', '', '', '4', '1575', '20', '');

### Structure of table `0_wo_issues` ###

DROP TABLE IF EXISTS `0_wo_issues`;

CREATE TABLE `0_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_wo_issues` ###

INSERT INTO `0_wo_issues` VALUES
('1', '1', '001/2025', '2025-05-31', 'DEF', '1'),
('2', '1', '002/2025', '2025-05-31', 'DEF', '2'),
('3', '2', '003/2025', '2025-06-02', 'DEF', '1'),
('4', '2', '004/2025', '2025-06-02', 'DEF', '2'),
('5', '2', '005/2025', '2025-06-02', 'DEF', '3'),
('6', '3', '006/2025', '2025-06-02', 'DEF', '1'),
('7', '3', '007/2025', '2025-06-02', 'DEF', '2'),
('8', '4', '008/2025', '2025-06-02', 'DEF', '1'),
('9', '4', '009/2025', '2025-06-02', 'DEF', '2'),
('10', '5', '010/2025', '2025-06-03', 'DEF', '1'),
('11', '5', '011/2025', '2025-06-03', 'DEF', '2'),
('12', '5', '012/2025', '2025-06-03', 'DEF', '3'),
('13', '6', '013/2025', '2025-06-03', 'DEF', '1'),
('14', '6', '014/2025', '2025-06-03', 'DEF', '2'),
('15', '7', '015/2025', '2025-06-03', 'DEF', '1'),
('16', '7', '016/2025', '2025-06-03', 'DEF', '2'),
('17', '8', '017/2025', '2025-06-03', 'DEF', '1'),
('18', '8', '018/2025', '2025-06-03', 'DEF', '2');

### Structure of table `0_wo_item_wesatge` ###

DROP TABLE IF EXISTS `0_wo_item_wesatge`;

CREATE TABLE `0_wo_item_wesatge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_type` int(11) NOT NULL,
  `stock_id_` varchar(225) NOT NULL,
  `inactive` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci ;

### Data of table `0_wo_item_wesatge` ###

INSERT INTO `0_wo_item_wesatge` VALUES
('2', '3', '77615985', '0'),
('3', '4', '77615985', '0'),
('5', '2', '39858313', '0'),
('6', '3', '53186355', '0'),
('8', '4', '53186355', '0'),
('9', '4', '91000026', '0'),
('10', '3', '91000026', '0'),
('11', '2', '62064910', '0'),
('12', '2', '28488323', '0');

### Structure of table `0_wo_manufacture` ###

DROP TABLE IF EXISTS `0_wo_manufacture`;

CREATE TABLE `0_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_wo_manufacture` ###

INSERT INTO `0_wo_manufacture` VALUES
('1', '001/2025', '1', '1', '2025-05-31'),
('2', '002/2025', '2', '1', '2025-06-02'),
('3', '003/2025', '3', '1', '2025-06-02'),
('4', '004/2025', '4', '1', '2025-06-02'),
('5', '005/2025', '5', '1', '2025-06-03'),
('6', '006/2025', '6', '1', '2025-06-03'),
('7', '007/2025', '7', '1', '2025-06-03'),
('8', '008/2025', '8', '1', '2025-06-03');

### Structure of table `0_wo_requirements` ###

DROP TABLE IF EXISTS `0_wo_requirements`;

CREATE TABLE `0_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT 0,
  `units_req` double NOT NULL DEFAULT 1,
  `unit_cost` double NOT NULL DEFAULT 0,
  `loc_code` char(5) NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_wo_requirements` ###


### Structure of table `0_workcentres` ###

DROP TABLE IF EXISTS `0_workcentres`;

CREATE TABLE `0_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) NOT NULL DEFAULT '',
  `description` char(50) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_workcentres` ###

INSERT INTO `0_workcentres` VALUES
('1', 'Raw Material', 'Raw Material', '0'),
('2', 'Semi/Finish Good', 'Semi/Finish Good', '0'),
('3', 'Wastage', 'Wastage', '0');

### Structure of table `0_workorders` ###

DROP TABLE IF EXISTS `0_workorders`;

CREATE TABLE `0_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) NOT NULL DEFAULT '',
  `loc_code` varchar(5) NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT 1,
  `stock_id` varchar(20) NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT 0,
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT 0,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `released` tinyint(1) NOT NULL DEFAULT 0,
  `additional_costs` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci ;

### Data of table `0_workorders` ###

INSERT INTO `0_workorders` VALUES
('1', '001/2025', 'DEF', '1', '50196340', '2025-05-31', '2', '2025-05-31', '2025-05-31', '1', '1', '1', '0'),
('2', '002/2025', 'DEF', '1', '50196340', '2025-06-02', '2', '2025-06-02', '2025-06-02', '1', '1', '1', '0'),
('3', '003/2025', 'DEF', '1', '50196340', '2025-06-02', '4', '2025-06-02', '2025-06-02', '1', '1', '1', '0'),
('4', '004/2025', 'DEF', '1', '50196340', '2025-06-02', '4', '2025-06-02', '2025-06-02', '1', '1', '1', '0'),
('5', '005/2025', 'DEF', '1', '50196340', '2025-06-03', '4', '2025-06-03', '2025-06-03', '1', '1', '1', '0'),
('6', '006/2025', 'DEF', '1', '50196340', '2025-06-03', '2', '2025-06-03', '2025-06-03', '1', '1', '1', '0'),
('7', '007/2025', 'DEF', '1', '50196340', '2025-06-03', '4', '2025-06-03', '2025-06-03', '1', '1', '1', '0'),
('8', '008/2025', 'DEF', '1', '50196340', '2025-06-03', '4', '2025-06-03', '2025-06-03', '1', '1', '1', '0');