<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_gate_pass($items, $reference="", $gate_pass_date="", $location="", $memo_, $cell_no, $vehicle_no, $name)
{
	$sql = "INSERT INTO ".TB_PREF."gate_pas (reference, gate_pass_date, location, memo_, cell_no, vehicle_no, name) VALUES (
		".db_escape($reference).", '".date2sql($gate_pass_date)."', ".db_escape($location).", ".db_escape($memo_).", ".db_escape($cell_no).", ".db_escape($vehicle_no).", ".db_escape($name).")";
	// display_error($sql);
   	db_query($sql,"The sales group could not be added");
   	$gate_pass_id = db_insert_id();
   	if ($gate_pass_id) {
	foreach ($items as $line_no=>$stock_item)
	{
		$sql = "INSERT INTO ".TB_PREF."gate_pas_details (gate_pass_id, stock_id, description, qty) VALUES (".db_escape($gate_pass_id).",".db_escape($stock_item->stock_id).", "
				.db_escape($stock_item->item_description).", ".db_escape($stock_item->quantity).")";
		// display_error($sql);
		db_query($sql, "order Details Cannot be Added");

	 }
   }
   return $gate_pass_id;
}


function get_gate_pass($trans_no)
{
	$sql = "SELECT * FROM ".TB_PREF."gate_pas WHERE gate_id=".db_escape($trans_no);
	$result = db_query($sql,"could not get group");
	return db_fetch($result);
}

function get_gate_pass_details($trans_no)
{
	$sql = "SELECT * FROM ".TB_PREF."gate_pas_details WHERE gate_pass_id=".db_escape($trans_no);
	return db_query($sql,"could not get group");
}


function get_gate_pass_inquiry($stock_id="", $location="", $from="", $to="")
{
	$sql = "SELECT 
			gp.gate_id,
			gp.reference,
			gp.location,
			gp.memo_,
			gpd.gate_pass_id,
			gpd.stock_id
	FROM ".TB_PREF."gate_pas as gp , ".TB_PREF."gate_pas_details as
	gpd WHERE gp.gate_id=gpd.gate_pass_id";

	$data_after = date2sql($from);
	$date_before = date2sql($to);

	$sql .= " AND gp.gate_pass_date >= '$data_after'";
	$sql .= " AND gp.gate_pass_date <= '$date_before'";

	if($stock_id != "")
		$sql .= "AND gpd.stock_id=".db_escape($stock_id);

	if($location != "")
		$sql .= "AND gp.location=".db_escape($location);
	// display_error($sql);
	$sql .= " GROUP BY gp.gate_id";
	return $sql;
}