<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
function add_unit_mapping($stock_id, $unit_id, $qty)
{
	$sql = "INSERT INTO ".TB_PREF."unit_mapping (stock_id, unit_id, qty) 
		VALUES (".db_escape($stock_id).", ".db_escape($unit_id)
		.", ".db_escape($qty).")";

	db_query($sql,"an item price could not be added");
}

function update_unit_mapping($id, $unit_id, $qty)
{
	$sql = "UPDATE ".TB_PREF."unit_mapping SET unit_id=".db_escape($unit_id).", 
		qty=".db_escape($qty)." WHERE id=".db_escape($id);

	db_query($sql,"an item price could not be updated");
}

function delete_unit_mapping($id)
{
	$sql="DELETE FROM ".TB_PREF."unit_mapping WHERE id= ".db_escape($id);
	db_query($sql,"an item price could not be deleted");
}

function get_unit_mapping($stock_id, $unit_id='')
{
	// display_error($stock_id .'=='. $unit_id);
	// exit();
	$sql = "SELECT * FROM ".TB_PREF."unit_mapping WHERE stock_id=".db_escape($stock_id);

	if ($unit_id != '') {
	   $sql .= " AND unit_id=".db_escape($unit_id);
	}

	$result = db_query($sql,"item prices could not be retreived");
	return db_fetch($result);
}

function get_stock_unit_mapping($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."unit_mapping WHERE id=".db_escape($selected_id);
	// display_error($sql);
	$result = db_query($sql,"price could not be retreived");

	return db_fetch($result);
}

function getting_unit_mapping($show_inactive, $stock_id)
{
	$sql = "SELECT * FROM ".TB_PREF."unit_mapping as um";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	if($stock_id)
		$sql .= " AND um.stock_id = ".db_escape($stock_id);
	$sql .= " ORDER BY unit_id";
	return db_query($sql,"could not get groups");


	// $sql = "SELECT * FROM ".TB_PREF."unit_mapping WHERE id = ".db_escape($id);
	// if (!$show_inactive) $sql .= " AND !inactive";
	// return db_query($sql, "could not query locations");
}

// function get_stock_price_type_currency($stock_id, $type, $currency)
// {
// 	$sql = "SELECT * FROM ".TB_PREF."prices WHERE stock_id=".db_escape($stock_id)."
// 		AND sales_type_id=".db_escape($type)."
// 		AND curr_abrev=".db_escape($currency);

// 	$result = db_query($sql,"price could not be retreived");

// 	return db_fetch($result);
// }
