<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CREATE_GATE_PAS';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/inventory/includes/create_gate_pas_ui.inc");
include_once($path_to_root . "/inventory/includes/db/create_gate_pas_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Gate Pass Inquiry"), false, false, "", $js);

//---------------------------------------------------------------------------------------------

function gate_pass_id($row)
{
	return viewer_link($row['gate_id'] ,'/inventory/view/view_gate_pass.php?trans_no='.$row['gate_id']);
}
//$row['gate_id'] . 
function print_gatePass($row)
{
	return viewer_link('print View' ,'/inventory/view/print_gate_pass.php?trans_no='.$row['gate_id']);
}

start_form();
start_table(TABLESTYLE_NOBORDER);
start_row();
global $Ajax;
stock_items_list_cells(_("For Item:"), 'stock_id', null, true);
locations_list_cells(_("From Location:"), 'StockLocation', null, true, false, (get_post('fixed_asset') == 1));
date_cells(_("From:"), 'AfterDate', '', null, -user_transaction_days());
date_cells(_("To:"), 'BeforeDate');
submit_cells('ShowMoves',_("Show"),'',_('Refresh Inquiry'), 'default');
if(get_post('ShowMoves'))
{
	$Ajax->activate('_page_body');
}
end_row();
end_table();
//---------------------------------------------------------------------------------------------

$sql = get_gate_pass_inquiry(get_post('stock_id'), get_post('StockLocation'), get_post('AfterDate'), get_post('BeforeDate'));

$cols = array(
	_("Gate Pass #") => array('fun'=>'gate_pass_id', 'ord'=>'', 'align'=>'center'),
	_("Reference") => array('reference', 'align'=>'center'),
	_("Location") => array('location', 'align'=>'center'),
	_("Comments") => array('memo_', 'align'=>'center'),
	_("Print Gate Pass") => array('fun'=>'print_gatePass', 'ord'=>'', 'align'=>'center'),
);

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);

$table->width = "80%";
display_db_pager($table);

end_form();
end_page();
