<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CREATE_GATE_PAS';
$path_to_root = "../..";

include($path_to_root . "/includes/session.inc");
// page(_($help_context = "Print"), true);
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root . "/inventory/includes/db/create_gate_pas_db.inc");
include_once($path_to_root . "/inventory/includes/db/unit_mapping_db.inc");
include_once($path_to_root . "/inventory/includes/db/items_units_db.inc");

if (isset($_GET["trans_no"]))
{
    $trans_no = $_GET["trans_no"];
}

 //  for header
$gate_pass = get_gate_pass($trans_no);
// print_r($gate_pass);

 //  for Detail
$gate_pass_detail = get_gate_pass_details($trans_no);
// print_r($gate_pass_detail);

?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Print Gate Pass</title>
</head>
<body>
    <div class="container">
        <div class="form-control">
            <!-- seperate division -->
            <div class="row">
                <h1 style="margin: 0, auto;">AHMED DIGITAL WORLD</h1>
                <h1 style="text-decoration: none; font-size: 14px; margin-top: 2px; margin-bottom: 2px;"> Customer Copy </h1>
                <span >Gate Pass</span>
                <table class="center" style="border-collapse: collapse;">
                <tr>
                    <th>Party</th>
                    <th>Date</th>
                    <th>GP #</th>
                </tr>

                <tr>
                    <th></th>
                    <th> <?php echo $gate_pass['gate_pass_date'];  ?> </th>
                    <th> <?php echo $gate_pass['reference'] ?> </th>
                </tr>
                </table>
                <br>
                <table class="center" style="border-collapse: collapse;">
                  <tr>
                    <th>SERIAL</th>
                    <th>DISCRIPTION</th>
                    <!-- <th>PCS</th> -->
                    <th>UNIT</th>
                    <th>QTY</th>
                    <th>REMARKS</th>
                  </tr>

                  <tr>
                    <?php 
                    $dec = user_price_dec();
                    while ($myrow = db_fetch($gate_pass_detail)) {
                        // print_r($myrow);
                        label_cell($myrow["stock_id"], "align='center'");
                        label_cell($myrow["description"], "align='center'");
                        // label_cell($myrow[""], "align='center'");
                        label_cell(get_unit_name_by_stock($myrow["stock_id"]), "align='center'");
                        qty_cell($myrow["qty"], false, $dec );
                        label_cell($gate_pass['memo_'], "align='center'");
                        end_row();

                        $qtyTotal +=  $myrow["qty"];
                    }
                         ?>
                  </tr>

                  <tr>
                    <th>Name</th>
                    <th>Cell #</th>
                    <th>Vehicle #</th>
                    <th>Total</th>
                    <th>Total Pack</th>
                  </tr>

                   <tr>
                    <td> <?php echo $gate_pass['name'];  ?> </td>
                    <td> <?php echo $gate_pass['cell_no'];  ?> </td>
                    <td> <?php echo $gate_pass['vehicle_no'];  ?> </td>
                    <td> <?php echo $qtyTotal; ?> </td>
                    <td></td>
                  </tr>
                </table>
                <br><br><br>

                <div class="sign">
                    <div class="row">
                        <span style="text-decoration: overline;">Prepared By</span>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <span style="text-decoration: overline;">Approved By</span>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <span style="text-decoration: overline;">Received By</span>
                    </div>
                    <span>----------------------------------------------------------------------------------------------------------</span>
                    
                    
                </div>

            </div>

            <!--  -->

            <div class="row">
                <h1 style="margin: 0, auto;">AHMED DIGITAL WORLD</h1>
                <h1 style="text-decoration: none; font-size: 14px; margin-top: 2px; margin-bottom: 2px;"> Gate Copy </h1>
                <span>Gate Pass</span>
                <table class="center" style="border-collapse: collapse;">
                <tr>
                    <th>Party</th>
                    <th>Date</th>
                    <th>GP #</th>

                </tr>

                <tr>
                    <th></th>
                    <th> <?php echo $gate_pass['gate_pass_date'];  ?> </th>
                    <th> <?php echo $gate_pass['reference'] ?> </th>

                </tr>
                </table>
                <br>
                <table class="center" style="border-collapse: collapse;">
                  <tr>
                    <th>SERIAL</th>
                    <th>DISCRIPTION</th>
                    <!-- <th>PCS</th> -->
                    <th>UNIT</th>
                    <th>QTY</th>
                    <th>REMARKS</th>
                  </tr>

                  <tr>
                    <?php 
                    $gate_pass_detail = get_gate_pass_details($trans_no);
                    $dec = user_price_dec();
                    while ($myrow = db_fetch($gate_pass_detail)) {
                        // print_r($myrow);
                        label_cell($myrow["stock_id"], "align='center'");
                        label_cell($myrow["description"], "align='center'");
                        // label_cell($myrow[""], "align='center'");
                        label_cell(get_unit_name_by_stock($myrow["stock_id"]), "align='center'");
                        qty_cell($myrow["qty"], false, $dec );
                        label_cell($gate_pass['memo_'], "align='center'");
                        end_row();

                        $qtyTotal2nd +=  $myrow["qty"];
                    }
                         ?>
                    <!-- <td>1</td>
                    <td>Maria Anders</td>
                    <td>Germany</td>
                    <td>Alfreds Futterkiste</td>
                    <td>Maria Anders</td>
                    <td>Germany</td> -->
                  </tr>

                  <tr>
                    <th>Name</th>
                    <th>Cell #</th>
                    <th>Vehicle #</th>
                    <th>Total</th>
                    <th>Total Pack</th>
                  </tr>

                   <tr>
                    <td> <?php echo $gate_pass['name'];  ?> </td>
                    <td> <?php echo $gate_pass['cell_no'];  ?> </td>
                    <td> <?php echo $gate_pass['vehicle_no'];  ?> </td>
                    <td> <?php echo $qtyTotal2nd; ?> </td>
                    <td></td>
                  </tr>
                </table>
                <br><br><br>

                <div class="sign">
                    <div class="row">
                        <span style="text-decoration: overline;">Prepared By</span>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <span style="text-decoration: overline;">Approved By</span>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <span style="text-decoration: overline;">Received By</span>
                    </div>
                    <span>----------------------------------------------------------------------------------------------------------</span>
                </div>
            </div>

            <!-- 2nd -->
            <!-- 3RD -->

            <div class="row">
                <h1 style="margin: 0, auto;">AHMED DIGITAL WORLD</h1>
                <h1 style="text-decoration: none; font-size: 14px; margin-top: 2px; margin-bottom: 2px;"> Office Copy </h1>
                <span>Gate Pass</span>
                <table class="center" style="border-collapse: collapse;">
                <tr>
                    <th>Party</th>
                    <th>Date</th>
                    <th>GP #</th>

                </tr>

                <tr>
                    <th></th>
                    <th> <?php echo $gate_pass['gate_pass_date'];  ?> </th>
                    <th> <?php echo $gate_pass['reference'] ?> </th>

                </tr>
                </table>
                <br>
                <table class="center" style="border-collapse: collapse;">
                  <tr>
                    <th>SERIAL</th>
                    <th>DISCRIPTION</th>
                    <!-- <th>PCS</th> -->
                    <th>UNIT</th>
                    <th>QTY</th>
                    <th>REMARKS</th>
                  </tr>

                  <tr>
                    <?php 
                    $gate_pass_detail = get_gate_pass_details($trans_no);
                    $dec = user_price_dec();
                    while ($myrow = db_fetch($gate_pass_detail)) {
                        // print_r($myrow);
                        label_cell($myrow["stock_id"], "align='center'");
                        label_cell($myrow["description"], "align='center'");
                        // label_cell($myrow[""], "align='center'");
                        label_cell(get_unit_name_by_stock($myrow["stock_id"]), "align='center'");
                        qty_cell($myrow["qty"], false, $dec );
                        label_cell($gate_pass['memo_'], "align='center'");
                        end_row();

                        $qtyTotal3rd +=  $myrow["qty"];
                    }
                         ?>
                    <!-- <td>1</td>
                    <td>Maria Anders</td>
                    <td>Germany</td>
                    <td>Alfreds Futterkiste</td>
                    <td>Maria Anders</td>
                    <td>Germany</td> -->
                  </tr>

                  <tr>
                    <th>Name</th>
                    <th>Cell #</th>
                    <th>Vehicle #</th>
                    <th>Total</th>
                    <th>Total Pack</th>
                  </tr>

                   <tr>
                    <td> <?php echo $gate_pass['name'];  ?> </td>
                    <td> <?php echo $gate_pass['cell_no'];  ?> </td>
                    <td> <?php echo $gate_pass['vehicle_no'];  ?> </td>
                    <td> <?php echo $qtyTotal3rd; ?> </td>
                    <td></td>
                  </tr>
                </table>
                <br><br><br>

                <div class="sign">
                    <div class="row">
                        <span style="text-decoration: overline;">Prepared By</span>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <span style="text-decoration: overline;">Approved By</span>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <span style="text-decoration: overline;">Received By</span>
                    </div>
                </div>
            </div>

            <!-- 3RD -->
            <!-- seperate division -->
        </div>
    </div>
</body>
</html>

<style type="text/css">
    table, th, td {
  border: 1px solid;
}

.container{
    text-align: center;
}

.center {
  margin-left: auto;
  margin-right: auto;
}

h1{
    font-size: 13px;
}

</style>

