<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CUSTPAYMREP';

// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Customer Balances
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/db/customers_db.inc");

//----------------------------------------------------------------------------------------------------

print_customer_balances();

function get_open_balance($debtorno, $to)
{
	if($to)
		$to = date2sql($to);
	$sql = "SELECT SUM(IF(t.type = ".ST_SALESINVOICE." OR (t.type IN (".ST_JOURNAL." , ".ST_BANKPAYMENT.") AND t.ov_amount>0),
             -abs(t.ov_amount + t.ov_gst + t.ov_freight + t.ov_freight_tax + t.ov_discount), 0)) AS charges,";

	$sql .= "SUM(IF(t.type != ".ST_SALESINVOICE." AND NOT(t.type IN (".ST_JOURNAL." , ".ST_BANKPAYMENT.") AND t.ov_amount>0),
             abs(t.ov_amount + t.ov_gst + t.ov_freight + t.ov_freight_tax + t.ov_discount) * -1, 0)) AS credits,";		

    $sql .= "SUM(IF(t.type != ".ST_SALESINVOICE." AND NOT(t.type IN (".ST_JOURNAL." , ".ST_BANKPAYMENT.")), t.alloc * -1, t.alloc)) AS Allocated,";

 	$sql .=	"SUM(IF(t.type = ".ST_SALESINVOICE." OR (t.type IN (".ST_JOURNAL." , ".ST_BANKPAYMENT.") AND t.ov_amount>0), 1, -1) *
 			(abs(t.ov_amount + t.ov_gst + t.ov_freight + t.ov_freight_tax + t.ov_discount) - abs(t.alloc))) AS OutStanding
		FROM ".TB_PREF."debtor_trans t
    	WHERE t.debtor_no = ".db_escape($debtorno)
		." AND t.type <> ".ST_CUSTDELIVERY;
    if ($to)
    	$sql .= " AND t.tran_date < '$to'";
	$sql .= " GROUP BY debtor_no";

    $result = db_query($sql,"No transactions were returned");
    return db_fetch($result);
}

function get_transactions($debtorno, $from, $to)
{
	$from = date2sql($from);
	$to = date2sql($to);

 	$allocated_from = 
 			"(SELECT trans_type_from as trans_type, trans_no_from as trans_no, date_alloc, sum(amt) amount
 			FROM ".TB_PREF."cust_allocations alloc
 				WHERE person_id=".db_escape($debtorno)."
 					AND date_alloc <= '$to'
 				GROUP BY trans_type_from, trans_no_from) alloc_from";
 	$allocated_to = 
 			"(SELECT trans_type_to as trans_type, trans_no_to as trans_no, date_alloc, sum(amt) amount
 			FROM ".TB_PREF."cust_allocations alloc
 				WHERE person_id=".db_escape($debtorno)."
 					AND date_alloc <= '$to'
 				GROUP BY trans_type_to, trans_no_to) alloc_to";

     $sql = "SELECT trans.*,
 		(trans.ov_amount + trans.ov_gst + trans.ov_freight + trans.ov_freight_tax + trans.ov_discount) AS TotalAmount,
 		IFNULL(alloc_from.amount, alloc_to.amount) AS Allocated,
 		((trans.type = ".ST_SALESINVOICE.")	AND trans.due_date < '$to') AS OverDue
     	FROM ".TB_PREF."debtor_trans trans
 			LEFT JOIN ".TB_PREF."voided voided ON trans.type=voided.type AND trans.trans_no=voided.id
 			LEFT JOIN $allocated_from ON alloc_from.trans_type = trans.type AND alloc_from.trans_no = trans.trans_no
 			LEFT JOIN $allocated_to ON alloc_to.trans_type = trans.type AND alloc_to.trans_no = trans.trans_no

     	WHERE trans.tran_date >= '$from'
 			AND trans.tran_date <= '$to'
 			AND trans.debtor_no = ".db_escape($debtorno)."
 			AND trans.type <> ".ST_CUSTDELIVERY."
 			AND ISNULL(voided.id)
     	ORDER BY trans.tran_date";
    return db_query($sql,"No transactions were returned");
}

//----------------------------------------------------------------------------------------------------

function print_customer_balances()
{
    	global $path_to_root, $systypes_array;

    	$from = $_POST['PARAM_0'];
    	$to = $_POST['PARAM_1'];
    	$fromcust = $_POST['PARAM_2'];
    	$cust_detail = $_POST['PARAM_3'];
    	$show_balance = $_POST['PARAM_4'];
    	$currency = $_POST['PARAM_5'];
    	$no_zeros = $_POST['PARAM_6'];
    	$comments = $_POST['PARAM_7'];
		$orientation = $_POST['PARAM_8'];
		$destination = $_POST['PARAM_9'];
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	if ($fromcust == ALL_TEXT)
		$cust = _('All');
	else
		$cust = get_customer_name($fromcust);
    $dec = user_price_dec();

	if ($show_balance) $sb = _('Yes');
	else $sb = _('No');

	if ($currency == ALL_TEXT)
	{
		$convert = true;
		$currency = _('Balances in Home Currency');
	}
	else
		$convert = false;

	if ($no_zeros) $nozeros = _('Yes');
	else $nozeros = _('No');

	$cols = array(0, 95, 140, 200,	250, 320, 385, 500);

	$headers = array(_('Trans Type'), _('#'), _('Date'), _('Due Date'), _('Debits'), _('Credits'), 	_('Outstanding'));

	if ($show_balance)
		$headers[7] = _('Balance');
	$aligns = array('left',	'left',	'left',	'left',	'right', 'right', 'right', 'right');

    $params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'), 'from' => $from, 		'to' => $to),
    				    2 => array('text' => _('Customer'), 'from' => $cust,   	'to' => ''),
    				    3 => array('text' => _('Show Balance'), 'from' => $sb,   	'to' => ''),
    				    4 => array('text' => _('Currency'), 'from' => $currency, 'to' => ''),
						5 => array('text' => _('Suppress Zeros'), 'from' => $nozeros, 'to' => ''));

    $rep = new FrontReport(_('Customer Balances'), "CustomerBalances", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);
    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

	$grandtotal = array(0,0,0,0);

	$sql = "SELECT debtor_no, name, curr_code FROM ".TB_PREF."debtors_master ";
	if ($fromcust != ALL_TEXT)
		$sql .= "WHERE debtor_no=".db_escape($fromcust);
	$sql .= " ORDER BY name";
	$result = db_query($sql, "The customers could not be retrieved");

	while ($myrow = db_fetch($result))
	{
		if (!$convert && $currency != $myrow['curr_code']) continue;
		
		$accumulate = 0;
		$rate = $convert ? get_exchange_rate_from_home_currency($myrow['curr_code'], Today()) : 1;
		$bal = get_open_balance($myrow['debtor_no'], $from);
		$init = array();
		$bal['charges'] = isset($bal['charges']) ? $bal['charges'] : 0;
		$bal['credits'] = isset($bal['credits']) ? $bal['credits'] : 0;
		// $bal['Allocated'] = isset($bal['Allocated']) ? $bal['Allocated'] : 0;
		// $bal['OutStanding'] = isset($bal['OutStanding']) ? $bal['OutStanding'] : 0;
		$init[0] = round2(abs($bal['charges']*$rate), $dec);
		$init[1] = round2(Abs($bal['credits']*$rate), $dec);
		// $init[2] = round2($bal['Allocated']*$rate, $dec);
		// if ($show_balance)
		// {
		// 	$init[3] = $init[0] - $init[1];
		// 	$accumulate += $init[3];
		// }	
		// else	
		// 	$init[3] = round2($bal['OutStanding']*$rate, $dec);

		$res = get_transactions($myrow['debtor_no'], $from, $to);
		if ($no_zeros && db_num_rows($res) == 0) continue;

		$rep->fontSize += 2;
		$rep->TextCol(0, 2, $myrow['name']);
		if ($convert)
			$rep->TextCol(2, 3,	$myrow['curr_code']);
		$rep->fontSize -= 2;
		$rep->TextCol(3, 4,	_("Open Balance"));
		$rep->AmountCol(4, 5, $init[0], $dec);
		$rep->AmountCol(5, 6, $init[1], $dec);
		// $rep->AmountCol(6, 7, $init[2], $dec);
		// $rep->AmountCol(7, 8, $init[3], $dec);
		$total = array(0,0,0,0);
		for ($i = 0; $i < 3; $i++)
		{
			$total[$i] += $init[$i];
			$grandtotal[$i] += $init[$i];
		}
		$balance_amt = 	$init[0]-$init[1];
		   // $item[2] = $balance_amt;
		$rep->AmountCol(6, 7, $balance_amt, $dec);
		$rep->NewLine(1, 2);
		$rep->Line($rep->row + 4);
		if (db_num_rows($res)==0) {
			$rep->NewLine(1, 2);
			continue;
		}
		while ($trans = db_fetch($res))
		{
            if ($no_zeros) {
                if ($show_balance) {
                    if ($trans['TotalAmount'] == 0) continue;
                } else {
                    if (floatcmp(abs($trans['TotalAmount']), $trans['Allocated']) == 0) continue;
                }
            }
			$rep->NewLine(1, 2);
			$rep->TextCol(0, 1, $systypes_array[$trans['type']]);
			$rep->TextCol(1, 2,	$trans['reference']);
			$rep->DateCol(2, 3,	$trans['tran_date'], true);
			if ($trans['type'] == ST_SALESINVOICE)
				$rep->DateCol(3, 4,	$trans['due_date'], true);
			$item[0] = $item[1] = 0.0;
			if ($trans['type'] == ST_CUSTCREDIT || $trans['type'] == ST_CUSTPAYMENT || $trans['type'] == ST_BANKDEPOSIT)
				$trans['TotalAmount'] *= -1;
			if ($trans['TotalAmount'] > 0.0)
			{
				$item[0] = round2($trans['TotalAmount'] * $rate, $dec);
				$rep->AmountCol(4, 5, $item[0], $dec);
				// $accumulate += $item[0];
				// $item[2] = round2($trans['Allocated'] * $rate, $dec);
			}
			else
			{
				$item[1] = round2(Abs($trans['TotalAmount']) * $rate, $dec);
				$rep->AmountCol(5, 6, $item[1], $dec);
				$accumulate -= $item[1];
				// $item[2] = round2($trans['Allocated'] * $rate, $dec) * -1;
			}

			$balance_amt += $trans['TotalAmount'];
			$rep->AmountCol(6, 7, $balance_amt, $dec);
          

			// $rep->AmountCol(6, 7, $item[2], $dec);
			// if (($trans['type'] == ST_JOURNAL && $item[0]) || $trans['type'] == ST_SALESINVOICE || $trans['type'] == ST_BANKPAYMENT)
			// 	$item[3] = $item[0] - $item[2];
			// else	
			// 	$item[3] = -$item[1] - $item[2];
			// if ($show_balance)	
			// 	$rep->AmountCol(7, 8, $accumulate, $dec);
			// else	
			// 	$rep->AmountCol(7, 8, $item[3], $dec);
			for ($i = 0; $i < 3; $i++)
			{
				$total[$i] += $item[$i];
				$grandtotal[$i] += $item[$i];
			}
				// $total[2] +=  $trans['TotalAmount'];
				// display_error($total[2]);
			// if ($show_balance)
				// $total[3] = $total[0] - $total[1];

			// display_error($trans['type']." == ".$trans['trans_no']);

		 if ($cust_detail == 1) {
			if ($trans['type'] == ST_SALESINVOICE){
				$inv_sum=0;
				$result = get_customer_trans_details($trans['type'], $trans['trans_no']);
				if(db_num_rows($result))
				 {
				 	$rep->NewLine();
				 	 $rep->Line($rep->row-3);
				 	$rep->Font('bold');
				 	$rep->TextCol(0, 2,"Item - Description");
					$rep->TextCol(2, 3, "Qty");
					$rep->TextCol(3, 4, "Price");
					$rep->TextCol(4, 5, "Total");
					$rep->Font();
						// $rep->NewLine();
				 }	
				 $rep->fontSize -= 2;
			 	while ($line_row = db_fetch($result)) {
		 			$rep->NewLine();
					$rep->TextCol(0, 2, $line_row['stock_id']." - ".$line_row['description']);
					$rep->TextCol(2, 3, $line_row['quantity']);
					$rep->TextCol(3, 4, $line_row['unit_price']);
					$sign = 1;
					// display_error($line_row["unit_price"]." == ".$line_row["unit_tax"]);
					$Net = round2(($sign *   ($line_row["unit_price"]+$line_row["unit_tax"]) * $line_row["quantity"]),user_price_dec());
					$DisplayNet = number_format2($Net,$dec);
					$rep->TextCol(4, 5, $DisplayNet);
					$inv_sum+=$Net;
				    }
   				    $rep->Line($rep->row-3);
				    $rep->NewLine();
				    $rep->Font('bold');
				    $rep->TextCol(0, 2,_("Invoice Total"));
				    $rep->TextCol(4, 5, $inv_sum);
	   			    $rep->Line($rep->row-3);
				    $rep->Font();
				       $rep->fontSize += 2;
			  }



			  		if ($trans['type'] == ST_JOURNAL){
			               $inv_sum=0;
			               $res_je = get_gl_trans($trans['type'], $trans['trans_no']);
			               $rep->fontSize -= 2;
			               $rep->aligns[5]='center';
			                  while ($je_row = db_fetch($res_je)) 
			                  {  
			                  	// display_error($myrow['supplier_id']." == ".$je_row["person_id"]);
			                     if($myrow['debtor_no']==$je_row["person_id"] && $je_row['account']==1200)
			                       {
			                            $rep->NewLine();
			                          	$rep->TextCol(0, 4, $je_row['account']." - ".$je_row['account_name']);
			                            //     if($je_row['amount']>0)
			                          		$rep->AmountCol(4, 5, $je_row['amount'], $dec);

			                          			$rep->TextCol(5, 8, $je_row['memo_']);
			                          	 //   else
			                          	 //   	$rep->AmountCol(5, 6, $je_row['amount'], $dec);	
			                       }



			                  }
			                  $rep->fontSize += 2;
			                     $rep->aligns[5]='right';
			                  // $rep->NewLine();



			
			  }
		  }

		}
		  $total[2]  = $balance_amt;
		$rep->Line($rep->row - 8);
		$rep->NewLine(2);
		$rep->TextCol(0, 3, _('Total'));
		for ($i = 0; $i < 3; $i++)
			$rep->AmountCol($i + 4, $i + 5, $total[$i], $dec);
   		$rep->Line($rep->row  - 4);
   		$rep->NewLine(2);
	}
	$rep->fontSize += 2;
	$rep->TextCol(0, 3, _('Grand Total'));
	$rep->fontSize -= 2;
	// if ($show_balance)
		$grandtotal[2] = $grandtotal[0] - $grandtotal[1];
	for ($i = 0; $i < 3; $i++)
		$rep->AmountCol($i + 4, $i + 5, $grandtotal[$i], $dec);
	$rep->Line($rep->row  - 4);
	$rep->NewLine();
    	$rep->End();
}

