<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SALESANALYTIC';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Inventory Sales Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/inventory/includes/db/items_category_db.inc");

//----------------------------------------------------------------------------------------------------

print_inventory_sales();

function getTransactions($stock_id, $location, $from, $to)
{
	$before_date = date2sql($to);
	$after_date = date2sql($from);
	if($exp_date == null)
		$exp_date = Today();
	$exp_date = date2sql($exp_date);
	
	
  	$sql = "SELECT move.*, IF(ISNULL(supplier.supplier_id), debtor.name, supplier.supp_name) name";

	if(!$StockLocation) {
		 $sql .= ", move.loc_code";
	}
  	$sql.=    " FROM ".TB_PREF."stock_moves move
				LEFT JOIN ".TB_PREF."supp_trans credit ON credit.trans_no=move.trans_no AND credit.type=move.type
				LEFT JOIN ".TB_PREF."grn_batch grn ON grn.id=move.trans_no AND 25=move.type
				LEFT JOIN ".TB_PREF."suppliers supplier ON IFNULL(grn.supplier_id, credit.supplier_id)=supplier.supplier_id
				LEFT JOIN ".TB_PREF."debtor_trans cust_trans ON cust_trans.trans_no=move.trans_no AND cust_trans.type=move.type
				LEFT JOIN ".TB_PREF."debtors_master debtor ON cust_trans.debtor_no=debtor.debtor_no
		WHERE";

  	if ($StockLocation) {
    	$sql.= " move.loc_code=".db_escape($StockLocation)." AND";
	}else{
			if ($_SESSION["wa_current_user"]->to_location!='')
		 $sql.="  move.loc_code IN (".$_SESSION["wa_current_user"]->to_location.") AND";
	}


	if($batch_no)
		$sql .= " move.batch_no LIKE " . db_escape("%" . $batch_no. "%") . " AND";

	if($filterType){
		if($filterType == 1)
			$sql .=" move.exp_date >= ". db_escape($exp_date). "	AND ";
		elseif($filterType == 2)
			$sql .=" move.exp_date <= ". db_escape($exp_date) . "	AND ";
		elseif($filterType == 3)
			$sql .=" move.exp_date <> ". db_escape($exp_date) . "	AND ";
	}
		
	
	$sql.= " move.tran_date >= '". $after_date . "'
		AND move.tran_date <= '" . $before_date . "'
		AND move.stock_id = ".db_escape($stock_id) . " ORDER BY move.tran_date, move.trans_id";

		// display_error($sql);

  	return db_query($sql);

}

//----------------------------------------------------------------------------------------------------

function print_inventory_sales()
{
    global $path_to_root;

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
    $stock_id = $_POST['PARAM_2'];
    $location = $_POST['PARAM_3'];
	$orientation = $_POST['PARAM_4'];
	$destination = $_POST['PARAM_5'];
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
    // $dec = user_price_dec();
	// // $kv_batch = get_company_pref('kv_batch');
	// // $kv_exp_date = get_company_pref('kv_exp_date');
	// if ($stock_id == ALL_NUMERIC)
	// 	$stock_id = 0;
	// if ($stock_id == 0)
	// 	$cat = _('All');
	// else
	// 	$cat = get_category_name($stock_id);

	// if ($location == '')
	// 	$loc = _('All');
	// else
	// 	$loc = get_location_name($location);

	// if ($fromcust == '')
	// 	$fromc = _('All');
	// else
	// 	$fromc = get_customer_name($fromcust);
	// if ($show_service) $show_service_items = _('Yes');
	// else $show_service_items = _('No');
	// if($kv_exp_date)
	// 	$cols = array(0, 55, 155, 220, 270, 320, 350, 400, 450, 515);
	// elseif($kv_batch )
	// 	$cols = array(0, 55, 155, 220, 280, 290, 350, 400, 450, 515);
	// else
		$cols = array(0, 110, 170, 220, 290, 370, 410, 470);

	$headers = array(_('Type'), _('Location'), _('Refrence'), _('Date'), _('Name'), _('Qty In'), _('Qty Out'), _('Qty On Hand'));

	$aligns = array('left',	'left',	'left',  'left', 'left', 'center', 'center', 'right', 'left');
	// if($kv_exp_date){
	// 	array_splice( $headers, 3, 0, _("Batch No") );
	// 	array_splice( $headers, 4, 0, _("Exp Date") );
	// }elseif($kv_batch){
	// 	array_splice( $headers, 3, 0, _("Batch No") );
	// 	array_splice( $headers, 4, 0, _("") );
	// }
	// if ($fromcust != '')
		// $headers[2] = '';

	// if($kv_batch || $kv_exp_date){
	// 	array_splice( $aligns, 3, 0, 'left' );
	// 	array_splice( $aligns, 4, 0, 'left' );
	// }
    $params =   array( 	0 => $comments,
    				    1 => array('text' => _('Period'),'from' => $from, 'to' => $to),
    				    // 2 => array('text' => _('Category'), 'from' => $cat, 'to' => ''),
    				    3 => array('text' => _('Location'), 'from' => $loc, 'to' => ''),
    				    // 4 => array('text' => _('Customer'), 'from' => $fromc, 'to' => ''),
    				    5 => array('text' => _('Show Service Items'), 'from' => $show_service_items, 'to' => ''));

    $rep = new FrontReport(_('Inventory Sales Report'), "InventorySalesReport", user_pagesize(), 9, $orientation);
   	if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

	$res = getTransactions($stock_id, $location, $from, $to);
	// print_r($res);
	// $total = $grandtotal = 0.0;
	// $total1 = $grandtotal1 = 0.0;
	// $total2 = $grandtotal2 = 0.0;
	// $catt = '';
	while ($trans=db_fetch($res))
	{
		global $systypes_array;
		$type_name = $systypes_array[$trans["type"]];
		$rep->NewLine();
		$rep->TextCol(0, 1, $type_name);
		$rep->TextCol(1, 2, $trans['loc_code']);
		$rep->TextCol(2, 3, $trans['reference']);
		$trandate = sql2date($trans["tran_date"]);
		$rep->TextCol(3, 4, $trandate);
		$rep->TextCol(4, 5, $trans['name']);

		if ($trans["qty"] > 0){
		$quantity_formatted = number_format2($trans["qty"], $dec);
		$total_in += $trans["qty"];
		$rep->TextCol(5, 6, $quantity_formatted);
		}
		else
		{
		$quantity_formatted = number_format2(-$trans["qty"], $dec);
		$total_out += -$trans["qty"];
		$rep->TextCol(6, 7, $quantity_formatted);
		}

		$after_qty += $trans["qty"];
		$rep->TextCol(7, 8, $after_qty);
	}
		
	$rep->Line($rep->row  - 4);
	$rep->NewLine();
    $rep->End();
}
